CVE-2017-1000112
================

```
When building a UFO packet with MSG_MORE __ip_append_data() calls ip_ufo_append_data() to append. However in between two 
send() calls, the append path can be switched from UFO to non-UFO one, which leads to a memory corruption.

In case UFO packet lengths exceeds MTU, copy = maxfraglen - skb->len becomes negative on the non-UFO path and the branch to 
allocate new skb is taken. This triggers fragmentation and computation of fraggap = skb_prev->len - maxfraglen. Fraggap can 
exceed MTU, causing copy = datalen - transhdrlen - fraggap to become negative. Subsequently skb_copy_and_csum_bits() writes 
out-of-bounds.


A similar issue is present in IPv6 code.

The bug was introduced in e89e9cf539a2 ("[IPv4/IPv6]: UFO Scatter-gather approach") on Oct 18 2005.

The fix has been submitted to netdev [1] and should be committed to mainline and to stable kernels soon. David has also sent
an RFC series to remove UFO completely [2], which should be merged in 4.14.

If unprivileged user namespaces are available, this bug can be exploited to gain root privileges. I'll share the details and
the exploit in a few days.
```

This is a proof-of-concept local root exploit for the vulnerability in the UFO Linux kernel implementation CVE-2017-1000112.

Some details: http://www.openwall.com/lists/oss-security/2017/08/13/1

