/*++

          ##     ## ######## ##     ## ########  
          ##     ## ##       ##     ## ##     ## 
          ##     ## ##       ##     ## ##     ## 
          ######### ######   ##     ## ##     ## 
          ##     ## ##        ##   ##  ##     ## 
          ##     ## ##         ## ##   ##     ## 
          ##     ## ########    ###    ########  

        HackSys Extreme Vulnerable Driver Exploit

Author : Ashfaq Ansari
Contact: ashfaq[at]payatu[dot]com
Website: http://www.payatu.com/

Copyright (C) 2011-2016 Payatu Technologies Pvt. Ltd. All rights reserved.

This program is free software: you can redistribute it and/or modify it under the terms of
the GNU General Public License as published by the Free Software Foundation, either version
3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program.
If not, see <http://www.gnu.org/licenses/>.

THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

See the file 'LICENSE' for complete copying permission.

Module Name:
    HackSysEVDExploit.h

Abstract:
    This module implements the data structures used by the
    main exploit module handling the exploitation routines.

--*/

#ifndef __EXPLOIT_H__
    #define __EXPLOIT_H__

    #pragma once

    #include "arg.h"
    #include "Common.h"

    typedef enum _VULNERABILITY_TYPE {
        DoubleFetch,
        PoolOverflow,
        UseAfterFree,
        TypeConfusion,
        StackOverflow,
        IntegerOverflow,
        StackOverflowGS,
        ArbitraryOverwrite,
        NullPointerDereference,
        InsecureKernelFileAccess,
        UninitializedHeapVariable,
        UninitializedStackVariable,
    } VULNERABILITY_TYPE, *PVULNERABILITY_TYPE;

    typedef struct _EXPLOIT_VULNERABILITY {
        PTCHAR             Command;
        VULNERABILITY_TYPE VulnerabilityType;
    } EXPLOIT_VULNERABILITY, *PEXPLOIT_VULNERABILITY;

    static VOID    ShowUsage(PTCHAR Process);
    BOOL           IsProcessHavingHigherPrivilege(LPCSTR TargetProcess);
    VOID           Exploit(PEXPLOIT_VULNERABILITY ExploitVulnerability);
    VOID           LaunchExploitThread(LPTHREAD_START_ROUTINE ExploitHandlerThread);

#endif //__EXPLOIT_H__
