#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>


// Western Digital Firmware Deobfuscation Tool
// v0.1 - 2015/05/17
// https://www.github.com/ddcc/drive_firmware
// GNU GPL v2 - see LICENSE.md

uint8_t key[513] = {
  0x6F, 0x6F, 0x6E, 0x76, 0x79, 0x6A, 0x6A, 0x72, 0x34, 0x66,
  0x65, 0x6A, 0x6A, 0x30, 0x77, 0x6C, 0x6F, 0x6F, 0x6C, 0x75,
  0x31, 0x61, 0x71, 0x71, 0x70, 0x32, 0x76, 0x79, 0x79, 0x6F,
  0x32, 0x6D, 0x33, 0x6F, 0x6F, 0x37, 0x35, 0x67, 0x76, 0x76,
  0x64, 0x34, 0x78, 0x6C, 0x61, 0x61, 0x6D, 0x71, 0x38, 0x62,
  0x62, 0x6B, 0x39, 0x37, 0x35, 0x34, 0x34, 0x72, 0x64, 0x73,
  0x70, 0x70, 0x37, 0x64, 0x36, 0x68, 0x74, 0x74, 0x61, 0x64,
  0x79, 0x61, 0x61, 0x67, 0x6E, 0x6C, 0x6C, 0x63, 0x63, 0x67,
  0x66, 0x76, 0x6E, 0x6E, 0x73, 0x73, 0x6A, 0x65, 0x67, 0x67,
  0x75, 0x65, 0x37, 0x68, 0x68, 0x63, 0x79, 0x32, 0x7A, 0x6A,
  0x6A, 0x38, 0x6F, 0x36, 0x61, 0x61, 0x64, 0x68, 0x37, 0x76,
  0x61, 0x61, 0x35, 0x72, 0x6E, 0x35, 0x35, 0x69, 0x6B, 0x67,
  0x38, 0x7A, 0x7A, 0x34, 0x66, 0x32, 0x77, 0x77, 0x39, 0x68,
  0x70, 0x32, 0x76, 0x76, 0x65, 0x65, 0x68, 0x32, 0x32, 0x6D,
  0x68, 0x71, 0x62, 0x77, 0x77, 0x30, 0x35, 0x38, 0x39, 0x39,
  0x37, 0x62, 0x33, 0x6F, 0x38, 0x38, 0x39, 0x79, 0x71, 0x75,
  0x75, 0x30, 0x66, 0x65, 0x67, 0x69, 0x69, 0x38, 0x68, 0x68,
  0x76, 0x76, 0x31, 0x7A, 0x36, 0x65, 0x78, 0x78, 0x73, 0x74,
  0x6A, 0x34, 0x34, 0x77, 0x68, 0x33, 0x72, 0x35, 0x35, 0x37,
  0x67, 0x74, 0x71, 0x71, 0x32, 0x31, 0x64, 0x79, 0x69, 0x69,
  0x68, 0x6E, 0x69, 0x7A, 0x7A, 0x6B, 0x78, 0x62, 0x30, 0x30,
  0x30, 0x62, 0x35, 0x7A, 0x73, 0x73, 0x77, 0x69, 0x68, 0x36,
  0x79, 0x79, 0x32, 0x37, 0x6B, 0x6F, 0x6F, 0x77, 0x77, 0x78,
  0x33, 0x72, 0x72, 0x74, 0x39, 0x76, 0x31, 0x31, 0x6F, 0x6E,
  0x7A, 0x70, 0x74, 0x74, 0x69, 0x67, 0x69, 0x63, 0x63, 0x6F,
  0x74, 0x36, 0x7A, 0x62, 0x62, 0x78, 0x6E, 0x63, 0x65, 0x65,
  0x6B, 0x6A, 0x64, 0x6F, 0x32, 0x32, 0x74, 0x75, 0x66, 0x6E,
  0x6E, 0x75, 0x70, 0x72, 0x6A, 0x65, 0x65, 0x38, 0x73, 0x6F,
  0x77, 0x77, 0x66, 0x78, 0x35, 0x38, 0x6D, 0x6D, 0x78, 0x69,
  0x36, 0x34, 0x34, 0x33, 0x6C, 0x31, 0x33, 0x75, 0x75, 0x76,
  0x62, 0x6B, 0x6B, 0x6B, 0x79, 0x71, 0x69, 0x78, 0x6A, 0x6A,
  0x6D, 0x79, 0x39, 0x77, 0x77, 0x31, 0x37, 0x62, 0x61, 0x36,
  0x36, 0x34, 0x78, 0x67, 0x6D, 0x6D, 0x70, 0x77, 0x75, 0x31,
  0x6C, 0x6C, 0x61, 0x74, 0x61, 0x34, 0x34, 0x72, 0x65, 0x79,
  0x68, 0x66, 0x66, 0x63, 0x39, 0x64, 0x6D, 0x6D, 0x70, 0x35,
  0x37, 0x73, 0x64, 0x64, 0x65, 0x78, 0x38, 0x39, 0x39, 0x6D,
  0x61, 0x6C, 0x62, 0x64, 0x64, 0x6F, 0x35, 0x38, 0x67, 0x67,
  0x78, 0x64, 0x76, 0x68, 0x30, 0x30, 0x79, 0x36, 0x37, 0x72,
  0x72, 0x33, 0x62, 0x79, 0x74, 0x6C, 0x6C, 0x6E, 0x67, 0x35,
  0x63, 0x63, 0x6B, 0x7A, 0x6B, 0x30, 0x68, 0x68, 0x35, 0x64,
  0x31, 0x36, 0x36, 0x62, 0x75, 0x37, 0x38, 0x69, 0x69, 0x36,
  0x79, 0x7A, 0x6A, 0x6A, 0x31, 0x6F, 0x68, 0x37, 0x64, 0x64,
  0x33, 0x36, 0x38, 0x62, 0x62, 0x79, 0x70, 0x7A, 0x79, 0x7A,
  0x7A, 0x35, 0x73, 0x38, 0x38, 0x38, 0x71, 0x62, 0x70, 0x70,
  0x36, 0x36, 0x6E, 0x70, 0x77, 0x61, 0x61, 0x65, 0x6E, 0x66,
  0x73, 0x76, 0x76, 0x78, 0x62, 0x65, 0x74, 0x74, 0x66, 0x6B,
  0x70, 0x39, 0x39, 0x39, 0x7A, 0x79, 0x78, 0x77, 0x77, 0x76,
  0x64, 0x71, 0x72, 0x70, 0x70, 0x66, 0x6E, 0x78, 0x69, 0x69,
  0x32, 0x32, 0x74, 0x37, 0x64, 0x64, 0x73, 0x62, 0x6D, 0x35,
  0x35, 0x39, 0x34, 0x75, 0x67, 0x71, 0x71, 0x38, 0x6C, 0x72,
  0x74, 0x74, 0x61, 0x67, 0x31, 0x65, 0x74, 0x74, 0x73, 0x62,
  0x76, 0x6B, 0x00
};

uint8_t decode(size_t i, uint8_t v) {
  return (v ^ key[i % 513]);
}

int main(int argc, char** argv) {
  FILE *ip = NULL, *op = NULL;

  uint8_t *buf;
  size_t i ,buf_size;

  int ret = 0;

  if (argc < 3) {
    printf("Usage: %s <input> <output>\n", argv[0]);
    ret = -1;
    goto end;
  }

  if (!(ip = fopen(argv[1], "rb"))) {
    printf("Error: Cannot open %s!\n", argv[1]);
    ret = -1;
    goto end;
  }

  fseek(ip, 0, SEEK_END);
  buf_size = ftell(ip);

  if (!(buf = malloc(buf_size))) {
    printf("Error: Cannot allocate input buffer of size %zu!\n", buf_size);
    ret = -1;
    goto end_buf;
  }

  rewind(ip);
  if (fread(buf, sizeof(*buf), buf_size / sizeof(*buf), ip) != buf_size / sizeof(*buf)) {
    perror(NULL);
    printf("Error: Cannot read %zu bytes!\n", buf_size);
    ret = -1;
    goto end_buf;
  }

  for (i = 0; i < buf_size; i++) {
    buf[i] = decode(i, buf[i]);
  }

  if (!(op = fopen(argv[2], "wb"))) {
    printf("Error: Cannot open %s!\n", argv[2]);
    ret = -1;
    goto end_buf;
  }

  if (fwrite(buf, sizeof(*buf), buf_size / sizeof(*buf), op) != buf_size / sizeof(*buf)) {
    printf("Error: Cannot write to output file!\n");
    ret = -1;
  }

  fclose(op);

end_buf:
  free(buf);
  fclose(ip);

end:
  return ret;
}
