#pragma once

#define DRIVER_PREFIX "KExplore: "

enum class SystemInformationClass {
	BasicInformation = 0,
	ProcessorInformation = 1,
	PerformanceInformation = 2,
	TimeOfDayInformation = 3,
	PathInformation = 4,
	ProcessInformation = 5,
	CallCountInformation = 6,
	DeviceInformation = 7,
	ProcessorPerformanceInformation = 8,
	FlagsInformation = 9,
	CallTimeInformation = 10,
	ModuleInformation = 11,
	LocksInformation = 12,
	StackTraceInformation = 13,
	PagedPoolInformation = 14,
	NonPagedPoolInformation = 15,
	HandleInformation = 16,
	ObjectInformation = 17,
	PageFileInformation = 18,
	VdmInstemulInformation = 19,
	VdmBopInformation = 20,
	FileCacheInformation = 21,
	PoolTagInformation = 22,
	InterruptInformation = 23,
	DpcBehaviorInformation = 24,
	FullMemoryInformation = 25,
	LoadGdiDriverInformation = 26,
	UnloadGdiDriverInformation = 27,
	TimeAdjustmentInformation = 28,
	SummaryMemoryInformation = 29,
	MirrorMemoryInformation = 30,
	PerformanceTraceInformation = 31,
	Obsolete0 = 32,
	ExceptionInformation = 33,
	CrashDumpStateInformation = 34,
	KernelDebuggerInformation = 35,
	ContextSwitchInformation = 36,
	RegistryQuotaInformation = 37,
	ExtendServiceTableInformation = 38,
	PrioritySeperation = 39,
	VerifierAddDriverInformation = 40,
	VerifierRemoveDriverInformation = 41,
	ProcessorIdleInformation = 42,
	LegacyDriverInformation = 43,
	CurrentTimeZoneInformation = 44,
	LookasideInformation = 45,
	TimeSlipNotification = 46,
	SessionCreate = 47,
	SessionDetach = 48,
	SessionInformation = 49,
	RangeStartInformation = 50,
	VerifierInformation = 51,
	VerifierThunkExtend = 52,
	SessionProcessInformation = 53,
	LoadGdiDriverInSystemSpace = 54,
	NumaProcessorMap = 55,
	PrefetcherInformation = 56,
	ExtendedProcessInformation = 57,
	RecommendedSharedDataAlignment = 58,
	ComPlusPackage = 59,
	NumaAvailableMemory = 60,
	ProcessorPowerInformation = 61,
	EmulationBasicInformation = 62,
	EmulationProcessorInformation = 63,
	ExtendedHandleInformation = 64,
	LostDelayedWriteInformation = 65,
	BigPoolInformation = 66,
	SessionPoolTagInformation = 67,
	SessionMappedViewInformation = 68,
	HotpatchInformation = 69,
	ObjectSecurityMode = 70,
	WatchdogTimerHandler = 71,
	WatchdogTimerInformation = 72,
	LogicalProcessorInformation = 73,
	Wow64SharedInformationObsolete = 74,
	RegisterFirmwareTableInformationHandler = 75,
	FirmwareTableInformation = 76,
	ModuleInformationEx = 77,
	VerifierTriageInformation = 78,
	SuperfetchInformation = 79,
	MemoryListInformation = 80,
	FileCacheInformationEx = 81,
	ThreadPriorityClientIdInformation = 82,
	ProcessorIdleCycleTimeInformation = 83,
	VerifierCancellationInformation = 84,
	ProcessorPowerInformationEx = 85,
	RefTraceInformation = 86,
	SpecialPoolInformation = 87,
	ProcessIdInformation = 88,
	ErrorPortInformation = 89,
	BootEnvironmentInformation = 90,
	HypervisorInformation = 91,
	VerifierInformationEx = 92,
	TimeZoneInformation = 93,
	ImageFileExecutionOptionsInformation = 94,
	CoverageInformation = 95,
	PrefetchPatchInformation = 96,
	VerifierFaultsInformation = 97,
	SystemPartitionInformation = 98,
	SystemDiskInformation = 99,
	ProcessorPerformanceDistribution = 100,
	NumaProximityNodeInformation = 101,
	DynamicTimeZoneInformation = 102,
	CodeIntegrityInformation = 103,
	ProcessorMicrocodeUpdateInformation = 104,
	ProcessorBrandString = 105,
	VirtualAddressInformation = 106,
	LogicalProcessorAndGroupInformation = 107,
	ProcessorCycleTimeInformation = 108,
	StoreInformation = 109,
	RegistryAppendString = 110,
	AitSamplingValue = 111,
	VhdBootInformation = 112,
	CpuQuotaInformation = 113,
	NativeBasicInformation = 114,
	ErrorPortTimeouts = 115,
	LowPriorityIoInformation = 116,
	BootEntropyInformation = 117,
	VerifierCountersInformation = 118,
	PagedPoolInformationEx = 119,
	SystemPtesInformationEx = 120,
	NodeDistanceInformation = 121,
	AcpiAuditInformation = 122,
	BasicPerformanceInformation = 123,
	QueryPerformanceCounterInformation = 124,
	SessionBigPoolInformation = 125,
	BootGraphicsInformation = 126,
	ScrubPhysicalMemoryInformation = 127,
	BadPageInformation = 128,
	ProcessorProfileControlArea = 129,
	CombinePhysicalMemoryInformation = 130,
	EntropyInterruptTimingInformation = 131,
	ConsoleInformation = 132,
	PlatformBinaryInformation = 133,
	PolicyInformation = 134,
	HypervisorProcessorCountInformation = 135,
	DeviceDataInformation = 136,
	DeviceDataEnumerationInformation = 137,
	MemoryTopologyInformation = 138,
	MemoryChannelInformation = 139,
	BootLogoInformation = 140,
	ProcessorPerformanceInformationEx = 141,
	CriticalProcessErrorLogInformation = 142,
	SecureBootPolicyInformation = 143,
	PageFileInformationEx = 144,
	SecureBootInformation = 145,
	EntropyInterruptTimingRawInformation = 146,
	PortableWorkspaceEfiLauncherInformation = 147,
	FullProcessInformation = 148,
	KernelDebuggerInformationEx = 149,
	BootMetadataInformation = 150,
	SoftRebootInformation = 151,
	ElamCertificateInformation = 152,
	OfflineDumpConfigInformation = 153,
	ProcessorFeaturesInformation = 154,
	RegistryReconciliationInformation = 155,
	EdidInformation = 156,
	ManufacturingInformation = 157,
	EnergyEstimationConfigInformation = 158,
	HypervisorDetailInformation = 159,
	ProcessorCycleStatsInformation = 160,
	VmGenerationCountInformation = 161,
	TrustedPlatformModuleInformation = 162,
	KernelDebuggerFlags = 163,
	CodeIntegrityPolicyInformation = 164,
	IsolatedUserModeInformation = 165,
	HardwareSecurityTestInterfaceResultsInformation = 166,
	SingleModuleInformation = 167,
	AllowedCpuSetsInformation = 168,
	DmaProtectionInformation = 169,
	InterruptCpuSetsInformation = 170,
	SecureBootPolicyFullInformation = 171,
	CodeIntegrityPolicyFullInformation = 172,
	AffinitizedInterruptProcessorInformation = 173,
	RootSiloInformation = 174,
	CpuSetInformation = 175,
	CpuSetTagInformation = 176,
	Win32WerStartCallout = 177,
	SecureKernelProfileInformation = 178,
	CodeIntegrityPlatformManifestInformation = 179,
	InterruptSteeringInformation = 180,
	SupportedProcessorArchitectures = 181,
	MemoryUsageInformation = 182,
	CodeIntegrityCertificateInformation = 183,
	PhysicalMemoryInformation = 184,
	ControlFlowTransition = 185,
	KernelDebuggingAllowed = 186,
	ActivityModerationExeState = 187,
	ActivityModerationUserSettings = 188,
	CodeIntegrityPoliciesFullInformation = 189,
	CodeIntegrityUnlockInformation = 190,
	IntegrityQuotaInformation = 191,
	FlushInformation = 192,
	ProcessorIdleMaskInformation = 193,
	SecureDumpEncryptionInformation = 194,
	WriteConstraintInformation = 195,
	KernelVaShadowInformation = 196,
	HypervisorSharedPagedInformation = 197,
	FirmwareBootPerformanceInformation = 198,
	CodeIntegrityVerificationInformation = 199,
	FirmwarePartitionInformation = 200,
	SystemSpeculationControlInformation = 201,
	MaxSystemInfoClass
};

extern "C" NTSTATUS NTAPI ZwQuerySystemInformation(SystemInformationClass infoClass, void* buffer, ULONG size, ULONG* needed);




