Linux Kernel Exploitation
=========================

Pull requests are welcome.

## Books

2014: "Android Hacker's Handbook" by Joshua J. Drake

2012: "A Guide to Kernel Exploitation: Attacking the Core" by Enrico Perla and Massimiliano Oldani

## Exploitation techniques

[2020: "Linux Kernel Stack Smashing" by Silvio Cesare](https://blog.infosectcbr.com.au/2020/02/linux-kernel-stack-smashing.html?m=1) [article]

[2020: "Structures that can be used in kernel exploits"](https://ptr-yudai.hatenablog.com/entry/2020/03/16/165628) [article]

[2019, Black Hat Europe: "Hands Off and Putting SLAB/SLUB Feng Shui in Blackbox" by Yueqi (Lewis) Chen](https://i.blackhat.com/eu-19/Wednesday/eu-19-Chen-Hands-Off-And-Putting-SLAB-SLUB-Feng-Shui-In-A-Blackbox.pdf) [slides] [[code](https://www.dropbox.com/sh/2kwcwqb8rjro80j/AAC8QBCIhcCylNUDLUd1OZCZa?dl=0)]

[2019: "SLAKE: Facilitating Slab Manipulation for Exploiting Vulnerabilities in the Linux Kernel" by Yueqi (Lewis) Chen and Xinyu Xing](http://personal.psu.edu/yxc431/publications/SLAKE_Slides.pdf) [slides] [[paper](http://personal.psu.edu/yxc431/publications/SLAKE.pdf)]

[2019, Linux Security Summit EU: "Exploiting Race Conditions Using the Scheduler" by Jann Horn](https://static.sched.com/hosted_files/lsseu2019/04/LSSEU2019%20-%20Exploiting%20race%20conditions%20on%20Linux.pdf) [slides] [[video](https://www.youtube.com/watch?v=MIJL5wLUtKE)]

[2019: "Kepler: Facilitating Control-flow Hijacking Primitive Evaluation for Linux Kernel Vulnerabilities"](https://www.usenix.org/sites/default/files/conference/protected-files/sec19_slides_wu-wei.pdf) [slides] [[video](https://www.youtube.com/watch?v=4b_GbFs5XZI)] [[paper](https://www.usenix.org/system/files/sec19-wu-wei.pdf)]

[2019: "Leak kernel pointer by exploiting uninitialized uses in Linux kernel" by Jinbum Park](https://jinb-park.github.io/leak-kptr.html) [slides]

[2018: "FUZE: Towards Facilitating Exploit Generation for Kernel Use-After-Free Vulnerabilities"](http://personal.psu.edu/yxc431/publications/FUZE_Slides.pdf) [slides] [[whitepaper](http://personal.psu.edu/yxc431/publications/FUZE.pdf)]

[2018: "Linux Kernel universal heap spray" by Vitaly Nikolenko](https://cyseclabs.com/blog/linux-kernel-heap-spray) [article]

[2018: "Linux-Kernel-Exploit Stack Smashing"](https://web.archive.org/web/20190421131414/http://tacxingxing.com/2018/02/15/linux-kernel-exploit-stack-smashing/) [article]

[2018: "Entering God Mode  -  The Kernel Space Mirroring Attack"](https://hackernoon.com/entering-god-mode-the-kernel-space-mirroring-attack-8a86b749545f) [article]

[2018, HitB: "Mirror Mirror: Rooting Android 8 with a Kernel Space Mirroring Attack" by Wang Yong](https://conference.hitb.org/hitbsecconf2018ams/materials/D1T2%20-%20Yong%20Wang%20&%20Yang%20Song%20-%20Rooting%20Android%208%20with%20a%20Kernel%20Space%20Mirroring%20Attack.pdf) [slides]

[2018, BlackHat: "KSMA:	Breaking	Android	kernel	isolation	and	Rooting	with	ARM	MMU	features" by Wang Yong](https://www.blackhat.com/docs/asia-18/asia-18-WANG-KSMA-Breaking-Android-kernel-isolation-and-Rooting-with-ARM-MMU-features.pdf) [slides]

[2018: "Still Hammerable and Exploitable: on the Effectiveness of Software-only Physical Kernel Isolation"](https://arxiv.org/pdf/1802.07060.pdf) [paper]

[2018: "linux kernel pwn notes"](https://www.cnblogs.com/hac425/p/9416886.html) [article]

[2018: "Use of timer_list structure in linux kernel exploit"](https://xz.aliyun.com/t/3455) [article]

[2017: "KERNELFAULT: Pwning Linux using Hardware Fault Injection" by Niek Timmers and Cristofaro Mune](https://www.youtube.com/watch?v=nqF_IjXg_uM) [video]

[2017: "Escalating Privileges in Linux using Fault Injection" by Niek Timmers and Cristofaro Mune](https://www.riscure.com/uploads/2017/10/escalating-privileges-in-linux-using-fi-presentation-fdtc-2017.pdf) [slides]

[2017: "Escalating Privileges in Linux using Fault Injection" by Niek Timmers and Cristofaro Mune](https://www.riscure.com/uploads/2017/10/Riscure_Whitepaper_Escalating_Privileges_in_Linux_using_Fault_Injection.pdf) [whitepaper]

[2017: "Kernel Driver mmap Handler Exploitation" by Mateusz Fruba](https://labs.mwrinfosecurity.com/assets/BlogFiles/mwri-mmap-exploitation-whitepaper-2017-09-18.pdf) [whitepaper]

[2017: "Linux kernel addr_limit bug / exploitation" by Vitaly Nikolenko](https://www.youtube.com/watch?v=UFakJa3t8Ls) [video]

[2017: "The Stack Clash" by Qualys Research Team](https://www.qualys.com/2017/06/19/stack-clash/stack-clash.txt) [article]

[2017: "New Reliable Android Kernel Root Exploitation Techniques"](http://powerofcommunity.net/poc2016/x82.pdf) [slides]

[2017: "Unleashing Use-Before-Initialization Vulnerabilities in the Linux Kernel Using Targeted Stack Spraying"](https://www-users.cs.umn.edu/~kjlu/papers/tss.pdf) [whitepaper]

[2017: "Breaking KASLR with perf" by Lizzie Dixon](https://blog.lizzie.io/kaslr-and-perf.html) [article]

[2017: "Linux kernel exploit cheetsheet"](https://github.com/verctor/MyNotes/blob/master/linux/linux_kernel_exploit_cheetsheet.md) [article]

[2016: "Getting Physical Extreme abuse of Intel based Paging Systems" by Nicolas Economou and Enrique Nissim](https://cansecwest.com/slides/2016/CSW2016_Economou-Nissim_GettingPhysical.pdf) [slides]

[2016: "Linux Kernel ROP - Ropping your way to # (Part 1)" by Vitaly Nikolenko](https://www.trustwave.com/Resources/SpiderLabs-Blog/Linux-Kernel-ROP---Ropping-your-way-to---(Part-1)/) [article]

[2016: "Linux Kernel ROP - Ropping your way to # (Part 2)" by Vitaly Nikolenko](https://www.trustwave.com/Resources/SpiderLabs-Blog/Linux-Kernel-ROP---Ropping-your-way-to---(Part-2)/) [article]

[2016, Ruxcon: "Exploiting COF Vulnerabilities in the Linux kernel" by Vitaly Nikolenko](https://ruxcon.org.au/assets/2016/slides/ruxcon2016-Vitaly.pdf) [slides]

[2016: "Using userfaultfd" by Lizzie Dixon](https://blog.lizzie.io/using-userfaultfd.html) [article]

[2016, DEF CON 24: "Direct Memory Attack the Kernel" by Ulf Frisk](https://www.youtube.com/watch?v=fXthwl6ShOg) [video]

[2016, MOSEC 2016: "Talk is cheap, show me the code" by Keen Lab](https://speakerdeck.com/retme7/talk-is-cheap-show-me-the-code) [slides]

[2016, Black Hat: "Randomization Can't Stop BPF JIT Spray" by Elena Reshetova](https://www.blackhat.com/docs/eu-16/materials/eu-16-Reshetova-Randomization-Can't-Stop-BPF-JIT-Spray.pdf) [slides] [[video](https://www.youtube.com/watch?v=_F7iQQ1Um2M)] [[whitepaper](https://www.blackhat.com/docs/eu-16/materials/eu-16-Reshetova-Randomization-Can't-Stop-BPF-JIT-Spray-wp.pdf)]

[2015: "Kernel Data Attack is a Realistic Security Threat"](https://www.eecis.udel.edu/~hnw/paper/kerneldata.pdf) [whitepaper]

[2015: "From Collision To Exploitation: Unleashing Use-After-Free Vulnerabilities in Linux Kernel"](http://repository.root-me.org/Exploitation%20-%20Syst%C3%A8me/Unix/EN%20-%20From%20collision%20to%20exploitation%3A%20Unleashing%20Use-After-Free%20vulnerabilities%20in%20Linux%20Kernel.pdf) [whitepaper]

[2015: "Linux Kernel Exploitation" by Patrick Biernat](http://security.cs.rpi.edu/courses/binexp-spring2015/lectures/23/13_lecture.pdf) [slides]

[2013, Black Hat USA: "Hacking like in the Movies: Visualizing Page Tables for Local Exploitation"](https://www.youtube.com/watch?v=Of6DemoMLaA)

[2013: "Exploiting linux kernel heap corruptions" by Mohamed Channam](http://resources.infosecinstitute.com/exploiting-linux-kernel-heap-corruptions-slub-allocator/) [article]

[2012: "Writing kernel exploits" by Keegan McAllister](https://tc.gtisc.gatech.edu/bss/2014/r/kernel-exploits.pdf) [slides]

[2012: "Understanding Linux Kernel Vulnerabilities" by Richard Carback](https://www.csee.umbc.edu/courses/undergraduate/421/Spring12/02/slides/ULKV.pdf) [slides]

[2012: "A Heap of Trouble: Breaking the Linux Kernel SLOB Allocator" by Dan Rosenberg](https://www.vsecurity.com//download/papers/slob-exploitation.pdf) [whitepaper]

[2012: "Attacking hardened Linux systems with kernel JIT spraying" by Keegan McAllister](https://mainisusuallyafunction.blogspot.ru/2012/11/attacking-hardened-linux-systems-with.html) [article]

[2012: "The Linux kernel memory allocators from an exploitation perspective" by Patroklos Argyroudis](https://argp.github.io/2012/01/03/linux-kernel-heap-exploitation/) [article]

[2012: "The Stack is Back" by Jon Oberheide](https://jon.oberheide.org/files/infiltrate12-thestackisback.pdf) [slides]

[2012: "Stackjacking" by Jon Oberheide and Dan Rosenberg](https://www.slideshare.net/scovetta/stackjacking) [slides]

[2011: "Stackjacking Your Way to grsec/PaX Bypass" by Jon Oberheide](https://jon.oberheide.org/blog/2011/04/20/stackjacking-your-way-to-grsec-pax-bypass/) [article]

[2010: "Much ado about NULL: Exploiting a kernel NULL dereference"](https://blogs.oracle.com/ksplice/entry/much_ado_about_null_exploiting1) [article]

[2010: "Exploiting Stack Overflows in the Linux Kernel" by Jon Oberheide](https://jon.oberheide.org/blog/2010/11/29/exploiting-stack-overflows-in-the-linux-kernel/) [article]

[2010, SOURCE Boston: "Linux Kernel Exploitation: Earning Its Pwnie a Vuln at a Time" by Jon Oberheide](https://jon.oberheide.org/files/source10-linuxkernel-jonoberheide.pdf) [slides]

[2009, CanSecWest: "There's a party at ring0, and you're invited" by Tavis Ormandy and Julien Tinnes](https://www.cr0.org/paper/to-jt-party-at-ring0.pdf) [slides]

[2007: "Kernel-mode exploits primer" by Sylvester Keil and Clemens Kolbitsch](http://old.iseclab.org/projects/vifuzz/docs/exploit.pdf) [whitepaper]

[2007, Phrack: "Attacking the Core : Kernel Exploiting Notes"](http://phrack.org/archives/issues/64/6.txt) [article]

[2007: "The story of exploiting kmalloc() overflows"](http://www.ouah.org/kmallocstory.html) [article]

[2007: "Linux 2.6 Kernel Exploits" by Stephane Duverger](https://airbus-seclab.github.io/kernsploit/kernel_exploit_syscan07.pdf) [slides]

[2005, CancSecWest: "Large memory management vulnerabilities" by Gael Delalleau](https://cansecwest.com/core05/memory_vulns_delalleau.pdf) [slides]

[2005: "The story of exploiting kmalloc() overflows"](https://argp.github.io/public/kmalloc_exploitation.pdf) [article]


## Vulnerabilities

### Information leak

[2019: "CVE-2018-3639 / CVE-2019-7308—Analysis of Spectre Attacking Linux Kernel ebpf"](https://xz.aliyun.com/t/4230) [article, CVE-2018-3639, CVE-2019-7308]

[2019: "From IP ID to Device ID and KASLR Bypass (Extended Version)"](https://arxiv.org/pdf/1906.10478.pdf) [paper]

[2018: "Kernel Memory disclosure & CANVAS Part 1 - Spectre: tips & tricks"](https://www.immunityinc.com/downloads/Kernel-Memory-Disclosure-and-Canvas_Part_1.pdf) [article, Spectre]

[2018: "Kernel Memory disclosure & CANVAS Part 2 - CVE-2017-18344 analysis & exploitation notes"](https://www.immunityinc.com/downloads/Kernel-Memory-Disclosure-and-Canvas_Part_2.pdf) [article, CVE-2017-18344]

[2018: "Linux kernel: CVE-2017-18344: arbitrary-read vulnerability in the timer subsystem" by Andrey Konovalov](https://www.openwall.com/lists/oss-security/2018/08/09/6) [announcement, CVE-2017-18344]

[2017: "Linux kernel 2.6.0 to 4.12-rc4 infoleak due to a data race in ALSA timer" by Alexander Potapenko](http://seclists.org/oss-sec/2017/q2/455) [announcement, CVE-2017-1000380]

[2017: "The Infoleak that (Mostly) Wasn't" by Brad Spengler](https://grsecurity.net/the_infoleak_that_mostly_wasnt.php) [article, CVE-2017-7616]

[2016: "Exploiting a Linux Kernel Infoleak to bypass Linux kASLR"](https://marcograss.github.io/security/linux/2016/01/24/exploiting-infoleak-linux-kaslr-bypass.html) [article]

[2010: "Linux Kernel pktcdvd Memory Disclosure" by Jon Oberheide](https://jon.oberheide.org/blog/2010/10/23/linux-kernel-pktcdvd-memory-disclosure/) [article, CVE-2010-3437]

[2009: "Linux Kernel x86-64 Register Leak" by Jon Oberheide](https://jon.oberheide.org/blog/2009/10/04/linux-kernel-x86-64-register-leak/) [article, CVE-2009-2910]

[2009: "Linux Kernel getname() Stack Memory Disclosures" by Jon Oberheide](https://jon.oberheide.org/blog/2009/08/29/linux-kernel-getname-stack-memory-disclosures/) [article, CVE-2009-3001]


### LPE

[2020: "Mitigations are attack surface, too" by Jann Horn](https://googleprojectzero.blogspot.com/2020/02/mitigations-are-attack-surface-too.html) [article]

[2020: "CVE-2019-18683: Exploiting a Linux kernel vulnerability in the V4L2 subsystem" by Alexander Popov](https://a13xp0p0v.github.io/2020/02/15/CVE-2019-18683.html) [article, CVE-2019-18683] [[slides](https://a13xp0p0v.github.io/img/CVE-2019-18683.pdf)]

[2019: "Bad Binder: Android In-The-Wild Exploit" by Maddie Stone](https://googleprojectzero.blogspot.com/2019/11/bad-binder-android-in-wild-exploit.html) [article, CVE-2019-2215]

[2019: "Analyzing Android's CVE-2019-2215 (/dev/binder UAF)"](https://dayzerosec.com/posts/analyzing-androids-cve-2019-2215-dev-binder-uaf/) [article, CVE-2019-2215]

[2019: "Stream Cut: Android Kernel Exploitation with Binder Use-After-Free (CVE-2019-2215)"](https://www.youtube.com/watch?v=yrLXvmzUQME) [video, CVE-2019-2215]

[2019: "CVE-2019-2215 - Android kernel binder vulnerability analysis"](https://xz.aliyun.com/t/6853) [article, CVE-2019-2215]

[2019, Linux Security Summit EU: "Deep Analysis of Exploitable Linux Kernel Vulnerabilities" by Tong Lin and Luhai Chen](https://www.youtube.com/watch?v=MYEAGmP_id4) [video, CVE-2017-16995, CVE-2017-10661]

[2019: "Tailoring CVE-2019-2215 to Achieve Root" by Grant Hernandez](https://hernan.de/blog/2019/10/15/tailoring-cve-2019-2215-to-achieve-root/) [article, CVE-2019-2215]

[2019: "Android: Use-After-Free in Binder driver"](https://bugs.chromium.org/p/project-zero/issues/detail?id=1942) [announcement, CVE 2019-2215]

[2019: "From	Zero	to	Root:	Building	Universal	Android	Rooting	with	a Type	Confusion	Vulnerability" by Wang Yong](https://github.com/ThomasKing2014/slides/blob/master/Building%20universal%20Android%20rooting%20with%20a%20type%20confusion%20vulnerability.pdf) [slides, CVE-2018-9568]

[2019: "Android Binder: The Bridge To Root" by Hongli Han and Mingjian Zhou](https://conference.hitb.org/hitbsecconf2019ams/materials/D2T2%20-%20Binder%20-%20The%20Bridge%20to%20Root%20-%20Hongli%20Han%20&%20Mingjian%20Zhou.pdf) [slides, CVE-2019-2025]

[2019: "The ‘Waterdrop’ in Android: A Binder Kernel Vulnerability" by Hongli Han](http://blogs.360.cn/post/Binder_Kernel_Vul_EN.html) [article, CVE-2019-2025]

[2019: "An Exercise in Practical Container Escapology" by Nick Freeman](https://capsule8.com/blog/practical-container-escape-exercise/) [article, CVE-2017-1000112]

[2019: "Taking a page from the kernel's book: A TLB issue in mremap()" by Jann Horn](https://googleprojectzero.blogspot.com/2019/01/taking-page-from-kernels-book-tlb-issue.html) [article, CVE-2018-18281]

[2019: "CVE-2018-18281 - Analysis of TLB Vulnerabilities in Linux Kernel"](https://xz.aliyun.com/t/4005) [article]

[2019: "Analysis of Linux xfrm Module Cross-Border Read-Write Escalation Vulnerability (CVE-2017-7184)"](http://p4nda.top/2019/02/16/CVE-2017-7184/) [article, CVE-2017-7184]

[2019: "Analysis of Escalation Vulnerability Caused by Integer Extension of Linux ebpf Module (CVE-2017-16995)"](http://p4nda.top/2019/01/18/CVE-2017-16995/) [article, CVE-2017-16995]

[2019: "Linux kernel 4.20 BPF integer overflow vulnerability analysis"](http://p4nda.top/2019/01/02/kernel-bpf-overflow/) [article]

[2018: "Linux kernel 4.20 BPF integer overflow-heap overflow vulnerability and its exploitation"](https://www.anquanke.com/post/id/166819) [article]

[2018: "CVE-2017-11176: A step-by-step Linux Kernel exploitation](https://blog.lexfo.fr/) [article, CVE-2017-11176]

[2018: "A cache invalidation bug in Linux memory management" by Jann Horn](https://googleprojectzero.blogspot.com/2018/09/a-cache-invalidation-bug-in-linux.html) [article, CVE-2018-17182]

[2018, beVX: "Dissecting a 17-year-old kernel bug" by Vitaly Nikolenko](https://cyseclabs.com/slides/bevx-talk.pdf) [slides, CVE-2018-6554, CVE-2018-6555]

[2018: "SSD Advisory – IRDA Linux Driver UAF"](https://blogs.securiteam.com/index.php/archives/3759) [article, CVE-2018-6554, CVE-2018-6555]

[2018: "Integer overflow in Linux's create_elf_tables()"](https://www.openwall.com/lists/oss-security/2018/09/25/4) [announcement, CVE-2018-14634]

[2018: "MMap Vulnerabilities – Linux Kernel"](https://research.checkpoint.com/mmap-vulnerabilities-linux-kernel/) [article, CVE-2018-8781]

[2018: "Ubuntu kernel eBPF 0day analysis"](https://security.tencent.com/index.php/blog/msg/124) [article, CVE-2017-16995]

[2018: "eBPF and Analysis of the get-rekt-linux-hardened.c Exploit for CVE-2017-16995"](https://ricklarabee.blogspot.com/2018/07/ebpf-and-analysis-of-get-rekt-linux.html) [article, CVE-2017-16695]

[2017: "Linux kernel: CVE-2017-1000112: Exploitable memory corruption due to UFO to non-UFO path switch" by Andrey Konovalov](http://seclists.org/oss-sec/2017/q3/286) [announcement, CVE-2017-1000112]

[2017: "Linux Kernel Vulnerability Can Lead to Privilege Escalation: Analyzing CVE-2017-1000112" by Krishs Patil](https://securingtomorrow.mcafee.com/mcafee-labs/linux-kernel-vulnerability-can-lead-to-privilege-escalation-analyzing-cve-2017-1000112/) [article, CVE-2017-1000112]

[2017: "Adapting the POC for CVE-2017-1000112 to Other Kernels"](https://ricklarabee.blogspot.de/2017/12/adapting-poc-for-cve-2017-1000112-to.html) [article, CVE-2017-1000112]

[2017: "The Art of Exploiting Unconventional Use-after-free Bugs in Android Kernel" by Di Shen](https://speakerdeck.com/retme7/the-art-of-exploiting-unconventional-use-after-free-bugs-in-android-kernel) [slides, CVE-2017-0403, CVE-2016-6787] [[video](https://www.youtube.com/watch?v=U2qvK1hJ6zg)]

[2017: "Exploiting CVE-2017-5123 with full protections. SMEP, SMAP, and the Chrome Sandbox!" by Chris Salls](https://salls.github.io/Linux-Kernel-CVE-2017-5123/) [article, CVE-2017-5123]

[2017: "Exploiting CVE-2017-5123" by Federico Bento](https://reverse.put.as/2017/11/07/exploiting-cve-2017-5123/) [article, CVE-2017-5123]

[2017: "Escaping Docker container using waitid() – CVE-2017-5123" by Daniel Shapira](https://www.twistlock.com/2017/12/27/escaping-docker-container-using-waitid-cve-2017-5123/) [article, CVE-2017-5123]

[2017: "LKE v4.13.x - waitid() LPE" by HyeongChan Kim](http://kozistr.tech/sec-res/2017/10/29/LKE-CVE-2017-5123.html) [article, CVE-2017-5123]

[2017: "Exploiting on CVE-2016-6787"](https://hardenedlinux.github.io/system-security/2017/10/16/Exploiting-on-CVE-2016-6787.html) [article, CVE-2016-6787]

[2017: "Race For Root: The Analysis Of The Linux Kernel Race Condition Exploit" by Alexander Popov](https://www.youtube.com/watch?v=g7Qm0NpPAz4) [video, CVE-2017-2636]

[2017: "Race For Root: The Analysis Of The Linux Kernel Race Condition Exploit" by Alexander Popov](https://program.sha2017.org/system/event_attachments/attachments/000/000/111/original/a13xp0p0v_race_for_root_SHA2017.pdf) [slides, CVE-2017-2636]

[2017: "CVE-2017-2636: exploit the race condition in the n_hdlc Linux kernel driver bypassing SMEP" by Alexander Popov](https://a13xp0p0v.github.io/2017/03/24/CVE-2017-2636.html) [article, CVE-2017-2636]

[2017: "CVE-2017-2636: local privilege escalation flaw in n_hdlc" by Alexander Popov](http://seclists.org/oss-sec/2017/q1/569) [announcement, CVE-2017-2636]

[2017: "Dirty COW and why lying is bad even if you are the Linux kernel"](https://chao-tic.github.io/blog/2017/05/24/dirty-cow) [article, CVE-2016-5195]

[2017: "NDAY-2017-0103: Arbitrary kernel write in sys_oabi_epoll_wait" by Zuk Avraham](https://blog.zimperium.com/nday-2017-0103-arbitrary-kernel-write-in-sys_oabi_epoll_wait/) [article, CVE-2016-3857]

[2017: "NDAY-2017-0106: Elevation of Privilege in NVIDIA nvhost-vic driver" by Zuk Avraham](https://blog.zimperium.com/nday-2017-0106-elevation-of-privilege-in-nvidia-nvhost-vic-driver/) [article, CVE-2016-2434]

[2017: "PWN2OWN 2017 Linux kernel privilege escalation analysis"](https://zhuanlan.zhihu.com/p/26674557) [article, CVE-2017-7184]

[2017: "Exploiting the Linux kernel via packet sockets" by Andrey Konovalov](https://googleprojectzero.blogspot.com/2017/05/exploiting-linux-kernel-via-packet.html) [article, CVE-2017-7308]

[2017: "NDAY-2017-0105: Elevation of Privilege Vulnerability in MSM Thermal Drive" by Zuk Avraham](https://blog.zimperium.com/nday-2017-0105-elevation-of-privilege-vulnerability-in-msm-thermal-driver/) [article, CVE-2016-2411]

[2017: "NDAY-2017-0102: Elevation of Privilege Vulnerability in NVIDIA Video Driver" by Zuk Avraham](https://blog.zimperium.com/nday-2017-0102-elevation-of-privilege-vulnerability-in-nvidia-video-driver/) [article, CVE-2016-2435]

[2017: "CVE-2017-6074: DCCP double-free vulnerability (local root)" by Andrey Konovalov](http://seclists.org/oss-sec/2017/q1/471) [announcement, CVE-2017-6074]

[2016: "CVE-2016-8655 Linux af_packet.c race condition (local root)" by Philip Pettersson](http://seclists.org/oss-sec/2016/q4/607) [announcement, CVE-2016-8655]

[2016, Black Hat: "Rooting Every Android From Extension To Exploitation" by Di Shen and James Fang](https://speakerdeck.com/retme7/rooting-every-android-from-extension-to-exploitation) [slides, CVE-2015-0570, CVE-2016-0820, CVE-2016-2475, CVE-2016-8453]

[2016: "Talk is Cheap, Show Me the Code" by James Fang, Di Shen and Wen Niu](https://speakerdeck.com/retme7/talk-is-cheap-show-me-the-code) [slides, CVE-2015-1805]

[2016: "CVE-2016-3873: Arbitrary Kernel Write in Nexus 9" by Sagi Kedmi](https://sagi.io/2016/09/cve-2016-3873-arbitrary-kernel-write-in-nexus-9/) [article, CVE-2016-3873]

[2016, Project Zero: "Exploiting Recursion in the Linux Kernel" by Jann Horn](https://googleprojectzero.blogspot.de/2016/06/exploiting-recursion-in-linux-kernel_20.html) [article, CVE-2016-1583]

[2016: "ANALYSIS AND EXPLOITATION OF A LINUX KERNEL VULNERABILITY (CVE-2016-0728)" By Perception Point Research Team](http://perception-point.io/2016/01/14/analysis-and-exploitation-of-a-linux-kernel-vulnerability-cve-2016-0728/) [article, CVE-2016-0728]

[2016: "CVE20160728 Exploit Code Explained" by Shilong Zhao](http://dreamhack.it/linux/2016/01/25/cve-2016-0728-exploit-code-explained.html) [article, CVE-2016-0728]

[2016: "CVE-2016-0728 vs Android" by Collin Mulliner](https://www.mulliner.org/blog/blosxom.cgi/security/CVE-2016-0728_vs_android.writeback?advanced_search=1) [article, CVE-2016-0728]

[2016: "Notes about CVE-2016-7117" by Lizzie Dixon](https://blog.lizzie.io/notes-about-cve-2016-7117.html) [article, CVE-2016-7117]

[2016: "CVE-2016-2384: exploiting a double-free in the usb-midi linux kernel driver" by Andrey Konovalov](https://xairy.github.io/blog/2016/cve-2016-2384) [article, CVE-2016-2384]

[2016: "CVE-2016-6187: Exploiting Linux kernel heap off-by-one" by Vitaly Nikolenko](https://cyseclabs.com/blog/cve-2016-6187-heap-off-by-one-exploit) [article, CVE-2016-6187]

[2016: "CVE-2014-2851 group_info UAF Exploitation" by Vitaly Nikolenko](https://cyseclabs.com/page?n=02012016) [article, CVE-2014-2851]

[2016, HITB Ams: "Perf: From Profiling To Kernel Exploiting" by Wish Wu](https://conference.hitb.org/hitbsecconf2016ams/wp-content/uploads/2015/11/D2T2-Wish-Wu-Perf-From-Profiling-to-Kernel-Exploiting.pdf) [slides, CVE-2016-0819]

[2016, HITB Ams: "Perf: From Profiling To Kernel Exploiting" by Wish Wu](https://www.youtube.com/watch?v=37v14rMtALs) [video, CVE-2016-0819]

[2016: "QUADROOTER: NEW VULNERABILITIES AFFECTING OVER 900 MILLION ANDROID DEVICES"](https://www.blackhat.com/docs/eu-16/materials/eu-16-Donenfeld-Stumping-The-Mobile-Chipset-wp.pdf) [article, CVE-2016-2503, CVE-2106-2504, CVE-2016-2059, CVE-2016-5340]

[2016, DEF CON: "STUMPING THE MOBILE CHIPSET: New 0days from down under" by Adam Donenfeld](https://media.defcon.org/DEF%20CON%2024/DEF%20CON%2024%20presentations/DEF%20CON%2024%20-%20Adam-Donenfeld-Stumping-The-Mobile-Chipset.pdf) [slides, CVE-2016-2503, CVE-2106-2504, CVE-2016-2059, CVE-2016-5340]

[2015: "Android linux kernel privilege escalation vulnerability and exploit (CVE-2014-4322)" by Gal Beniamini](https://bits-please.blogspot.de/2015/08/android-linux-kernel-privilege.html) [article, CVE-2014-4322]

[2015: "Exploiting "BadIRET" vulnerability" by Rafal Wojtczuk](https://web.archive.org/web/20171118232027/https://blogs.bromium.com/exploiting-badiret-vulnerability-cve-2014-9322-linux-kernel-privilege-escalation/) [article, CVE-2014-9322]

[2015: "Follow-up on Exploiting "BadIRET" vulnerability (CVE-2014-9322)" by Adam Zabrocki](http://blog.pi3.com.pl/?p=509) [article, CVE-2014-9322]

[2015, Black Hat: "Ah! Universal Android Rooting Is Back" by Wen Xu](https://www.blackhat.com/docs/us-15/materials/us-15-Xu-Ah-Universal-Android-Rooting-Is-Back-wp.pdf) [whitepaper, CVE-2015-3636]

[2015, Black Hat: "Ah! Universal Android Rooting Is Back" by Wen Xu](https://www.blackhat.com/docs/us-15/materials/us-15-Xu-Ah-Universal-Android-Rooting-Is-Back.pdf) [slides, CVE-2015-3636]

[2015, Black Hat: "Ah! Universal Android Rooting Is Back" by Wen Xu](https://www.youtube.com/watch?v=HVP1c7Ct1nM) [video, CVE-2015-3636]

[2015: "When is something overflowing" by Keen Team](https://www.slideshare.net/PeterHlavaty/overflow-48573748) [slides]

[2015, Project Zero: "Exploiting the DRAM rowhammer bug to gain kernel privileges" by Mark Seaborn and Thomas Dullien](https://googleprojectzero.blogspot.de/2015/03/exploiting-dram-rowhammer-bug-to-gain.html) [article, rowhammer]

[2015: "CVE-2014-4943 - PPPoL2TP DoS Analysis" by Vitaly Nikolenko](https://cyseclabs.com/page?n=01102015) [article, CVE-2014-4943]

[2015: "CVE-2015-0568: Use-After-Free Vulnerability in the Camera Driver of Qualcomm MSM 7x30"](http://c0reteam.org/2015/11/18/cve-20150568) [article, CVE-2015-0568]

[2014: "Exploiting CVE-2014-0196 a walk-through of the Linux pty race condition PoC" by Samuel Gross](http://blog.includesecurity.com/2014/06/exploit-walkthrough-cve-2014-0196-pty-kernel-race-condition.html) [article, CVE-2014-0196]

[2014: "CVE-2014-4014: Linux Kernel Local Privilege Escalation "exploitation"" by Vitaly Nikolenko](https://cyseclabs.com/blog/cve-2014-4014-local-privilege-escalation) [article, CVE-2014-4014]

[2014: "CVE-2014-4699: Linux Kernel ptrace/sysret vulnerability analysis" by Vitaly Nikolenko](https://cyseclabs.com/blog/cve-2014-4699-linux-kernel-ptrace-sysret-analysis) [article, CVE-2014-4699]

[2014: "How to exploit the x32 recvmmsg() kernel vulnerability CVE 2014-0038" by Samuel Gross](http://blog.includesecurity.com/2014/03/exploit-CVE-2014-0038-x32-recvmmsg-kernel-vulnerablity.html) [article, CVE-2014-0038]

[2014: "Exploiting the Futex Bug and uncovering Towelroot"](http://tinyhack.com/2014/07/07/exploiting-the-futex-bug-and-uncovering-towelroot/) [article, CVE-2014-3153]

[2014: "CVE-2014-3153 Exploit" by Joel Eriksson](http://www.clevcode.org/cve-2014-3153-exploit/) [article, CVE-2014-3153]

[2013: "Privilege Escalation Kernel Exploit" by Julius Plenz](https://blog.plenz.com/2013-02/privilege-escalation-kernel-exploit.html) [article, CVE-2013-1763]

[2013: "A closer look at a recent privilege escalation bug in Linux (CVE-2013-2094)" by Joe Damato](http://timetobleed.com/a-closer-look-at-a-recent-privilege-escalation-bug-in-linux-cve-2013-2094/) [article, CVE-2013-2094]

[2012: "Linux Local Privilege Escalation via SUID /proc/pid/mem Write" by Jason Donenfeld](https://git.zx2c4.com/CVE-2012-0056/about/) [article, CVE-2012-0056]

[2011, DEF CON 19: "Kernel Exploitation Via Uninitialized Stack" by Kees Cook](https://www.defcon.org/images/defcon-19/dc-19-presentations/Cook/DEFCON-19-Cook-Kernel-Exploitation.pdf) [slides, CVE-2010-2963]

[2011, DEF CON 19: "Kernel Exploitation Via Uninitialized Stack" by Kees Cook](https://www.youtube.com/watch?v=jg-wnwnkbsy) [video, CVE-2010-2963]

[2010: "CVE-2010-2963 v4l compat exploit" by Kees Cook](https://outflux.net/blog/archives/2010/10/19/cve-2010-2963-v4l-compat-exploit/) [article, CVE-2010-2963]

[2010: "Exploiting large memory management vulnerabilities in Xorg server running on Linux" by Rafal Wojtczuk](http://invisiblethingslab.com/resources/misc-2010/xorg-large-memory-attacks.pdf) [article, CVE-2010-2240]

[2010: "CVE-2010-4258: Turning Denial-of-service Into Privilege Escalation" by Nelson Elhage](https://blog.nelhage.com/2010/12/cve-2010-4258-from-dos-to-privesc/) [article, CVE-2010-4258]

[2010: "CVE-2007-4573: The Anatomy of a Kernel Exploit" by Nelson Elhage](https://blog.nelhage.com/2010/02/cve-2007-4573-the-anatomy-of-a-kernel-exploit/) [article, CVE-2007-4573]

[2010: "Linux Kernel CAN SLUB Overflow" by Jon Oberheide](https://jon.oberheide.org/blog/2010/09/10/linux-kernel-can-slub-overflow/) [article, CVE-2010-2959]

[2010: "af_can linux kernel overflow" by Ben Hawkes](http://inertiawar.com/af_can/) [article, CVE-2010-2959]

[2010: "linux compat vulns (part 1)" by Ben Hawkes](http://inertiawar.com/compat1/) [article, CVE-2010-3081]

[2010: "linux compat vulns (part 2)" by Ben Hawkes](http://inertiawar.com/compat2/) [article, CVE-2010-3301]

[2010: "Some Notes on CVE-2010-3081 Exploitability"](https://blog.nelhage.com/2010/11/exploiting-cve-2010-3081/) [article, CVE-2010-3081]

[2010: "Anatomy of an exploit: CVE-2010-3081"](https://blogs.oracle.com/ksplice/anatomy-of-an-exploit%3a-cve-2010-3081) [article, CVE-2010-3081]

[2010: "CVE-2010-4258: Turning denial-of-service into privilege escalation" by Nelson Elhage](https://blog.nelhage.com/2010/12/cve-2010-4258-from-dos-to-privesc/) [article, CVE-2010-4258]

[2009: "Linux NULL pointer dereference due to incorrect proto_ops initializations (CVE-2009-2692)"](http://blog.cr0.org/2009/08/linux-null-pointer-dereference-due-to.html) [article, CVE-2009-2692]

[2009: "Even when one byte matters"](https://kernelbof.blogspot.de/2009/07/even-when-one-byte-matters.html) [article, CVE-2009-1046]

[2009: "CVE-2008-0009/CVE-2008-0010: Linux kernel vmsplice(2) Privilege Escalation"](https://xorl.wordpress.com/2009/08/10/cve-2008-0600cve-2008-0010-linux-kernel-vmsplice2-privilege-escalation/) [article, CVE-2008-0009, CVE-2008-0010]

[2008: "vmsplice(): the making of a local root exploit" by Jonathan Corbet](https://lwn.net/Articles/268783/) [article, CVE-2008-0600]

[2004: "Linux kernel do_mremap VMA limit local privilege escalation vulnerability"](http://isec.pl/vulnerabilities/isec-0014-mremap-unmap.txt) [article, CVE-2004-0077]


### RCE

[2017: "Over The Air: Exploiting Broadcom’s Wi-Fi Stack (Part 2)" by Gal Beniamini](https://googleprojectzero.blogspot.com/2017/04/over-air-exploiting-broadcoms-wi-fi_11.html) [article, CVE-2017-0569]

[2017: "BlueBorn: The dangers of Bluetooth implementations: Unveiling zero day vulnerabilities and security flaws in modern Bluetooth stacks"](http://go.armis.com/hubfs/BlueBorne%20Technical%20White%20Paper.pdf?t=1505222709963) [whitepaper, CVE-2017-1000251]

[2016: "CVE Publication: CVE 2016-8633" by Eyal Itkin](https://eyalitkin.wordpress.com/2016/11/06/cve-publication-cve-2016-8633/) [article, CVE-2016-8633]

[2011, DEF CON 19: "Owned Over Amateur Radio: Remote Kernel Exploitation in 2011"](http://cs.dartmouth.edu/~sergey/cs258/2012/Dan-Rosenberg-lecture.pdf) [slides, CVE-2011-1493]

[2011, DEF CON 19: "Owned Over Amateur Radio: Remote Kernel Exploitation in 2011"](https://www.youtube.com/watch?v=kBjD0HITQZA) [video, CVE-2011-1493]

[2009: "When a "potential D.o.S." means a one-shot remote kernel exploit: the SCTP story"](https://kernelbof.blogspot.de/2009/04/kernel-memory-corruptions-are-not-just.html) [article, CVE-2009-0065]


### Other

[2020: "BINDER - ANALYSIS AND EXPLOITATION OF CVE-2020-0041" by Jean-Baptiste Cayrou](https://www.synacktiv.com/posts/exploit/binder-analysis-and-exploitation-of-cve-2020-0041.html) [article, CVE-2020-0041] [[slides](https://www.synacktiv.com/ressources/thcon2020_binder.pdf])]

[2020: "The never ending problems of local ASLR holes in Linux"](https://blog.blazeinfosec.com/the-never-ending-problems-of-local-aslr-holes-in-linux/) [article, CVE-2019-11190]

[2019: "Reverse-engineering Broadcom wireless chipsets" by Hugues Anguelkov](https://blog.quarkslab.com/reverse-engineering-broadcom-wireless-chipsets.html) [article, CVE-2019-9503, CVE-2019-9500]

[2019: "CVE-2019-2000 - Android kernel binder vulnerability analysis"](https://xz.aliyun.com/t/4494) [article, CVE-2019-2000]

[2019: "Linux: virtual address 0 is mappable via privileged write() to /proc/\*/mem"](https://bugs.chromium.org/p/project-zero/issues/detail?id=1792&desc=2) [article, CVE-2019-9213]

[2019: "CVE-2019-9213 - Analysis of Linux Kernel User Space 0 Virtual Address Mapping Vulnerability"](https://cert.360.cn/report/detail?id=58e8387ec4c79693354d4797871536ea) [article, CVE-2019-9213]

[2018: "IOMMU-resistant DMA attacks" by Gil Kupfer](http://www.cs.technion.ac.il/users/wwwb/cgi-bin/tr-get.cgi/2018/MSC/MSC-2018-21.pdf) [thesis]

[2017: "initroot: Bypassing Nexus 6 Secure Boot through Kernel Command-line Injection"](https://alephsecurity.com/2017/05/23/nexus6-initroot/#anecdote-a-linux-kernel-out-of-bounds-write-cve-2017-1000363) [article, CVE-2017-1000363]

[2016: "Motorola Android Bootloader Kernel Cmdline Injection Secure Boot Bypass"](https://alephsecurity.com/vulns/aleph-2017011) [article, CVE-2016-10277]

[2015: "Vulnerability in the Linux Crypto API that allows unprivileged users to load arbitrary kernel modules" by Mathias Krause](https://plus.google.com/+MathiasKrause/posts/PqFCo4bfrWu) [annnouncement]


## Protection bypass techniques

[2020: "Weaknesses in Linux Kernel Heap Hardening" by Silvio Cesare](https://blog.infosectcbr.com.au/2020/03/weaknesses-in-linux-kernel-heap.html) [article]

[2020: "PAN: Another day, another broken mitigation" by Siguza](https://siguza.github.io/PAN/) [article]

[2019, POC: "KNOX Kernel Mitigation Bypasses" by Dong-Hoon You](http://powerofcommunity.net/poc2019/x82.pdf) [slides]

[2017: "Lifting the (Hyper) Visor: Bypassing Samsung’s Real-Time Kernel Protection" by Gal Beniamini](https://googleprojectzero.blogspot.com/2017/02/lifting-hyper-visor-bypassing-samsungs.html) [article]

[2016: "Linux Kernel x86-64 bypass SMEP - KASLR - kptr_restric"](https://web.archive.org/web/20171029060939/http://www.blackbunny.io/linux-kernel-x86-64-bypass-smep-kaslr-kptr_restric/) [article]

[2016, KIWICON: "Practical SMEP bypass techniques on Linux" by Vitaly Nikolenko](https://cyseclabs.com/slides/smep_bypass.pdf) [slides]

[2016: "Micro architecture attacks on KASLR" by Anders Fogh"](https://cyber.wtf/2016/10/25/micro-architecture-attacks-on-kasrl/) [article]

[2016: "Jump Over ASLR: Attacking Branch Predictors to Bypass ASLR" by Dmitry Evtyushkin, Dmitry Ponomarev and Nael Abu-Ghazaleh](http://www.cs.ucr.edu/~nael/pubs/micro16.pdf) [slides]

[2016, CCS: "Prefetch Side-Channel Attacks: Bypassing SMAP and Kernel ASLR" by Daniel Gruss, Clementine Maurice, Anders Fogh, Moritz Lipp and Stefan Mangard](https://www.youtube.com/watch?v=TJTQbs3oJx8) [video]

[2016, Black Hat USA: "Using Undocumented CPU Behavior to See Into Kernel Mode and Break KASLR in the Process"](https://www.youtube.com/watch?v=T3kmq2NLpH4) [video]

[2016, Black Hat USA: "Breaking KASLR with Intel TSX" Yeongjin Jang, Sangho Lee and Taesoo Kim](https://www.blackhat.com/docs/us-16/materials/us-16-Jang-Breaking-Kernel-Address-Space-Layout-Randomization-KASLR-With-Intel-TSX.pdf) [slides]

[2016, Black Hat USA: "Breaking KASLR with Intel TSX" Yeongjin Jang, Sangho Lee and Taesoo Kim](https://www.youtube.com/watch?v=rtuXG28g0CU) [video]

[2016: "Breaking KASLR with micro architecture" by Anders Fogh](https://dreamsofastone.blogspot.ru/2016/02/breaking-kasrl-with-micro-architecture.html) [article]

[2015: "Effectively bypassing kptr_restrict on Android" by Gal Beniamini](https://bits-please.blogspot.de/2015/08/effectively-bypassing-kptrrestrict-on.html) [article]

[2014, Black Hat Europe: "ret2dir: Deconstructing Kernel Isolation" by Vasileios P. Kemerlis, Michalis Polychronakis, Angelos D. Keromytis](https://www.blackhat.com/docs/eu-14/materials/eu-14-Kemerlis-Ret2dir-Deconstructing-Kernel-Isolation-wp.pdf) [whitepaper]

[2014, Black Hat Europe: "ret2dir: Deconstructing Kernel Isolation" by Vasileios Kemerlis](https://www.youtube.com/watch?v=kot-EQ9zf9k) [video]

[2013: "A Linux Memory Trick" by Dan Rosenberg](http://vulnfactory.org/blog/2013/02/06/a-linux-memory-trick/) [article]

[2011: "SMEP: What is It, and How to Beat It on Linux" by Dan Rosenberg](http://vulnfactory.org/blog/2011/06/05/smep-what-is-it-and-how-to-beat-it-on-linux/) [article]

[2009: "Bypassing Linux' NULL pointer dereference exploit prevention (mmap_min_addr)"](http://blog.cr0.org/2009/06/bypassing-linux-null-pointer.html) [article]


## Defensive

[2020, linux.conf.au: "Control Flow Integrity in the Linux Kernel" by Kees Cook](https://outflux.net/slides/2020/lca/cfi.pdf) [slides] [[video](https://www.youtube.com/watch?v=0Bj6W7qrOOI)]

[2019: "Camouflage: Hardware-assisted CFI for the ARM Linux kernel"](https://arxiv.org/pdf/1912.04145v1.pdf) [paper]

[2019, Linux Security Summit EU: "A New Proposal for Protecting Kernel Data Memory" by Igor Stoppa](https://www.youtube.com/watch?v=nPH2sQAD6RY) [video]

[2019: "security things in Linux vX.X" by Kees Cook](https://outflux.net/blog/archives/2019/11/14/security-things-in-linux-v5-3/) [articles]

[2019: "Control-Flow Integrity for the Linux kernel: A Security Evaluation" by Federico Manuel Bento](http://www.alunos.dcc.fc.up.pt/~up201407890/Thesis.pdf) [thesis]

[2019: "Kernel Self-Protection Project" by Kees Cook](https://outflux.net/slides/2019/lss/kspp.pdf) [slides]

[2019: "Touch but don’t look - Running the Kernel in Execute-only memory" by Rick Edgecombe](https://linuxplumbersconf.org/event/4/contributions/283/attachments/357/588/Touch_but_dont_look__Running_the_kernel_in_execute_only_memory-presented.pdf) [slides]

[2019: "Breaking and Protecting Linux Kernel Stack" by Elena Reshetova](https://www.youtube.com/watch?v=FacpjoQbMhU) [video]

[2019: "Making C Less Dangerous in the Linux Kernel" by Kees Cook](https://outflux.net/slides/2019/lca/danger.pdf) [slides]

[2019: "Mitigation for the Kernel Space Mirroring Attack (内核镜像攻击的缓解措施)"](http://c0reteam.org/2019/01/02/ksma) [article]

[2018: "The State of Kernel Self Protection" by Kees Cook](https://outflux.net/slides/2018/lss/kspp.pdf) [slides]

[2018: "Android Kernel Control Flow Integrity Analysis (分析)"](http://c0reteam.org/2018/09/17/kcfi) [article]

[2018: "Overview and Recent Developments: Kernel Self-Protection Project" by Kees Cook](https://outflux.net/slides/2018/lss-eu/kspp.pdf) [slides]

[2018, beVX: "The Last Man Standing: The Only Practical, Lightweight and Hypervisor-Based Kernel Protector Struggling with the Real World Alone" by Seunghun Han](https://github.com/kkamagui/papers/blob/master/bevx-2018/presentation.pdf) [video]

[2018, CONFidence: "Linux Kernel Runtime Guard (LKRG) under the hood" by Adam "pi3" Zabrocki](https://www.openwall.com/presentations/CONFidence2018-LKRG-Under-The-Hood/CONFidence2018-LKRG-Under-The-Hood.pdf) [slides, [video](https://www.youtube.com/watch?v=tOiPM692DOM)]

[2018: "GuardION: Practical Mitigation of DMA-based Rowhammer Attacks on ARM"](https://vvdveen.com/publications/dimva2018.pdf) [paper]

[2018, BlackHat: "kR^X: Comprehensive Kernel Protection Against Just-In-Time Code Reuse"](https://www.youtube.com/watch?v=L-3eCmZ8s3A) [video]

[2018: "KASR: A Reliable and Practical Approach to Attack Surface Reduction of Commodity OS Kernels"](https://arxiv.org/pdf/1802.07062.pdf) [paper]

[2018, Linux Conf AU: "The State of Kernel Self Protection" by Kees Cook](https://outflux.net/slides/2018/lca/kspp.pdf) [slides]

[2017: "kR^X: Comprehensive Kernel Protection against Just-In-Time Code Reuse"](https://cs.brown.edu/~vpk/papers/krx.eurosys17.pdf) [paper]

[2017, Linux Piter: "How STACKLEAK improves Linux kernel security" by Alexander Popov](https://linuxpiter.com/system/attachments/files/000/001/376/original/Alexander_Popov_LinuxPiter2017.pdf) [slides]

[2017, HitB: "Shadow-Box: The Practical and Omnipotent Sandbox" by Seunghun Han](http://conference.hitb.org/hitbsecconf2017ams/materials/D1T2%20-%20Seunghun%20Han%20-%20Shadow-Box%20-%20The%20Practical%20and%20Omnipotent%20Sandbox.pdf) [slides]

[2017: "Towards Linux Kernel Memory Safety"](https://arxiv.org/pdf/1710.06175.pdf) [whitepaper]

[2017: "Proposal of a Method to Prevent Privilege Escalation Attacks for Linux Kernel"](https://events.linuxfoundation.org/sites/events/files/slides/nakamura_20170831_1.pdf) [slides]

[2017: "Linux Kernel Self Protection Project" by Kees Cook](https://outflux.net/slides/2017/lss/kspp.pdf) [slides]

[2017: "PT-Rand: Practical Mitigation of Data-only Attacks against Page Tables"](https://www.internetsociety.org/sites/default/files/ndss2017_05B-4_Davi_paper.pdf) [whitepaper]

[2017: "KASLR is Dead: Long Live KASLR"](https://gruss.cc/files/kaiser.pdf) [whitepaper]

[2017: "Honey, I shrunk the attack surface – Adventures in Android security hardening" by Nick Kralevich](https://www.youtube.com/watch?v=ITL6VHOFQj8) [video]

[2017: "Fine Grained Control-Flow Integrity for The Linux Kernel" by Sandro Rigo, Michalis Polychronakis, Vasileios Kemerlis](https://www.blackhat.com/docs/asia-17/materials/asia-17-Moreira-Drop-The-Rop-Fine-Grained-Control-Flow-Integrity-For-The-Linux-Kernel.pdf) [slides]

[2016: "Thwarting unknown bugs: hardening features in the mainline Linux kernel" by Mark Rutland](https://events.static.linuxfound.org/sites/events/files/slides/slides_21.pdf) [slides]

[2016: "Emerging Defense in Android Kernel" by James Fang](http://keenlab.tencent.com/en/2016/06/01/Emerging-Defense-in-Android-Kernel/) [article]

[2016: "Randomizing the Linux kernel heap freelists" by Thomas Garnier](https://medium.com/@mxatone/randomizing-the-linux-kernel-heap-freelists-b899bb99c767#.3csq8t23s) [article]

[2015: "RAP: RIP ROP"](https://pax.grsecurity.net/docs/PaXTeam-H2HC15-RAP-RIP-ROP.pdf) [slides]

[2015: "Protecting Commodity Operating Systems through Strong Kernel Isolation" by Vasileios Kemerlis](http://www.cs.columbia.edu/~angelos/Papers/theses/vpk_thesis.pdf) [whitepaper]

[2014: "Kernel Self-Protection through Quantified Attack Surface Reduction" by Anil Kurmus](https://publikationsserver.tu-braunschweig.de/servlets/MCRFileNodeServlet/digibib_derivate_00036154/Diss_Kurmus_Anil.pdf) [whitepaper]

[2013: "KASLR: An Exercise in Cargo Cult Security" by Brad Spengler](https://forums.grsecurity.net/viewtopic.php?f=7&t=3367) [article]

[2012: "How do I mitigate against NULL pointer dereference vulnerabilities?" by RedHat](https://access.redhat.com/articles/20484) [article]

[2011: "Linux kernel vulnerabilities: State-of-the-art defenses and open problems"](https://pdos.csail.mit.edu/papers/chen-kbugs.pdf) [paper]

[2009, Phrack: "Linux Kernel Heap Tampering Detection" by Larry Highsmith](http://phrack.org/archives/issues/66/15.txt) [article]


## Vulnerability discovery

[2020: "HFL: Hybrid Fuzzing on the Linux Kernel"](https://www.ndss-symposium.org/wp-content/uploads/2020/02/24018.pdf) [paper]

[2020: "KOOBE: Towards Facilitating Exploit Generation of Kernel Out-Of-Bounds Write Vulnerabilities"](https://www.usenix.org/system/files/sec20summer_chen-weiteng_prepub.pdf) [paper]

[2020: "Analyzing the Linux Kernel in Userland with AFL and KLEE"](https://blog.grimm-co.com/post/analyzing-the-linux-kernel-in-userland-with-afl-and-klee/) [article]

[2019: "Effective Static Analysis of Concurrency Use-After-Free Bugs in Linux Device Drivers"](https://hal.inria.fr/hal-02182516/document) [paper]

[2019: "A gentle introduction to Linux Kernel fuzzing" by
Marek Majkowski](https://blog.cloudflare.com/a-gentle-introduction-to-linux-kernel-fuzzing/) [article]

[2019: "Unicorefuzz: On the Viability of Emulation for Kernelspace Fuzzing"](https://www.usenix.org/system/files/woot19-paper_maier.pdf) [paper]

[2019: "Case study: Searching for a vulnerability pattern in the Linux kernel" by Alexander Popov](https://a13xp0p0v.github.io/2019/08/10/cfu.html) [article]

[2019: "Razzer: Finding Kernel Race Bugs through Fuzzing"](https://www.youtube.com/watch?v=9UszCIxc0r0) [video]

[2019: "Fuzzing File Systems via Two-Dimensional Input Space Exploration"](https://taesoo.kim/pubs/2019/xu:janus.pdf) [paper]

[2019: "PeriScope: An Effective Probing and Fuzzing Framework for the Hardware-OS Boundary"](https://www.ndss-symposium.org/wp-content/uploads/2019/02/ndss2019_04A-1_Song_paper.pdf) [paper]

[2019: "Hourglass	Fuzz:	A	Quick	Bug	Hunting	Method"](https://conference.hitb.org/hitbsecconf2019ams/materials/D1T2%20-%20Hourglass%20Fuzz%20-%20A%20Quick%20Bug%20Hunting%20Method%20-%20Moony%20Li,%20Todd%20Han,%20Lance%20Jiang%20&%20Lilang%20Wu.pdf) [slides]

[2018: "RAZZER: Finding Kernel Race Bugs through Fuzzing"](https://lifeasageek.github.io/papers/jeong:razzer.pdf) [paper]

[2018: "FastSyzkaller: Improving Fuzz Efficiency for Linux Kernel Fuzzing"](https://iopscience.iop.org/article/10.1088/1742-6596/1176/2/022013/pdf) [paper]

[2018: "Writing the worlds worst Android fuzzer, and then improving it" by Brandon Falk](https://gamozolabs.github.io/fuzzing/2018/10/18/terrible_android_fuzzer.html) [article]

[2018: "From Thousands of Hours to a Couple of Minutes: Towards Automating Exploit Generation for Arbitrary Types of Kernel Vulnerabilities"](http://i.blackhat.com/us-18/Thu-August-9/us-18-Wu-Towards-Automating-Exploit-Generation-For-Arbitrary-Types-of-Kernel-Vulnerabilities.pdf) [slides] [[whitepaper](http://i.blackhat.com/us-18/Thu-August-9/us-18-Wu-Towards-Automating-Exploit-Generation-For-Arbitrary-Types-of-Kernel-Vulnerabilities-wp.pdf)]

[2018: "MoonShine: Optimizing OS Fuzzer Seed Selection with Trace Distillation"](http://www.cs.columbia.edu/~suman/docs/moonshine.pdf) [paper]

[2018: "Detecting Kernel Memory Disclosure with x86 Emulation and Taint Tracking" by Mateusz Jurczyk](https://j00ru.vexillium.org/papers/2018/bochspwn_reloaded.pdf) [whitepaper]

[2018, BlackHat: "New Compat Vulnerabilities In Linux Device Drivers"](https://www.blackhat.com/docs/asia-18/asia-18-Ding-New-Compat-Vulnerabilities-In-Linux-Device-Drivers.pdf) [slides]

[2018: "Precise and Scalable Detection of Double-Fetch Bugs in OS Kernels"](http://www-users.cs.umn.edu/~kjlu/papers/deadline.pdf) [paper]

[2018, OffensiveCon: "Concolic Testing for Kernel Fuzzing and Vulnerability Discovery" by Vitaly Nikolenko](https://www.youtube.com/watch?v=mpfKN1URqdQ) [video]

[2017: "KernelMemorySanitizer (KMSAN)" by Alexander Potapenko](https://blog.linuxplumbersconf.org/2017/ocw/system/presentations/4825/original/KMSAN%20presentation%20for%20LPC%202017.pdf) [slides]

[2017: "The android vulnerability discovery in SoC" by Yu Pan and Yang Dai](http://powerofcommunity.net/poc2017/yu.pdf) [slides]

[2017, Black Hat USA: "Evolutionary Kernel Fuzzing" by Richard Johnson](https://moflow.org/Presentations/Evolutionary%20Kernel%20Fuzzing-BH2017-rjohnson-FINAL.pdf) [slides]

[2017: "DIFUZE: Interface Aware Fuzzing for Kernel Drivers"](https://www.blackhat.com/docs/eu-17/materials/eu-17-Corina-Difuzzing-Android-Kernel-Drivers.pdf) [slides] [[whitepaper](https://www.blackhat.com/docs/eu-17/materials/eu-17-Corina-Difuzzing-Android-Kernel-Drivers-wp.pdf)]

[2017, CCS: "SemFuzz: Semantics-based Automatic Generation of Proof-of-Concept Exploits"](https://acmccs.github.io/papers/p2139-youA.pdf) [whitepaper]

[2017, USENIX: "kAFL: Hardware-Assisted Feedback Fuzzing for OS Kernels"](https://www.usenix.org/system/files/conference/usenixsecurity17/sec17-schumilo.pdf) [whitepaper]

[2017, USENIX: "How Double-Fetch Situations turn into DoubleFetch Vulnerabilities: A Study of Double Fetches in the Linux Kernel"](https://www.usenix.org/system/files/conference/usenixsecurity17/sec17-wang.pdf) [whitepaper]

[2017, USENIX: "DR. CHECKER: A Soundy Analysis for Linux Kernel Drivers"](https://www.usenix.org/system/files/conference/usenixsecurity17/sec17-machiry.pdf) [whitepaper]

[2016: "Using Static Checking To Find Security Vulnerabilities In The Linux Kernel" by Vaishali Thakkar](http://events17.linuxfoundation.org/sites/events/files/slides/Using%20static%20checking%20to%20find%20security%20vulnerabilities%20in%20the%20Linux%20Kernel.pdf) [slides]

[2016: "UniSan: Proactive Kernel Memory Initialization to Eliminate Data Leakages"](https://gts3.org/assets/papers/2016/lu:unisan.pdf) [paper]

[2016: "An Analysis on the Impact and Detection of Kernel Stack Infoleaks"](https://www.researchgate.net/publication/298313650_An_Analysis_on_the_Impact_and_Detection_of_Kernel_Stack_Infoleaks) [paper]

[2016, Linux Plumbers: "Syzkaller, Future Developement" by Dmitry Vyukov](https://docs.google.com/presentation/d/1iAuTvzt_xvDzS2misXwlYko_VDvpvCmDevMOq2rXIcA/edit#slide=id.p) [slides]

[2016: "Coverage-guided kernel fuzzing with syzkaller"](https://lwn.net/Articles/677764/) [article]

[2016: "Filesystem Fuzzing with American Fuzzy Lop" by Vegard Nossum and Quentin Casasnovas](https://events.linuxfoundation.org/sites/events/files/slides/AFL%20filesystem%20fuzzing%2C%20Vault%202016_0.pdf) [slides]

[2016, ToorCon: "Project Triforce: AFL + QEMU + kernel = CVEs! (or) How to use AFL to fuzz arbitrary VMs"](https://github.com/nccgroup/TriforceAFL/blob/master/slides/ToorCon16_TriforceAFL.pdf) [slides]

[2015, LinuxCon North America: "KernelAddressSanitizer (KASan): a fast memory error detector for the Linux kernel" by Andrey Konovalov](http://events.linuxfoundation.org/sites/events/files/slides/LinuxCon%20North%20America%202015%20KernelAddressSanitizer.pdf) [slides]

[2015, DEF CON 23: "Introduction to USB and Fuzzing" by Matt DuHarte](https://www.youtube.com/watch?v=KWOTXypBt4E) [video]

[2015, Black Hat: "Don't Trust Your USB! How to Find Bugs in USB Device Drivers" by Sergej Schumilo, Ralf Spenneberg, and Hendrik Schwartke](https://www.youtube.com/watch?v=OAbzN8k6Am4) [video]

[2012: "Comprehensive Kernel Instrumentation via Dynamic Binary Translation"](http://www.cs.toronto.edu/~peter/feiner_asplos_2012.pdf) [whitepaper]

[2010: "Automatic Bug-finding Techniques for Linux Kernel" by Jiri Slaby](https://www.fi.muni.cz/~xslaby/sklad/teze.pdf) [whitepaper]

[2009, DEF CON 11: "Opensource Kernel Auditing and Exploitation" by Silvio Cesare](https://www.youtube.com/watch?v=sNh2TD6Tf9Q&feature=youtu.be) [video]


## Fuzzers

https://github.com/google/syzkaller

https://github.com/kernelslacker/trinity

http://web.eece.maine.edu/~vweaver/projects/perf_events/fuzzer/

https://github.com/nccgroup/TriforceLinuxSyscallFuzzer

https://github.com/oracle/kernel-fuzzing

https://github.com/rgbkrk/iknowthis

https://github.com/schumilo/vUSBf

https://github.com/ucsb-seclab/difuze

https://github.com/compsec-snu/razzer [race-condition]

https://github.com/fgsect/unicorefuzz

https://github.com/shankarapailoor/moonshine [corpus-generation]


## Exploits

https://www.exploit-db.com/search/?action=search&description=linux+kernel

https://github.com/offensive-security/exploit-database/tree/master/platforms/linux/local

https://bugs.chromium.org/p/project-zero/issues/list?can=1&q=linux+kernel&colspec=ID+Type+Status+Priority+Milestone+Owner+Summary&cells=ids

http://vulnfactory.org/exploits/ [2010-2011]

https://github.com/dirtycow/dirtycow.github.io/wiki/PoCs

https://github.com/ScottyBauer/Android_Kernel_CVE_POCs

https://github.com/f47h3r/hackingteam_exploits

https://github.com/xairy/kernel-exploits

https://github.com/milabs/kernel-exploits/blob/master/CVE-2017-1000112/poc.c (CVE-2017-1000112 exploit with LKRG bypass)

https://github.com/Kabot/Unix-Privilege-Escalation-Exploits-Pack

https://github.com/SecWiki/linux-kernel-exploits

https://grsecurity.net/~spender/exploits/

https://github.com/jiayy/android_vuln_poc-exp

https://github.com/marsyy/littl_tools/tree/master/bluetooth

https://github.com/nongiach/CVE/tree/master/CVE-2017-5123

http://seclists.org/fulldisclosure/2010/Sep/268

https://github.com/hardenedlinux/offensive_poc

https://github.com/jiayy/android_vuln_poc-exp

https://github.com/brl/grlh

https://github.com/externalist/exploit_playground

https://github.com/ww9210/Linux_kernel_exploits [FUZE]

https://github.com/ww9210/kepler-cfhp [KEPLER]

https://github.com/Kabot/Unix-Privilege-Escalation-Exploits-Pack

https://github.com/yzimhao/godpock

https://github.com/packetforger/localroot

http://www.cs.columbia.edu/~vpk/research/ret2dir/

https://github.com/w0lfzhang/kernel_exploit

https://github.com/jinb-park/linux-exploit

https://github.com/bcoles/kernel-exploits

https://github.com/jollheef/lpe

https://github.com/tangsilian/android-vuln

https://github.com/grant-h/qu1ckr00t

https://github.com/kangtastic/cve-2019-2215

https://github.com/QuestEscape/exploit

https://github.com/duasynt/xfrm_poc

https://github.com/saelo/cve-2014-0038


## Tools

https://github.com/jonoberheide/ksymhunter

https://github.com/jonoberheide/kstructhunter

https://github.com/ngalongc/AutoLocalPrivilegeEscalation

https://github.com/PenturaLabs/Linux_Exploit_Suggester

https://github.com/jondonas/linux-exploit-suggester-2

https://github.com/mzet-/linux-exploit-suggester

https://github.com/spencerdodd/kernelpop

https://github.com/vnik5287/kaslr_tsx_bypass

http://www.openwall.com/lkrg/

https://github.com/IAIK/meltdown

https://github.com/nforest/droidimg

https://github.com/a13xp0p0v/kconfig-hardened-check

https://github.com/PaoloMonti42/salt

https://github.com/jollheef/out-of-tree

https://github.com/nforest/droidimg

https://github.com/elfmaster/kdress

https://github.com/mephi42/ida-kallsyms/

[[ KASLD ] Kernel Address Space Layout Derandomization](https://github.com/bcoles/kasld)

## CTF tasks

CSAW CTF 2010: [writeup](https://jon.oberheide.org/blog/2010/11/02/csaw-ctf-kernel-exploitation-challenge/), [source](https://jon.oberheide.org/files/csaw.c), [source and exploit](https://github.com/0x3f97/pwn/tree/master/kernel/csaw-ctf-2010-kernel-exploitation-challenge)

CSAW CTF 2011: [writeup](https://jon.oberheide.org/blog/2011/11/27/csaw-ctf-2011-kernel-exploitation-challenge/), [source](https://jon.oberheide.org/files/SqueamishOssifrage.c)

CSAW CTF 2013: [writeup](https://poppopret.org/2013/11/20/csaw-ctf-2013-kernel-exploitation-challenge/), [source and exploit](https://github.com/mncoppola/Brad-Oberberg)

CSAW CTF 2014: [source and exploit](https://github.com/mncoppola/suckerusu)

CSAW CTF 2015: [writeup 1](https://poppopret.org/2015/11/16/csaw-ctf-2015-kernel-exploitation-challenge/), [writeup 2](http://itszn.com/blog/?p=21), [source and exploit](https://github.com/mncoppola/StringIPC)

Insomni’hack finals 2015: [writeup](https://blog.scrt.ch/2015/03/24/insomnihack-finals-sh1tty-writeup/), [source and exploit](https://github.com/Insomnihack/Insomnihack-2015/tree/master/exploit/sh1tty)

rwth2011 CTF (ps3game): [writeup](http://mslc.ctf.su/wp/rwth2011-ctf-ps3game/)

PlaidCTF 2013 (Servr): [writeup](http://blog.frizn.fr/plaidctf-2013/pwn-400-servr), [source](http://blog.frizn.fr/fil3z/pctf-2013/servr.tar.bz2)

0ctf2016: [writeup](http://dragonsector.pl/docs/0ctf2016_writeups.pdf), [exploit](https://gist.github.com/anonymous/83f96600c5ae851940d6)

0ctf2017: [source and exploit 1](https://github.com/lovelydream/0ctf2017_kernel_pwn), [source and exploit 2](https://github.com/yifengyou/CTF/tree/master/2017/0ctf/pwn/knote)

0ctf2018: [writeup 1](http://blog.eadom.net/writeups/0ctf-2018-zerofs-writeup/), [writeup 2](http://ddaa.tw/0ctf_pwnable_478_zer0fs.html)

QWB2018 (solid_core): [writeup](http://f0r1st.me/2018/04/02/QWB2018-solid-core-Write-Up/), [exploit 1](https://github.com/w0lfzhang/kernel_exploit/tree/master/2018-qwb-core), [exploit 2](https://github.com/sixstars/ctf/tree/master/2018/qiangwangbei/core), [exploit 3](https://github.com/o0xmuhe/PwnableLog/blob/master/CTFWP/qwb2018/core/exp.c)

Blaze2018 (blazeme): [source and exploit 1](https://github.com/vakzz/ctfs/tree/master/Blaze2018/blazeme), [soure and exploit 2](https://github.com/wangray/ctf_dump/tree/master/Blaze2018/blazeme)

TCTF 2017 (cred_jar): [writeup](http://ww9210.cn/2017/06/08/tctf-2017-final-cred_jar-linux-kernel-driver-pwn-write-up/)

N1CTF 2018: [writeup](http://r3ka.eu/2018/03/n1ctf-2018-network-card-writeup/)

Sharif CTF 2018 (kdb): [writeup](https://changochen.github.io/2018/02/07/sharif8/), [source and exploit](https://changochen.github.io/2018/02/07/sharif8/)

NCSTISC 2018 (babydriver): [writeup](http://f0r1st.me/2018/03/28/ROP-in-Linux-Kernel/), [source and exploit](https://github.com/w0lfzhang/kernel_exploit/tree/master/2017-ncstisc-babydriver)

TWCTF 2018 (ReadableKernelModule): [writeup](http://r3ka.eu/2018/09/twctf-2018-rkm-readablekernelmodule-writeup/)

SECT CTF 2018 (Gh0st): [writeup](http://mslc.ctf.su/wp/sect-ctf-2018-gh0st/)

WCTF 2018 (cpf): [source, writeup, and exploit](https://github.com/cykorteam/cykor_belluminar_2018/tree/master/cpf)

hxp CTF 2018 (Green Computing): [writeup](http://s3.eurecom.fr/nops/2018-12-10-hxp-ctf-2018-green-computing.html)

Insomni'hack teaser 2019 (1118daysober): [writeup 1](https://ctftime.org/writeup/12919), [writeup 2](https://github.com/EmpireCTF/empirectf/blob/master/writeups/2019-01-19-Insomni-Hack-Teaser/README.md#1118daysober)

Security Fest 2019 (brainfuck64): [writeup](https://kileak.github.io/ctf/2019/secfest-brainfuck64/)

TokyoWesterns CTF 2019 (gnote): [writeup](https://rpis.ec/blog/tokyowesterns-2019-gnote/), video [part 1](https://www.youtube.com/watch?v=n7osrud3PMI), [part 2](https://www.youtube.com/watch?v=i8gZ85VC2Mw)

Balsn CTF 2019 (KrazyNote): [exploit](https://github.com/Mem2019/Mem2019.github.io/blob/master/codes/krazynote.c)

HITCON CTF Quals 2019 (PoE): [source and exploit](https://github.com/david942j/ctf-writeups/tree/master/hitcon-quals-2019/PoE)

r2con CTF 2019: [source, exploit and writeup](https://github.com/esanfelix/r2con2019-ctf-kernel)

De1CTF 2019 (Race): [writeup and exploit](https://github.com/De1ta-team/De1CTF2019/tree/master/writeup/pwn/Race)

zer0pts CTF 2020 (meow): [writeup](https://pr0cf5.github.io/ctf/2020/03/09/the-plight-of-tty-in-the-linux-kernel.html)


## Misc

https://github.com/Fuzion24/AndroidKernelExploitationPlayground

https://github.com/ReverseLab/kernel-pwn-challenge

https://github.com/djrbliss/libplayground

[pwnable.kr tasks](http://pwnable.kr/play.php) (syscall, rootkit, softmmu, towelroot, kcrc, exynos)

[RPISEC kernel labs](https://github.com/RPISEC/MBE/tree/master/src/lab10)

https://github.com/hackedteam

https://github.com/mncoppola/Linux-Kernel-CTF

https://crowell.github.io/blog/2014/11/24/hosting-a-local-kernel-ctf-challenge/

https://github.com/ukanth/afwall/wiki/Kernel-security

https://github.com/a13xp0p0v/linux-kernel-defence-map

https://github.com/kmcallister/alameda

https://github.com/01org/jit-spray-poc-for-ksp

https://forums.grsecurity.net/viewforum.php?f=7

https://grsecurity.net/research.php

https://github.com/yrp604/atc-sources

https://www.linuxkernelcves.com/

https://github.com/jameshilliard/linux-grsec/

https://github.com/a13xp0p0v/kernel-hack-drill

https://github.com/vnik5287/kernel_rop

https://github.com/R3x/How2Kernel

https://www.twitch.tv/dayzerosec/videos?filter=all&sort=time

https://github.com/pr0cf5/kernel-exploit-practice

https://github.com/milabs/lkrg-bypass
