### <a href="/contents/tools/GDB_Tips.md"><-</a> [.instruction-sets](instruction-sets.md)[__x86__] <a href="x86-64.md">-></a>

---
#### *<p align='center'> Registers </p>*
---
* Temporary storages that are built into the CPU. Aside from the General Purpose Registers (GPRs), most other registers are dedicated to specific purposes
* The 6 16-bit selector registers for x86 architecture are CS, DS, ES, FS, GS, SS 
  * A selector register contains address to a specific block of memory from which one can read or write. It was created for Intel 8086 processor's [memory segmentation model](https://en.wikipedia.org/wiki/Memory_segmentation) to enable access to the full 1 MB of physical memory despite machine word size being only 16-bit (would require 20-bit word size). Nowadays, memory addressing uses the [flat memory model](https://en.wikipedia.org/wiki/Flat_memory_model) since modern processor does not run into the complication with machine word size and addressable memory
  * Although memory segmentation is no longer relevant, [FS and GS selector registers are still being used in OS-specific manners](https://stackoverflow.com/a/10810287)
* Control register: EFLAGS. It contains arithmetic and system flag values
  * Arithmetic flags are used by [JCC](https://c9x.me/x86/html/file_module_x86_id_146.html) instructions to decide whether to branch or not
  * System flags are more specific. For example, Direction Flag (DF) is only used by string instructions (STOS, SCAS, LODS, MOVS, CMPS) to decide whether to process character bytes from high to low addresses or vice versa

---
#### *<p align='center'> Assembly to Machine Code Is Not One-To-One </p>*
---
* An opcode can have multiple mnemonics associated with it and a mnemonic can have multiple opcodes associated with it
* __Example 1__: 0x75 is both the opcode for JNZ and JNE
* __Example 2__: 0xb142 and 0xc6c142 both corresponds to the instruction MOV CL, 66

---
#### *<p align='center'> Lost Of Type Information </p>*
---
* There is no way to tell the datatype of bytes stored in memory by just looking at the location of where it is stored. Instead, the datatype is implied by the operations that are used on it
* __Type Inference From JCC Instruction__: Type inference is generally a non-trivial task, but when the data is used to determine the outcome of a JCC instruction (branch or not) we can easily determine if the data is a sign or unsigned since certain JCC instructions are sign-specific 
  * [Signed, unsigned, sign-irrevalent JCC instructions](https://stackoverflow.com/a/9617990/3003933)

---
#### *<p align='center'> Floating Point Arithmetic </p>*
---
* Floating point operations are performed using the FPU Register Stack, or the ["x87 Stack."](https://en.wikibooks.org/wiki/X86_Assembly/Floating_Point) FPU is divided into 8 registers, st0 to st7. Typical FPU operations will pop item(s) off the stack, perform on it/them, and push the result back to the stack
* FLD instruction is for loading values onto the FPU Register Stack
* FST instruction is for storing values from ST0 into memory
* FPU Register Stack can be accessed only by FPU instructions

---
#### *<p align='center'> Variable-Length Instruction </p>*
---
* Even though most instruction opcodes are only 1 byte long, the total size for those instructions can still range from 1 to 15 bytes. To understand how x86 instructions are encoded, check out this [article](https://www.codeproject.com/Articles/662301/x-Instruction-Encoding-Revealed-Bit-Twiddling-fo)

<div align='center'>
<img src="https://github.com/yellowbyte/reverse-engineering-reference-manual/blob/master/images/instruction-sets/x86/x86.png" height="600" width="400">
<p align='center'><sub><strong>one byte x86 instructions</strong></sub></p>
</div>

---
#### *<p align='center'> Commonly Used But Hard To Remember x86 Instructions With Side Effects </p>*
---
* __Side Effects?__: effects on memory and registers after executing a particular instruction without the effects being explicitly stated in the instruction itself
  * [Binary Ninja](https://binary.ninja/) does a good job revealing implicit registers usage
<div align='center'>
<img src="https://github.com/yellowbyte/reverse-engineering-reference-manual/blob/master/images/instruction-sets/x86/binja_assembly.png">
<p align='center'><sub><strong>registers implicitly used by movsd and stosd instructions are revealed in assembly view</strong></sub></p>
</div>
<div align='center'>
<img src="https://github.com/yellowbyte/reverse-engineering-reference-manual/blob/master/images/instruction-sets/x86/binja_llil_p1.png">
</div>
<div align='center'>
<img src="https://github.com/yellowbyte/reverse-engineering-reference-manual/blob/master/images/instruction-sets/x86/binja_llil_p2.png">
<p align='center'><sub><strong>although use of implicit registers are not shown in assembly view for imul, idiv, and cld instructions, they are in LLIL view</strong></sub></p>
</div>

* __IMUL reg/mem__: register is multiplied with AL, AX, or EAX and the result is stored in AX, DX:AX, or EDX:EAX
* __IDIV reg/mem__: takes one parameter (divisor). Depending on the divisor’s size, div will use either AX, DX:AX, or EDX:EAX as the dividend, and the resulting quotient/remainder pair are stored in AL/AH, AX/DX, or EAX/EDX
* __STOS(B/W/D)__: writes the value AL/AX/EAX to EDI. Commonly used to initialize a buffer to a constant value
* __SCAS(B/W/D)__: compares AL/AX/EAX with data starting at the memory address EDI
* __LODS(B/W/D)__: reads 1, 2, or 4 byte value from esi and stores it in al, ax, or eax
* __MOVS(B/W/D)__: moves data with 1, 2, or 4 byte granularity between two memory addresses. They implicitly use EDI/ESI as the destination/source address
* __CLD/STD__: CLD/STD clears/sets direction flag (DF). If DF is 1, addresses are decremented. It is used by STOS(B/W/D), SCAS(B/W/D), LODS(B/W/D), and MOVS(B/W/D)
* __REP__: repeats an instruction up to ECX times
* __PUSHAD/POPAD__: pushes/pops all 8 general-purpose registers
* __PUSHFD/POPFD__: pushes/pops EFLAGS register
* __MOVSX/MOVZX__: both works like a MOV except MOVSX sign-extends the value in the destination register while MOVZX zero-extends the value in the destination register
* __CMOVcc__: if the condition code's (cc) corresponding flag is set in EFLAGS, MOV will be performed. Otherwises, it's just like a NOP

#
<strong><p align='center'><a href="/contents/tools/GDB_Tips.md">GDB Tips</a> <- <a href="/README.md#-reverse-engineering-reference-manual-beta-">RERM</a>[<a href="instruction-sets.md">.instruction-sets</a>] -> <a href="x86-64.md">x86-64</a></p></strong>
