## *<p align='center'><a href="/contents/encodings/encodings.md"><-</a>  .general  <a href="/contents/tools/tools.md">-></a></p>*

<div align='center'>
<img src="https://github.com/yellowbyte/reverse-engineering-reference-manual/blob/master/images/general/introduction.png">
<p align='center'><sub><strong>semantic insight vs implementation detail</strong></sub></p>
</div>

__What is Reverse Engineering?__
* No one likes reading another person's code. And quite frankly, I enjoy reverse engineering not because I prefer the bloated code generated by software instead. Reverse engineering is more than just reading code. It is about understanding the interactions with different layers of the software stack that are typically abstracted away in higher level programming. It is about understanding how software, that is not your own or not meant to be read by you, works with the rest of the computer system.

__Motivation (Anonymous)__
* Reversing is like solving a puzzle. You start out at one point, putting piece after piece together until you are stuck then you start another colony somewhere else and slowly the little colonies start growing together. You will be able to see the big picture clearer and clearer with every piece you add to the whole. In the end, you marvel at your work, shows it to others, and enjoys it, tells stories about how you did it and can't wait to start all over again with another one because of the fascinating dynamics and the great fun. Whatever you are doing, enjoy your work, be proud of it, and make it something special.

__Semantic Insight vs Implementation Detail__
* Higher semantic insight means better overall understanding of the program and how different parts of it interact with each other whereas higher understanding of implementation detail means better overall understanding of how the computer will run the program. Although you gain greater understanding of implementation detail from the program as it gets closer to the zeros and ones that the CPU executes, you also will lose more and more of the program's semantically rich information. For example, in C++ source code you can use access specifier keywords such as public, protected, or private to enforce access restriction to class member functions. But in the corresponding compiled binary, although acess restriction will be enforced, there will be no remanent blatantly indicating which functions are public, which are private, etc... You might be able to guess the original access specifier for a member function by studying how that member function is being used throughout the program whereas from the source code you can tell right away.

---
### *<p align='center'> section overview </p>*
---
* [Miscellaneous](Miscellaneous.md)
  * [Threads](Miscellaneous.md#-threads-)
  * [Start IS NOT Main](Miscellaneous.md#-start-is-not-main-)
  * [Random Number Generator](Miscellaneous.md#-random-number-generator-)
  * [Endianness](Miscellaneous.md#-endianness-)
  * [Software Breakpoint](Miscellaneous.md#-software-breakpoint-)
  * [Hardware Breakpoint](Miscellaneous.md#-hardware-breakpoint-)
  * [Memory Breakpoint](Miscellaneous.md#-memory-breakpoint-)

---
### *<p align='center'> further readings </p>*
---
* Recommended Websites
  * [Reverse Engineering Workshops](https://malwareunicorn.org/#/workshops) ([@malwareunicorn](https://twitter.com/malwareunicorn))
  * [Reverse Engineering for Beginners](https://www.begin.re/) ([@OphirHarpaz](https://twitter.com/OphirHarpaz))
  * [Android App Reverse Engineering 101](https://maddiestone.github.io/AndroidAppRE/) ([@maddiestone](https://twitter.com/maddiestone))
  * [Binary Analysis Course](https://maxkersten.nl/) ([@LibraAnalysis](https://twitter.com/libraanalysis))
  * [ReversingHero](https://www.reversinghero.com/)
  * [martin.vy](https://martin.uy/blog/projects/reverse-engineering/)
  * [Azeria Labs](https://azeria-labs.com/)
  * [XOR06](https://xor06.wordpress.com/tutorials/) (same author that made [The Legend Of Random](http://octopuslabs.io/legend/blog/sample-page.html))
* Recommended Books
  * [Reverse Engineering for Beginners](https://beginners.re/) ([Dennis Yurichev](https://yurichev.com/))
  * [Practical Reverse Engineering](https://www.amazon.com/Practical-Reverse-Engineering-Reversing-Obfuscation/dp/1118787315)
  * [Practical Malware Analysis](https://nostarch.com/malware)
  * [Practical Binary Analysis](https://nostarch.com/binaryanalysis)
  * [xchg rax, rax](https://www.xorpd.net/pages/xchg_rax/snip_00.html)
* Recommended Forums
  * [0x00SEC](https://0x00sec.org)
  * [BinaryNinja's Slack Channel](https://binaryninja.slack.com/)
  * [Reverse Engineering's subreddit](https://www.reddit.com/r/ReverseEngineering/)
  * [Reverse Engineering's StackExchange](https://reverseengineering.stackexchange.com/)
* Recommended YouTubers
  * [GynvaelEN](https://www.youtube.com/channel/UCCkVMojdBWS-JtH7TliWkVg)
  * [Murmus CTF](https://www.youtube.com/channel/UCUB9vOGEUpw7IKJRoR4PK-A)
  * [Give Academy](https://www.youtube.com/channel/UC8yWAWQXsX8sLEng0s2gJxQ)
  * [LiveOverflow](https://www.youtube.com/channel/UClcE-kVhqyiHCcjYwcpfj9w)
  * [BinaryAdventure](https://www.youtube.com/channel/UCSLlgiYtOXZnYPba_W4bHqQ)
  * [MalwareAnalysisForHedgehogs](https://www.youtube.com/channel/UCVFXrUwuWxNlm6UNZtBLJ-A)
  * [L!NK](https://www.youtube.com/channel/UCv6i6WVf-KeUeXFmp9oy29w)
  * [OALabs](https://www.youtube.com/channel/UC--DwaiMV-jtO-6EvmKOnqg)
* Recommended Magazines
  * [Paged Out!](https://pagedout.institute/)
  * [POC||GTFO](https://www.alchemistowl.org/pocorgtfo/)
* [Full-Stack Reverse Engineer](https://twitter.com/daeken/status/1025123319824244738?ref_src=twsrc%5Egoogle%7Ctwcamp%5Eserp%7Ctwgr%5Etweet): [@daeken](https://twitter.com/daeken)'s steps to getting the base knowledge for reversing anything ([video presentation](https://www.youtube.com/watch?v=9vKG8-TnawY))
* [Program Analysis Reading List](https://www.msreverseengineering.com/program-analysis-reading-list/) ([@RolfRolles](https://twitter.com/RolfRolles))

#
<strong><p align='center'><a href="/contents/encodings/encodings.md">.encodings</a> <- <a href="/README.md#-reverse-engineering-reference-manual-beta-">RERM</a> -> <a href="/contents/tools/tools.md">.tools</a></p></strong>
