// Copyright (c) 2015-2016, tandasat. All rights reserved.
// Use of this source code is governed by a MIT-style license that can be
// found in the LICENSE file.

//
// This module declares interfaces to exclusivity functions.
//

#ifndef UNLINKED_EXCLUSIVITY_H_
#define UNLINKED_EXCLUSIVITY_H_

#include <fltKernel.h>

extern "C" {
////////////////////////////////////////////////////////////////////////////////
//
// macro utilities
//

////////////////////////////////////////////////////////////////////////////////
//
// constants and macros
//

////////////////////////////////////////////////////////////////////////////////
//
// types
//

////////////////////////////////////////////////////////////////////////////////
//
// prototypes
//

_IRQL_raises_(DISPATCH_LEVEL) void *ExclGainExclusivity();

_IRQL_requires_max_(DISPATCH_LEVEL) void ExclReleaseExclusivity(
    _In_opt_ void *exclusivity);

////////////////////////////////////////////////////////////////////////////////
//
// variables
//

////////////////////////////////////////////////////////////////////////////////
//
// implementations
//

}  // extern "C"

#endif  // UNLINKED_EXCLUSIVITY_H_
