#pragma once

#include "ProcessesUtils.h"
#include "LinkedLists.h"

#define ANY_PROCESS (HANDLE)0xFFFFFFFF

#define DEFENCE_SUMMARY_PROCESSES_FLAGS	(\
	PROCESS_TERMINATE					|\
	PROCESS_CREATE_THREAD				|\
	PROCESS_SET_SESSIONID				|\
	PROCESS_VM_OPERATION				|\
	PROCESS_VM_READ						|\
	PROCESS_VM_WRITE					|\
	PROCESS_DUP_HANDLE					|\
	PROCESS_SET_INFORMATION				|\
	PROCESS_QUERY_INFORMATION			|\
	PROCESS_SUSPEND_RESUME				|\
	PROCESS_QUERY_LIMITED_INFORMATION	\
)

#define DEFENCE_SUMMARY_THREADS_FLAGS	(\
	THREAD_TERMINATE					|\
	THREAD_SUSPEND_RESUME				|\
	THREAD_GET_CONTEXT					|\
	THREAD_SET_CONTEXT					|\
	THREAD_SET_INFORMATION				|\
	THREAD_QUERY_INFORMATION			|\
	THREAD_SET_LIMITED_INFORMATION		|\
	THREAD_QUERY_LIMITED_INFORMATION	\
)

BOOL RegisterProtection();
VOID UnregisterProtection();

VOID AddProtectedProcess	(HANDLE ProcessId, HANDLE DefenderId);
VOID RemoveProtectedProcess	(HANDLE ProcessId, HANDLE DefenderId);

typedef enum _PROTECTION_STATUS {
	PROCESS_PROTECTED,
	PROCESS_NOT_PROTECTED,
	DEFENDER_NOT_FOUND
} PROTECTION_STATUS;

PROTECTION_STATUS IsProcessProtected(HANDLE ProcessId, HANDLE DefenderId);

VOID ClearProtectedProcessesList();

VOID PrintProtectedProcessesList();

