# Misc userscripts [![tag](https://img.shields.io/github/tag/Mottie/Misc-userscripts.svg)](https://github.com/Mottie/Misc-userscripts/tags)

Userscripts to add functionality to miscellaneous sites.

## Installation

1. Make sure you have user scripts enabled in your browser (these instructions refer to the latest versions of the browser):

	* Firefox - install [Greasemonkey](https://addons.mozilla.org/en-US/firefox/addon/greasemonkey/).
	* Chrome - install [Tampermonkey](https://tampermonkey.net/?ext=dhdg&browser=chrome).
	* Opera - install [Tampermonkey](https://tampermonkey.net/?ext=dhdg&browser=opera) or [Violent Monkey](https://addons.opera.com/en/extensions/details/violent-monkey/).
	* Safari - install [Tampermonkey](https://tampermonkey.net/?ext=dhdg&browser=safari).
	* Dolphin - install [Tampermonkey](https://tampermonkey.net/?ext=dhdg&browser=dolphin).
	* UC Browser - install [Tampermonkey](https://tampermonkey.net/?ext=dhdg&browser=ucweb).

2. Get information or install:
	* Learn more about the userscript by clicking on the named link. You will be taken to the specific wiki page.
	* Install a script directly from GitHub by clicking on the "install" link in the table below.
	* Install a script from [GreasyFork](https://greasyfork.org/en/users/24847-mottie) (GF) from the userscript site page
	* Or, install the scripts from [OpenUserJS](https://openuserjs.org/users/Mottie/scripts) (OU).<br><br>

	| Userscript Wiki                           | Direct<br>Install   | Sites                       | Created    | Updated    |
	|-------------------------------------------|:-------------------:|:---------------------------:|:----------:|:----------:|
	| [Greasy Fork Total Installs][gfti-wiki]   | [install][gfti-raw] | [GF][gfti-gf] [OU][gfti-ou] | 2017.09.12 | 2017.09.12 |
	| [Cryptokitty rare highlighter][gfti-wiki] | [install][ckrh-raw] | [GF][ckrh-gf] [OU][ckrh-ou] | 2017.12.11 | 2018.07.12 |


[gfti-wiki]: https://github.com/Mottie/Misc-userscripts/wiki/Greasy-Fork-Total-Installs
[ckrh-wiki]: https://github.com/Mottie/Misc-userscripts/wiki/Cryptokitty-Rare-Highlighter

[gfti-raw]: https://raw.githubusercontent.com/Mottie/Misc-userscripts/master/greasy-fork-total-installs.user.js
[ckrh-raw]: https://raw.githubusercontent.com/Mottie/Misc-userscripts/master/cryptokitty-rare-highlighter.user.js

[gfti-gf]: https://greasyfork.org/en/scripts/33064-greasy-fork-total-installs
[ckrh-gf]: https://greasyfork.org/en/scripts/36269-cryptokitty-rare-highlighter

[gfti-ou]: https://openuserjs.org/scripts/Mottie/Greasy_Fork_Total_Installs
[ckrh-ou]: https://openuserjs.org/scripts/Mottie/Cryptokitty_rare_highlighter

## Updating

Userscripts are set up to automatically update. You can check for updates from within the Greasemonkey or Tampermonkey menu, or click on the install link again to get the update.

Each individual userscript's change log is contained on its individual wiki page.

## Issues

Please report any userscript issues within this repository's [issue section](https://github.com/Mottie/Misc-userscripts/issues). Greasyfork messages are also received, but not as easily tracked. Thanks!

## Contributions

If you would like to contribute to this repository, please...

1. Fork
2. Make changes (please read the [contribution guidelines](./CONTRIBUTING.md) and abide by them)
3. Create a pull request!

## Other userscripts not hosted here:

* [GitHub userscripts](https://github.com/Mottie/GitHub-userscripts)
* [GitHub Dark Script](https://github.com/StylishThemes/GitHub-Dark-Script)
	* [Github Monospace Font Toggle](https://greasyfork.org/en/scripts/18787-github-monospace-font-toggle) (also part of GitHub Dark Script)
	* [GitHub Diff File Toggle](https://greasyfork.org/en/scripts/18788-github-diff-file-toggle) (also part of GitHub Dark Script)
	* [GitHub Toggle Code Wrap](https://greasyfork.org/en/scripts/18789-github-toggle-code-wrap) (also part of GitHub Dark Script)
* [GitHub Custom Emojis](https://github.com/StylishThemes/GitHub-Custom-Emojis)
* [GitHub Make Tooltips](https://greasyfork.org/en/scripts/22194)
* [Bitbucket userscripts](https://bitbucket.org/mottie/bitbucket-userscripts)
* [GitLab userscript](https://gitlab.com/Mottie/GitLab-userscripts)
