#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char** argv) {
	FILE *input = NULL, *output = NULL;
	char outpath[256];
	
	if (argc != 3)
		if (argc != 2)
			return 0;
		else
			snprintf(outpath, 256, "%s.js", argv[1]);
	else
		snprintf(outpath, 256, "%s", argv[2]);
	
	input = fopen(argv[1], "rb");
	output = fopen(outpath, "wb");
	if (!input || !output)
		fprintf(stderr, "could not open file");
	
	fseek(input, 0, SEEK_END);
	unsigned long size = ftell(input);
	fseek(input, 0, SEEK_SET);

	uint32_t* buffer = (uint32_t *)malloc(size);
	fread(buffer, 1, size, input);
	fclose(input);
	char text[256];

	snprintf(text, 256, "    var shcode = [");
	fwrite(text, strlen(text), 1, output);

	for (uint32_t i=0; i < size/4; i++) {
		snprintf(text, 256, "0x%08X, ", buffer[i]);
		fwrite(text, strlen(text), 1, output);
	}
	
	snprintf(text, 256, "];\n");
	fwrite(text, strlen(text), 1, output);
	
	fclose(output);
	return 0;
}