/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding.avmplus;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Decimal128;
import macromedia.asc.util.IntList;
import macromedia.asc.util.IntegerPool;
import macromedia.asc.util.ObjectList;
import macromedia.asc.util.StringPrintWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteCodeFactory {
    private static boolean debug = false;
    public StringPrintWriter cpool_out = new StringPrintWriter();
    public StringPrintWriter defns_out = new StringPrintWriter();
    public boolean show_bytecode;
    private Map<String, ByteList> utfConstants = new HashMap<String, ByteList>();
    private Map<Integer, ByteList> nsConstants = new HashMap<Integer, ByteList>();
    private Map<Integer, ByteList> nsPackageConstants = new HashMap<Integer, ByteList>();
    private Map<Integer, ByteList> nsPrivateConstants = new HashMap<Integer, ByteList>();
    private Map<Integer, ByteList> nsInternalConstants = new HashMap<Integer, ByteList>();
    private Map<Integer, ByteList> nsProtectedConstants = new HashMap<Integer, ByteList>();
    private Map<Integer, ByteList> nsStaticProtectedConstants = new HashMap<Integer, ByteList>();
    private Map<Integer, ByteList> intConstants = new HashMap<Integer, ByteList>();
    private Map<Integer, ByteList> uintConstants = new HashMap<Integer, ByteList>();
    private ByteList FALSE = new ByteList(1);
    private ByteList TRUE;
    private ByteList NULL;

    public ByteCodeFactory() {
        ByteCodeFactory.Byte(this.FALSE, 10);
        this.TRUE = new ByteList(1);
        ByteCodeFactory.Byte(this.TRUE, 11);
        this.NULL = new ByteList(1);
        ByteCodeFactory.Byte(this.NULL, 12);
    }

    public void clear() {
        this.utfConstants.clear();
        this.nsConstants.clear();
        this.nsPackageConstants.clear();
        this.nsPrivateConstants.clear();
        this.nsInternalConstants.clear();
        this.nsProtectedConstants.clear();
        this.nsStaticProtectedConstants.clear();
        this.intConstants.clear();
        this.uintConstants.clear();
    }

    public static ByteList allocBytes() {
        return new ByteList();
    }

    public static ByteList allocBytes(int size) {
        return new ByteList(size);
    }

    public ByteList ConstantValue(byte value) {
        if (this.show_bytecode) {
            switch (value) {
                case 10: {
                    this.cpool_out.write("\n      ConstantFalse");
                    break;
                }
                case 11: {
                    this.cpool_out.write("\n      ConstantTrue");
                    break;
                }
                case 12: {
                    this.cpool_out.write("\n      ConstantNull");
                }
            }
        }
        switch (value) {
            case 10: {
                return this.FALSE;
            }
            case 11: {
                return this.TRUE;
            }
            case 12: {
                return this.NULL;
            }
        }
        ByteList bytes = ByteCodeFactory.allocBytes(1);
        ByteCodeFactory.Byte(bytes, value);
        return bytes;
    }

    public ByteList ConstantNamespace(int uri_index) {
        Integer num;
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantNamespace " + uri_index);
        }
        if (this.nsConstants.containsKey(num = IntegerPool.getNumber(uri_index))) {
            return this.nsConstants.get(num);
        }
        ByteList bytes = ByteCodeFactory.allocBytes(3);
        bytes = ByteCodeFactory.Byte(bytes, 8);
        bytes = ByteCodeFactory.Int(bytes, uri_index);
        this.nsConstants.put(num, bytes);
        return bytes;
    }

    public ByteList ConstantPrivateNamespace(int uri_index) {
        Integer num;
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantPrivateNamespace " + uri_index);
        }
        if (this.nsPrivateConstants.containsKey(num = IntegerPool.getNumber(uri_index))) {
            return this.nsPrivateConstants.get(num);
        }
        ByteList bytes = ByteCodeFactory.allocBytes(3);
        bytes = ByteCodeFactory.Byte(bytes, 5);
        bytes = ByteCodeFactory.Int(bytes, uri_index);
        this.nsPrivateConstants.put(num, bytes);
        return bytes;
    }

    public ByteList ConstantPackageNamespace(int uri_index) {
        Integer num;
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantPackageNamespace " + uri_index);
        }
        if (this.nsPackageConstants.containsKey(num = IntegerPool.getNumber(uri_index))) {
            return this.nsPackageConstants.get(num);
        }
        ByteList bytes = ByteCodeFactory.allocBytes(3);
        bytes = ByteCodeFactory.Byte(bytes, 22);
        bytes = ByteCodeFactory.Int(bytes, uri_index);
        this.nsPackageConstants.put(num, bytes);
        return bytes;
    }

    public ByteList ConstantInternalNamespace(int uri_index) {
        Integer num;
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantInternalNamespace " + uri_index);
        }
        if (this.nsInternalConstants.containsKey(num = IntegerPool.getNumber(uri_index))) {
            return this.nsInternalConstants.get(num);
        }
        ByteList bytes = ByteCodeFactory.allocBytes(3);
        bytes = ByteCodeFactory.Byte(bytes, 23);
        bytes = ByteCodeFactory.Int(bytes, uri_index);
        this.nsInternalConstants.put(num, bytes);
        return bytes;
    }

    public ByteList ConstantProtectedNamespace(int uri_index) {
        Integer num;
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantProtectedNamespace " + uri_index);
        }
        if (this.nsProtectedConstants.containsKey(num = IntegerPool.getNumber(uri_index))) {
            return this.nsProtectedConstants.get(num);
        }
        ByteList bytes = ByteCodeFactory.allocBytes(3);
        bytes = ByteCodeFactory.Byte(bytes, 24);
        bytes = ByteCodeFactory.Int(bytes, uri_index);
        this.nsProtectedConstants.put(num, bytes);
        return bytes;
    }

    public ByteList ConstantStaticProtectedNamespace(int uri_index) {
        Integer num;
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantStaticProtectedNamespace " + uri_index);
        }
        if (this.nsStaticProtectedConstants.containsKey(num = IntegerPool.getNumber(uri_index))) {
            return this.nsStaticProtectedConstants.get(num);
        }
        ByteList bytes = ByteCodeFactory.allocBytes(3);
        bytes = ByteCodeFactory.Byte(bytes, 26);
        bytes = ByteCodeFactory.Int(bytes, uri_index);
        this.nsStaticProtectedConstants.put(num, bytes);
        return bytes;
    }

    public ByteList ConstantNamespaceSet(Set<Integer> namespaces) {
        ByteList bytes = ByteCodeFactory.allocBytes(5 + namespaces.size() * 2);
        return this.ConstantNamespaceSet(bytes, namespaces);
    }

    public ByteList ConstantNamespaceSet(ByteList bytes, Set<Integer> namespaces) {
        if (this.show_bytecode) {
            int ns_id;
            this.cpool_out.write("\n      ConstantNamespaceSet " + namespaces.size() + " {");
            Iterator<Integer> i$ = namespaces.iterator();
            while (i$.hasNext() && (ns_id = i$.next().intValue()) != 0) {
                this.cpool_out.write(" " + ns_id);
            }
            this.cpool_out.write(" }");
        }
        bytes = ByteCodeFactory.Int(bytes, namespaces.size());
        for (int ns_id : namespaces) {
            bytes = ByteCodeFactory.Int(bytes, ns_id);
        }
        return bytes;
    }

    public ByteList ConstantTypeName(ByteList bytes, int name_index, IntList types) {
        int i;
        if (this.show_bytecode) {
            this.cpool_out.write("\n     ConstantMultiname " + name_index + " {");
            for (i = 0; i < types.size(); ++i) {
                this.cpool_out.write(" " + types.at(i));
            }
            this.cpool_out.write(" }");
        }
        bytes = ByteCodeFactory.Byte(bytes, 29);
        bytes = ByteCodeFactory.Int(bytes, name_index);
        bytes = ByteCodeFactory.Int(bytes, types.size());
        for (i = 0; i < types.size(); ++i) {
            bytes = ByteCodeFactory.Int(bytes, types.at(i));
        }
        return bytes;
    }

    public ByteList ConstantTypeName(int name_index, IntList types) {
        return this.ConstantTypeName(ByteCodeFactory.allocBytes(3 + types.size() * 2), name_index, types);
    }

    public ByteList ConstantMultiname(ByteList bytes, int name_index, int namespace_set_index, boolean isAttribute) {
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantMultiname " + (isAttribute ? "@" : "") + name_index + " " + namespace_set_index);
        }
        bytes = ByteCodeFactory.Byte(bytes, isAttribute ? 14 : 9);
        bytes = ByteCodeFactory.Int(bytes, name_index);
        bytes = ByteCodeFactory.Int(bytes, namespace_set_index);
        return bytes;
    }

    public ByteList ConstantMultiname(int name_index, int namespace_set_index, boolean isAttribute) {
        return this.ConstantMultiname(ByteCodeFactory.allocBytes(5), name_index, namespace_set_index, isAttribute);
    }

    public ByteList ConstantMultinameLate(ByteList bytes, int namespace_set_index, boolean isAttribute) {
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantMultinameLate " + (isAttribute ? "@" : "") + namespace_set_index);
        }
        bytes = ByteCodeFactory.Byte(bytes, isAttribute ? 28 : 27);
        bytes = ByteCodeFactory.Int(bytes, namespace_set_index);
        return bytes;
    }

    public ByteList ConstantMultinameLate(int namespace_set_index, boolean isAttribute) {
        return this.ConstantMultinameLate(ByteCodeFactory.allocBytes(5), namespace_set_index, isAttribute);
    }

    public ByteList ConstantUtf8Info(String text) {
        byte[] utf8Bytes;
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantUtf8Info " + text);
        }
        if (this.utfConstants.containsKey(text)) {
            return this.utfConstants.get(text);
        }
        try {
            utf8Bytes = text.getBytes("UTF8");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            utf8Bytes = new byte[text.length()];
        }
        int text_length = utf8Bytes.length;
        ByteList bytes = ByteCodeFactory.allocBytes(text_length + 3);
        bytes = ByteCodeFactory.Int(bytes, text_length);
        bytes.addAll(utf8Bytes);
        this.utfConstants.put(text, bytes);
        return bytes;
    }

    public ByteList ConstantIntegerInfo(int value) {
        Integer num;
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantIntegerInfo " + value);
        }
        if (this.intConstants.containsKey(num = IntegerPool.getNumber(value))) {
            return this.intConstants.get(num);
        }
        ByteList bytes = ByteCodeFactory.allocBytes(5);
        bytes = ByteCodeFactory.Int(bytes, value);
        this.intConstants.put(num, bytes);
        return bytes;
    }

    public ByteList ConstantUintInfo(long value) {
        Integer num;
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantUintInfo " + value);
        }
        if (this.uintConstants.containsKey(num = IntegerPool.getNumber((int)value))) {
            return this.uintConstants.get(num);
        }
        ByteList bytes = ByteCodeFactory.allocBytes(5);
        bytes = ByteCodeFactory.Int(bytes, value);
        this.uintConstants.put(num, bytes);
        return bytes;
    }

    public ByteList ConstantDoubleInfo(ByteList bytes, double value) {
        if (this.show_bytecode) {
            StringBuilder numStr = new StringBuilder();
            ByteCodeFactory.IL_FormatDoubleAsString(value, numStr);
            this.cpool_out.write("\n      ConstantDoubleInfo " + numStr.toString());
        }
        bytes = ByteCodeFactory.Double(bytes, value);
        return bytes;
    }

    public ByteList ConstantDoubleInfo(double value) {
        return this.ConstantDoubleInfo(ByteCodeFactory.allocBytes(9), value);
    }

    public ByteList ConstantDecimalInfo(ByteList bytes, Decimal128 value) {
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantDecimalInfo " + value.toString());
        }
        bytes = value.toByteList(bytes);
        return bytes;
    }

    public ByteList ConstantDecimalInfo(Decimal128 value) {
        return this.ConstantDecimalInfo(ByteCodeFactory.allocBytes(16), value);
    }

    public ByteList ConstantQualifiedName(ByteList bytes, int name_index, int namespace_index, boolean isAttribute) {
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantQualifiedName " + (isAttribute ? "@" : "") + name_index + " " + namespace_index);
        }
        bytes = ByteCodeFactory.Byte(bytes, isAttribute ? 13 : 7);
        bytes = ByteCodeFactory.Int(bytes, namespace_index);
        bytes = ByteCodeFactory.Int(bytes, name_index);
        return bytes;
    }

    public ByteList ConstantQualifiedName(int name_index, int namespace_index, boolean isAttribute) {
        return this.ConstantQualifiedName(ByteCodeFactory.allocBytes(5), name_index, namespace_index, isAttribute);
    }

    public ByteList ConstantRuntimeQualifiedName(ByteList bytes, int name_index, boolean isAttribute) {
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantRuntimeQualifiedName " + (isAttribute ? "@" : "") + name_index);
        }
        bytes = ByteCodeFactory.Byte(bytes, isAttribute ? 16 : 15);
        bytes = ByteCodeFactory.Int(bytes, name_index);
        return bytes;
    }

    public ByteList ConstantRuntimeQualifiedName(int name_index, boolean isAttribute) {
        return this.ConstantRuntimeQualifiedName(ByteCodeFactory.allocBytes(3), name_index, isAttribute);
    }

    public ByteList ConstantRuntimeQualifiedLate(ByteList bytes, boolean isAttribute) {
        if (this.show_bytecode) {
            this.cpool_out.write("\n      ConstantRuntimeQualifiedLate " + (isAttribute ? "@" : ""));
        }
        bytes = ByteCodeFactory.Byte(bytes, isAttribute ? 18 : 17);
        return bytes;
    }

    public ByteList ConstantRuntimeQualifiedLate(boolean isAttribute) {
        return this.ConstantRuntimeQualifiedLate(ByteCodeFactory.allocBytes(1), isAttribute);
    }

    public static ByteList ConstantPool(ByteList bytes, ObjectList<ByteList> constants) {
        for (ByteList list : constants) {
            bytes.addAll(list);
        }
        return bytes;
    }

    public static ByteList Namespaces(ByteList bytes, IntList namespaces) {
        for (int i = 0; i < namespaces.size(); ++i) {
            bytes = ByteCodeFactory.Int(bytes, namespaces.get(i));
        }
        return bytes;
    }

    public static ByteList Interfaces(ByteList bytes, IntList interfaces) {
        int n = interfaces.size();
        for (int i = 0; i < n; ++i) {
            bytes = ByteCodeFactory.Int(bytes, interfaces.get(i));
        }
        return bytes;
    }

    public ByteList TraitInfo(ByteList bytes, int name_index, int tag, int id, int info, int other, byte other2, IntList metadata) {
        if (this.show_bytecode) {
            switch (tag) {
                case 0: {
                    this.defns_out.write("\n      *Trait name_index=" + name_index + " tag=var" + " slot_id=" + id + " type_index=" + info + " value=" + other + " value_kind=" + other2);
                    break;
                }
                case 6: {
                    this.defns_out.write("\n      *Trait name_index=" + name_index + " tag=const" + " slot_id=" + id + " type_index=" + info + " value=" + other + " value_kind=" + other2);
                    break;
                }
                case 1: {
                    this.defns_out.write("\n      *Trait name_index=" + name_index + " tag=method" + " disp_id=" + id + " method_info=" + info + ((other & 1) != 0 ? " final" : " virtual") + ((other & 2) != 0 ? " override" : " new"));
                    break;
                }
                case 2: {
                    this.defns_out.write("\n      *Trait name_index=" + name_index + " tag=getter" + " disp_id=" + id + " method_info=" + info + ((other & 1) != 0 ? " final" : " virtual") + ((other & 2) != 0 ? " override" : " new"));
                    break;
                }
                case 3: {
                    this.defns_out.write("\n      *Trait name_index=" + name_index + " tag=setter" + " disp_id=" + id + " method_info=" + info + ((other & 1) != 0 ? " final" : " virtual") + ((other & 2) != 0 ? " override" : " new"));
                    break;
                }
                case 5: {
                    this.defns_out.write("\n      *Trait name_index=" + name_index + " tag=function" + " slot_id=" + id + " method_info=" + info);
                    break;
                }
                case 4: {
                    this.defns_out.write("\n      *Trait name_index=" + name_index + " tag=class" + " slot_id=" + id + " class_info=" + info);
                }
            }
        }
        int tag_flags = tag;
        if (metadata != null) {
            tag_flags |= 0x40;
        }
        if (tag == 1 || tag == 2 || tag == 3) {
            tag_flags |= other << 4;
        }
        bytes = ByteCodeFactory.Int(bytes, name_index);
        bytes = ByteCodeFactory.Byte(bytes, tag_flags);
        switch (tag) {
            case 0: 
            case 6: {
                bytes = ByteCodeFactory.Int(bytes, id);
                bytes = ByteCodeFactory.Int(bytes, info);
                bytes = ByteCodeFactory.Int(bytes, other);
                if (other == 0) break;
                bytes = ByteCodeFactory.Byte(bytes, other2);
                break;
            }
            case 4: 
            case 5: {
                bytes = ByteCodeFactory.Int(bytes, id);
                bytes = ByteCodeFactory.Int(bytes, info);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                bytes = ByteCodeFactory.Int(bytes, id);
                bytes = ByteCodeFactory.Int(bytes, info);
                break;
            }
        }
        if (metadata != null) {
            int metadata_size = metadata.size();
            bytes = ByteCodeFactory.Int(bytes, metadata_size);
            for (int i = 0; i < metadata_size; ++i) {
                bytes = ByteCodeFactory.Int(bytes, metadata.get(i));
            }
        }
        return bytes;
    }

    public static ByteList Traits(ByteList bytes, ObjectList<ByteList> traits) {
        for (ByteList list : traits) {
            bytes.addAll(list);
        }
        return bytes;
    }

    public ByteList VarInfo(ByteList bytes, int type_index, int value_index, int slot_index, int var_info) {
        if (this.show_bytecode) {
            this.defns_out.write("\n      VarInfo type_index=" + type_index + " value_index=" + value_index + " slot_index=" + slot_index + " -> " + var_info);
        }
        bytes = ByteCodeFactory.Int(bytes, slot_index);
        bytes = ByteCodeFactory.Int(bytes, type_index);
        bytes = ByteCodeFactory.Int(bytes, value_index);
        return bytes;
    }

    public static ByteList Vars(ByteList bytes, ObjectList<ByteList> vars) {
        for (ByteList list : vars) {
            bytes.addAll(list);
        }
        return bytes;
    }

    public static ByteList Methods(ByteList bytes, ObjectList<ByteList> methods) {
        for (ByteList list : methods) {
            bytes.addAll(list);
        }
        return bytes;
    }

    public static ByteList Metadata(ByteList bytes, ObjectList<ByteList> metadata) {
        for (ByteList list : metadata) {
            bytes.addAll(list);
        }
        return bytes;
    }

    public static ByteList Bodies(ByteList bytes, ObjectList<ByteList> bodies) {
        for (ByteList list : bodies) {
            bytes.addAll(list);
        }
        return bytes;
    }

    public ByteList InstanceInfo(ByteList bytes, int name_index, int base_index, int flags, int protected_index, int interfaces_count, IntList interfaces, int iinit_index, ObjectList<ByteList> itraits, int class_info) {
        if (this.show_bytecode) {
            this.defns_out.write("\n      InstanceInfo name_index=" + name_index + " base_index=" + base_index + " interfaces_count=" + interfaces_count + " interfaces={");
            for (int i = 0; i < interfaces.size(); ++i) {
                this.defns_out.write(" " + interfaces.get(i));
            }
            this.defns_out.write("} flags=" + flags + " iinit_index=" + iinit_index + " itraits_count=" + itraits.size() + " -> " + class_info);
        }
        bytes = ByteCodeFactory.Int(bytes, name_index);
        bytes = ByteCodeFactory.Int(bytes, base_index);
        bytes = ByteCodeFactory.Byte(bytes, flags);
        if (protected_index != 0) {
            bytes = ByteCodeFactory.Int(bytes, protected_index);
        }
        bytes = ByteCodeFactory.Int(bytes, interfaces_count);
        bytes = ByteCodeFactory.Interfaces(bytes, interfaces);
        bytes = ByteCodeFactory.Int(bytes, iinit_index);
        bytes = ByteCodeFactory.Int(bytes, itraits.size());
        bytes = ByteCodeFactory.Traits(bytes, itraits);
        return bytes;
    }

    public ByteList ClassInfo(ByteList bytes, int cinit_index, ObjectList<ByteList> ctraits, int class_info) {
        if (this.show_bytecode) {
            this.defns_out.write("\n      ClassInfo  cinit_index=" + cinit_index + " ctraits_count=" + ctraits.size() + " -> " + class_info);
        }
        bytes = ByteCodeFactory.Int(bytes, cinit_index);
        bytes = ByteCodeFactory.Int(bytes, ctraits.size());
        bytes = ByteCodeFactory.Traits(bytes, ctraits);
        return bytes;
    }

    public ByteList ScriptInfo(ByteList bytes, int init_index, ObjectList<ByteList> traits, int pkg_info) {
        if (this.show_bytecode) {
            this.defns_out.write("\n      ScriptInfo init_index=" + init_index + " traits_count=" + traits.size() + " -> " + pkg_info);
        }
        ByteCodeFactory.Int(bytes, init_index);
        ByteCodeFactory.Int(bytes, traits.size());
        ByteCodeFactory.Traits(bytes, traits);
        return bytes;
    }

    public static ByteList Classes(ByteList bytes, ObjectList<ByteList> classes) {
        for (ByteList list : classes) {
            bytes.addAll(list);
        }
        return bytes;
    }

    public static ByteList Instances(ByteList bytes, ObjectList<ByteList> instances) {
        for (ByteList list : instances) {
            bytes.addAll(list);
        }
        return bytes;
    }

    public static ByteList Packages(ByteList bytes, ObjectList<ByteList> scripts) {
        for (ByteList list : scripts) {
            bytes.addAll(list);
        }
        return bytes;
    }

    public static ByteList Attributes(ByteList bytes, ObjectList<ByteList> attributes) {
        for (ByteList list : attributes) {
            bytes.addAll(list);
        }
        return bytes;
    }

    public ByteList MethodInfo(ByteList bytes, int param_count, int return_type, IntList param_types, IntList param_values, ByteList param_kinds, IntList param_names, int debug_name_index, int flags, int method_info_index) {
        int i;
        if (this.show_bytecode) {
            int size;
            this.defns_out.write("\n      MethodInfo ");
            this.defns_out.write(" param_count=" + param_count);
            this.defns_out.write(" return_type=" + return_type + " param_types={ ");
            int n = size = param_types == null ? 0 : param_types.size();
            for (i = 0; i < size; ++i) {
                this.defns_out.write(param_types.get(i) + " ");
            }
            this.defns_out.write("} debug_name_index=" + debug_name_index + " needs_arguments=" + ((flags & 1) != 0 ? "true" : "false") + " need_rest=" + ((flags & 4) != 0 ? "true" : "false") + " needs_activation=" + ((flags & 2) != 0 ? "true" : "false") + " has_optional=" + ((flags & 8) != 0 ? "true" : "false") + " ignore_rest=" + ((flags & 0x10) != 0 ? "true" : "false") + " native=" + ((flags & 0x20) != 0 ? "true" : "false") + " has_param_names =" + ((flags & 0x80) != 0 ? "true" : "false"));
            if ((flags & 8) != 0) {
                this.defns_out.write(" optional_count=" + param_values.size());
                this.defns_out.write(" optional_indexes={ ");
                int n2 = size = param_values == null ? 0 : param_values.size();
                for (i = 0; i < size; ++i) {
                    this.defns_out.write(" " + param_values.get(i));
                }
                this.defns_out.write(" }");
                this.defns_out.write(" optional_kinds={ ");
                int n3 = size = param_values == null ? 0 : param_values.size();
                for (i = 0; i < size; ++i) {
                    this.defns_out.write(" " + param_kinds.get(i));
                }
                this.defns_out.write(" }");
            }
            if ((flags & 0x80) != 0) {
                this.defns_out.write(" param_names={ ");
                int n4 = size = param_names == null ? 0 : param_names.size();
                for (i = 0; i < size; ++i) {
                    this.defns_out.write(" " + param_names.get(i));
                }
                this.defns_out.write(" }");
            }
            this.defns_out.write(" -> " + method_info_index);
        }
        if (debug) {
            System.out.print("\n      bytes.size() = " + bytes.size());
        }
        ByteCodeFactory.Int(bytes, param_count);
        ByteCodeFactory.Int(bytes, return_type);
        for (i = 0; i < param_count; ++i) {
            ByteCodeFactory.Int(bytes, param_types.get(i));
        }
        ByteCodeFactory.Int(bytes, debug_name_index);
        ByteCodeFactory.Byte(bytes, flags);
        if ((flags & 8) != 0) {
            ByteCodeFactory.Int(bytes, param_values.size());
            int n = param_values.size();
            for (i = 0; i < n; ++i) {
                ByteCodeFactory.Int(bytes, param_values.get(i));
                bytes.add(param_kinds.get(i));
            }
        }
        if ((flags & 0x80) != 0) {
            for (i = 0; i < param_count; ++i) {
                ByteCodeFactory.Int(bytes, param_names.get(i));
            }
        }
        return bytes;
    }

    public ByteList MethodBody(ByteList bytes, int max_stack, int max_locals, int scope_depth, int max_scope, int code_length, ByteList code, int exception_table_length, ByteList exception_table, ObjectList<ByteList> traits, int method_info_index) {
        if (this.show_bytecode) {
            this.defns_out.write("\n      MethodBody max_stack=" + max_stack);
            this.defns_out.write(" max_locals=" + max_locals);
            this.defns_out.write(" scope_depth=" + scope_depth + " max_scope=" + max_scope);
            this.defns_out.write(" code_length=" + code_length + " traits_count=" + traits.size() + " -> " + method_info_index);
        }
        if (debug) {
            System.out.print("\n      bytes.size() = " + bytes.size() + ", code.size() = " + code.size());
        }
        ByteCodeFactory.Int(bytes, method_info_index);
        ByteCodeFactory.Int(bytes, max_stack);
        ByteCodeFactory.Int(bytes, max_locals);
        ByteCodeFactory.Int(bytes, scope_depth);
        ByteCodeFactory.Int(bytes, max_scope);
        ByteCodeFactory.Int(bytes, code_length);
        if (code_length != 0) {
            bytes.addAll(code);
        }
        ByteCodeFactory.Int(bytes, exception_table_length);
        if (exception_table_length != 0) {
            bytes.addAll(exception_table);
        }
        ByteCodeFactory.Int(bytes, traits.size());
        ByteCodeFactory.Traits(bytes, traits);
        return bytes;
    }

    public ByteList MetadataInfo(ByteList bytes, int nameIndex, int valuesCount, IntList keys, IntList values, int metadata_info_index) {
        int i;
        if (this.show_bytecode) {
            this.defns_out.write("\n      MetadataInfo ");
            this.defns_out.write(" nameIndex=" + nameIndex);
            this.defns_out.write(" valuesCount=" + valuesCount + " keys={ ");
            int size = keys.size();
            for (i = 0; i < size; ++i) {
                this.defns_out.write(keys.get(i) + " ");
            }
            this.defns_out.write("} values={");
            size = values.size();
            for (i = 0; i < size; ++i) {
                this.defns_out.write(values.get(i) + " ");
            }
            this.defns_out.write(" }");
            this.defns_out.write(" -> " + metadata_info_index);
        }
        if (debug) {
            System.out.print("\n      bytes.size() = " + bytes.size());
        }
        ByteCodeFactory.Int(bytes, nameIndex);
        ByteCodeFactory.Int(bytes, valuesCount);
        for (i = 0; i < valuesCount; ++i) {
            ByteCodeFactory.Int(bytes, keys.get(i));
        }
        for (i = 0; i < valuesCount; ++i) {
            ByteCodeFactory.Int(bytes, values.get(i));
        }
        return bytes;
    }

    public ByteList ActionBlock(ByteList bytes, int minor_version, int major_version, int constant_int_pool_count, ObjectList<ByteList> constant_int_pool, int constant_uint_pool_count, ObjectList<ByteList> constant_uint_pool, int constant_double_pool_count, ObjectList<ByteList> constant_double_pool, int constant_decimal_pool_count, ObjectList<ByteList> constant_decimal_pool, int constant_utf8_pool_count, ObjectList<ByteList> constant_utf8_pool, int constant_mn_pool_count, ObjectList<ByteList> constant_mn_pool, int constant_nss_pool_count, ObjectList<ByteList> constant_nss_pool, int constant_ns_pool_count, ObjectList<ByteList> constant_ns_pool, int methods_count, ObjectList<ByteList> methods, int metadata_count, ObjectList<ByteList> metadata, int classes_count, ObjectList<ByteList> instances, ObjectList<ByteList> classes, int scripts_count, ObjectList<ByteList> scripts, int bodies_count, ObjectList<ByteList> bodies) {
        if (this.show_bytecode) {
            this.defns_out.write("\n      ActionBlock major_version=" + major_version + " minor_version=" + minor_version + " constant_int_count= " + constant_int_pool_count + " constant_uint_count=: " + constant_uint_pool_count + " constant_double_count= " + constant_double_pool_count + " constant_decimal_count= " + constant_decimal_pool_count + " constant_utf8_count=" + constant_utf8_pool_count + " constant_namespace_count=" + constant_ns_pool_count + " constant_namespaceset_count=" + constant_nss_pool_count + " constant_multiname_count=" + constant_mn_pool_count + " methods_count=" + methods_count + " metadata_count=" + metadata_count + " classes_count=" + classes_count + " scripts_count=" + scripts_count + " bodies_count=" + bodies_count);
        }
        ByteCodeFactory.RealShort(bytes, minor_version);
        ByteCodeFactory.RealShort(bytes, major_version);
        ByteCodeFactory.Int(bytes, constant_int_pool_count);
        if (constant_int_pool_count != 0) {
            bytes = ByteCodeFactory.ConstantPool(bytes, constant_int_pool);
        }
        ByteCodeFactory.Int(bytes, constant_uint_pool_count);
        if (constant_uint_pool_count != 0) {
            bytes = ByteCodeFactory.ConstantPool(bytes, constant_uint_pool);
        }
        ByteCodeFactory.Int(bytes, constant_double_pool_count);
        if (constant_double_pool_count != 0) {
            bytes = ByteCodeFactory.ConstantPool(bytes, constant_double_pool);
        }
        if (minor_version < 17) {
            assert (constant_decimal_pool_count == 0);
        } else {
            ByteCodeFactory.Int(bytes, constant_decimal_pool_count);
            if (constant_decimal_pool_count != 0) {
                bytes = ByteCodeFactory.ConstantPool(bytes, constant_decimal_pool);
            }
        }
        ByteCodeFactory.Int(bytes, constant_utf8_pool_count);
        if (constant_utf8_pool_count != 0) {
            bytes = ByteCodeFactory.ConstantPool(bytes, constant_utf8_pool);
        }
        ByteCodeFactory.Int(bytes, constant_ns_pool_count);
        if (constant_ns_pool_count != 0) {
            bytes = ByteCodeFactory.ConstantPool(bytes, constant_ns_pool);
        }
        ByteCodeFactory.Int(bytes, constant_nss_pool_count);
        if (constant_nss_pool_count != 0) {
            bytes = ByteCodeFactory.ConstantPool(bytes, constant_nss_pool);
        }
        ByteCodeFactory.Int(bytes, constant_mn_pool_count);
        if (constant_mn_pool_count != 0) {
            bytes = ByteCodeFactory.ConstantPool(bytes, constant_mn_pool);
        }
        ByteCodeFactory.Int(bytes, methods_count);
        if (methods_count != 0) {
            bytes = ByteCodeFactory.Methods(bytes, methods);
        }
        ByteCodeFactory.Int(bytes, metadata_count);
        if (metadata_count != 0) {
            bytes = ByteCodeFactory.Metadata(bytes, metadata);
        }
        ByteCodeFactory.Int(bytes, classes_count);
        if (classes_count != 0) {
            bytes = ByteCodeFactory.Instances(bytes, instances);
            bytes = ByteCodeFactory.Classes(bytes, classes);
        }
        ByteCodeFactory.Int(bytes, scripts_count);
        if (scripts_count != 0) {
            bytes = ByteCodeFactory.Packages(bytes, scripts);
        }
        ByteCodeFactory.Int(bytes, bodies_count);
        if (bodies_count != 0) {
            bytes = ByteCodeFactory.Bodies(bytes, bodies);
        }
        return bytes;
    }

    public static ByteList Byte(ByteList bytes, int v) {
        bytes.add((byte)v);
        return bytes;
    }

    public static ByteList RealShort(ByteList bytes, int v) {
        bytes.add((byte)v);
        bytes.add((byte)(v >> 8));
        return bytes;
    }

    public static ByteList Int24(ByteList bytes, int v) {
        byte byte1 = (byte)v;
        byte byte2 = (byte)(v >> 8);
        byte byte3 = (byte)(v >> 16);
        bytes.add(byte1);
        bytes.add(byte2);
        bytes.add(byte3);
        return bytes;
    }

    public static ByteList Int(ByteList bytes, long v) {
        if (v < 128L && v > -1L) {
            bytes.add((byte)v);
        } else if (v < 16384L && v > -1L) {
            bytes.add((byte)(v & 0x7FL | 0x80L));
            bytes.add((byte)(v >> 7 & 0x7FL));
        } else if (v < 0x200000L && v > -1L) {
            bytes.add((byte)(v & 0x7FL | 0x80L));
            bytes.add((byte)(v >> 7 | 0x80L));
            bytes.add((byte)(v >> 14 & 0x7FL));
        } else if (v < 0x10000000L && v > -1L) {
            bytes.add((byte)(v & 0x7FL | 0x80L));
            bytes.add((byte)(v >> 7 | 0x80L));
            bytes.add((byte)(v >> 14 | 0x80L));
            bytes.add((byte)(v >> 21 & 0x7FL));
        } else {
            bytes.add((byte)(v & 0x7FL | 0x80L));
            bytes.add((byte)(v >> 7 | 0x80L));
            bytes.add((byte)(v >> 14 | 0x80L));
            bytes.add((byte)(v >> 21 | 0x80L));
            bytes.add((byte)(v >> 28 & 0xFL));
        }
        return bytes;
    }

    public static ByteList Double(ByteList bytes, double v) {
        long bits = Double.doubleToLongBits(v);
        bytes.add((byte)bits);
        bytes.add((byte)(bits >> 8));
        bytes.add((byte)(bits >> 16));
        bytes.add((byte)(bits >> 24));
        bytes.add((byte)(bits >> 32));
        bytes.add((byte)(bits >> 40));
        bytes.add((byte)(bits >> 48));
        bytes.add((byte)(bits >> 56));
        return bytes;
    }

    public static StringBuilder IL_FormatDoubleAsString(double val, StringBuilder buff) {
        if (val == 0.0) {
            return buff.append("0.0");
        }
        if (val == Double.POSITIVE_INFINITY) {
            return buff.append("Infinity");
        }
        if (val == Double.NEGATIVE_INFINITY) {
            return buff.append("-Infinity");
        }
        if (Double.isNaN(val)) {
            return buff.append("NaN");
        }
        if (val == (double)((int)val)) {
            return buff.append((int)val);
        }
        boolean neg = false;
        if (val < 0.0) {
            val = 0.0 - val;
            neg = true;
        }
        int exp = 0;
        if (val >= 1.0) {
            while (val > 10.0) {
                val /= 10.0;
                ++exp;
            }
            int truncVal = (int)val;
            buff.append(neg ? "-" : "+").append(truncVal).append(".");
            for (int pos = 0; pos < 5; ++pos) {
                val -= (double)truncVal;
                truncVal = (int)(val *= 10.0);
                buff.append(truncVal);
            }
            if (exp > 0) {
                buff.append("e").append(exp);
            }
            return buff;
        }
        while (val < 1.0) {
            val *= 10.0;
            ++exp;
        }
        int truncVal = (int)val;
        buff.append(neg ? "-" : "+").append(truncVal).append(".");
        for (int pos = 0; pos < 5; ++pos) {
            val -= (double)truncVal;
            truncVal = (int)(val *= 10.0);
            buff.append(truncVal);
        }
        return buff.append("e-").append(exp);
    }
}

