/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.FileOutputStream;
import java.io.IOException;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.ConstantPool;
import macromedia.abc.Decoder;
import macromedia.abc.Encoder;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.ObjectList;

public class Optimizer {
    public static void main(String[] args) {
        ObjectList<String> file_names = new ObjectList<String>();
        String output_file = "merged.abc";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-o")) {
                output_file = args[++i];
                continue;
            }
            file_names.add(args[i]);
        }
        BytecodeBuffer[] byte_codes = new BytecodeBuffer[file_names.size()];
        for (int i = 0; i < file_names.size(); ++i) {
            try {
                BytecodeBuffer buf;
                byte_codes[i] = buf = new BytecodeBuffer((String)file_names.at(i));
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        byte[] abc = Optimizer.optimize(byte_codes);
        try {
            if (abc != null) {
                FileOutputStream fos = new FileOutputStream(output_file);
                fos.write(abc);
                fos.close();
            } else {
                System.err.println("Error occurred when merging abc files.");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static ByteList optimize(ByteList bytes) {
        BytecodeBuffer[] byte_codes = new BytecodeBuffer[]{new BytecodeBuffer(bytes.toByteArray())};
        byte[] temp = Optimizer.optimize(byte_codes);
        ByteList new_bytes = new ByteList(temp.length);
        new_bytes.addAll(temp);
        return new_bytes;
    }

    public static byte[] optimize(BytecodeBuffer[] byte_codes) {
        Decoder.ClassInfo classInfo;
        int infoSize;
        int j;
        int abcSize = byte_codes.length;
        Decoder[] decoders = new Decoder[abcSize];
        ConstantPool[] pools = new ConstantPool[abcSize];
        int majorVersion = 0;
        int minorVersion = 0;
        boolean skipFrame = false;
        for (int j2 = 0; j2 < abcSize; ++j2) {
            try {
                decoders[j2] = new Decoder(byte_codes[j2]);
                if (decoders[j2].majorVersion > majorVersion) {
                    majorVersion = decoders[j2].majorVersion;
                }
                if (decoders[j2].minorVersion > minorVersion) {
                    minorVersion = decoders[j2].minorVersion;
                }
                pools[j2] = decoders[j2].constantPool;
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                skipFrame = true;
                break;
            }
        }
        Encoder encoder = new Encoder(majorVersion, minorVersion);
        encoder.enablePeepHole();
        Decoder decoder = null;
        try {
            encoder.addConstantPools(pools);
            encoder.disableDebugging();
            encoder.removeMetadata();
            encoder.configure(decoders);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
        for (j = 0; j < abcSize; ++j) {
            decoder = decoders[j];
            encoder.useConstantPool(j);
            Decoder.MethodInfo methodInfo = decoder.methodInfo;
            try {
                infoSize = methodInfo.size();
                for (int k = 0; k < infoSize; ++k) {
                    methodInfo.decode(k, encoder);
                }
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                skipFrame = true;
                break;
            }
        }
        if (skipFrame) {
            return null;
        }
        for (j = 0; j < abcSize; ++j) {
            decoder = decoders[j];
            encoder.useConstantPool(j);
            Decoder.MetaDataInfo metadataInfo = decoder.metadataInfo;
            try {
                infoSize = metadataInfo.size();
                for (int k = 0; k < infoSize; ++k) {
                    metadataInfo.decode(k, encoder);
                }
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                skipFrame = true;
                break;
            }
        }
        if (skipFrame) {
            return null;
        }
        for (j = 0; j < abcSize; ++j) {
            decoder = decoders[j];
            encoder.useConstantPool(j);
            classInfo = decoder.classInfo;
            try {
                infoSize = classInfo.size();
                for (int k = 0; k < infoSize; ++k) {
                    classInfo.decodeInstance(k, encoder);
                }
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                skipFrame = true;
                break;
            }
        }
        if (skipFrame) {
            return null;
        }
        for (j = 0; j < abcSize; ++j) {
            decoder = decoders[j];
            encoder.useConstantPool(j);
            classInfo = decoder.classInfo;
            try {
                infoSize = classInfo.size();
                for (int k = 0; k < infoSize; ++k) {
                    classInfo.decodeClass(k, 0, encoder);
                }
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                skipFrame = true;
                break;
            }
        }
        if (skipFrame) {
            return null;
        }
        for (j = 0; j < abcSize; ++j) {
            decoder = decoders[j];
            encoder.useConstantPool(j);
            Decoder.ScriptInfo scriptInfo = decoder.scriptInfo;
            try {
                int scriptSize = scriptInfo.size();
                for (int k = 0; k < scriptSize; ++k) {
                    scriptInfo.decode(k, encoder);
                }
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                skipFrame = true;
                break;
            }
        }
        if (skipFrame) {
            return null;
        }
        for (j = 0; j < abcSize; ++j) {
            decoder = decoders[j];
            encoder.useConstantPool(j);
            Decoder.MethodBodies methodBodies = decoder.methodBodies;
            try {
                int bodySize = methodBodies.size();
                for (int k = 0; k < bodySize; ++k) {
                    methodBodies.decode(k, 2, encoder);
                }
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                skipFrame = true;
                break;
            }
        }
        if (skipFrame) {
            return null;
        }
        byte[] abc = encoder.toABC();
        return abc;
    }
}

