/*
 * Decompiled with CFR 0.152.
 */
package flash.graphics.g2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Vector;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.ext.awt.g2d.TransformStackElement;

public final class GraphicContext
implements Cloneable {
    private final BufferedImage bufferedImage;
    private Graphics2D bufferedImageGraphics;
    private Font font = new Font("Dialog", 0, 12);
    private static final AffineTransform defaultTransform = new AffineTransform();
    private AffineTransform transform = new AffineTransform();
    private Vector<TransformStackElement> transformStack = new Vector();
    private boolean transformStackValid = true;
    private Composite composite = AlphaComposite.SrcOver;
    private Point2D pen = new Point2D.Double(0.0, 0.0);
    private Paint paint = Color.black;
    private static final Color defaultPaint = Color.black;
    private Stroke stroke = new BasicStroke();
    private Color background = new Color(255, 255, 255, 0);
    private Shape clip = null;
    private RenderingHints hints = new RenderingHints(null);
    private int width;
    private int height;

    public GraphicContext() {
        this.bufferedImage = null;
        this.init();
    }

    public GraphicContext(int width, int height) {
        this.width = width;
        this.height = height;
        this.bufferedImage = new BufferedImage(width, height, 2);
        this.bufferedImageGraphics = this.bufferedImage.createGraphics();
        this.hints.put(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE, new WeakReference<BufferedImage>(this.bufferedImage));
        this.init();
    }

    private void init() {
        this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        this.transform = new AffineTransform(defaultTransform);
    }

    public Color getColor() {
        if (this.paint instanceof Color) {
            return (Color)this.paint;
        }
        return defaultPaint;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite comp) {
        this.composite = comp;
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.setComposite(comp);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        if (f == null) {
            return;
        }
        this.font = f;
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.setFont(f);
        }
    }

    public FontRenderContext getFontRenderContext() {
        Object antialiasingHint = this.hints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
        boolean isAntialiased = true;
        if (antialiasingHint != RenderingHints.VALUE_TEXT_ANTIALIAS_ON && antialiasingHint != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
            if (antialiasingHint != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                antialiasingHint = this.hints.get(RenderingHints.KEY_ANTIALIASING);
                if (antialiasingHint != RenderingHints.VALUE_ANTIALIAS_ON && antialiasingHint != RenderingHints.VALUE_ANTIALIAS_DEFAULT && antialiasingHint == RenderingHints.VALUE_ANTIALIAS_OFF) {
                    isAntialiased = false;
                }
            } else {
                isAntialiased = false;
            }
        }
        boolean useFractionalMetrics = true;
        if (this.hints.get(RenderingHints.KEY_FRACTIONALMETRICS) == RenderingHints.VALUE_FRACTIONALMETRICS_OFF) {
            useFractionalMetrics = false;
        }
        FontRenderContext frc = new FontRenderContext(null, isAntialiased, useFractionalMetrics);
        return frc;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        if (this.bufferedImageGraphics != null) {
            return this.bufferedImageGraphics.getDeviceConfiguration();
        }
        return null;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.setPaint(paint);
        }
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke s) {
        this.stroke = s;
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.setStroke(s);
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.setBackground(color);
        }
    }

    public Point2D getPen() {
        return this.pen;
    }

    public Point2D setPen(Point2D pen) {
        Point2D old = this.pen;
        this.pen = pen;
        return old;
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.hints.put(hintKey, hintValue);
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.setRenderingHint(hintKey, hintValue);
        }
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.hints.get(hintKey);
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void addRenderingHints(Map hints) {
        this.hints.putAll((Map<?, ?>)hints);
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.addRenderingHints(hints);
        }
    }

    public void setRenderingHints(Map hints) {
        RenderingHints h;
        this.hints = h = new RenderingHints(hints);
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.setRenderingHints(h);
        }
    }

    public void clip(Shape s) {
        if (s != null) {
            s = this.transform.createTransformedShape(s);
        }
        if (this.clip != null) {
            Area newClip = new Area(this.clip);
            newClip.intersect(new Area(s));
            this.clip = new GeneralPath(newClip);
        } else {
            this.clip = s;
        }
    }

    public Rectangle getClipBounds() {
        Shape c = this.getClip();
        if (c == null) {
            return null;
        }
        return c.getBounds();
    }

    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    public void setClip(Shape clip) {
        Shape s = null;
        this.clip = clip != null ? (s = this.transform.createTransformedShape(clip)) : null;
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.setClip(s);
        }
    }

    public Shape getClip() {
        try {
            return this.transform.createInverse().createTransformedShape(this.clip);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    public FontMetrics getFontMetrics(Font f) {
        if (this.bufferedImageGraphics != null) {
            return this.bufferedImageGraphics.getFontMetrics(f);
        }
        return null;
    }

    public ColorModel getColorModel() {
        if (this.bufferedImage != null) {
            return this.bufferedImage.getColorModel();
        }
        return null;
    }

    public void rotate(double theta) {
        this.transform.rotate(theta);
        this.transformStack.addElement(TransformStackElement.createRotateElement((double)theta));
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.rotate(theta);
        }
    }

    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
        this.transformStack.addElement(TransformStackElement.createTranslateElement((double)x, (double)y));
        this.transformStack.addElement(TransformStackElement.createRotateElement((double)theta));
        this.transformStack.addElement(TransformStackElement.createTranslateElement((double)(-x), (double)(-y)));
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.rotate(theta, x, y);
        }
    }

    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
        this.transformStack.addElement(TransformStackElement.createScaleElement((double)sx, (double)sy));
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.scale(sx, sy);
        }
    }

    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
        this.transformStack.addElement(TransformStackElement.createShearElement((double)shx, (double)shy));
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.shear(shx, shy);
        }
    }

    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
        this.transformStack.addElement(TransformStackElement.createTranslateElement((double)tx, (double)ty));
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.translate(tx, ty);
        }
    }

    public void translate(int x, int y) {
        if (x != 0 || y != 0) {
            this.transform.translate(x, y);
            this.transformStack.addElement(TransformStackElement.createTranslateElement((double)x, (double)y));
        }
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.translate(x, y);
        }
    }

    public void transform(AffineTransform tx) {
        this.transform.concatenate(tx);
        this.transformStack.addElement(TransformStackElement.createGeneralTransformElement((AffineTransform)tx));
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.transform(tx);
        }
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    public void setTransform(AffineTransform Tx) {
        this.transform = new AffineTransform(Tx);
        this.invalidateTransformStack();
        if (!Tx.isIdentity()) {
            this.transformStack.addElement(TransformStackElement.createGeneralTransformElement((AffineTransform)Tx));
        }
        if (this.bufferedImageGraphics != null) {
            this.bufferedImageGraphics.setTransform(Tx);
        }
    }

    public AffineTransform getDefaultTransform() {
        return defaultTransform;
    }

    public void validateTransformStack() {
        this.transformStackValid = true;
    }

    public boolean isTransformStackValid() {
        return this.transformStackValid;
    }

    void invalidateTransformStack() {
        this.transformStack.removeAllElements();
        this.transformStackValid = false;
    }

    public Object clone() {
        GraphicContext copy = new GraphicContext(this.width, this.height);
        copy.bufferedImageGraphics = this.bufferedImageGraphics;
        copy.setTransform(this.transform);
        copy.setPaint(this.paint);
        copy.setStroke(this.stroke);
        copy.setComposite(this.composite);
        copy.clip = this.clip != null ? new GeneralPath(this.clip) : null;
        copy.setRenderingHints((RenderingHints)this.hints.clone());
        copy.setFont(this.font);
        copy.setBackground(this.background);
        return copy;
    }
}

