# ArchiveSpark Documentation

ArchiveSpark is a Java/JVM library, written in Scala, based on [Apache Spark](https://spark.apache.org), which can be used as an API for easy and efficient access to web archives and other supported datasets, as part of your own project or stand-alone, using Scala's interactive shell or notebook tools, such as [Jupyter](http://jupyter.org).

To get familiar with ArchiveSpark, but also for most of the common use cases, we recommend the use with Jupyter. In order to get you started more easily, we provide a pre-packaged and pre-configured [Docker](https://www.docker.com/) container with ArchiveSpark and Jupyter ready to run, just one command away: https://github.com/helgeho/ArchiveSpark-docker

To learn more about [ArchiveSpark](https://github.com/helgeho/ArchiveSpark) have a look at our [GitHub repository](https://github.com/helgeho/ArchiveSpark).

## Basics / Background
* [Approach and Publications](Approach_Publications.md)
* [Related Projects](Related_Projects.md)

## Getting Started
* [Installing ArchiveSpark with Jupyter](Installing_Jupyter.md)
* [Using ArchiveSpark with Jupyter](Using_Jupyter.md)
* [General Usage](General_Usage.md)
* [Recipes / Examples](Recipes.md)
* [Building ArchiveSpark](Building.md) (advanced) 
* [Using ArchiveSpark as a Library](Using_Library.md) (advanced)

## API Docs
* [Configuration](Config.md)
* [ArchiveSpark Operations](Operations.md)
* [Data Specifications (DataSpecs)](DataSpecs.md)
* [Enrichment Functions](EnrichFuncs.md)

## Developer Documentation
* [Contribute](Contribute.md)
* [How to Implement DataSpecs](Dev_DataSpecs.md)
* [How to Implement Enrichment Functions](Dev_EnrichFuncs.md)