/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CDownloader;
import org.monazilla.v2c.V2CHttpUtil;
import org.monazilla.v2c.V2CJStr;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CMoviePanel;
import org.monazilla.v2c.V2CMovieUtil;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CWebBrowser;
import org.monazilla.v2c.V2CWebBrowserUtil;

public class V2CYTPanel
extends V2CMoviePanel {
    private static final String sSiteID = "YT";
    private static final String sYTSaveDirKey = "YTSaveDir";
    private static final String sConfKey = "Movie.YTConf";
    private static final int[] ilZoomFactor = new int[]{-1, 1, 2, 3, 4, 6, 10};
    static int nDefaultWidth = 480;
    static int nDefaultHeight = 385;
    static int nDefaultWideWidth = 640;
    static int nDefaultWideHeight = 385;
    static int nFMT;
    String sHost;
    JComboBox jcbZoom;
    String sFMT;
    String sScript;
    String sScript2;
    boolean bWideMode = true;
    float fZoomFactor = 1.0f;

    static void setUseFMT(int n) {
        if (n == nFMT) {
            return;
        }
        nFMT = n;
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        v2CProperty.put(sConfKey, n > 0 ? ":f" + n : "n");
    }

    static void popup(String string, int n) {
        V2CYTPanel.popup(string, n, V2CSwingUtil.getMouseLocationOnScreen(null));
    }

    static void popup(String string, int n, Point point) {
        String string2;
        Matcher matcher;
        if (string.endsWith("&guid=ON")) {
            string = string.substring(0, string.length() - 8);
        }
        if ((matcher = Pattern.compile("&client=[\\w-]+(?=&|$)").matcher(string)).find()) {
            string = string.substring(0, matcher.start()) + string.substring(matcher.end(), string.length());
        }
        if (string.startsWith("http://m.")) {
            string = "http://www." + string.substring(9);
            n += 2;
        }
        if ((string2 = V2CYTPanel.extractID(string, n, false)) == null) {
            return;
        }
        V2CYTPanel v2CYTPanel = V2CYTPanel.getPanel(string2);
        if (v2CYTPanel != null) {
            v2CYTPanel.moveToFront();
        } else {
            v2CYTPanel = new V2CYTPanel(string, string2, point);
            v2CYTPanel.showDialog();
        }
    }

    static String extractID(String string, int n, boolean bl) {
        String string2;
        Pattern pattern = Pattern.compile("([A-Za-z0-9_-]{10,12})(?:$|[^A-Za-z0-9_-])");
        Matcher matcher = pattern.matcher(string2 = string.substring(n));
        if (!matcher.lookingAt()) {
            return null;
        }
        String string3 = matcher.group(1);
        if (bl) {
            string3 = sSiteID + string3;
        }
        return string3;
    }

    static V2CYTPanel getPanel(String string) {
        return (V2CYTPanel)V2CYTPanel.getPanel(sSiteID, string);
    }

    public V2CYTPanel(String string, String string2, Point point) {
        super(string, string2, point);
        Matcher matcher = Pattern.compile("http://((?:\\w+\\.)?youtube.com)/").matcher(string);
        this.sHost = matcher.lookingAt() ? matcher.group(1) : "www.youtube.com";
    }

    String getSiteID() {
        return sSiteID;
    }

    String getTitlePrefix() {
        return "Youtube - ";
    }

    boolean executeCommand(char c) {
        boolean bl;
        boolean bl2 = bl = c == 'G';
        if (c == 'X') {
            this.maximizeDialog();
            bl = true;
        }
        return bl;
    }

    void showDialog() {
        this.jDialog = new JFrame(this.getTitlePrefix() + this.sID);
        if (!this.isDialogResizable()) {
            this.jDialog.setResizable(false);
        }
        if (bRetainBrowser) {
            this.jDialog.setDefaultCloseOperation(0);
        }
        this.jDialog.setContentPane(this);
        this.jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (V2CYTPanel.this.thGetKey.isAlive()) {
                    V2CYTPanel.this.thGetKey.interrupt();
                }
                V2CYTPanel.this.unregisterPanel();
                if (V2CMoviePanel.bRetainBrowser && V2CYTPanel.this.vWebBrowser != null) {
                    if (!V2CYTPanel.this.bClosed) {
                        V2CYTPanel.this.bClosed = true;
                        if (V2CYTPanel.this.jPanel != null) {
                            V2CYTPanel.this.jPanel.remove((Component)((Object)V2CYTPanel.this.vWebBrowser));
                            V2CYTPanel.this.remove(V2CYTPanel.this.jPanel);
                        }
                    }
                } else {
                    V2CYTPanel.this.disposeLater();
                }
            }
        });
        this.jDialog.pack();
        this.adjustDialogPosition(true);
        this.jDialog.setVisible(true);
        this.thGetKey = new Thread(new Runnable(){

            public void run() {
                int n = nFMT;
                for (int i = 0; i < 4; ++i) {
                    Matcher matcher;
                    String string;
                    String string2 = "http://" + V2CYTPanel.this.sHost + "/watch?v=" + V2CYTPanel.this.sID;
                    Matcher matcher2 = Pattern.compile("&fmt=\\d+").matcher(V2CYTPanel.this.sURL);
                    boolean bl = matcher2.find();
                    if (bl) {
                        string = matcher2.group();
                    } else {
                        String string3 = string = n > 0 ? "&fmt=" + n : null;
                    }
                    if (string != null) {
                        string2 = string2 + string;
                    }
                    if ((matcher = Pattern.compile("#t=(?:\\d+h)?(?:\\d+m)?(?:\\d+s)?$").matcher(V2CYTPanel.this.sURL)).find()) {
                        string2 = string2 + matcher.group();
                    }
                    String string4 = V2CHttpUtil.getHTMLFile(string2, "UTF-8", 2);
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    if (string4 == null || !V2CYTPanel.this.createHTMLFile(string4)) {
                        V2CYTPanel.this.setErrorMessage("\u30d3\u30c7\u30aa\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    }
                    if (bl || V2CYTPanel.this.sFMT != null && (n == 0 || V2CMiscUtil.parseInt(V2CYTPanel.this.sFMT) == n)) {
                        V2CYTPanel.this.createLocalVideoURL();
                        break;
                    }
                    if (n == 37) {
                        n = 22;
                        continue;
                    }
                    if (n == 22) {
                        n = 35;
                        continue;
                    }
                    if (n != 35) break;
                    n = 18;
                }
            }
        });
        this.thGetKey.start();
    }

    void maximizeDialog() {
        Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(this.jDialog.getLocation());
        this.jDialog.setSize(rectangle.width, rectangle.height);
        this.jDialog.setLocation(rectangle.x, rectangle.y);
    }

    void downloadLink(String string) {
        String string2;
        String string3 = "";
        StringBuffer stringBuffer = new StringBuffer("http://");
        stringBuffer.append(this.sHost);
        stringBuffer.append("/get_video?");
        Pattern pattern = Pattern.compile("(?<=(?:^|&amp;))video_id=[^&]+(?=(?:&amp;|$))");
        Matcher matcher = pattern.matcher(string3);
        if (!matcher.find()) {
            return;
        }
        stringBuffer.append(matcher.group());
        stringBuffer.append('&');
        Pattern pattern2 = Pattern.compile("(?<=(?:^|&amp;))t=[^&]+(?=(?:&amp;|$))");
        Matcher matcher2 = pattern2.matcher(string3);
        if (!matcher2.find()) {
            return;
        }
        stringBuffer.append(matcher2.group());
        String string4 = this.sFMT;
        String string5 = ".flv";
        if (string4 != null && string4.length() > 0) {
            stringBuffer.append("&fmt=");
            stringBuffer.append(string4);
            if (string4.equals("18") || string4.equals("22") || string4.equals("37")) {
                string5 = ".mp4";
            }
        }
        String string6 = string2 = string != null && string.equals("T") && this.sTitle != null ? this.sTitle : this.sID;
        if (string2.length() > 250) {
            string2 = string2.substring(0, 250);
        }
        if ((string2 = V2CLocalFileHandler.checkFileName(string2)) == null || string2.length() == 0) {
            string2 = "unknown";
        }
        String string7 = string2 + string5;
        File file = V2CLocalFileHandler.getObjectSaveDir(sYTSaveDirKey);
        JFileChooser jFileChooser = V2CSwingUtil.createFileChooser();
        jFileChooser.setDialogTitle("\u4fdd\u5b58\uff1a " + this.sID);
        jFileChooser.setSelectedFile(new File(file, string7));
        int n = jFileChooser.showSaveDialog(V2CMain.v2cMain);
        if (n != 0) {
            return;
        }
        File file2 = jFileChooser.getSelectedFile();
        V2CLocalFileHandler.saveObjectSaveDir(sYTSaveDirKey, file2, true);
        if (file2.exists() && !V2CSwingUtil.showOKCancelDialog(V2CJStr.getFileExistsMessage(file2), "Warning", 2)) {
            return;
        }
        V2CDownloader.download(stringBuffer.toString(), file2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jcbZoom) {
            int n = this.jcbZoom.getSelectedIndex();
            if (n > 0) {
                this.fZoomFactor = (float)ilZoomFactor[n] / 2.0f;
                this.setBrowserSize();
                this.jDialog.pack();
                this.adjustDialogPosition(false);
                this.jcbZoom.setSelectedIndex(0);
            }
        } else {
            V2CAction.setSelected("ToggleYTWideMode", this.bWideMode);
            super.actionPerformed(actionEvent);
        }
    }

    void seYTWideMode(boolean bl) {
        if (bl == this.bWideMode) {
            return;
        }
        this.bWideMode = bl;
        this.setBrowserSize();
        this.jDialog.pack();
        this.adjustDialogPosition(false);
    }

    Dimension calcBrowserSize() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 2;
        if (this.bWideMode) {
            n4 = 16;
            n3 = 9;
            n2 = nDefaultWideWidth - n5;
            n = nDefaultWideHeight - n3 * n2 / n4;
        } else {
            n4 = 4;
            n3 = 3;
            n2 = nDefaultWidth - n5;
            n = nDefaultHeight - n3 * n2 / n4;
        }
        int n6 = (int)((float)n2 * this.fZoomFactor) + n5;
        int n7 = (int)((float)n3 * this.fZoomFactor * (float)n2 / (float)n4) + n;
        return new Dimension(n6, n7);
    }

    public boolean willOpenURL(URL uRL) {
        if (uRL != null) {
            final String string = uRL.toExternalForm();
            if (string.endsWith("/watch?v=null")) {
                return false;
            }
            final int n = V2CMovieUtil.getYTPrefix(string);
            if (n > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        V2CYTPanel.popup(string, n);
                    }
                });
                return false;
            }
        }
        return true;
    }

    public void run() {
        this.removeAll();
        V2CWebBrowser v2CWebBrowser = V2CWebBrowserUtil.createJDICWebBrowser(this.uVideo);
        if (v2CWebBrowser != null) {
            this.vWebBrowser = v2CWebBrowser;
            this.createBPanel();
            v2CWebBrowser.setV2CWebBrowserListener(this);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            this.add((Component)new V2CMoviePanel.TitleLabel(this.sTitle), gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridx;
            this.jbFunction = new JButton("\u6a5f\u80fd");
            this.jbFunction.setFocusable(false);
            this.jbFunction.addActionListener(this);
            gridBagConstraints.insets = new Insets(1, 0, 1, 1);
            this.add((Component)this.jbFunction, gridBagConstraints);
            ++gridBagConstraints.gridx;
            Object[] objectArray = new String[ilZoomFactor.length];
            for (int i = 0; i < objectArray.length; ++i) {
                int n = ilZoomFactor[i];
                objectArray[i] = n > 0 ? "\u00d7" + (double)n / 2.0 : "\u500d\u7387";
            }
            this.jcbZoom = V2CSwingUtil.createComboBox(objectArray);
            this.jcbZoom.setSelectedIndex(0);
            this.jcbZoom.setFocusable(false);
            this.jcbZoom.setLightWeightPopupEnabled(false);
            this.jcbZoom.addActionListener(this);
            this.add((Component)this.jcbZoom, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.jDialog.pack();
            this.adjustDialogPosition(false);
            this.jDialog.setTitle(this.getTitlePrefix() + this.sTitle);
            this.repaint();
        } else {
            this.setErrorMessage("WebBrowser\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
    }

    boolean createHTMLFile(String string) {
        Matcher matcher;
        if (string == null) {
            return false;
        }
        String string2 = string;
        Matcher matcher2 = Pattern.compile("<head>.*?</head>", 34).matcher(string);
        if (!matcher2.find()) {
            return false;
        }
        string = matcher2.group();
        Matcher matcher3 = Pattern.compile("<title>([^<]+)</title>", 2).matcher(string);
        String string3 = null;
        if (matcher3.find()) {
            string3 = matcher3.group(1);
            matcher = Pattern.compile("\\s*YouTube\\s*-\\s*(.*)\\s*", 2).matcher(string3);
            if (matcher.matches()) {
                string3 = matcher.group(1);
            }
            string3 = string3.trim();
        }
        if (string3 == null) {
            string3 = "\u30bf\u30a4\u30c8\u30eb\u4e0d\u660e";
        }
        this.setTitle(string3);
        System.out.println("title: " + this.sTitle);
        matcher = Pattern.compile("<script[\\s>].*?</script>", 34).matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            stringBuffer.append(matcher.group());
        }
        this.sScript = stringBuffer.toString();
        string = string2.substring(matcher2.end());
        Matcher matcher4 = Pattern.compile("&fmt_map=(\\d+)%2F", 2).matcher(string);
        if (!matcher4.find()) {
            return false;
        }
        this.sFMT = matcher4.group(1);
        System.out.println("sFMT: " + this.sFMT);
        Matcher matcher5 = Pattern.compile("<script[\\s>].*?</script>", 34).matcher(string);
        stringBuffer.setLength(0);
        while (matcher5.find()) {
            stringBuffer.append(matcher5.group());
        }
        this.sScript2 = stringBuffer.toString();
        return true;
    }

    String createHTMLContents() {
        StringBuffer stringBuffer = new StringBuffer(10000);
        stringBuffer.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
        stringBuffer.append("<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n<title>Youtube - ");
        stringBuffer.append(this.sID);
        stringBuffer.append("</title>\n");
        stringBuffer.append("<base href=\"http://");
        stringBuffer.append(this.sHost);
        stringBuffer.append("/\">\n");
        if (this.sScript != null) {
            stringBuffer.append(this.sScript);
        }
        stringBuffer.append("<style type=\"text/css\">html{height:100%;overflow:hidden;}\nbody{height:100%;margin:0;padding:0;}</style>");
        stringBuffer.append("</head>\n<body onLoad='fp=document.getElementById(\"movie_player\");if(fp){fp.style.width=\"100%\";fp.style.height=\"100%\";};'>\n");
        if (this.sScript2 != null) {
            stringBuffer.append(this.sScript2);
        }
        stringBuffer.append("</body>\n</html>\n");
        System.out.println(stringBuffer);
        return stringBuffer.toString();
    }

    static {
        String string = V2CApp.getUserProperty().get(sConfKey);
        int n = 35;
        if (string != null) {
            if (string.equals(":f18")) {
                n = 18;
            } else if (string.equals(":f35")) {
                n = 35;
            } else if (string.equals(":f22")) {
                n = 22;
            } else if (string.equals(":f37")) {
                n = 37;
            } else if (string.equals("n")) {
                n = 0;
            }
        }
        nFMT = n;
    }
}

