/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.EventQueue;
import java.awt.Rectangle;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CJPConverter;
import org.monazilla.v2c.V2CLauncher;
import org.monazilla.v2c.V2CMain;

public class V2CWinJNIUtil {
    private static final int VER_NT_WORKSTATION = 1;
    private static final int VER_SUITE_WH_SERVER = 32768;
    private static final boolean bUseJNI = true;
    private static final int WM_QUERYENDSESSION = 17;
    private static final int WM_ENDSESSION = 22;
    private static final int REQUEST_NOOP = 0;
    private static final int REQUEST_UNHOOK = 1;
    private static final int REQUEST_CPUINFO = 2;
    private static final int REQUEST_MEMINFO = 3;
    private static final int REQUEST_BRINGWINDOWTOTOP = 4;
    private static final int REQUEST_OSINFO = 5;
    private static final int REQUEST_RESTART = 6;
    private static final int ID_TOGGLEMENU = 10;
    private static final int ID_QUITAPP = 1000;
    private static long vMainWindowHandle;
    private static int iV2CExeVersion;
    private static int iCapability;
    private static boolean bRegisterNativeChecked;
    private static boolean bRegisterNativeOK;
    static Runnable vCommandLoop;
    static int iCommand;
    static long lCommandValue;
    static volatile int nWindowCreated;
    static boolean bImageViewerWindowCreated;
    static boolean bEndSessionNotified;
    private static volatile boolean bExited;

    public static int setVersionAndCapability(int n, int n2) {
        iV2CExeVersion = n;
        iCapability = n2;
        V2CApp.setV2CExeVersion(n);
        long l = V2CApp.getActiveV2CWindowHandle();
        if (l > 0L) {
            V2CWinJNIUtil.bringWindowToTop(l);
            V2CApp.immediateExit(0);
        }
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                while (true) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    final int n = iCommand;
                    if (n <= 0) continue;
                    iCommand = 0;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            switch (n) {
                                case 10: {
                                    V2CMain.toggleMenuBar();
                                    break;
                                }
                                case 1000: {
                                    V2CApp.quitApp(true);
                                }
                            }
                        }
                    });
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        vCommandLoop = runnable;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (V2CWinJNIUtil.checkRestartV2C()) {
                    V2CMain.addRestartV2C();
                }
            }
        });
        return 1;
    }

    static native long processRequest(int var0, long var1, byte[] var3);

    static long processRequest(int n) {
        return V2CWinJNIUtil.processRequest(n, 0L, null);
    }

    static long processRequest(int n, long l) {
        return V2CWinJNIUtil.processRequest(n, l, null);
    }

    static long processRequest(int n, byte[] byArray) {
        return V2CWinJNIUtil.processRequest(n, 0L, byArray);
    }

    static boolean checkRegisterNative() {
        if (iV2CExeVersion == 0) {
            return false;
        }
        if (bRegisterNativeChecked) {
            return bRegisterNativeOK;
        }
        bRegisterNativeChecked = true;
        boolean bl = false;
        try {
            V2CWinJNIUtil.processRequest(0);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        bRegisterNativeOK = bl;
        return bl;
    }

    static native long getMainWindowHandle(byte[] var0, int var1, int var2, int var3, int var4);

    static long getMainWindowHandle(boolean bl) {
        if (!bl) {
            return vMainWindowHandle;
        }
        if (!V2CWinJNIUtil.checkRegisterNative()) {
            return 0L;
        }
        long l = 0L;
        for (int i = 0; i < 2; ++i) {
            V2CMain v2CMain = V2CMain.v2cMain;
            byte[] byArray = V2CJPConverter.getBytes(v2CMain.getTitle(), "UTF-16LE");
            int n = byArray.length;
            byte[] byArray2 = new byte[n + 2];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            Rectangle rectangle = v2CMain.getBounds();
            l = V2CWinJNIUtil.getMainWindowHandle(byArray2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (l != 0L) break;
        }
        vMainWindowHandle = l;
        return l;
    }

    static void unhookWindProc(boolean bl) {
        if (V2CWinJNIUtil.checkRegisterNative()) {
            V2CWinJNIUtil.processRequest(1, bl ? 1L : 0L);
        }
    }

    static long longFromBytes(byte[] byArray, int n) {
        if (byArray == null || n < 0 || n + 8 >= byArray.length) {
            return -1L;
        }
        return ((long)V2CWinJNIUtil.intFromBytes(byArray, n + 4) & 0xFFFFFFFFL) << 32 | (long)V2CWinJNIUtil.intFromBytes(byArray, n) & 0xFFFFFFFFL;
    }

    static int intFromBytes(byte[] byArray, int n) {
        if (byArray == null || n < 0 || n + 4 >= byArray.length) {
            return -1;
        }
        return (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    static char charFromBytes(byte[] byArray, int n) {
        if (byArray == null || n < 0 || n + 2 >= byArray.length) {
            return '\uffff';
        }
        return (char)((byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF);
    }

    static String getCPUInfo() {
        String string;
        if (!V2CWinJNIUtil.checkRegisterNative()) {
            return null;
        }
        byte[] byArray = new byte[544];
        int n = (int)V2CWinJNIUtil.processRequest(2, byArray) / 16;
        if (n <= 0) {
            return null;
        }
        if (n < 1) {
            return null;
        }
        if (n >= 7) {
            int n2;
            int n3 = 64;
            for (n2 = 0; n2 < 48 && byArray[n3 + n2] != 0; ++n2) {
            }
            string = new String(byArray, n3, n2);
        } else {
            for (int i = 8; i < 12; ++i) {
                byte by = byArray[i];
                byArray[i] = byArray[i + 4];
                byArray[i + 4] = by;
            }
            string = new String(byArray, 4, 12);
        }
        return string;
    }

    static int[] getMemInfo() {
        if (!V2CWinJNIUtil.checkRegisterNative()) {
            return null;
        }
        byte[] byArray = new byte[100];
        if (V2CWinJNIUtil.processRequest(3, byArray) == 0L) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[40 + i] & 0xFF));
            stringBuffer.append(' ');
        }
        int[] nArray = new int[]{(int)(V2CWinJNIUtil.longFromBytes(byArray, 8) >>> 20), (int)(V2CWinJNIUtil.longFromBytes(byArray, 16) >>> 20), (int)(V2CWinJNIUtil.longFromBytes(byArray, 40) >>> 20), (int)(V2CWinJNIUtil.longFromBytes(byArray, 48) >>> 20)};
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getOSInfo() {
        Object object;
        String string;
        int n;
        if (!V2CWinJNIUtil.checkRegisterNative()) {
            return null;
        }
        byte[] byArray = new byte[512];
        if (V2CWinJNIUtil.processRequest(5, byArray) == 0L) {
            return null;
        }
        int n2 = V2CWinJNIUtil.intFromBytes(byArray, 0);
        if (n2 < 276) {
            return null;
        }
        boolean bl = n2 >= 284;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = V2CWinJNIUtil.intFromBytes(byArray, 4);
        int n4 = V2CWinJNIUtil.intFromBytes(byArray, 8);
        int n5 = n = bl ? byArray[282] & 0xFF : 0;
        if (n3 < 5) {
            return null;
        }
        if (n3 == 5) {
            if (n4 == 0) {
                string = "2000";
            } else if (n4 == 1) {
                string = "XP";
            } else {
                if (n4 != 2) return null;
                object = System.getProperty("os.arch");
                string = object != null && ((String)object).equals("amd64") && n == 1 ? "XP Professional" : (V2CWinJNIUtil.charFromBytes(byArray, 280) == '\u8000' ? "Home Server" : "Server 2003");
            }
        } else {
            if (n3 != 6) return null;
            if (n4 == 0) {
                string = n == 1 ? "Vista" : "Server 2008";
            } else if (n4 == 1) {
                string = n == 1 ? "7" : "Server 2008 R2";
            } else {
                if (n4 != 2) return null;
                if (n != 1) return null;
                string = "8";
            }
        }
        stringBuffer.append("Windows ");
        stringBuffer.append(string);
        object = new char[128];
        int n6 = 10;
        for (int i = 0; i < 128; ++i) {
            char c = V2CWinJNIUtil.charFromBytes(byArray, 20 + 2 * i);
            if (c == '\u0000') {
                stringBuffer.append(' ');
                stringBuffer.append(new String((char[])object, 0, i));
                return stringBuffer.toString();
            }
            object[i] = c;
        }
        return stringBuffer.toString();
    }

    static boolean bringWindowToTop(long l) {
        if (!V2CWinJNIUtil.checkRegisterNative()) {
            return false;
        }
        return V2CWinJNIUtil.processRequest(4, l, null) != 0L;
    }

    static boolean checkV2CExeVersion(int n, boolean bl) {
        if (bl) {
            return iV2CExeVersion >= n;
        }
        return iV2CExeVersion > 0 && iV2CExeVersion < n;
    }

    static boolean checkRestartV2C() {
        String string;
        return iV2CExeVersion >= 458754 && ((string = V2CLauncher.getLauncherJavaCmd()) == null || string.length() == 0) && V2CWinJNIUtil.checkRegisterNative();
    }

    static boolean restartV2C() {
        if (!V2CWinJNIUtil.checkRegisterNative()) {
            return false;
        }
        return V2CWinJNIUtil.processRequest(6, null) != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long notifyCommand(int n, long l) {
        switch (n) {
            case 10: {
                Runnable runnable = vCommandLoop;
                if (runnable != null) {
                    Runnable runnable2 = runnable;
                    synchronized (runnable2) {
                        iCommand = n;
                        runnable.notifyAll();
                    }
                }
                return 0L;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long notifyEndSession(int n, long l, long l2) {
        if (n != 17) {
            return 0L;
        }
        if (bEndSessionNotified) {
            return 0L;
        }
        bEndSessionNotified = true;
        Runnable runnable = vCommandLoop;
        if (runnable != null) {
            Runnable runnable2 = runnable;
            synchronized (runnable2) {
                iCommand = 1000;
                runnable.notifyAll();
            }
        } else {
            V2CApp.quitApp(true);
        }
        return 100L;
    }
}

