/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTablePopupListener;
import org.monazilla.v2c.V2CTextField;
import org.monazilla.v2c.V2CWebSearchEntry;

public class V2CWebSearchSP
extends JPanel
implements ActionListener {
    MyTableModel tmTableModel;
    JTable jTable;
    JButton jbUp;
    JButton jbDown;
    JTextField jtfLabel;
    JTextField jtfCommand;
    JComboBox jcbKeywords;
    JComboBox jcbLinkEx;
    JButton jbAdd;
    JButton jbInsert;
    JButton jbInsertEx;
    static /* synthetic */ Class class$java$lang$String;

    public V2CWebSearchSP(ArrayList arrayList) {
        super(new GridBagLayout());
        JTable jTable;
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.tmTableModel = new MyTableModel(arrayList);
        this.jTable = jTable = new JTable(this.tmTableModel);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(100);
        tableColumnModel.getColumn(1).setPreferredWidth(300);
        jTable.addMouseListener(new V2CTablePopupListener("EditAndDeleteEntry", this, jTable));
        JScrollPane jScrollPane = V2CSwingUtil.createScrollPaneForTable(jTable, 200);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        Box box = new Box(1);
        this.jbUp = new JButton("\u2191");
        this.jbUp.setFocusable(false);
        this.jbUp.addActionListener(this);
        box.add(this.jbUp);
        this.jbDown = new JButton("\u2193");
        this.jbDown.setFocusable(false);
        this.jbDown.addActionListener(this);
        box.add(this.jbDown);
        gridBagConstraints.gridx = 2;
        this.add((Component)box, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("\u30e9\u30d9\u30eb\uff1a "), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jtfLabel = new V2CTextField();
        gridBagConstraints.fill = 2;
        this.add((Component)this.jtfLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        this.jbAdd = new JButton("\u8ffd\u52a0");
        this.jbAdd.setFocusable(false);
        this.jbAdd.addActionListener(this);
        gridBagConstraints.fill = 2;
        this.add((Component)this.jbAdd, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("\u691c\u7d22URL\uff1a "), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jtfCommand = new V2CTextField();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.jtfCommand, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("\u30ad\u30fc\u30ef\u30fc\u30c9: "), gridBagConstraints);
        ++gridBagConstraints.gridx;
        KeywordEntry[] keywordEntryArray = new KeywordEntry[]{new KeywordEntry("$INPTEXTU", "URL\u30a8\u30f3\u30b3\u30fc\u30c9\u3057\u305f\u5165\u529b\u30c6\u30ad\u30b9\u30c8\uff08UTF-8\uff09"), new KeywordEntry("$INPTEXTE", "URL\u30a8\u30f3\u30b3\u30fc\u30c9\u3057\u305f\u5165\u529b\u30c6\u30ad\u30b9\u30c8\uff08EUC-JP\uff09"), new KeywordEntry("$INPTEXTS", "URL\u30a8\u30f3\u30b3\u30fc\u30c9\u3057\u305f\u5165\u529b\u30c6\u30ad\u30b9\u30c8\uff08MS932\u3001\u30b7\u30d5\u30c8JIS\uff09")};
        this.jcbKeywords = new JComboBox<KeywordEntry>(keywordEntryArray);
        this.jcbKeywords.setFocusable(false);
        gridBagConstraints.fill = 2;
        this.add((Component)this.jcbKeywords, gridBagConstraints);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        this.jbInsert = new JButton("\u633f\u5165");
        this.jbInsert.setFocusable(false);
        this.jbInsert.addActionListener(this);
        gridBagConstraints.fill = 2;
        this.add((Component)this.jbInsert, gridBagConstraints);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.add((Component)new JLabel("\u4f8b: "), gridBagConstraints);
        ++gridBagConstraints.gridx;
        ExampleEntry[] exampleEntryArray = new ExampleEntry[]{new ExampleEntry("\uff12\u3061\u3083\u3093\u306d\u308b\u691c\u7d22\uff08\u4e21\u65b9\u304b\u3089\uff09", "http://find.2ch.net/?BBS=ALL&TYPE=TITLE&STR=$INPTEXTE"), new ExampleEntry("\uff12\u3061\u3083\u3093\u306d\u308b\u691c\u7d22\uff08\uff12\u3061\u3083\u3093\u306d\u308b\uff09", "http://find.2ch.net/?BBS=2ch&TYPE=TITLE&STR=$INPTEXTE"), new ExampleEntry("\uff12\u3061\u3083\u3093\u306d\u308b\u691c\u7d22\uff08PINK\u3061\u3083\u3093\u306d\u308b\uff09", "http://find.2ch.net/?BBS=bbspink&TYPE=TITLE&STR=$INPTEXTE"), new ExampleEntry("domo2", "http://www.domo2.net/search/search.cgi?word=$INPTEXTE&tnum=50&bbs=all"), new ExampleEntry("ttsearch", "http://ttsearch.net/s.cgi?k=$INPTEXTS&N=50"), new ExampleEntry("Google [site:.2ch.net]", "http://www.google.co.jp/search?as_q=$INPTEXTU+site:.2ch.net&num=50"), new ExampleEntry("2NN+", "http://www.2nn.jp/")};
        this.jcbLinkEx = new JComboBox<ExampleEntry>(exampleEntryArray);
        this.jcbLinkEx.setFocusable(false);
        gridBagConstraints.fill = 2;
        this.add((Component)this.jcbLinkEx, gridBagConstraints);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        this.jbInsertEx = new JButton("\u5165\u529b");
        this.jbInsertEx.setFocusable(false);
        this.jbInsertEx.addActionListener(this);
        gridBagConstraints.fill = 2;
        this.add((Component)this.jbInsertEx, gridBagConstraints);
        gridBagConstraints.fill = 0;
    }

    boolean showDialog() {
        V2CSwingUtil.showDialogWithClose(this, this.jtfCommand, "Web\u30b9\u30ec\u30c3\u30c9\u691c\u7d22\u306e\u8a2d\u5b9a");
        V2CSwingUtil.checkEditing(this.jTable);
        return this.tmTableModel.bChange;
    }

    void deleteSelectedEntry() {
        int[] nArray = this.jTable.getSelectedRows();
        if (nArray == null) {
            return;
        }
        this.tmTableModel.delete(nArray);
    }

    void editSelectedEntry() {
        int n = this.jTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        V2CWebSearchEntry v2CWebSearchEntry = this.tmTableModel.getSearchEntry(n);
        if (v2CWebSearchEntry == null) {
            return;
        }
        String string = v2CWebSearchEntry.getLabel();
        if (string != null) {
            this.jtfLabel.setText(string);
        } else {
            this.jtfLabel.setText("");
        }
        String string2 = v2CWebSearchEntry.getRawURL();
        if (string2 != null) {
            this.jtfCommand.setText(string2);
        } else {
            this.jtfCommand.setText("");
        }
    }

    void insertCommandString(String string) {
        int n = Math.max(this.jtfCommand.getCaretPosition(), 0);
        try {
            this.jtfCommand.getDocument().insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        this.jtfCommand.setCaretPosition(n + string.length());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTable jTable = this.jTable;
        Object object = actionEvent.getSource();
        if (object == this.jbAdd) {
            String string = this.jtfCommand.getText();
            if (!V2CWebSearchEntry.checkURL(string)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            V2CSwingUtil.checkEditing(jTable);
            this.tmTableModel.add(this.jtfLabel.getText(), string);
        } else if (object == this.jbInsert) {
            Object object2 = this.jcbKeywords.getSelectedItem();
            if (object2 instanceof KeywordEntry) {
                this.insertCommandString(((KeywordEntry)object2).sKeyword);
            }
        } else if (object == this.jbInsertEx) {
            Object object3 = this.jcbLinkEx.getSelectedItem();
            if (object3 instanceof ExampleEntry) {
                ExampleEntry exampleEntry = (ExampleEntry)object3;
                this.jtfLabel.setText(exampleEntry.sLabel);
                this.jtfCommand.setText(exampleEntry.sCommand);
            }
        } else if (object == this.jbUp) {
            int n = jTable.getSelectedRow();
            if (n < 0) {
                return;
            }
            V2CSwingUtil.checkEditing(jTable);
            if (this.tmTableModel.moveEntry(n, true)) {
                jTable.changeSelection(n - 1, 0, false, false);
            }
        } else if (object == this.jbDown) {
            int n = jTable.getSelectedRow();
            if (n < 0) {
                return;
            }
            V2CSwingUtil.checkEditing(jTable);
            if (this.tmTableModel.moveEntry(n, false)) {
                jTable.changeSelection(n + 1, 0, false, false);
            }
        }
    }

    private static class ExampleEntry {
        String sLabel;
        String sCommand;

        ExampleEntry(String string, String string2) {
            this.sLabel = string;
            this.sCommand = string2;
        }

        public String toString() {
            return this.sLabel;
        }
    }

    private static class KeywordEntry {
        final String sKeyword;
        final String sLabel;

        KeywordEntry(String string, String string2) {
            this.sKeyword = string;
            this.sLabel = string + "\uff1a  " + string2;
        }

        public String toString() {
            return this.sLabel;
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        static final int LABEL = 0;
        static final int COMMAND = 1;
        static final String[] slColNames = new String[]{"\u30e9\u30d9\u30eb", "\u691c\u7d22URL"};
        final ArrayList alEntries;
        boolean bChange;

        MyTableModel(ArrayList arrayList) {
            this.alEntries = arrayList;
        }

        void add(String string, String string2) {
            this.bChange = true;
            V2CWebSearchEntry.addEntry(string, string2);
            int n = this.alEntries.size() - 1;
            this.fireTableRowsInserted(n, n);
        }

        void delete(int[] nArray) {
            this.bChange = true;
            if (nArray.length > 1) {
                Arrays.sort(nArray);
            }
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = nArray[i];
                this.alEntries.remove(n);
                this.fireTableRowsDeleted(n, n);
            }
        }

        boolean moveEntry(int n, boolean bl) {
            if (bl && n == 0 || !bl && n == this.getRowCount() - 1) {
                return false;
            }
            this.bChange = true;
            Object e = this.alEntries.get(n);
            int n2 = bl ? n - 1 : n + 1;
            this.alEntries.set(n, this.alEntries.get(n2));
            this.alEntries.set(n2, e);
            if (bl) {
                this.fireTableRowsUpdated(n - 1, n);
            } else {
                this.fireTableRowsUpdated(n, n + 1);
            }
            return true;
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = V2CWebSearchSP.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public int getRowCount() {
            return this.alEntries.size();
        }

        public int getColumnCount() {
            return slColNames.length;
        }

        public String getColumnName(int n) {
            return slColNames[n];
        }

        public void setValueAt(Object object, int n, int n2) {
            this.bChange = true;
            String string = (String)object;
            V2CWebSearchEntry v2CWebSearchEntry = this.getSearchEntry(n);
            String string2 = v2CWebSearchEntry.getLabel();
            String string3 = v2CWebSearchEntry.getRawURL();
            switch (n2) {
                case 0: {
                    string2 = string;
                    break;
                }
                case 1: {
                    if (string.length() > 0) {
                        string3 = string;
                        break;
                    }
                    this.alEntries.remove(n);
                    this.fireTableRowsDeleted(n, n);
                    return;
                }
            }
            if (!V2CWebSearchEntry.setEntryAt(n, string2, string3)) {
                this.fireTableRowsUpdated(n, n);
            }
        }

        V2CWebSearchEntry getSearchEntry(int n) {
            return (V2CWebSearchEntry)this.alEntries.get(n);
        }

        public Object getValueAt(int n, int n2) {
            V2CWebSearchEntry v2CWebSearchEntry = this.getSearchEntry(n);
            if (v2CWebSearchEntry == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return v2CWebSearchEntry.getLabel();
                }
                case 1: {
                    return v2CWebSearchEntry.getRawURL();
                }
            }
            return null;
        }
    }
}

