/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import javax.swing.Icon;
import org.monazilla.v2c.V2CURLItem;
import org.monazilla.v2c.V2CWebSearchEntry;
import org.monazilla.v2c.V2CWebSearchList;

public final class V2CWebSearchItem {
    boolean bOK;
    String sURL;
    String sTitle;
    boolean bURLButton;
    boolean bSaveHistory;

    static V2CWebSearchItem createItem(V2CWebSearchEntry v2CWebSearchEntry, String string) {
        if (v2CWebSearchEntry == null || string == null) {
            return null;
        }
        V2CWebSearchItem v2CWebSearchItem = new V2CWebSearchItem(v2CWebSearchEntry, string);
        return v2CWebSearchItem.bOK ? v2CWebSearchItem : null;
    }

    private V2CWebSearchItem(V2CWebSearchEntry v2CWebSearchEntry, String string) {
        this.bURLButton = false;
        boolean bl = v2CWebSearchEntry.needsSearchWord();
        if (bl && string.length() == 0) {
            return;
        }
        this.sURL = v2CWebSearchEntry.getSearchURL(string);
        if (string.length() >= 10) {
            string = string.substring(0, 9) + '\u2026';
        }
        String string2 = v2CWebSearchEntry.getLabel();
        if (bl) {
            string2 = string + " - " + string2;
        }
        this.sTitle = string2;
        this.bOK = true;
    }

    public V2CWebSearchItem(V2CURLItem v2CURLItem, boolean bl) {
        this.sURL = v2CURLItem.getURLString();
        this.sTitle = v2CURLItem.getLabel();
        this.bURLButton = bl;
        this.bSaveHistory = true;
        this.bOK = true;
    }

    String getSearchURL() {
        return this.sURL;
    }

    String getTitleString() {
        return this.sTitle;
    }

    Icon getIcon() {
        return this.bSaveHistory ? V2CURLItem.icDefault : V2CWebSearchList.icDefault;
    }

    boolean isURLButton() {
        return this.bURLButton;
    }

    boolean getSaveHistory() {
        return this.bSaveHistory;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!this.bURLButton || this.sURL == null || !(object instanceof V2CWebSearchItem)) {
            return false;
        }
        V2CWebSearchItem v2CWebSearchItem = (V2CWebSearchItem)object;
        return v2CWebSearchItem.bURLButton && this.sURL.equals(v2CWebSearchItem.sURL);
    }

    public int hashCode() {
        return this.bURLButton && this.sURL != null ? this.sURL.hashCode() : super.hashCode();
    }
}

