/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CJPConverter;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CWebSearchMenu;
import org.monazilla.v2c.V2CWebSearchSP;

public final class V2CWebSearchEntry {
    private static final String sWebSearchEntryKey = "WebSearch.Entry";
    private static final int UNCHECKED = 0;
    private static final int NO_INPUT = 1;
    private static final int NEED_INPUT = 2;
    private static final ArrayList alEntries = new ArrayList();
    String sURL;
    String sLabel;
    int nNeedsInput;

    static void restoreEntries() {
        V2CPackedPropValue[] v2CPackedPropValueArray = V2CApp.getUserProperty().getPackedValueArray(sWebSearchEntryKey);
        if (v2CPackedPropValueArray != null) {
            for (int i = 0; i < v2CPackedPropValueArray.length; ++i) {
                V2CPackedPropValue v2CPackedPropValue = v2CPackedPropValueArray[i];
                String string = v2CPackedPropValue.getString('L');
                String string2 = v2CPackedPropValue.getString('U');
                if (string == null || string.length() <= 0 || !V2CWebSearchEntry.checkURL(string2)) continue;
                V2CWebSearchEntry.addEntry(string, string2);
            }
        }
        if (alEntries.size() == 0) {
            V2CWebSearchEntry.addEntry("\uff12\u3061\u3083\u3093\u306d\u308b\u691c\u7d22\uff08\u4e21\u65b9\u304b\u3089\uff09", "http://find.2ch.net/?BBS=ALL&TYPE=TITLE&STR=$INPTEXTE");
        }
    }

    static void saveEntries() {
        ArrayList<V2CPackedPropValue> arrayList = new ArrayList<V2CPackedPropValue>();
        for (int i = 0; i < alEntries.size(); ++i) {
            V2CWebSearchEntry v2CWebSearchEntry = (V2CWebSearchEntry)alEntries.get(i);
            V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
            v2CPackedPropValue.setString('L', v2CWebSearchEntry.sLabel);
            v2CPackedPropValue.setString('U', v2CWebSearchEntry.sURL);
            arrayList.add(v2CPackedPropValue);
        }
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        int n = arrayList.size();
        if (n > 0) {
            v2CProperty.putPackedValueArray(sWebSearchEntryKey, arrayList.toArray(new V2CPackedPropValue[n]));
        } else {
            v2CProperty.remove(sWebSearchEntryKey);
        }
    }

    static void setWebSearchEntry() {
        V2CWebSearchSP v2CWebSearchSP = new V2CWebSearchSP(alEntries);
        if (!v2CWebSearchSP.showDialog()) {
            return;
        }
        V2CWebSearchEntry.saveEntries();
        V2CWebSearchMenu.updateConfigTime();
    }

    static ArrayList getEntries() {
        return alEntries;
    }

    static boolean checkURL(String string) {
        if (string == null) {
            return false;
        }
        if (!string.startsWith("http")) {
            return false;
        }
        return Pattern.matches("[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+", string);
    }

    static void addEntry(String string, String string2) {
        alEntries.add(new V2CWebSearchEntry(string, string2));
    }

    static boolean setEntryAt(int n, String string, String string2) {
        if (!V2CWebSearchEntry.checkURL(string2)) {
            return false;
        }
        V2CWebSearchEntry v2CWebSearchEntry = (V2CWebSearchEntry)alEntries.get(n);
        v2CWebSearchEntry.sLabel = string;
        v2CWebSearchEntry.sURL = string2;
        return true;
    }

    public V2CWebSearchEntry(String string, String string2) {
        this.sLabel = V2CMiscUtil.replaceTab2SP(string);
        this.sURL = string2;
    }

    String getRawURL() {
        return this.sURL;
    }

    String getSearchURL(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("$INPTEXTU", V2CJPConverter.urlEncode(string, "UTF-8"));
        hashMap.put("$INPTEXTE", V2CJPConverter.urlEncode(string, "EUC-JP"));
        hashMap.put("$INPTEXTS", V2CJPConverter.urlEncode(string, "MS932"));
        return V2CMiscUtil.replaceKeywords(this.sURL, hashMap);
    }

    boolean needsSearchWord() {
        if (this.nNeedsInput == 0) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("$INPTEXTU", "");
            hashMap.put("$INPTEXTE", "");
            hashMap.put("$INPTEXTS", "");
            String string = V2CMiscUtil.replaceKeywords(this.sURL, hashMap);
            this.nNeedsInput = this.sURL.equals(string) ? 1 : 2;
        }
        return this.nNeedsInput == 2;
    }

    String getLabel() {
        return this.sLabel;
    }

    public int hashCode() {
        return this.sURL.hashCode() + this.sLabel.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof V2CWebSearchEntry)) {
            return false;
        }
        V2CWebSearchEntry v2CWebSearchEntry = (V2CWebSearchEntry)object;
        return this.sURL.equals(v2CWebSearchEntry.sURL) && this.sLabel.equals(v2CWebSearchEntry.sLabel);
    }

    public String toString() {
        return this.sLabel;
    }

    static {
        V2CWebSearchEntry.restoreEntries();
    }
}

