/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.text.JTextComponent;
import org.monazilla.v2c.V2CBBS;
import org.monazilla.v2c.V2CHTMLPane;
import org.monazilla.v2c.V2CHttpUtil;
import org.monazilla.v2c.V2CJSONUtil;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CTweetItem;
import org.monazilla.v2c.V2CTwitterBBS;
import org.monazilla.v2c.V2CTwitterConstants;
import org.monazilla.v2c.V2CTwitterListItem;
import org.monazilla.v2c.V2CTwitterThreadRes;
import org.monazilla.v2c.V2CTwitterUser;
import org.monazilla.v2c.V2CTwitterUserID;

public class V2CTwitterUtil
implements V2CTwitterConstants {
    private static long ltListMemberTime;

    static boolean isFilterStreamType(V2CThreadItem v2CThreadItem) {
        return V2CTwitterUtil.isFilterStreamType(V2CTwitterBBS.getThreadType(v2CThreadItem));
    }

    static boolean isFilterStreamType(char c) {
        return c == 'L' || c == 'K' || c == 'U';
    }

    static HashSet getFilterStreamListIDs() {
        HashSet<Long> hashSet = new HashSet<Long>();
        V2CThreadPanel[] v2CThreadPanelArray = V2CThreadPanel.getOpenThreadPanels();
        for (int i = v2CThreadPanelArray.length - 1; i >= 0; --i) {
            long l;
            V2CThreadPanel v2CThreadPanel = v2CThreadPanelArray[i];
            V2CThreadItem v2CThreadItem = v2CThreadPanel.getThreadItem();
            if (!V2CTwitterBBS.isListThread(v2CThreadItem, true) || !V2CTwitterBBS.getUseFilterStream(v2CThreadItem, V2CTwitterBBS.getUser(v2CThreadItem)) || (l = V2CTwitterBBS.getThreadConfLong(v2CThreadItem, 'K')) <= 0L) continue;
            hashSet.add(new Long(l));
        }
        return hashSet;
    }

    static boolean getListMembers(int n) {
        if (n < 0 || n > 3) {
            return false;
        }
        HashSet hashSet = n == 0 ? V2CTwitterUtil.getFilterStreamListIDs() : null;
        long l = 0L;
        if (n == 0) {
            ltListMemberTime = System.currentTimeMillis();
        } else if (n == 2) {
            l = System.currentTimeMillis() - 900000L;
        } else if (n == 3) {
            l = ltListMemberTime;
        }
        int n2 = 0;
        V2CTwitterUser[] v2CTwitterUserArray = V2CTwitterUser.getUsers();
        for (int i = 0; i < v2CTwitterUserArray.length; ++i) {
            V2CTwitterUser v2CTwitterUser = v2CTwitterUserArray[i];
            ArrayList arrayList = v2CTwitterUser.getLists(true);
            int n3 = arrayList.size();
            for (int j = 0; j < n3; ++j) {
                V2CTwitterListItem v2CTwitterListItem = (V2CTwitterListItem)arrayList.get(j);
                long l2 = v2CTwitterListItem.getID();
                if (n == 0) {
                    if (!hashSet.remove(new Long(l2))) {
                        continue;
                    }
                } else {
                    long l3 = v2CTwitterListItem.getMemberFileDate();
                    if (n == 1) {
                        if (l3 >= 0L) {
                            continue;
                        }
                    } else if (n == 2) {
                        if (l3 <= 0L) continue;
                        if (l3 > l) {
                            ++n2;
                            continue;
                        }
                    } else if (n != 3 || l3 <= 0L || l3 > l) continue;
                }
                V2CTwitterBBS.getListMembers(v2CTwitterListItem, v2CTwitterUser);
            }
        }
        return n2 > 0;
    }

    static byte[] getBytes(String string, V2CTwitterUser v2CTwitterUser, boolean bl, HashMap hashMap) {
        V2CHttpUtil.CAndC cAndC;
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("Authorization", V2CHttpUtil.createOAuthHeader(v2CTwitterUser, false, string, hashMap));
        String string2 = V2CHttpUtil.constructQuery(hashMap);
        String string3 = string;
        if (string2 != null) {
            string3 = string3 + '?' + string2;
        }
        if ((cAndC = V2CHttpUtil.getRawHTTPFile(string3, 1, hashMap2)) == null) {
            System.out.println("cac==null");
            return null;
        }
        v2CTwitterUser.setConnectionInfo(cAndC.getConnection(), string);
        byte[] byArray = cAndC.getRawContents();
        if (byArray == null) {
            System.out.println("bl==null: " + v2CTwitterUser + " " + string3);
        }
        return byArray;
    }

    static Object[] getJSON(String string, V2CTwitterUser v2CTwitterUser, boolean bl, HashMap hashMap) {
        Object[] objectArray;
        byte[] byArray = V2CTwitterUtil.getBytes(string, v2CTwitterUser, bl, hashMap);
        if (byArray == null) {
            return null;
        }
        Object object = null;
        try {
            object = V2CJSONUtil.parse(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = object;
            objectArray = objectArray2;
            objectArray2[1] = byArray;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    static ArrayList getJSONWithCursor(String string, V2CTwitterUser v2CTwitterUser, boolean bl, HashMap hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        ArrayList<Map> arrayList = new ArrayList<Map>();
        long l = -1L;
        while (true) {
            hashMap.put("cursor", String.valueOf(l));
            Object[] objectArray = V2CTwitterUtil.getJSON(string, v2CTwitterUser, bl, hashMap);
            if (objectArray == null) {
                return null;
            }
            Object object = objectArray[0];
            if (!(object instanceof Map)) {
                return null;
            }
            Map map = (Map)object;
            arrayList.add(map);
            long l2 = V2CTwitterThreadRes.getLongFromMap(map, "next_cursor");
            if (l2 <= 0L) break;
            l = l2;
        }
        return arrayList;
    }

    static Matcher getUserURLMatcher(String string) {
        return Pattern.compile("https?://(?:jp\\.)?twitter\\.com/(?:(?:#|%23)(?:!|%21)/)?(\\w+)/?").matcher(string);
    }

    static JComponent createProfileHTML(Object object) {
        Serializable serializable;
        if (!(object instanceof Map)) {
            return null;
        }
        Map map = (Map)object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append("<body");
        stringBuffer.append(">\n");
        stringBuffer.append("<table cellpadding=\"4\">");
        String string = V2CTwitterThreadRes.getStringFromMap(map, "screen_name");
        V2CTwitterUtil.appendEntry("\u30e6\u30fc\u30b6\u540d", string, stringBuffer, false);
        V2CTwitterUtil.appendSimpleEntry("\u540d\u524d", "name", map, stringBuffer, false);
        V2CTwitterUtil.appendSimpleEntry("\u73fe\u5728\u5730", "location", map, stringBuffer, false);
        V2CTwitterUtil.appendLink("Web", V2CTwitterThreadRes.getStringFromMap(map, "url"), stringBuffer);
        V2CTwitterUtil.appendSimpleEntry("\u81ea\u5df1\u7d39\u4ecb", "description", map, stringBuffer, false);
        int n = (int)V2CTwitterThreadRes.getLongFromMap(map, "friends_count");
        V2CTwitterUtil.appendLabel("\u30d5\u30a9\u30ed\u30fc\u3057\u3066\u3044\u308b", stringBuffer, false);
        stringBuffer.append("<a href=\"http://twitter.com/");
        stringBuffer.append(string);
        stringBuffer.append("/following\">");
        stringBuffer.append(n);
        stringBuffer.append("</a>");
        V2CTwitterUtil.endTableRow(stringBuffer);
        int n2 = (int)V2CTwitterThreadRes.getLongFromMap(map, "followers_count");
        V2CTwitterUtil.appendLabel("\u30d5\u30a9\u30ed\u30fc\u3055\u308c\u3066\u3044\u308b", stringBuffer, false);
        stringBuffer.append("<a href=\"http://twitter.com/");
        stringBuffer.append(string);
        stringBuffer.append("/followers\">");
        stringBuffer.append(n2);
        stringBuffer.append("</a>");
        V2CTwitterUtil.endTableRow(stringBuffer);
        int n3 = (int)V2CTwitterThreadRes.getLongFromMap(map, "listed_count");
        V2CTwitterUtil.appendLabel("\u30ea\u30b9\u30c8", stringBuffer, false);
        stringBuffer.append("<a href=\"http://twitter.com/");
        stringBuffer.append(string);
        stringBuffer.append("/lists/memberships\">");
        stringBuffer.append(n3);
        stringBuffer.append("</a>");
        V2CTwitterUtil.endTableRow(stringBuffer);
        int n4 = (int)V2CTwitterThreadRes.getLongFromMap(map, "statuses_count");
        V2CTwitterUtil.appendLabel("\u30c4\u30a4\u30fc\u30c8", stringBuffer, false);
        stringBuffer.append("<a href=\"http://twitter.com/");
        stringBuffer.append(string);
        stringBuffer.append("\">");
        stringBuffer.append(n4);
        stringBuffer.append("</a>");
        V2CTwitterUtil.endTableRow(stringBuffer);
        V2CTwitterUtil.appendLongEntry("\u304a\u6c17\u306b\u5165\u308a", "favourites_count", map, stringBuffer);
        V2CTwitterUtil.appendLongEntry("ID", "id", map, stringBuffer);
        V2CTwitterUtil.appendLabel("\u30a2\u30ab\u30a6\u30f3\u30c8\u4f5c\u6210", stringBuffer, true);
        String string2 = V2CTwitterThreadRes.getStringFromMap(map, "created_at");
        if (string2 != null) {
            String string3 = null;
            try {
                TimeZone timeZone = V2CBBS.tzWritePreview;
                serializable = new SimpleDateFormat("EEE MMM dd HH:mm:ss ZZZZZ yyyy");
                string3 = new SimpleDateFormat("yyyy/MM/dd(E) HH:mm:ss", Locale.JAPANESE).format(((DateFormat)serializable).parse(string2));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (string3 != null) {
                stringBuffer.append("<small>");
                stringBuffer.append(string3);
                stringBuffer.append("</small>");
            }
        }
        V2CTwitterUtil.endTableRow(stringBuffer);
        V2CTwitterUtil.appendSimpleEntry("\u8a00\u8a9e", "lang", map, stringBuffer, true);
        V2CTwitterUtil.appendSimpleEntry("\u30bf\u30a4\u30e0\u30be\u30fc\u30f3", "time_zone", map, stringBuffer, true);
        V2CTwitterUtil.appendLabel("\u305d\u306e\u4ed6", stringBuffer, false);
        boolean bl = V2CTwitterThreadRes.getBooleanFromMap(map, "protected");
        boolean bl2 = V2CTwitterThreadRes.getBooleanFromMap(map, "verified");
        if (bl) {
            stringBuffer.append("\u975e\u516c\u958b ");
        }
        if (bl2) {
            stringBuffer.append("\u8a8d\u8a3c\u6e08\u307f");
        }
        V2CTwitterUtil.endTableRow(stringBuffer);
        stringBuffer.append("</table>\n</body></html>");
        serializable = new V2CHTMLPane(stringBuffer.toString());
        ((V2CHTMLPane)serializable).listenToHyperlinkEvent(true);
        ((V2CHTMLPane)serializable).setAntiAliasing(true);
        JScrollPane jScrollPane = new JScrollPane((Component)serializable);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        Insets insets = jScrollPane.getInsets();
        Dimension dimension = V2CMain.v2cMain.getSize();
        int n5 = Math.max((int)((double)dimension.width * 0.7), 500);
        int n6 = Math.max((int)((double)dimension.height * 0.8), 400);
        Dimension dimension2 = ((JEditorPane)serializable).getPreferredSize();
        int n7 = dimension2.width + insets.left + insets.right + 20;
        if (n7 > n5) {
            JWindow jWindow = new JWindow(V2CMain.v2cMain);
            Container container = jWindow.getContentPane();
            container.add((Component)jScrollPane, "Center");
            n7 = n5;
            dimension2.width = n5;
            jScrollPane.setPreferredSize(new Dimension(n7, n6 - insets.top - insets.bottom));
            jWindow.pack();
            dimension2 = ((JTextComponent)serializable).getPreferredScrollableViewportSize();
            container.remove(jScrollPane);
        }
        int n8 = Math.min(dimension2.height + insets.top + insets.bottom, n6);
        jScrollPane.setPreferredSize(new Dimension(n7, n8));
        return jScrollPane;
    }

    private static void appendLink(String string, String string2, StringBuffer stringBuffer) {
        if (string2 == null) {
            return;
        }
        V2CTwitterUtil.appendEntry(string, string2 != null ? "<a href=\"" + string2 + "\">" + string2 + "</a>" : null, stringBuffer, false);
    }

    private static void appendLongEntry(String string, String string2, Map map, StringBuffer stringBuffer) {
        V2CTwitterUtil.appendEntry(string, String.valueOf(V2CTwitterThreadRes.getLongFromMap(map, string2)), stringBuffer, true);
    }

    private static void appendSimpleEntry(String string, String string2, Map map, StringBuffer stringBuffer, boolean bl) {
        V2CTwitterUtil.appendEntry(string, V2CTwitterThreadRes.getStringFromMap(map, string2), stringBuffer, bl);
    }

    private static void appendEntry(String string, String string2, StringBuffer stringBuffer, boolean bl) {
        V2CTwitterUtil.appendLabel(string, stringBuffer, bl);
        if (string2 != null) {
            if (bl) {
                stringBuffer.append("<small>");
            }
            stringBuffer.append(string2);
            if (bl) {
                stringBuffer.append("</small>");
            }
        }
        stringBuffer.append("</td></tr>\n");
    }

    private static void appendLabel(String string, StringBuffer stringBuffer, boolean bl) {
        stringBuffer.append("<tr><td nowrap align=\"right\"><b>");
        if (string != null) {
            if (bl) {
                stringBuffer.append("<small>");
            }
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append("</small>");
            }
        }
        stringBuffer.append("</b></td><td>");
    }

    private static void endTableRow(StringBuffer stringBuffer) {
        stringBuffer.append("</td></tr>\n");
    }

    static V2CTwitterUserID[] createUIDArray(V2CTwitterThreadRes v2CTwitterThreadRes, int[] nArray, int n) {
        Object[] objectArray;
        int n2;
        HashMap<Long, V2CTwitterUserID> hashMap = new HashMap<Long, V2CTwitterUserID>();
        for (n2 = n - 1; n2 >= 0; --n2) {
            V2CTwitterUserID v2CTwitterUserID;
            V2CTwitterUserID v2CTwitterUserID2;
            objectArray = v2CTwitterThreadRes.getTweetItem(nArray[n2]);
            if (objectArray == null || !objectArray.hasCorrectUID() || (v2CTwitterUserID2 = V2CTwitterUserID.createInstanceRT((V2CTweetItem)objectArray)) == null || (v2CTwitterUserID = (V2CTwitterUserID)hashMap.get(v2CTwitterUserID2.getID())) != null && (v2CTwitterUserID.hasName() || !v2CTwitterUserID2.hasName())) continue;
            hashMap.put(v2CTwitterUserID2.getID(), v2CTwitterUserID2);
        }
        n2 = hashMap.size();
        objectArray = new V2CTwitterUserID[n2];
        objectArray = hashMap.values().toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    static V2CTwitterListItem getListItemOf(V2CThreadItem v2CThreadItem, V2CTwitterUser v2CTwitterUser) {
        if (!V2CTwitterBBS.isListThread(v2CThreadItem, false)) {
            return null;
        }
        if (v2CTwitterUser == null && (v2CTwitterUser = V2CTwitterBBS.getUser(v2CThreadItem)) == null) {
            return null;
        }
        ArrayList arrayList = v2CTwitterUser.getLists(false);
        V2CTwitterListItem v2CTwitterListItem = V2CTwitterListItem.createItem(v2CThreadItem);
        if (v2CTwitterListItem != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                V2CTwitterListItem v2CTwitterListItem2 = (V2CTwitterListItem)arrayList.get(i);
                if (!v2CTwitterListItem2.isSameAs(v2CTwitterListItem)) continue;
                return v2CTwitterListItem2;
            }
        }
        return null;
    }

    static boolean followUsers(V2CTwitterUserID[] v2CTwitterUserIDArray, boolean bl, V2CThreadItem v2CThreadItem) {
        Object object;
        Object object2;
        int n;
        if (v2CThreadItem == null) {
            return false;
        }
        V2CTwitterUser v2CTwitterUser = V2CTwitterUser.getSingleUser(V2CTwitterBBS.getUser(v2CThreadItem));
        if (v2CTwitterUser == null || !v2CTwitterUser.isOK()) {
            return false;
        }
        String string = bl ? "\u30d5\u30a9\u30ed\u30fc" : "\u30a2\u30f3\u30d5\u30a9\u30ed\u30fc";
        String string2 = bl ? "\u8ffd\u52a0" : "\u524a\u9664";
        V2CTwitterListItem v2CTwitterListItem = null;
        String string3 = "Home TimeLine";
        ArrayList arrayList = v2CTwitterUser.getLists(false);
        if (arrayList != null && arrayList.size() > 0) {
            arrayList.add(0, string3);
            String string4 = string3;
            n = V2CTwitterBBS.getThreadType(v2CThreadItem);
            if (!bl && n == 76 && (object2 = v2CThreadItem.getProperty()) != null && (object = V2CTwitterListItem.createItem(((V2CProperty)object2).getPackedValue("Thread.TwitterConf:"))) != null) {
                for (int i = arrayList.size() - 1; i > 0; --i) {
                    if (!((V2CTwitterListItem)object).isSameAs((V2CTwitterListItem)arrayList.get(i))) continue;
                    string4 = arrayList.get(i);
                    break;
                }
            }
            if ((object2 = V2CSwingUtil.showComboBoxDialog(arrayList.toArray(), (Object)string4, "\u5bfe\u8c61\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002", "Twitter " + string)) == null) {
                return false;
            }
            if (object2 != string3) {
                v2CTwitterListItem = (V2CTwitterListItem)object2;
                string3 = v2CTwitterListItem.sListName;
            }
        }
        boolean bl2 = v2CTwitterListItem == null;
        n = v2CTwitterUserIDArray.length;
        if (n == 0) {
            V2CSwingUtil.showErrorMessage("\u64cd\u4f5c\u5bfe\u8c61\u306e\u30e6\u30fc\u30b6\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            return false;
        }
        object2 = n > 1 ? n + "\u4eba\u306e\u30e6\u30fc\u30b6" : v2CTwitterUserIDArray[0].getUserName();
        if (!V2CSwingUtil.showOKCancelQuestionDialog((String)object2 + " \u3092 " + (bl2 ? "" : string3 + " \u3067") + string + "\u3057\u307e\u3059\u304b\uff1f", "Twitter " + string)) {
            return false;
        }
        object = bl ? "create" : "destroy";
        String string5 = bl2 ? "friendships/" + (String)object : "lists/members/" + (String)object + "_all";
        String string6 = V2CTwitterBBS.getAPIPrefix() + string5 + ".json";
        for (int i = 0; i < n; ++i) {
            String string7;
            long l;
            Object object3;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (!bl2) {
                hashMap.put("list_id", String.valueOf(v2CTwitterListItem.nListID));
            }
            if (bl2) {
                object3 = v2CTwitterUserIDArray[i];
                l = ((V2CTwitterUserID)object3).getID();
                string7 = String.valueOf(l);
                object2 = ((V2CTwitterUserID)object3).getUserName();
            } else {
                l = 0L;
                object3 = new StringBuffer();
                int n2 = 0;
                while (i < n) {
                    ((StringBuffer)object3).append(v2CTwitterUserIDArray[i].getID().toString());
                    ((StringBuffer)object3).append(',');
                    if (++n2 >= 100) break;
                    ++i;
                }
                string7 = ((StringBuffer)object3).substring(0, ((StringBuffer)object3).length() - 1);
            }
            hashMap.put("user_id", V2CHttpUtil.oauthURLEncode(string7));
            object3 = new V2CTwitterBBS.APIAction(16, v2CTwitterUser, string6, (String)object2 + " \u3092" + string2 + "\u4e2d\u2026", "Twitter " + string, hashMap, false);
            if (!((V2CTwitterBBS.APIAction)object3).start()) {
                return false;
            }
            V2CHttpUtil.CAndC cAndC = (V2CHttpUtil.CAndC)((V2CTwitterBBS.APIAction)object3).getResult();
            String string8 = null;
            if (cAndC == null || (string8 = cAndC.getContents()) == null) {
                boolean bl3;
                boolean bl4 = true;
                String string9 = null;
                if (cAndC != null) {
                    Object object4 = cAndC.getErrorJSONObject();
                    if (object4 instanceof Map) {
                        string9 = V2CTwitterThreadRes.getStringFromMap(object4, "error");
                    }
                    if (string9 == null) {
                        int n3 = cAndC.getResponseCode();
                        if (bl && n3 == 403) {
                            string9 = (String)object2 + " \u306f\u65e2\u306b\u8ffd\u52a0\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
                            bl4 = false;
                        } else {
                            string9 = cAndC.getErrorMessage();
                        }
                    }
                }
                if (string9 == null) {
                    string9 = "unknown reason";
                }
                if (bl4) {
                    string9 = string + " \u30a8\u30e9\u30fc\n(" + string9 + ")";
                }
                if (i + 1 < n) {
                    bl3 = !V2CSwingUtil.showOKCancelWarningDialog(string9 + "\n\n\u51e6\u7406\u3092\u7d9a\u884c\u3057\u307e\u3059\u304b\uff1f");
                } else {
                    bl3 = true;
                    V2CSwingUtil.showErrorMessage(string9);
                }
                if (!bl3) continue;
                return false;
            }
            if (!bl2) continue;
            if (bl) {
                v2CTwitterUser.addToIDs(l, 0);
                continue;
            }
            v2CTwitterUser.removeFromIDs(l, 0);
        }
        return true;
    }

    static boolean deleteList(V2CTwitterListItem v2CTwitterListItem, V2CTwitterUser v2CTwitterUser) {
        if (v2CTwitterListItem == null || v2CTwitterUser == null || !v2CTwitterUser.isOK()) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("list_id", String.valueOf(v2CTwitterListItem.getID()));
        String string = V2CTwitterBBS.getAPIPrefix() + "lists/destroy.json";
        V2CTwitterBBS.APIAction aPIAction = new V2CTwitterBBS.APIAction(16, v2CTwitterUser, string, "\u30ea\u30b9\u30c8\u524a\u9664\u4e2d\u2026", "Twitter \u30ea\u30b9\u30c8\u524a\u9664", hashMap, false);
        if (!aPIAction.start()) {
            return false;
        }
        V2CHttpUtil.CAndC cAndC = (V2CHttpUtil.CAndC)aPIAction.getResult();
        String string2 = null;
        if (cAndC == null || (string2 = cAndC.getContents()) == null) {
            String string3 = null;
            if (cAndC != null) {
                Object object = cAndC.getErrorJSONObject();
                if (object instanceof Map) {
                    string3 = V2CTwitterThreadRes.getStringFromMap(object, "error");
                }
                if (string3 == null) {
                    string3 = cAndC.getErrorMessage();
                }
            }
            if (string3 == null) {
                string3 = "unknown reason";
            }
            string3 = "\u30ea\u30b9\u30c8\u524a\u9664\u30a8\u30e9\u30fc\n(" + string3 + ")";
            V2CSwingUtil.showErrorMessage(string3);
            return false;
        }
        Object object = null;
        try {
            object = V2CJSONUtil.parse(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (!(object instanceof Map)) {
            V2CSwingUtil.showErrorMessage("\u7d50\u679c\u3092\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "Twitter\u30ea\u30b9\u30c8\u524a\u9664\u30a8\u30e9\u30fc");
            return false;
        }
        V2CTwitterBBS.APIAction aPIAction2 = new V2CTwitterBBS.APIAction(4, v2CTwitterUser, false);
        return aPIAction2.start();
    }

    static void checkTwitterTimers() {
        if (!V2CMain.isOnlineMode()) {
            return;
        }
        V2CThreadPanel[] v2CThreadPanelArray = V2CThreadPanel.getOpenThreadPanels();
        for (int i = v2CThreadPanelArray.length - 1; i >= 0; --i) {
            V2CThreadPanel v2CThreadPanel = v2CThreadPanelArray[i];
            if (!v2CThreadPanel.getThreadItem().isTwitter()) continue;
            v2CThreadPanel.checkTwitterTimer();
        }
    }
}

