/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadFilterSelector;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CTweetFilterItem;
import org.monazilla.v2c.V2CTweetFilterSP;
import org.monazilla.v2c.V2CTweetItem;
import org.monazilla.v2c.V2CTwitterThreadRes;
import org.monazilla.v2c.V2CTwitterUserID;

public class V2CTweetFilter {
    static final String sFilterConfKey = "Thread.TwitterFilter:";
    private V2CThreadPanel vThreadPanel;
    private final ArrayList alFilterItems = new ArrayList();

    static V2CTweetFilter restoreFilter(V2CThreadItem v2CThreadItem, V2CThreadPanel v2CThreadPanel) {
        if (v2CThreadItem == null || !v2CThreadItem.isTwitter()) {
            return null;
        }
        return new V2CTweetFilter(v2CThreadItem, v2CThreadPanel);
    }

    public V2CTweetFilter(V2CThreadItem v2CThreadItem, V2CThreadPanel v2CThreadPanel) {
        this.vThreadPanel = v2CThreadPanel;
        V2CPackedPropValue[] v2CPackedPropValueArray = v2CThreadItem.getProperty().getPackedValueArray(sFilterConfKey);
        if (v2CPackedPropValueArray == null) {
            return;
        }
        ArrayList arrayList = this.alFilterItems;
        for (int i = 0; i < v2CPackedPropValueArray.length; ++i) {
            arrayList.add(new V2CTweetFilterItem(v2CPackedPropValueArray[i]));
        }
    }

    synchronized void save() {
        ArrayList arrayList = this.alFilterItems;
        ArrayList<V2CPackedPropValue> arrayList2 = new ArrayList<V2CPackedPropValue>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList2.add(((V2CTweetFilterItem)arrayList.get(i)).getSaveValue());
        }
        this.vThreadPanel.getThreadItem().getProperty().putPackedValueArray(sFilterConfKey, arrayList2.toArray(new V2CPackedPropValue[n]));
    }

    int getNumFilter() {
        return this.alFilterItems.size();
    }

    V2CTweetFilterItem getFilterItem(int n) {
        return (V2CTweetFilterItem)this.alFilterItems.get(n);
    }

    void applyFilter(V2CTweetItem v2CTweetItem) {
        ArrayList arrayList = this.alFilterItems;
        int n = 0;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            n <<= 1;
            V2CTweetFilterItem v2CTweetFilterItem = (V2CTweetFilterItem)arrayList.get(i);
            if (v2CTweetFilterItem == null || !v2CTweetFilterItem.check(v2CTweetItem, this.vThreadPanel)) continue;
            n |= 1;
        }
        v2CTweetItem.setFilteredState(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFilter(int n) {
        if (n < 0 || n >= this.getNumFilter()) {
            return;
        }
        V2CTweetFilterItem v2CTweetFilterItem = this.getFilterItem(n);
        if (!V2CSwingUtil.showOKCancelWarningDialog("\u62bd\u51fa\u6761\u4ef6\u300c" + v2CTweetFilterItem.getLabel() + "\u300d\u3092\u524a\u9664\u3057\u307e\u3059\u3002")) {
            return;
        }
        ArrayList arrayList = this.alFilterItems;
        Serializable serializable = arrayList;
        synchronized (serializable) {
            arrayList.remove(n);
        }
        this.save();
        serializable = this.vThreadPanel;
        ((V2CThreadPanel)serializable).getThreadFilterSelector().filterDeleted(n);
        ((V2CTwitterThreadRes)((V2CAbstractThreadPanel)serializable).getThreadRes()).applyFilter();
        ((V2CThreadPanel)serializable).forceResetDisplay();
        ((JComponent)serializable).revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveFilter(int n, boolean bl) {
        int n2 = this.getNumFilter();
        if (bl ? n <= 0 || n >= n2 : n < 0 || n >= n2 - 1) {
            return;
        }
        int n3 = n + (bl ? -1 : 1);
        ArrayList arrayList = this.alFilterItems;
        Serializable serializable = arrayList;
        synchronized (serializable) {
            Object e = arrayList.remove(n);
            arrayList.add(n3, e);
        }
        this.save();
        serializable = this.vThreadPanel;
        ((V2CThreadPanel)serializable).getThreadFilterSelector().filterMoved(n, n3, bl);
        ((V2CTwitterThreadRes)((V2CAbstractThreadPanel)serializable).getThreadRes()).applyFilter();
        ((V2CThreadPanel)serializable).forceResetDisplay();
        ((JComponent)serializable).revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void duplicateFilter(int n) {
        if (n < 0 || n >= this.getNumFilter()) {
            return;
        }
        V2CTweetFilterItem v2CTweetFilterItem = new V2CTweetFilterItem(this.getFilterItem(n));
        ArrayList arrayList = this.alFilterItems;
        Serializable serializable = arrayList;
        synchronized (serializable) {
            arrayList.add(n, v2CTweetFilterItem);
        }
        this.save();
        serializable = this.vThreadPanel;
        ((V2CThreadPanel)serializable).getThreadFilterSelector().filterInserted(n, v2CTweetFilterItem);
        ((V2CTwitterThreadRes)((V2CAbstractThreadPanel)serializable).getThreadRes()).applyFilter();
        ((V2CThreadPanel)serializable).forceResetDisplay();
        ((JComponent)serializable).revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configFilter(int n, boolean bl) {
        Object object;
        V2CTweetFilterItem v2CTweetFilterItem;
        if (bl) {
            v2CTweetFilterItem = new V2CTweetFilterItem();
        } else if (n >= 0 && n < this.getNumFilter()) {
            v2CTweetFilterItem = this.getFilterItem(n);
        } else {
            return;
        }
        V2CThreadPanel v2CThreadPanel = this.vThreadPanel;
        V2CTwitterThreadRes v2CTwitterThreadRes = (V2CTwitterThreadRes)v2CThreadPanel.getThreadRes();
        HashMap<Long, V2CTwitterUserID> hashMap = new HashMap<Long, V2CTwitterUserID>();
        for (int i = v2CTwitterThreadRes.getNRes() - 1; i >= 0; --i) {
            object = V2CTwitterUserID.createInstance((V2CTweetItem)v2CTwitterThreadRes.getResItem(i));
            if (object == null) continue;
            hashMap.put(((V2CTwitterUserID)object).getID(), (V2CTwitterUserID)object);
        }
        V2CTweetFilterSP v2CTweetFilterSP = new V2CTweetFilterSP(v2CTweetFilterItem, hashMap);
        if (!v2CTweetFilterSP.showDialog()) {
            return;
        }
        object = v2CThreadPanel.getThreadFilterSelector();
        if (bl) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList = this.alFilterItems;
            synchronized (arrayList2) {
                if (n < 0 || n >= this.getNumFilter()) {
                    n = arrayList.size();
                }
                arrayList.add(n, v2CTweetFilterItem);
            }
            ((V2CThreadFilterSelector)object).filterInserted(n, v2CTweetFilterItem);
        } else {
            ((V2CThreadFilterSelector)object).updateLabel(n, v2CTweetFilterItem.getLabel());
        }
        this.save();
        v2CTwitterThreadRes.applyFilter();
        v2CThreadPanel.forceResetDisplay();
        v2CThreadPanel.revalidate();
    }

    void addUser(V2CTweetItem v2CTweetItem, boolean bl) {
        Object object;
        if (v2CTweetItem == null) {
            return;
        }
        V2CTwitterUserID v2CTwitterUserID = V2CTwitterUserID.createInstance(v2CTweetItem);
        if (v2CTwitterUserID == null) {
            return;
        }
        long l = v2CTwitterUserID.getID();
        ArrayList arrayList = this.alFilterItems;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            object = (V2CTweetFilterItem)arrayList.get(i);
            if (!(bl ^ ((V2CTweetFilterItem)object).contains(l))) continue;
            arrayList2.add(object);
        }
        String string = bl ? "\u8ffd\u52a0" : "\u9664\u5916";
        object = v2CTwitterUserID.getUserName();
        int n2 = arrayList2.size();
        if (n2 == 0) {
            V2CSwingUtil.showErrorMessage('\"' + (String)object + "\"\u3092" + string + "\u3059\u308b\u632f\u308a\u5206\u3051\u30dc\u30bf\u30f3\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            return;
        }
        Object object2 = V2CSwingUtil.showComboBoxDialog(arrayList2.toArray(), null, '\"' + (String)object + "\"\u3092" + string + "\u3057\u307e\u3059\u3002", "\u632f\u308a\u5206\u3051\u30dc\u30bf\u30f3\u8a2d\u5b9a");
        if (!(object2 instanceof V2CTweetFilterItem)) {
            return;
        }
        ((V2CTweetFilterItem)object2).toggleUser(v2CTwitterUserID, bl);
        this.save();
        V2CThreadPanel v2CThreadPanel = this.vThreadPanel;
        ((V2CTwitterThreadRes)v2CThreadPanel.getThreadRes()).applyFilter();
        v2CThreadPanel.forceResetDisplay();
        v2CThreadPanel.revalidate();
    }
}

