/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.DimensionUIResource;
import org.monazilla.v2c.V2CAbstractAction;
import org.monazilla.v2c.V2CAbstractMiniSearch;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CAddressBar;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CImgDLStatus;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMacQuaquaSupport;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMemoryGauge;
import org.monazilla.v2c.V2CMessageField;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CMonochromeIconFactory;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProgressBar;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSearchHistoryItem;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadListHistory;
import org.monazilla.v2c.V2CThreadListPane;
import org.monazilla.v2c.V2CThreadViewHistory;
import org.monazilla.v2c.V2CThreadViewPane;
import org.monazilla.v2c.V2CToolBarButtonPanel;
import org.monazilla.v2c.V2CToolBarComponent;
import org.monazilla.v2c.V2CToolBarSP;
import org.monazilla.v2c.V2CToolBarSetting;
import org.monazilla.v2c.V2CWritePanel;
import org.monazilla.v2c.V2CWriteWindow;

public class V2CToolBar
extends JPanel {
    private static final String sSaveFileName = "toolbar.txt";
    private static final String sSaveFileName2 = "toolbar2.txt";
    static final String sComponentsFileName = "tbcmps.txt";
    static final String sConfKey = "ToolBar.Conf";
    static final String sMacConfKey = "ToolBar.MacConf";
    static final HashMap hmToolBars = new HashMap();
    static V2CToolBarSetting[] vlToolBarSetting;
    static V2CToolBarSetting[] vlClonedSetting;
    static boolean bSettingChecked;
    static final ArrayList alButtonPanels;
    static final boolean bMacUseSegmentedButton;
    static boolean bNoCustomBottonBorder;
    static int nDefaultIconSize;
    static final boolean bUseMonochromeIcon = false;
    String sID;

    static boolean canMacUseSegmentedButton() {
        return V2CApp.isMacintosh(5) && !V2CMacQuaquaSupport.isQuaquaInstalled();
    }

    static boolean getMacUseSegmentedButtonSetting() {
        String string = V2CApp.getUserProperty().get(sMacConfKey);
        return string == null || !string.equals("n");
    }

    static void setMacUseSegmentedButtonSetting(boolean bl) {
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        if (bl) {
            v2CProperty.remove(sMacConfKey);
        } else {
            v2CProperty.put(sMacConfKey, "n");
        }
    }

    static void updateAllUI(Container container) {
        Iterator iterator = hmToolBars.values().iterator();
        while (iterator.hasNext()) {
            V2CToolBar v2CToolBar = (V2CToolBar)iterator.next();
            if (container != null && container != v2CToolBar.getParent()) continue;
            V2CMain.fontForUIChanged0(v2CToolBar);
        }
    }

    static ArrayList getButtonPanels() {
        return alButtonPanels;
    }

    static void setToolBar() {
        V2CToolBar.checkSetting();
        if (vlClonedSetting == null) {
            vlClonedSetting = V2CToolBarSetting.cloneArray(vlToolBarSetting);
        }
        V2CToolBarSetting[] v2CToolBarSettingArray = V2CToolBarSetting.cloneArray(vlClonedSetting);
        V2CToolBarSetting[] v2CToolBarSettingArray2 = V2CToolBar.restoreSetting(sComponentsFileName, false);
        if (v2CToolBarSettingArray2 == null || v2CToolBarSettingArray2.length != vlToolBarSetting.length) {
            return;
        }
        V2CToolBarSP v2CToolBarSP = new V2CToolBarSP(v2CToolBarSettingArray2, v2CToolBarSettingArray, !bNoCustomBottonBorder, nDefaultIconSize);
        if (!v2CToolBarSP.showDialog()) {
            return;
        }
        vlClonedSetting = v2CToolBarSettingArray;
        V2CToolBar.saveSetting();
        boolean bl = !v2CToolBarSP.getDrawCustomBottonBorder();
        int n = v2CToolBarSP.getIconWidth();
        bNoCustomBottonBorder = bl;
        nDefaultIconSize = n;
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        if (bl || n > 0) {
            V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
            v2CPackedPropValue.setBoolean('e', bl);
            if (n > 0) {
                v2CPackedPropValue.setInt('W', n);
            }
            v2CProperty.putPackedValue(sConfKey, v2CPackedPropValue);
        } else {
            v2CProperty.remove(sConfKey);
        }
        V2CSearchHistoryItem.setHistoryNum(v2CToolBarSP);
    }

    static void restoreToolBar() {
        vlToolBarSetting = V2CToolBar.restoreSetting(sSaveFileName, true);
        for (int i = 0; i < vlToolBarSetting.length; ++i) {
            V2CToolBar.createToolBar(vlToolBarSetting[i], null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static V2CToolBarSetting[] restoreSetting(String string, boolean bl) {
        BufferedReader bufferedReader;
        BufferedReader bufferedReader2 = bufferedReader = bl ? V2CLocalFileHandler.getUserSaveFileReader(string) : null;
        if (bufferedReader == null) {
            bufferedReader = V2CLocalFileHandler.getConfigReader(string);
        }
        if (bufferedReader == null) {
            System.out.println("cannot read " + string + " !");
            V2CApp.immediateExit(1);
            return null;
        }
        ArrayList<V2CToolBarSetting> arrayList = new ArrayList<V2CToolBarSetting>();
        try {
            try {
                String string2;
                V2CToolBarSetting v2CToolBarSetting = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.length() == 0 || string2.charAt(0) == '#') continue;
                    String[] stringArray = V2CMiscUtil.split(string2);
                    int n = stringArray.length;
                    String string3 = stringArray[0];
                    if (string3.equals("ToolBar")) {
                        v2CToolBarSetting = new V2CToolBarSetting(stringArray);
                        arrayList.add(v2CToolBarSetting);
                        continue;
                    }
                    if (v2CToolBarSetting == null) continue;
                    v2CToolBarSetting.add(stringArray);
                }
                Object var10_10 = null;
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                V2CApp.errorExit("\u30c4\u30fc\u30eb\u30d0\u30fc\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc\u30a8\u30e9\u30fc");
                Object var10_11 = null;
                V2CLocalFileHandler.closeReader(bufferedReader);
                return arrayList.toArray(new V2CToolBarSetting[arrayList.size()]);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            V2CLocalFileHandler.closeReader(bufferedReader);
            throw throwable;
        }
        V2CLocalFileHandler.closeReader(bufferedReader);
        return arrayList.toArray(new V2CToolBarSetting[arrayList.size()]);
    }

    static void checkSetting() {
        int n;
        V2CToolBarSetting[] v2CToolBarSettingArray;
        if (bSettingChecked) {
            return;
        }
        bSettingChecked = true;
        V2CToolBarSetting[] v2CToolBarSettingArray2 = vlToolBarSetting;
        int n2 = v2CToolBarSettingArray2.length;
        for (int i = 0; i < n2; ++i) {
            V2CToolBarSetting v2CToolBarSetting = v2CToolBarSettingArray2[i];
            if (v2CToolBarSetting.getIndex() != 3 || !v2CToolBarSetting.getIDString().equals("Write")) continue;
            return;
        }
        if (v2CToolBarSettingArray2[n2 - 2].getIDString().equals("Write")) {
            V2CToolBarSetting v2CToolBarSetting = v2CToolBarSettingArray2[n2 - 1];
            v2CToolBarSettingArray2[n2 - 1] = v2CToolBarSettingArray2[n2 - 2];
            v2CToolBarSettingArray2[n2 - 2] = v2CToolBarSetting;
        }
        if ((v2CToolBarSettingArray = V2CToolBar.restoreSetting(sSaveFileName2, false)) != null && (n = v2CToolBarSettingArray.length) > 0) {
            V2CToolBarSetting[] v2CToolBarSettingArray3 = new V2CToolBarSetting[n2 + n];
            System.arraycopy(v2CToolBarSettingArray2, 0, v2CToolBarSettingArray3, 0, n2);
            System.arraycopy(v2CToolBarSettingArray, 0, v2CToolBarSettingArray3, n2, n);
            vlToolBarSetting = v2CToolBarSettingArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void saveSetting() {
        block12: {
            if (vlClonedSetting == null) {
                return;
            }
            BufferedWriter bufferedWriter = V2CLocalFileHandler.getUserConfigWriter(sSaveFileName);
            if (bufferedWriter == null) {
                System.out.println("cannot write to toolbar.txt !");
                return;
            }
            for (int i = 0; i < vlClonedSetting.length; ++i) {
                V2CToolBarSetting v2CToolBarSetting = vlClonedSetting[i];
                bufferedWriter.write("ToolBar,");
                bufferedWriter.write(v2CToolBarSetting.getIDString());
                bufferedWriter.write(44);
                bufferedWriter.write(v2CToolBarSetting.getPositionString());
                bufferedWriter.newLine();
                for (int j = 0; j < v2CToolBarSetting.size(); ++j) {
                    V2CToolBarComponent v2CToolBarComponent = v2CToolBarSetting.get(j);
                    String string = v2CToolBarComponent.getSaveString();
                    if (string == null) continue;
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
            Object var7_7 = null;
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
            break block12;
            {
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    Object var7_8 = null;
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static V2CToolBar getToolBar(String string, String string2) {
        return (V2CToolBar)hmToolBars.get(string + ':' + string2);
    }

    static boolean isToolBarVisible(String string, String string2) {
        V2CToolBar v2CToolBar = V2CToolBar.getToolBar(string, string2);
        if (v2CToolBar == null) {
            return true;
        }
        return v2CToolBar.isVisible();
    }

    static boolean setToolBarVisible(String string, String string2, boolean bl) {
        int n;
        char[] cArray;
        V2CToolBar v2CToolBar = V2CToolBar.getToolBar(string, string2);
        if (v2CToolBar == null) {
            return true;
        }
        v2CToolBar.setVisible(bl);
        String string3 = string + ".ShowToolBar";
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        String string4 = v2CProperty.get(string3);
        if (string4 == null || string4.length() != 4) {
            string4 = "SSSS";
        }
        if (bl != ((cArray = string4.toCharArray())[n = V2CToolBarSetting.getToolBarPositionIndex(string2)] == 'S')) {
            cArray[n] = bl ? 83 : 72;
            v2CProperty.put(string3, new String(cArray));
        }
        return bl;
    }

    static void createToolBar(Container container, String string) {
        V2CToolBar.checkSetting();
        if (vlToolBarSetting == null) {
            return;
        }
        for (int i = 0; i < vlToolBarSetting.length; ++i) {
            V2CToolBarSetting v2CToolBarSetting = vlToolBarSetting[i];
            if (!string.equals(v2CToolBarSetting.getIDString())) continue;
            V2CToolBar.createToolBar(v2CToolBarSetting, container);
        }
    }

    static void createToolBar(V2CToolBarSetting v2CToolBarSetting, Container container) {
        String string;
        String string2 = v2CToolBarSetting.getIDString();
        if (container == null) {
            container = v2CToolBarSetting.getContainer();
        }
        if (container == null) {
            return;
        }
        boolean bl = string2.startsWith("Write");
        if (bl && v2CToolBarSetting.size() == 0) {
            return;
        }
        V2CToolBar v2CToolBar = new V2CToolBar(string2, v2CToolBarSetting, container);
        container.add((Component)v2CToolBar, v2CToolBarSetting.getBorderPosition());
        if (!bl && (string = V2CMain.getUserProperty().get(string2 + ".ShowToolBar")) != null && string.length() == 4 && string.charAt(v2CToolBarSetting.getIndex()) != 'S') {
            v2CToolBar.setVisible(false);
        }
    }

    static Component createToolBarButton(V2CAbstractAction v2CAbstractAction, boolean bl) {
        String string;
        ToolBarButton toolBarButton = null;
        switch (v2CAbstractAction.getType()) {
            case 0: {
                toolBarButton = new ToolBarButton(v2CAbstractAction);
                break;
            }
            case 2: {
                toolBarButton = new ToolBarButton(v2CAbstractAction);
                if (!v2CAbstractAction.isSelected()) break;
                toolBarButton.setSelected(true);
            }
        }
        if (toolBarButton == null) {
            return null;
        }
        if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.needsGeometryTweak()) {
            V2CMacQuaquaSupport.resetVisualMargin(toolBarButton);
            V2CMacQuaquaSupport.setSquareButtonStyle(toolBarButton);
            toolBarButton.setMargin(new Insets(2, 2, 2, 2));
        }
        toolBarButton.setFocusable(false);
        if (bl) {
            v2CAbstractAction.add(toolBarButton);
        }
        if (!V2CToolBar.setCustomIcon(toolBarButton, string = v2CAbstractAction.getName())) {
            Icon icon = null;
            if (bMacUseSegmentedButton) {
                V2CToolBar.checkSpecialIcon(string);
                toolBarButton.putClientProperty("JComponent.sizeVariant", "small");
                int n = 26;
                int n2 = 18;
                toolBarButton.putClientProperty("JButton.buttonType", "segmentedTextured");
                String string2 = null;
                if (v2CAbstractAction instanceof V2CAction.DisplayPaneHistoryBack) {
                    string2 = "first";
                    n = 20;
                } else if (v2CAbstractAction instanceof V2CAction.DisplayPaneHistoryForward) {
                    string2 = "last";
                    n = 20;
                } else {
                    string2 = "only";
                }
                toolBarButton.putClientProperty("JButton.segmentPosition", string2);
                Dimension dimension = new Dimension(n, n2);
                toolBarButton.setPreferredSize(dimension);
                toolBarButton.setMinimumSize(dimension);
                toolBarButton.bMacSegmented = true;
                String string3 = v2CAbstractAction.getIconName();
                icon = V2CMonochromeIconFactory.createIcon(string3, false);
                if (icon != null) {
                    toolBarButton.setIcon(icon);
                    icon = V2CMonochromeIconFactory.createIcon(string3, true);
                    if (icon != null) {
                        toolBarButton.setSelectedIcon(icon);
                    }
                }
            }
            if (icon == null && !V2CToolBar.setDefaultIcon(toolBarButton, v2CAbstractAction.getName())) {
                icon = v2CAbstractAction.getIcon();
                if (icon != null) {
                    toolBarButton.setIcon(icon);
                    icon = v2CAbstractAction.getDisabledIcon();
                    if (icon != null) {
                        toolBarButton.setDisabledIcon(icon);
                    }
                } else {
                    toolBarButton.setText(v2CAbstractAction.getToolBarLabel());
                }
            }
        }
        toolBarButton.setToolTipText(v2CAbstractAction.getToolTipText());
        return toolBarButton;
    }

    static boolean setDefaultIcon(ToolBarButton toolBarButton, String string) {
        int n;
        int[] nArray;
        int n2;
        int n3;
        byte[] byArray = V2CLocalFileHandler.getIconBytesFromResource(string);
        if (byArray == null) {
            return false;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n4 = byArray.length;
        int n5 = byArray[0];
        int n6 = byArray[1];
        int n7 = byArray[2] << 1;
        int[] nArray2 = new int[n5 * n6];
        int n8 = nDefaultIconSize;
        boolean bl = n8 > 0 && n8 < n5;
        boolean bl2 = V2CApp.isMacintosh();
        if (bl) {
            if (2 * n8 < n5) {
                n8 = (n5 + 1) / 2;
            }
            n3 = n8;
            n2 = n8;
            nArray = new int[n3 * n2];
            n = (n3 << 15) / n5;
        } else {
            n3 = n5;
            n2 = n6;
            nArray = nArray2;
            n = 0;
        }
        int n9 = 3;
        block9: for (int i = 0; i < 7; ++i) {
            int n10;
            int n11;
            if (((n7 >>>= 1) & 1) == 0) continue;
            if (bl2 && (n7 == 2 || n7 == 4)) {
                n9 += 4 * n5 * n6;
                continue;
            }
            int n12 = 0;
            for (n11 = 0; n11 < n6; ++n11) {
                for (n10 = 0; n10 < n5; ++n10) {
                    nArray2[n12++] = (byArray[n9++] & 0xFF) << 24 | (byArray[n9++] & 0xFF) << 16 | (byArray[n9++] & 0xFF) << 8 | byArray[n9++] & 0xFF;
                }
            }
            if (bl) {
                int n13;
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                int n23;
                n12 = 0;
                n11 = nArray2.length;
                block12: for (n10 = 0; n10 < n6; ++n10) {
                    n23 = n10 * n5;
                    n22 = 32768;
                    n21 = 0;
                    n20 = 0;
                    n19 = 0;
                    n18 = 0;
                    for (n17 = 0; n17 < n5; ++n17) {
                        n16 = nArray2[n23 + n17];
                        if (n17 == n5 - 1) {
                            n22 = n;
                        }
                        int n24 = n15 = n22 <= n ? 1 : 0;
                        if (n15 != 0) {
                            n14 = n22;
                        } else {
                            n14 = n;
                            n22 -= n;
                        }
                        n13 = n16 >>> 24;
                        int n25 = n14 * n13;
                        n18 += n25;
                        n21 += (n16 >>> 16 & 0xFF) * n25;
                        n20 += (n16 >>> 8 & 0xFF) * n25;
                        n19 += (n16 & 0xFF) * n25;
                        if (n15 == 0) continue;
                        if (n12 >= n11) continue block12;
                        nArray2[n12++] = n18 != 0 ? (n18 & 0x7F8000) << 9 | n21 / n18 << 16 | n20 / n18 << 8 | n19 / n18 : 0;
                        n14 = n - n14;
                        n13 = n16 >>> 24;
                        n18 = n25 = n14 * n13;
                        n21 = (n16 >>> 16 & 0xFF) * n25;
                        n20 = (n16 >>> 8 & 0xFF) * n25;
                        n19 = (n16 & 0xFF) * n25;
                        n22 = 32768 - n14;
                    }
                }
                n11 = nArray.length;
                block14: for (n10 = 0; n10 < n3; ++n10) {
                    n12 = n10;
                    n23 = 32768;
                    n22 = 0;
                    n21 = 0;
                    n20 = 0;
                    n19 = 0;
                    for (n18 = 0; n18 < n6; ++n18) {
                        n17 = nArray2[n18 * n3 + n10];
                        if (n18 == n6 - 1) {
                            n23 = n;
                        }
                        int n26 = n16 = n23 <= n ? 1 : 0;
                        if (n16 != 0) {
                            n15 = n23;
                        } else {
                            n15 = n;
                            n23 -= n;
                        }
                        n14 = n17 >>> 24;
                        n13 = n15 * n14;
                        n19 += n13;
                        n22 += (n17 >>> 16 & 0xFF) * n13;
                        n21 += (n17 >>> 8 & 0xFF) * n13;
                        n20 += (n17 & 0xFF) * n13;
                        if (n16 == 0) continue;
                        if (n12 >= n11) continue block14;
                        nArray[n12] = n19 != 0 ? (n19 & 0x7F8000) << 9 | n22 / n19 << 16 | n21 / n19 << 8 | n20 / n19 : 0;
                        n12 += n2;
                        n15 = n - n15;
                        n14 = n17 >>> 24;
                        n19 = n13 = n15 * n14;
                        n22 = (n17 >>> 16 & 0xFF) * n13;
                        n21 = (n17 >>> 8 & 0xFF) * n13;
                        n20 = (n17 & 0xFF) * n13;
                        n23 = 32768 - n15;
                    }
                }
            }
            BufferedImage bufferedImage = new BufferedImage(n3, n2, 2);
            bufferedImage.setRGB(0, 0, n3, n2, nArray, 0, n3);
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            switch (i) {
                case 0: {
                    toolBarButton.setIcon(imageIcon);
                    continue block9;
                }
                case 1: {
                    toolBarButton.setPressedIcon(imageIcon);
                    continue block9;
                }
                case 2: {
                    toolBarButton.setRolloverIcon(imageIcon);
                    continue block9;
                }
                case 3: {
                    toolBarButton.setSelectedIcon(imageIcon);
                    continue block9;
                }
                case 4: {
                    toolBarButton.setRolloverSelectedIcon(imageIcon);
                    continue block9;
                }
                case 5: {
                    toolBarButton.setDisabledIcon(imageIcon);
                    continue block9;
                }
                case 6: {
                    toolBarButton.setDisabledSelectedIcon(imageIcon);
                    continue block9;
                }
                default: {
                    return false;
                }
            }
        }
        toolBarButton.setBorderPainted(false);
        toolBarButton.setContentAreaFilled(false);
        toolBarButton.setRolloverEnabled(true);
        Dimension dimension = new Dimension(n3 + 2, n2 + 2);
        toolBarButton.setPreferredSize(dimension);
        toolBarButton.setMinimumSize(dimension);
        V2CToolBar.checkSpecialIcon(string);
        toolBarButton.bDefaultIcon = true;
        return true;
    }

    static JButton createButtonForToolBar(String string) {
        ToolBarButton toolBarButton = new ToolBarButton();
        if (bMacUseSegmentedButton) {
            toolBarButton.putClientProperty("JComponent.sizeVariant", "small");
            toolBarButton.putClientProperty("JButton.buttonType", "segmentedTextured");
            toolBarButton.putClientProperty("JButton.segmentPosition", "only");
        } else if (V2CApp.isMacintosh()) {
            toolBarButton.setContentAreaFilled(false);
            toolBarButton.setBorderPainted(false);
        }
        toolBarButton.setMargin(bMacUseSegmentedButton ? new Insets(5, -7, 5, -7) : new Insets(1, 2, 1, 2));
        String string2 = "AddressBarOpen";
        if (!V2CToolBar.setCustomIcon(toolBarButton, string2)) {
            ImageIcon imageIcon = null;
            if (bMacUseSegmentedButton) {
                imageIcon = V2CMonochromeIconFactory.createIcon(string, false);
            }
            if (imageIcon == null && !V2CToolBar.setDefaultIcon(toolBarButton, string2)) {
                imageIcon = V2CSwingUtil.getSystemIcon(string);
            }
            if (imageIcon != null) {
                toolBarButton.setIcon(imageIcon);
            }
        }
        return toolBarButton;
    }

    static boolean setCustomIcon(AbstractButton abstractButton, String string) {
        Icon icon = V2CToolBar.getCustomIcon(string);
        if (icon == null) {
            return false;
        }
        V2CToolBar.checkSpecialIcon(string);
        if (bNoCustomBottonBorder) {
            abstractButton.setContentAreaFilled(false);
            abstractButton.setBorderPainted(false);
        }
        abstractButton.setIcon(icon);
        icon = V2CToolBar.getCustomIcon(string + "_P");
        if (icon != null) {
            abstractButton.setPressedIcon(icon);
        }
        if ((icon = V2CToolBar.getCustomIcon(string + "_S")) != null) {
            abstractButton.setSelectedIcon(icon);
        }
        if ((icon = V2CToolBar.getCustomIcon(string + "_R")) != null) {
            abstractButton.setRolloverIcon(icon);
        }
        if ((icon = V2CToolBar.getCustomIcon(string + "_RS")) != null) {
            abstractButton.setRolloverSelectedIcon(icon);
        }
        if ((icon = V2CToolBar.getCustomIcon(string + "_D")) != null) {
            abstractButton.setDisabledIcon(icon);
        }
        if ((icon = V2CToolBar.getCustomIcon(string + "_DS")) != null) {
            abstractButton.setDisabledSelectedIcon(icon);
        }
        return true;
    }

    static Icon getCustomIcon(String string) {
        File file = V2CLocalFileHandler.getToolBarIconFile(string);
        if (file == null) {
            return null;
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return null;
        }
        if (bufferedImage == null) {
            return null;
        }
        return new ImageIcon(bufferedImage);
    }

    static void checkSpecialIcon(String string) {
        V2CThreadListPane.checkSpecialIcon(string);
        V2CThreadViewPane.checkSpecialIcon(string);
    }

    static Component createToolBarComponent(JToolBar jToolBar, V2CToolBarComponent v2CToolBarComponent, String string, Container container) {
        Component component = null;
        switch (v2CToolBarComponent.getType()) {
            case 2: {
                String string2 = v2CToolBarComponent.getComponentName();
                if (string2.equals("AddressBar")) {
                    component = V2CAddressBar.getInstance();
                    break;
                }
                if (string2.equals("FindField")) break;
                if (string2.equals("BoardTreeMiniSearch")) {
                    component = V2CAbstractMiniSearch.getInstance(0, true);
                    break;
                }
                if (string2.equals("ThreadListMiniSearch")) {
                    component = V2CAbstractMiniSearch.getInstance(1, true);
                    break;
                }
                if (string2.equals("ThreadViewMiniSearch")) {
                    component = V2CAbstractMiniSearch.getInstance(2, true);
                    break;
                }
                if (string2.equals("MessageField")) {
                    component = V2CMessageField.getInstance();
                    break;
                }
                if (string2.equals("ImgDLStatus")) {
                    component = V2CImgDLStatus.getInstance();
                    break;
                }
                if (string2.equals("ProgressBar")) {
                    component = V2CProgressBar.getInstance();
                    break;
                }
                if (string2.equals("MemoryGauge")) {
                    component = V2CMemoryGauge.getInstance();
                    break;
                }
                if (string2.equals("NameAndMail")) {
                    component = ((V2CWritePanel)container).createNameAndMail();
                    break;
                }
                if (string2.equals("WritePanelWarning")) {
                    component = ((V2CWriteWindow)container).createWarning();
                    break;
                }
                if (string2.equals("WritePanelCounter")) {
                    component = ((V2CWritePanel)container).createCounter();
                    break;
                }
                if (string2.equals("WriteMessageStatus")) {
                    component = ((V2CWritePanel)container).createWriteMessageStatus();
                    break;
                }
                if (string2.equals("MemoSelector")) {
                    component = ((V2CWritePanel)container).createMemoSelector();
                    break;
                }
                if (string2.equals("ThreadViewHistory")) {
                    component = V2CThreadViewHistory.createThreadViewHistory();
                    break;
                }
                if (string2.equals("ThreadListHistory")) {
                    component = V2CThreadListHistory.createThreadListHistory();
                    break;
                }
                if (!string2.equals("ButtonPanel")) break;
                component = V2CToolBarButtonPanel.getButtonPanel(string);
                alButtonPanels.add(component);
                break;
            }
            case 3: {
                jToolBar.addSeparator();
                break;
            }
            case 4: {
                component = new ToolBarSpacer(v2CToolBarComponent.getWidth());
                break;
            }
            case 5: {
                component = new ToolBarGlue();
            }
        }
        return component;
    }

    public V2CToolBar(String string, V2CToolBarSetting v2CToolBarSetting, Container container) {
        super(new GridBagLayout());
        Serializable serializable;
        this.sID = string;
        JToolBar jToolBar = this.createNewToolBar(v2CToolBarSetting.getToolBarOrientation());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jToolBar, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        String string2 = v2CToolBarSetting.getPositionString();
        if (!string.startsWith("Write")) {
            hmToolBars.put(string + ':' + string2, this);
        }
        for (int i = 0; i < v2CToolBarSetting.size(); ++i) {
            V2CToolBarComponent v2CToolBarComponent = v2CToolBarSetting.get(i);
            serializable = null;
            int n = v2CToolBarComponent.getType();
            if (n == 6) {
                jToolBar = this.createNewToolBar(v2CToolBarSetting.getToolBarOrientation());
                ++gridBagConstraints.gridy;
                this.add((Component)jToolBar, gridBagConstraints);
                continue;
            }
            serializable = n == 1 ? V2CToolBar.createToolBarButton(v2CToolBarComponent.getAction(), true) : V2CToolBar.createToolBarComponent(jToolBar, v2CToolBarComponent, this.sID, container);
            if (serializable == null) continue;
            jToolBar.add((Component)serializable);
        }
        if (V2CApp.isMacintosh() && string.equals("Main") && string2.equals("Bottom")) {
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            int n = V2CApp.getOSXVersion() >= 5 ? 8 : (V2CApp.isBrushMetalLook() ? 20 : 13);
            serializable = new Dimension(n, 10);
            jPanel.setPreferredSize((Dimension)serializable);
            jPanel.setMaximumSize((Dimension)serializable);
            jToolBar.add(jPanel);
        }
    }

    JToolBar createNewToolBar(int n) {
        SingleToolBar singleToolBar = new SingleToolBar(n);
        singleToolBar.setFloatable(false);
        return singleToolBar;
    }

    static {
        alButtonPanels = new ArrayList();
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        if (V2CApp.isMacintosh()) {
            boolean bl = V2CApp.isMacintosh(5);
            boolean bl2 = V2CMacQuaquaSupport.isQuaquaInstalled();
            String string = v2CProperty.get(sMacConfKey);
            boolean bl3 = string == null || !string.equals("n");
            boolean bl4 = bMacUseSegmentedButton = bl && !bl2 && bl3;
            if (bl && !bl2 && !bl3) {
                UIManager.put("ToolBar.separatorSize", new DimensionUIResource(28, 2));
            }
        } else {
            bMacUseSegmentedButton = false;
        }
        V2CPackedPropValue v2CPackedPropValue = v2CProperty.getPackedValue(sConfKey);
        if (v2CPackedPropValue != null) {
            bNoCustomBottonBorder = v2CPackedPropValue.getBoolean('e');
            nDefaultIconSize = v2CPackedPropValue.getIntInRangeIfExists('W', 12, 23);
        }
    }

    private static class SingleToolBar
    extends JToolBar {
        SingleToolBar(int n) {
            super(n);
        }

        public void updateUI() {
            super.updateUI();
            if (V2CSwingUtil.isSynthLaF()) {
                this.setLayout(new BoxLayout(this, 2));
            }
        }
    }

    private static class ToolBarGlue
    extends JPanel {
        static Dimension dPref;
        static Dimension dMax;

        ToolBarGlue() {
            this.setOpaque(false);
        }

        public Dimension getPreferredSize() {
            return dPref;
        }

        public Dimension getMaximumSize() {
            return dMax;
        }

        public Dimension getMinimumSize() {
            return dPref;
        }

        static {
            Dimension dimension = UIManager.getDimension("ToolBar.separatorSize");
            dPref = new Dimension(dimension != null ? dimension.width : 5, 10);
            dMax = new Dimension(100000000, 10);
        }
    }

    private static class ToolBarSpacer
    extends JPanel {
        Dimension dSize;

        ToolBarSpacer(int n) {
            this.dSize = new Dimension(n, 10);
            this.setOpaque(false);
        }

        public Dimension getPreferredSize() {
            return this.dSize;
        }

        public Dimension getMaximumSize() {
            return this.dSize;
        }

        public Dimension getMinimumSize() {
            return this.dSize;
        }
    }

    private static class ToolBarButton
    extends JButton {
        boolean bUIUpdated;
        boolean bDefaultIcon;
        boolean bMacSegmented;

        ToolBarButton() {
        }

        ToolBarButton(V2CAbstractAction v2CAbstractAction) {
            super(v2CAbstractAction);
        }

        public void setSelected(boolean bl) {
            if (!((V2CAbstractAction)this.getAction()).getName().equals("ToggleTreePane")) {
                super.setSelected(bl);
            }
        }

        public void updateUI() {
            if (!this.bUIUpdated || !this.bMacSegmented) {
                this.bUIUpdated = true;
                super.updateUI();
            }
        }
    }
}

