/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.monazilla.v2c.V2CGestureMap;
import org.monazilla.v2c.V2CListTable;
import org.monazilla.v2c.V2CListTableModel;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMemoryGauge;
import org.monazilla.v2c.V2CMouseClickManager;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CProgressBar;
import org.monazilla.v2c.V2CProgressState;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTextMarker;
import org.monazilla.v2c.V2CTextMarkerItem;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadListHistory;
import org.monazilla.v2c.V2CThreadListPane;
import org.monazilla.v2c.V2CThreadOpenRequest;

public class V2CTextMarkerList
extends V2CListTable {
    static final String[][] slColumnLabel = new String[][]{{"\u6642\u523b", "TIME"}, {"\u30b3\u30e1\u30f3\u30c8", "COMMENT"}, {"\u30ec\u30b9\u756a\u53f7", "RESNUM"}, {"\u30bf\u30a4\u30c8\u30eb", "TITLE"}, {"\u677f", "BOARD"}};
    static final int TIME = 0;
    static final int COMMENT = 1;
    static final int RESNUM = 2;
    static final int TITLE = 3;
    static final int BOARD = 4;
    static final int TEXTMARKERITEM = 5;
    static final int THREADITEM = 6;
    static final int ARRAYSIZE = 7;
    static int[] nlColWidth = new int[slColumnLabel.length];
    static Reference refTextMarkerList;
    static Icon icDefault;
    static final Object oHistoryKey;
    TextMarkerTableModel icTableModel = new TextMarkerTableModel();
    volatile boolean bUpdating;

    static V2CTextMarkerList getTextMarkerList(boolean bl) {
        V2CTextMarkerList v2CTextMarkerList = refTextMarkerList != null ? (V2CTextMarkerList)refTextMarkerList.get() : null;
        if (v2CTextMarkerList == null && bl) {
            v2CTextMarkerList = new V2CTextMarkerList();
            refTextMarkerList = new SoftReference<V2CTextMarkerList>(v2CTextMarkerList);
        }
        return v2CTextMarkerList;
    }

    static void fontSizeChanged(Font font, int n) {
        V2CTextMarkerList v2CTextMarkerList = V2CTextMarkerList.getTextMarkerList(false);
        if (v2CTextMarkerList != null) {
            v2CTextMarkerList.setFont(font);
            v2CTextMarkerList.setRowHeight(n);
        }
    }

    static void setBGColor() {
        V2CTextMarkerList v2CTextMarkerList = V2CTextMarkerList.getTextMarkerList(false);
        if (v2CTextMarkerList == null) {
            return;
        }
        v2CTextMarkerList.setBackground(cOddBG);
    }

    static void listTextMarkers(boolean bl) {
        V2CTextMarkerList v2CTextMarkerList = V2CTextMarkerList.getTextMarkerList(true);
        v2CTextMarkerList.openTextMarkerList(bl);
    }

    public V2CTextMarkerList() {
        this.setModel(this.icTableModel);
        this.dTCRenderer = new ListRenderer();
        this.setColumnState();
        this.vGestureMap = V2CGestureMap.getGestureMap("Other");
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        TableHeaderListener tableHeaderListener = new TableHeaderListener();
        jTableHeader.addMouseListener(tableHeaderListener);
        jTableHeader.addMouseMotionListener(tableHeaderListener);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.addMouseMotionListener(popupListener);
        this.addMouseWheelListener(this);
    }

    public String getTitleString() {
        return "\u30de\u30fc\u30ab\u30fc\u4e00\u89a7";
    }

    public Icon getIcon() {
        return icDefault;
    }

    public void detouch() {
        this.close();
    }

    public boolean close() {
        return true;
    }

    public V2CProgressState getProgressState() {
        return this.psProgState;
    }

    public Icon getDefaultIcon() {
        return icDefault;
    }

    Object getItem() {
        return oHistoryKey;
    }

    void setColumnWidths() {
        this.setColumnState(false);
    }

    void setColumnState() {
        this.setColumnState(true);
    }

    void setColumnState(boolean bl) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int n2 = nlColWidth[i];
            tableColumnModel.getColumn(i).setPreferredWidth(n2);
            if (!bl) continue;
            tableColumnModel.getColumn(i).setCellRenderer(this.dTCRenderer);
        }
    }

    synchronized boolean setUpdating(boolean bl) {
        if (bl && this.bUpdating) {
            return false;
        }
        this.bUpdating = bl;
        this.psProgState.setInProgress(this.bUpdating);
        if (this.bUpdating) {
            V2CProgressBar.setState(this, this.psProgState);
        }
        return this.bUpdating;
    }

    void openTextMarkerList(boolean bl) {
        V2CThreadListPane v2CThreadListPane = V2CMain.getTablePane();
        int n = v2CThreadListPane.indexOfPanel(this);
        if (n < 0) {
            if (bl || v2CThreadListPane.getPanelCount() == 0) {
                n = v2CThreadListPane.addPanel(this);
            } else {
                n = Math.max(v2CThreadListPane.getSelectedIndex(), 0);
                v2CThreadListPane.setPanelAt(n, this);
            }
        }
        v2CThreadListPane.setSelectedIndex(n);
        V2CThreadListHistory.moveToHistoryTop(oHistoryKey);
        V2CMain.showTablePane(false);
        this.openList(false);
    }

    void openList(final boolean bl) {
        if (!this.setUpdating(true)) {
            System.out.println("already updating !");
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                V2CTextMarkerList.this.psProgState.setThread();
                try {
                    V2CTextMarkerList.this.displayList(bl);
                    V2CSwingUtil.armRequestFocus(V2CTextMarkerList.this);
                    Object var2_1 = null;
                    V2CTextMarkerList.this.setUpdating(false);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    V2CTextMarkerList.this.setUpdating(false);
                    throw throwable;
                }
                V2CMemoryGauge.update();
            }
        };
        thread.start();
    }

    boolean displayList(boolean bl) {
        final ArrayList arrayList = V2CTextMarker.createMarkerList();
        if (SwingUtilities.isEventDispatchThread()) {
            this.icTableModel.setNewList(arrayList);
            this.scrollToRow(0);
            this.indicateSortColumn(-1);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    V2CTextMarkerList.this.icTableModel.setNewList(arrayList);
                    V2CTextMarkerList.this.scrollToRow(0);
                    V2CTextMarkerList.this.indicateSortColumn(-1);
                }
            });
        }
        return true;
    }

    int[] getActiveRowIndices() {
        int[] nArray = this.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (!this.icTableModel.getTextMarkerItem(n2).isValid()) continue;
            if (n < i) {
                nArray[n] = n2;
            }
            ++n;
        }
        if (n == 0) {
            return null;
        }
        if (n == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    void changeSelectedMarker() {
        int[] nArray = this.getActiveRowIndices();
        if (nArray != null) {
            if (nArray.length == 1) {
                V2CTextMarkerItem v2CTextMarkerItem;
                int n = nArray[0];
                V2CThreadItem v2CThreadItem = this.icTableModel.getThreadItem(n);
                if (V2CTextMarker.changeMarker(v2CThreadItem, v2CTextMarkerItem = this.icTableModel.getTextMarkerItem(n))) {
                    this.icTableModel.textMarkerItemUpdated(n);
                }
            } else {
                V2CSwingUtil.showErrorMessage("\u4e00\u5ea6\u306b\u8907\u6570\u306e\u30de\u30fc\u30ab\u30fc\u3092\u5909\u66f4\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
            }
        }
    }

    void deleteSelectedMarkers() {
        int[] nArray = this.getActiveRowIndices();
        if (nArray != null && (nArray.length <= 1 || V2CSwingUtil.showOKCancelDialog(nArray.length + "\u500b\u306e\u30de\u30fc\u30ab\u30fc\u3092\u524a\u9664\u3057\u307e\u3059\u3002", "\u30de\u30fc\u30ab\u30fc\u306e\u524a\u9664", 2))) {
            for (int i = 0; i < nArray.length; ++i) {
                V2CTextMarkerItem v2CTextMarkerItem;
                int n = nArray[i];
                V2CThreadItem v2CThreadItem = this.icTableModel.getThreadItem(n);
                if (!V2CTextMarker.deleteMarker(v2CThreadItem, v2CTextMarkerItem = this.icTableModel.getTextMarkerItem(n))) continue;
                this.icTableModel.textMarkerItemDeleted(n);
            }
            this.repaint();
        }
    }

    void doSortColumn(int n) {
        this.icTableModel.sort(n);
    }

    String getRowURLString(int n) {
        return null;
    }

    String getPanelURLString() {
        return null;
    }

    void showPopup(MouseEvent mouseEvent, Point point) {
        JPopupMenu jPopupMenu;
        int n = this.rowAtPoint(point);
        if (n < 0) {
            return;
        }
        if (mouseEvent != null) {
            mouseEvent.consume();
        }
        if (!this.isRowSelected(n)) {
            this.changeSelection(n, 0, false, false);
        }
        if ((jPopupMenu = V2CMain.getPopupMenu("TextMarkerList")) == null) {
            return;
        }
        V2CPopupListener.showPopup(jPopupMenu, mouseEvent, this, point.x, point.y);
    }

    int getTitleColumnIndex() {
        return 1;
    }

    V2CListTableModel getListTableModel() {
        return this.icTableModel;
    }

    static {
        oHistoryKey = new byte[0];
        V2CTextMarkerList.nlColWidth[0] = 120;
        V2CTextMarkerList.nlColWidth[1] = 100;
        V2CTextMarkerList.nlColWidth[2] = 50;
        V2CTextMarkerList.nlColWidth[3] = 400;
        V2CTextMarkerList.nlColWidth[4] = 100;
        icDefault = V2CSwingUtil.getItemIcon("Marker");
    }

    private class ListRenderer
    extends V2CListTable.ListItemRenderer {
        private ListRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            V2CTextMarkerItem v2CTextMarkerItem;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setHorizontalAlignment(n2 == 0 || n2 == 2 ? 4 : 2);
            if (!bl) {
                this.setForeground(V2CListTable.cTextFG);
                this.setBackground(n % 2 == 0 ? V2CListTable.cOddBG : V2CListTable.cEvenBG);
            }
            if (!(v2CTextMarkerItem = V2CTextMarkerList.this.icTableModel.getTextMarkerItem(n)).isValid()) {
                this.setForeground(Color.GRAY);
            }
            return this;
        }
    }

    private static class TextMarkerTableModel
    extends V2CListTableModel {
        private TextMarkerTableModel() {
        }

        String getTitle(int n) {
            return (String)this.getValueAt(n, 1);
        }

        public int getColumnCount() {
            return slColumnLabel.length;
        }

        String getRealColumnName(int n) {
            return slColumnLabel[n][0];
        }

        public Object getValueAt(int n, int n2) {
            if (this.olTemp == null) {
                return null;
            }
            Object[] objectArray = (Object[])this.olTemp[n];
            if (objectArray == null) {
                return null;
            }
            return objectArray[n2];
        }

        void textMarkerItemUpdated(int n) {
            V2CTextMarkerItem v2CTextMarkerItem = this.getTextMarkerItem(n);
            Object[] objectArray = (Object[])this.olTemp[n];
            objectArray[1] = v2CTextMarkerItem.getComment();
            this.fireTableCellUpdated(n, 1);
        }

        void textMarkerItemDeleted(int n) {
            this.getTextMarkerItem(n).invalidate();
        }

        V2CTextMarkerItem getTextMarkerItem(int n) {
            Object object = this.getValueAt(n, 5);
            return (V2CTextMarkerItem)object;
        }

        V2CThreadItem getThreadItem(int n) {
            Object object = this.getValueAt(n, 6);
            return (V2CThreadItem)object;
        }

        void sort(int n) {
            this.bAscending = n == this.nColSort ? !this.bAscending : false;
            this.nColSort = n;
            Arrays.sort(this.olTemp, 0, this.getRowCount(), this);
            this.fireTableDataChanged();
        }

        public int compare(Object object, Object object2) {
            int n;
            V2CTextMarkerItem v2CTextMarkerItem = (V2CTextMarkerItem)((Object[])object)[5];
            V2CTextMarkerItem v2CTextMarkerItem2 = (V2CTextMarkerItem)((Object[])object2)[5];
            if (this.nColSort == 0) {
                long l = v2CTextMarkerItem2.getTime() - v2CTextMarkerItem.getTime();
                n = l < 0L ? -1 : (l > 0L ? 1 : 0);
            } else if (this.nColSort == 2) {
                n = v2CTextMarkerItem.iResStart - v2CTextMarkerItem2.iResStart;
            } else {
                String string = (String)((Object[])object)[this.nColSort];
                String string2 = (String)((Object[])object2)[this.nColSort];
                n = string == null ? (string2 == null ? 0 : -1) : (string2 == null ? 1 : string.compareTo(string2));
            }
            return this.bAscending ? n : -n;
        }
    }

    private class PopupListener
    extends V2CListTable.TitlePopupListener {
        private PopupListener() {
        }

        boolean isActiveColumn(int n) {
            return true;
        }

        void doClickAction(MouseEvent mouseEvent, int n, int n2) {
            V2CThreadItem v2CThreadItem = V2CTextMarkerList.this.icTableModel.getThreadItem(n);
            int n3 = V2CTextMarkerList.this.icTableModel.getTextMarkerItem((int)n).iResStart;
            V2CThreadOpenRequest v2CThreadOpenRequest = new V2CThreadOpenRequest();
            v2CThreadOpenRequest.setResNumToGo(n3);
            String string = V2CMouseClickManager.checkClickAction("G", mouseEvent);
            if (string != null) {
                v2CThreadItem.open(false, string.equals("ON"), v2CThreadOpenRequest);
            }
        }
    }

    private class TableHeaderListener
    extends MouseInputAdapter {
        int nDragCount;

        private TableHeaderListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ++this.nDragCount;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.nDragCount = 0;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 1 && this.nDragCount < 2 && mouseEvent.getButton() == 1) {
                V2CTextMarkerList.this.sortColumn(V2CTextMarkerList.this.getColumnModel().getColumnIndexAtX(mouseEvent.getX()));
            }
        }
    }
}

