/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CPanel;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CSingleTabbedPane;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTabbedPane;
import org.monazilla.v2c.V2CTabbedPaneLayout;
import org.monazilla.v2c.V2CThreadPanel;

public class V2CTabbedPaneCenterPanel
extends JPanel
implements AdjustmentListener,
MouseWheelListener {
    static final int INDICATOR_WIDTH = 2;
    private final V2CTabbedPane vParentPane;
    final JScrollBar vHScrollBar;
    boolean bPainted;
    final Box vButtonBox;
    Component vLastActiveButton;
    static /* synthetic */ Class class$org$monazilla$v2c$V2CSingleTabbedPane;

    public V2CTabbedPaneCenterPanel(V2CTabbedPane v2CTabbedPane) {
        super(new V2CTabbedPaneLayout());
        Box box;
        this.vParentPane = v2CTabbedPane;
        JScrollBar jScrollBar = new JScrollBar(0);
        jScrollBar.addMouseWheelListener(this);
        this.vHScrollBar = jScrollBar;
        jScrollBar.setVisible(false);
        jScrollBar.addAdjustmentListener(this);
        this.vButtonBox = box = new Box(0);
        box.setVisible(false);
        this.addAllPanes(false);
    }

    void addAllPanes(boolean bl) {
        if (bl) {
            this.removeAll();
        }
        V2CSingleTabbedPane[] v2CSingleTabbedPaneArray = this.vParentPane.getChildPanes();
        int n = v2CSingleTabbedPaneArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(v2CSingleTabbedPaneArray[i]);
        }
        this.add(this.vHScrollBar);
        Box box = this.vButtonBox;
        int n2 = box.getComponentCount();
        if (n2 > n) {
            for (int i = n; i < n2; ++i) {
                box.remove(i);
            }
        } else if (n2 < n) {
            for (int i = n2; i < n; ++i) {
                box.add(this.createNewButton());
            }
        }
        this.add(box);
    }

    V2CSingleTabbedPane getSourceSinglePane(JPanel jPanel) {
        Box box = this.vButtonBox;
        for (int i = box.getComponentCount() - 1; i >= 0; --i) {
            if (box.getComponent(i) != jPanel) continue;
            return this.vParentPane.getChildPane(i);
        }
        return null;
    }

    private JPanel createNewButton() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createBevelBorder(0));
        jPanel.setPreferredSize(new Dimension(14, 16));
        jPanel.addMouseListener(new V2CPopupListener("ThreadViewColumn"));
        jPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!V2CSwingUtil.isSimpleClick(mouseEvent)) {
                    return;
                }
                Component component = mouseEvent.getComponent();
                Box box = V2CTabbedPaneCenterPanel.this.vButtonBox;
                for (int i = box.getComponentCount() - 1; i >= 0; --i) {
                    if (box.getComponent(i) != component) continue;
                    V2CTabbedPaneCenterPanel.this.vParentPane.setActiveSinglePane(i, true);
                    return;
                }
            }
        });
        jPanel.addMouseWheelListener(this);
        return jPanel;
    }

    V2CTabbedPane getParentTabbedPane() {
        return this.vParentPane;
    }

    void repaintActiveIndicator(boolean bl) {
        if (this.vParentPane.getChildPaneCount() <= 1) {
            return;
        }
        if (bl && this.vHScrollBar.isVisible()) {
            this.checkColumnPositionLater(null);
        }
        this.repaint(0, 0, this.getWidth(), 2);
    }

    boolean isHSBVisible() {
        return this.vHScrollBar.isVisible();
    }

    void checkColumnPositionLater(final V2CPanel v2CPanel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl;
                JScrollBar jScrollBar = V2CTabbedPaneCenterPanel.this.vHScrollBar;
                if (!jScrollBar.isVisible()) {
                    return;
                }
                boolean bl2 = bl = v2CPanel != null;
                V2CSingleTabbedPane v2CSingleTabbedPane = bl ? (V2CSingleTabbedPane)SwingUtilities.getAncestorOfClass(class$org$monazilla$v2c$V2CSingleTabbedPane == null ? (class$org$monazilla$v2c$V2CSingleTabbedPane = V2CTabbedPaneCenterPanel.class$("org.monazilla.v2c.V2CSingleTabbedPane")) : class$org$monazilla$v2c$V2CSingleTabbedPane, (Component)((Object)v2CPanel)) : V2CTabbedPaneCenterPanel.this.vParentPane.getActiveSinglePane();
                if (v2CSingleTabbedPane == null) {
                    return;
                }
                Rectangle rectangle = v2CSingleTabbedPane.getBounds();
                int n = -1;
                int n2 = V2CTabbedPaneCenterPanel.this.getWidth();
                if (rectangle.x < 0) {
                    n = jScrollBar.getValue() + rectangle.x;
                } else if (rectangle.x + rectangle.width > n2) {
                    n = jScrollBar.getValue() + (rectangle.x + rectangle.width - n2);
                }
                if (n >= 0) {
                    jScrollBar.setValue(n);
                }
                if (v2CPanel instanceof V2CThreadPanel && ((V2CThreadPanel)v2CPanel).bAutoNextThread) {
                    ((V2CThreadPanel)v2CPanel).bAutoNextThread = false;
                    bl = false;
                }
                if (bl) {
                    ((Component)((Object)v2CPanel)).requestFocusInWindow();
                }
            }
        });
    }

    public void paintComponent(Graphics graphics) {
        Serializable serializable;
        super.paintComponent(graphics);
        if (this.vParentPane.getChildPaneCount() <= 1) {
            return;
        }
        V2CSingleTabbedPane v2CSingleTabbedPane = this.vParentPane.getActiveSinglePane();
        if (v2CSingleTabbedPane == null) {
            return;
        }
        Color color = new Color(255, 99, 71);
        int n = this.vParentPane.getSinglePaneIndex(v2CSingleTabbedPane);
        Box box = this.vButtonBox;
        if (n >= 0 && n < box.getComponentCount()) {
            serializable = this.vLastActiveButton;
            Component component = box.getComponent(n);
            if (component != serializable) {
                component.setBackground(color);
                if (serializable != null) {
                    ((Component)serializable).setBackground(null);
                }
                this.vLastActiveButton = component;
            }
        }
        serializable = v2CSingleTabbedPane.getBounds();
        graphics.setColor(color);
        graphics.fillRect(((Rectangle)serializable).x, 0, ((Rectangle)serializable).width, 2);
        if (!this.bPainted) {
            this.bPainted = true;
            this.repaintActiveIndicator(true);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        JScrollBar jScrollBar = this.vHScrollBar;
        boolean bl = mouseWheelEvent.getWheelRotation() > 0;
        Component component = mouseWheelEvent.getComponent();
        if (component == jScrollBar) {
            int n = jScrollBar.getValue();
            int n2 = -1;
            int n3 = jScrollBar.getUnitIncrement();
            if (bl) {
                int n4 = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
                if (n < n4 && (n2 = n + n3) > n4) {
                    n2 = n4;
                }
            } else if (n > 0 && (n2 = n - n3) < 0) {
                n2 = 0;
            }
            if (n2 >= 0) {
                jScrollBar.setValue(n2);
            }
        } else {
            Box box = this.vButtonBox;
            int n = box.getComponentCount();
            int n5 = -1;
            boolean bl2 = false;
            for (int i = n - 1; i >= 0; --i) {
                Component component2 = box.getComponent(i);
                if (component2 == component) {
                    bl2 = true;
                }
                if (component2 != this.vLastActiveButton) continue;
                n5 = i;
            }
            if (bl2 && n5 >= 0) {
                this.vParentPane.setActiveSinglePane((n5 + (bl ? 1 : -1) + n) % n, true);
            }
            return;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.revalidate();
        this.repaint();
    }
}

