/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Toolkit;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.SourceDataLine;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSoundSP;

public class V2CSoundUtil {
    private static final int EXTERNAL_BUFFER_SIZE = 128000;
    private static final String sConfKey = "Sound.Conf";
    private static V2CPackedPropValue ppvSoundConf;
    static final char USE_SOUND = 'a';
    static final char MUTE_SOUND = 'm';
    static final char THREAD_NEWRES = 'r';
    static final char THREAD_NONEWRES = 'n';
    static final char THREAD_ERROR = 'e';
    static final char TWITTER_NEWTWEET = 'w';
    static final char TWITTER_NONEWTWEET = 'o';
    static final char TWITTER_ERROR = 'x';
    static final char BOARD_NEWRES = 'R';
    static final char BOARD_NONEWRES = 'N';
    static final char BOARD_NEWTHREAD = 'T';
    static final char BOARD_ERROR = 'E';
    static final char CHECK_NEWRES = 'C';
    static final char CHECK_NONEWRES = '0';
    static final char WEBSEARCH_NEWTHREAD = 't';

    static boolean isCompSoundEnabled() {
        return !ppvSoundConf.getBoolean('m');
    }

    static void setSound() {
        V2CSoundSP v2CSoundSP = new V2CSoundSP(V2CSoundUtil.createSoundFileListForSetting());
        if (!v2CSoundSP.showDialog()) {
            return;
        }
        v2CSoundSP.setSoundName(ppvSoundConf);
        V2CApp.getUserProperty().putPackedValue(sConfKey, ppvSoundConf);
    }

    static boolean isSoundDefined(char c) {
        return V2CSoundUtil.getSoundName(c) != null;
    }

    static String getSoundName(char c) {
        return ppvSoundConf.getString(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void playSoundFile0(File file) throws Exception {
        Line line;
        block6: {
            AudioInputStream audioInputStream = null;
            line = null;
            try {
                audioInputStream = AudioSystem.getAudioInputStream(file);
                AudioFormat audioFormat = audioInputStream.getFormat();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(audioFormat);
                line.start();
                int n = 0;
                byte[] byArray = new byte[128000];
                while (n >= 0) {
                    n = audioInputStream.read(byArray, 0, byArray.length);
                    if (n <= 0) continue;
                    line.write(byArray, 0, n);
                }
                line.drain();
                Object var8_7 = null;
                if (audioInputStream == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (audioInputStream != null) {
                    audioInputStream.close();
                }
                if (line != null) {
                    line.close();
                }
                throw throwable;
            }
            audioInputStream.close();
        }
        if (line != null) {
            line.close();
        }
    }

    static void playSound(char c) {
        V2CSoundUtil.playSoundFile(V2CSoundUtil.getSoundName(c));
    }

    static void playSoundFile(String string) {
        if (string == null) {
            return;
        }
        File file = V2CLocalFileHandler.getSoundFile(string);
        if (file != null) {
            V2CSoundUtil.playSoundFile(file);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    static void playSoundFile(final File file) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    V2CSoundUtil.playSoundFile0(file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    V2CMain.setErrorMessage(V2CMiscUtil.getMessage(exception));
                }
            }
        };
        thread.start();
    }

    static String[] createSoundFileListForSetting() {
        return V2CSoundUtil.createSoundFileListForSetting("\uff08\u306a\u3057\uff09");
    }

    static String[] createSoundFileListForSetting(String string) {
        String[] stringArray = V2CSoundUtil.createSoundFileList();
        if (string != null) {
            if (stringArray != null) {
                String[] stringArray2 = new String[stringArray.length + 1];
                stringArray2[0] = string;
                System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                stringArray = stringArray2;
            } else {
                stringArray = new String[]{string};
            }
        } else if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    static String[] createSoundFileList() {
        Object[] objectArray;
        int n;
        File file = V2CLocalFileHandler.getSoundDir();
        if (file == null) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[]{".wav", ".WAV", ".au", ".AU", ".af", ".AF", ".aiff", ".AIFF"};
        HashSet<String> hashSet = new HashSet<String>();
        block0: for (n = 0; n < fileArray.length; ++n) {
            objectArray = fileArray[n];
            String string = objectArray.getName();
            if (string.indexOf(9) >= 0) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.endsWith(stringArray[i])) continue;
                hashSet.add(string.substring(0, string.length() - stringArray[i].length()));
                continue block0;
            }
        }
        n = hashSet.size();
        if (n == 0) {
            return null;
        }
        objectArray = hashSet.toArray(new String[n]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    static {
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        V2CPackedPropValue v2CPackedPropValue = v2CProperty.getPackedValue(sConfKey);
        if (v2CPackedPropValue != null) {
            boolean bl = v2CPackedPropValue.getBoolean('a');
            int n = V2CApp.getLastRelSeqNum();
            if (n > 0 && n < 528) {
                if (bl) {
                    v2CPackedPropValue.setBoolean('a', false);
                } else {
                    v2CPackedPropValue.setBoolean('m', true);
                }
                v2CProperty.putPackedValue(sConfKey, v2CPackedPropValue);
            } else if (bl) {
                v2CPackedPropValue.setBoolean('a', false);
                v2CProperty.putPackedValue(sConfKey, v2CPackedPropValue);
            }
        } else {
            v2CPackedPropValue = new V2CPackedPropValue();
        }
        ppvSoundConf = v2CPackedPropValue;
    }
}

