/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.monazilla.v2c.V2CSoundUtil;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CSingleSoundSP
implements ActionListener {
    static final ImageIcon icPlayIcon = V2CSwingUtil.getSystemIcon("arstart");
    JPanel jPanel;
    final String[] slSoundNames;
    final char cSound;
    JComboBox jcbSound;
    JButton jbPlay;
    boolean bBeep;

    public V2CSingleSoundSP() {
        this('\u0000', V2CSoundUtil.createSoundFileListForSetting(), null);
    }

    public V2CSingleSoundSP(String string) {
        this('\u0000', V2CSoundUtil.createSoundFileListForSetting("\uff08beep\u97f3\uff09"), string);
        this.bBeep = true;
    }

    public V2CSingleSoundSP(char c, String[] stringArray) {
        this(c, stringArray, null);
    }

    public V2CSingleSoundSP(char c, String[] stringArray, String string) {
        JButton jButton;
        JComboBox jComboBox;
        JPanel jPanel;
        this.cSound = c;
        this.slSoundNames = stringArray;
        this.jPanel = jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        if (string != null) {
            jPanel.add((Component)new JLabel(string), gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        this.jcbSound = jComboBox = V2CSwingUtil.createComboBox(new DefaultComboBoxModel<String>(stringArray));
        jComboBox.setFocusable(false);
        if (c > '\u0000') {
            this.setSoundName(V2CSoundUtil.getSoundName(c));
        }
        jPanel.add((Component)jComboBox, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jbPlay = jButton = new JButton(icPlayIcon);
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(2, 3, 2, 3));
        jButton.addActionListener(this);
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
    }

    JPanel getPanel() {
        return this.jPanel;
    }

    char getSoundChar() {
        return this.cSound;
    }

    void setSoundName(String string) {
        int n = 0;
        if (string != null) {
            for (int i = 1; i < this.slSoundNames.length; ++i) {
                if (!string.equals(this.slSoundNames[i])) continue;
                n = i;
                break;
            }
        }
        this.jcbSound.setSelectedIndex(n);
    }

    String getSoundName() {
        int n = this.jcbSound.getSelectedIndex();
        return n > 0 ? (String)this.jcbSound.getItemAt(n) : null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.jcbSound.getSelectedIndex() > 0) {
            String string = (String)this.jcbSound.getSelectedItem();
            V2CSoundUtil.playSoundFile(string);
        } else if (this.bBeep) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

