/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CMain;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class V2CSingleImage {
    private static final boolean bPrintNodeInfo = false;
    static final int NONE = 0;
    static final int DO_NOT_DISPOSE = 1;
    static final int RESTORE_TO_BG = 2;
    static final int RESTORE_TO_PREV = 3;
    private static final int nMinDelayTime = 30;
    Image iImage;
    Image iScaledImage;
    int nX;
    int nY;
    int nWidth;
    int nHeight;
    boolean bInterlace;
    boolean bTransparent;
    int iDisposalMethod;
    int nDelayTime = 500;
    boolean bThumbnailImageCreated;
    private static float[] flcr = new float[]{-0.05930647f, -0.2515778f, -0.23557812f, -1.1090195f, 0.35699975f, -0.1684346f, -0.31154224f, -0.20283332f, 0.55225927f, -0.1587408f, -1.577459f, 0.5184523f, -0.04045399f, 1.9835776f, -0.4294166f};
    private static float[] flcg = new float[]{-0.08279894f, -0.30088562f, -0.28102827f, -1.1301343f, 0.43929404f, -0.26312226f, -0.39744073f, 0.1177769f, 0.718766f, -0.17132558f, 0.53735924f, 0.5986116f, -0.043202728f, 0.77968246f, -0.5170328f};
    private static float[] flcb = new float[]{0.005186297f, 0.056275643f, -0.0054614902f, -1.0151097f, -0.018772785f, 0.12510085f, 0.14771836f, -1.7603017f, -0.2235212f, 0.055800404f, 0.0115760425f, -0.11844744f, -7.781947E-4f, 1.8844783f, 0.07955397f};
    int nBlockSize;

    public V2CSingleImage(V2CSingleImage v2CSingleImage, double d, AffineTransformOp affineTransformOp, boolean bl, String string) {
        Image image = v2CSingleImage.iImage;
        this.nX = (int)(d * (double)v2CSingleImage.nX);
        this.nY = (int)(d * (double)v2CSingleImage.nY);
        this.bInterlace = v2CSingleImage.bInterlace;
        this.bTransparent = v2CSingleImage.bTransparent;
        this.iDisposalMethod = v2CSingleImage.iDisposalMethod;
        this.nDelayTime = v2CSingleImage.nDelayTime;
        if (bl) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            v2CSingleImage.setScaledImageCreated(string);
            int n6 = image.getWidth(null);
            int n7 = image.getHeight(null);
            if (n6 <= 0 || n7 <= 0) {
                return;
            }
            int n8 = Math.max((int)Math.round(d * (double)n6), 1);
            int n9 = Math.max((int)Math.round(d * (double)n7), 1);
            this.nWidth = n8;
            this.nHeight = n9;
            int n10 = n6 * n7;
            int[] nArray = new int[n10];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n6, n7, nArray, 0, n6);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                System.out.println("image fetch aborted or errored");
            }
            if (d < 0.1) {
                int n11 = (int)(1.0 - 2.0 * Math.log(d * 10.0) / Math.log(2.0));
                if (n11 > 14) {
                    n11 = 14;
                }
                n5 = n11 / 2;
                n4 = 255 >>> 7 - n5;
                n3 = 8 - (n11 - n5);
                n2 = 256 >>> 8 - n3;
                n = n2 - 1;
            } else {
                n4 = 1;
                n3 = 8;
                n2 = 256;
                n = 255;
            }
            int[] nArray2 = new int[n8 * n9];
            n5 = 0;
            for (int i = 0; i < n9; ++i) {
                int n12 = i * n7 / n9;
                int n13 = n2 - ((i * n7 << n3) / n9 & n);
                int n14 = (i + 1) * n7 / n9;
                int n15 = ((i + 1) * n7 << n3) / n9 & n;
                for (int j = 0; j < n8; ++j) {
                    int n16;
                    int n17 = j * n6 / n8;
                    int n18 = n2 - ((j * n6 << n3) / n8 & n);
                    int n19 = (j + 1) * n6 / n8;
                    int n20 = ((j + 1) * n6 << n3) / n8 & n;
                    int n21 = 0;
                    int n22 = 0;
                    int n23 = 0;
                    int n24 = 0;
                    int n25 = 0;
                    for (n16 = n12; n16 <= n14 && n16 < n7; ++n16) {
                        int n26;
                        int n27 = n16 * n6;
                        if (n16 == n12) {
                            n26 = n13;
                        } else if (n16 == n14) {
                            if (n15 == 0) continue;
                            n26 = n15;
                        } else {
                            n26 = n2;
                        }
                        for (int k = n17; k <= n19 && k < n6; ++k) {
                            int n28;
                            int n29 = nArray[n27 + k];
                            int n30 = n29 >>> 24;
                            int n31 = n29 >>> 16 & 0xFF;
                            int n32 = n29 >>> 8 & 0xFF;
                            int n33 = n29 & 0xFF;
                            if (k == n17) {
                                n28 = n18;
                            } else if (k == n19) {
                                if (n20 == 0) continue;
                                n28 = n20;
                            } else {
                                n28 = n2;
                            }
                            if (n26 != n2) {
                                n28 = n28 * n26 >>> 8;
                            }
                            int n34 = n30 * n28;
                            n25 += n28;
                            n21 += n34;
                            n22 += n31 * n34 / n4;
                            n23 += n32 * n34 / n4;
                            n24 += n33 * n34 / n4;
                        }
                    }
                    n16 = n21 / n4;
                    if (n16 > 0) {
                        nArray2[n5] = n21 / n25 << 24 | (n22 / n16 & 0xFF) << 16 | (n23 / n16 & 0xFF) << 8 | n24 / n16 & 0xFF;
                    }
                    ++n5;
                }
            }
            BufferedImage bufferedImage = new BufferedImage(n8, n9, 2);
            bufferedImage.setRGB(0, 0, n8, n9, nArray2, 0, n8);
            this.iImage = bufferedImage;
        } else if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            ColorModel colorModel = bufferedImage.getColorModel();
            int n = bufferedImage.getType();
            int n35 = Math.max((int)Math.round(d * (double)bufferedImage.getWidth()), 1);
            int n36 = Math.max((int)Math.round(d * (double)bufferedImage.getHeight()), 1);
            this.nWidth = n35;
            this.nHeight = n36;
            BufferedImage bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n35, n36), colorModel.isAlphaPremultiplied(), null);
            this.iImage = bufferedImage2;
            boolean bl2 = false;
            if (affineTransformOp != null) {
                v2CSingleImage.setScaledImageCreated(string);
                try {
                    affineTransformOp.filter(bufferedImage, bufferedImage2);
                    bl2 = true;
                }
                catch (ImagingOpException imagingOpException) {
                    // empty catch block
                }
            }
            if (!bl2) {
                Graphics2D graphics2D = (Graphics2D)this.iImage.getGraphics();
                graphics2D.drawImage(image, 0, 0, n35, n36, null);
                graphics2D.dispose();
            }
        } else {
            int n = Math.max((int)Math.round(d * (double)image.getWidth(null)), 1);
            int n37 = Math.max((int)Math.round(d * (double)image.getHeight(null)), 1);
            this.nWidth = n;
            this.nHeight = n37;
            this.iImage = V2CMain.v2cMain.createImage(n, n37);
            Graphics2D graphics2D = (Graphics2D)this.iImage.getGraphics();
            graphics2D.drawImage(image, 0, 0, n, n37, null);
            graphics2D.dispose();
        }
    }

    public V2CSingleImage(ImageReader imageReader, Object object, int n, boolean bl, boolean bl2) throws IOException {
        Serializable serializable;
        boolean bl3 = true;
        if (object instanceof File) {
            serializable = (File)object;
            if (bl) {
                BufferedImage bufferedImage = null;
                try {
                    bufferedImage = imageReader.read(0);
                }
                catch (IIOException iIOException) {
                    StackTraceElement[] stackTraceElementArray = iIOException.getStackTrace();
                    Raster raster = imageReader.readRaster(0, null);
                    if (raster == null || raster.getNumBands() != 4) {
                        throw iIOException;
                    }
                    int n2 = raster.getWidth();
                    int n3 = raster.getHeight();
                    bufferedImage = new BufferedImage(n2, n3, 2);
                    float[] fArray = new float[5];
                    float[] fArray2 = new float[15];
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n2; ++j) {
                            int n4;
                            float f;
                            raster.getPixel(j, i, fArray);
                            fArray[0] = fArray[0] / 256.0f;
                            fArray[1] = fArray[1] / 256.0f;
                            fArray[2] = fArray[2] / 256.0f;
                            fArray[3] = fArray[3] / 256.0f;
                            fArray[4] = 1.0f;
                            int n5 = 0;
                            for (int k = 0; k < 5; ++k) {
                                f = fArray[k];
                                for (int i2 = k; i2 < 5; ++i2) {
                                    fArray2[n5++] = f * fArray[i2];
                                }
                            }
                            float f2 = 0.0f;
                            f = 0.0f;
                            float f3 = 0.0f;
                            for (n4 = 0; n4 < 15; ++n4) {
                                f2 += fArray2[n4] * flcr[n4];
                                f += fArray2[n4] * flcg[n4];
                                f3 += fArray2[n4] * flcb[n4];
                            }
                            n4 = Math.max(0, Math.min((int)(f2 * 255.0f), 255));
                            int n6 = Math.max(0, Math.min((int)(f * 255.0f), 255));
                            int n7 = Math.max(0, Math.min((int)(f3 * 255.0f), 255));
                            bufferedImage.setRGB(j, i, 0xFF000000 | n4 << 16 | n6 << 8 | n7);
                        }
                    }
                }
                this.iImage = bufferedImage;
                bl3 = false;
            } else {
                this.iImage = Toolkit.getDefaultToolkit().createImage(((File)serializable).getPath());
            }
        } else if (object instanceof byte[]) {
            this.iImage = Toolkit.getDefaultToolkit().createImage((byte[])object);
        }
        if (this.iImage == null) {
            throw new IOException("createImage failed !");
        }
        if (bl3) {
            serializable = new MediaTracker(V2CMain.v2cMain);
            ((MediaTracker)serializable).addImage(this.iImage, 0);
            try {
                ((MediaTracker)serializable).waitForAll();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("image loading interrupted !");
            }
            if (((MediaTracker)serializable).isErrorAny()) {
                throw new IOException("image loading error !");
            }
        }
        this.nWidth = this.iImage.getWidth(null);
        this.nHeight = this.iImage.getHeight(null);
        if (this.nWidth < 0 || this.nHeight < 0) {
            throw new IOException("unknown image geometry !");
        }
        this.nBlockSize = n;
    }

    public V2CSingleImage(ImageReader imageReader, int n, int n2) throws IOException {
        this(imageReader.read(n), n2);
    }

    public V2CSingleImage(BufferedImage bufferedImage, int n) throws IOException {
        this.iImage = bufferedImage;
        this.nWidth = bufferedImage.getWidth();
        this.nHeight = bufferedImage.getHeight();
        if (this.nWidth < 0 || this.nHeight < 0) {
            throw new IOException("(nWidth<0)||(nHeight<0)");
        }
        this.nBlockSize = n;
    }

    void clear() {
        Image image = this.iImage;
        if (image != null) {
            this.iImage = null;
            image.flush();
        }
    }

    void setBlockSize(int n) {
        if (n != this.nBlockSize) {
            this.nBlockSize = n;
            this.iScaledImage = null;
        }
    }

    void createScaledImage() {
        Object object;
        if (this.nBlockSize < 4 || this.iScaledImage != null) {
            return;
        }
        if (this.nWidth <= 1 && this.nHeight <= 1) {
            this.iScaledImage = this.iImage;
            return;
        }
        int n = Math.max(this.nWidth / this.nBlockSize, 1);
        int n2 = Math.max(this.nHeight / this.nBlockSize, 1);
        Image image = this.iImage;
        if (image instanceof BufferedImage) {
            object = (BufferedImage)image;
            ColorModel colorModel = ((BufferedImage)object).getColorModel();
            int n3 = ((BufferedImage)object).getType();
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
            this.iScaledImage = bufferedImage;
        } else {
            this.iScaledImage = V2CMain.v2cMain.createImage(n, n2);
        }
        object = this.iScaledImage.getGraphics();
        ((Graphics)object).drawImage(image, 0, 0, n, n2, null);
        ((Graphics)object).dispose();
    }

    void computeUnion(Rectangle rectangle) {
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            rectangle.setBounds(this.nX, this.nY, this.nWidth, this.nHeight);
        } else {
            SwingUtilities.computeUnion(this.nX, this.nY, this.nWidth, this.nHeight, rectangle);
        }
    }

    int getWidth() {
        return this.nWidth;
    }

    int getHeight() {
        return this.nHeight;
    }

    boolean needsBuffer(int n, int n2) {
        return this.iDisposalMethod == 1 || this.isBGVisible(n, n2);
    }

    Image getImage() {
        return this.iImage;
    }

    void setImage(Image image) {
        this.iImage = image;
    }

    int getDelayTime() {
        return this.nDelayTime;
    }

    int getDisposalMethod() {
        return this.iDisposalMethod;
    }

    void setDisposalMethod(int n) {
        this.iDisposalMethod = n;
    }

    boolean shouldClear() {
        return this.iDisposalMethod == 2;
    }

    boolean isBGVisible(int n, int n2) {
        return this.bTransparent || this.nX > 0 || this.nY > 0 || this.nWidth < n || this.nHeight < n2;
    }

    boolean restoreToPrev() {
        return this.iDisposalMethod == 3;
    }

    void clearRect(Graphics2D graphics2D, int n, int n2, double d, Color color) {
        int n3;
        int n4;
        graphics2D.setColor(color);
        if (d > 0.0 && d != 1.0) {
            n += (int)(d * (double)this.nX);
            n2 += (int)(d * (double)this.nY);
            n4 = (int)(d * (double)this.nWidth);
            n3 = (int)(d * (double)this.nHeight);
        } else {
            n += this.nX;
            n2 += this.nY;
            n4 = this.nWidth;
            n3 = this.nHeight;
        }
        graphics2D.fillRect(n, n2, n4, n3);
    }

    void setScaledImageCreated(String string) {
        this.bThumbnailImageCreated = string != null && string.equalsIgnoreCase("PNG");
    }

    void draw(Graphics2D graphics2D, int n, int n2, double d) {
        if (this.bThumbnailImageCreated) {
            this.bThumbnailImageCreated = false;
            if (this.nWidth * this.nHeight > 500000) {
                BufferedImage bufferedImage = new BufferedImage(this.nWidth, this.nHeight, 2);
                Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                graphics2D2.drawImage(this.iImage, 0, 0, this.nWidth, this.nHeight, null);
                graphics2D2.dispose();
                this.iImage = bufferedImage;
            }
        }
        if (d > 0.0 && d != 1.0) {
            n += (int)(d * (double)this.nX);
            n2 += (int)(d * (double)this.nY);
            int n3 = (int)(d * (double)this.nWidth);
            int n4 = (int)(d * (double)this.nHeight);
            if (this.nBlockSize >= 4) {
                this.createScaledImage();
                graphics2D.drawImage(this.iScaledImage, n, n2, n3, n4, null);
            } else {
                graphics2D.drawImage(this.iImage, n, n2, n3, n4, null);
            }
        } else {
            n += this.nX;
            n2 += this.nY;
            if (this.nBlockSize >= 4) {
                this.createScaledImage();
                graphics2D.drawImage(this.iScaledImage, n, n2, this.nWidth, this.nHeight, null);
            } else {
                graphics2D.drawImage(this.iImage, n, n2, null);
            }
        }
    }

    void extractInfo(ImageReader imageReader, int n) {
        IIOMetadata iIOMetadata = null;
        try {
            iIOMetadata = imageReader.getImageMetadata(n);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        if (iIOMetadata == null) {
            return;
        }
        String string = iIOMetadata.getNativeMetadataFormatName();
        if (string == null || string.length() == 0) {
            return;
        }
        Node node = iIOMetadata.getAsTree(string);
        if (string.indexOf("_gif_") > 0) {
            this.extractGIFInfo(node);
        }
    }

    void extractGIFInfo(Node node) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2;
            Node node2;
            Node node3 = nodeList.item(i);
            String string3 = node3.getNodeName();
            if (string3 == null) continue;
            NamedNodeMap namedNodeMap = node3.getAttributes();
            if (string3.equals("ImageDescriptor")) {
                String string4;
                node2 = namedNodeMap.getNamedItem("imageLeftPosition");
                if (node2 != null) {
                    try {
                        this.nX = Integer.parseInt(node2.getNodeValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((node2 = namedNodeMap.getNamedItem("imageTopPosition")) != null) {
                    try {
                        this.nY = Integer.parseInt(node2.getNodeValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((node2 = namedNodeMap.getNamedItem("interlaceFlag")) == null || (string4 = node2.getNodeValue()) == null || !string4.equalsIgnoreCase("TRUE")) continue;
                this.bInterlace = true;
                continue;
            }
            if (!string3.equals("GraphicControlExtension")) continue;
            node2 = namedNodeMap.getNamedItem("disposalMethod");
            if (node2 != null && (string2 = node2.getNodeValue()) != null) {
                if (string2.equals("none")) {
                    this.iDisposalMethod = 0;
                } else if (string2.equals("doNotDispose")) {
                    this.iDisposalMethod = 1;
                } else if (string2.equals("restoreToBackgroundColor")) {
                    this.iDisposalMethod = 2;
                } else if (string2.equals("restoreToPrevious")) {
                    this.iDisposalMethod = 3;
                }
            }
            if ((node2 = namedNodeMap.getNamedItem("transparentColorFlag")) != null && (string = node2.getNodeValue()) != null && string.equalsIgnoreCase("TRUE")) {
                this.bTransparent = true;
            }
            if ((node2 = namedNodeMap.getNamedItem("delayTime")) == null) continue;
            int n2 = 0;
            try {
                n2 = Integer.parseInt(node2.getNodeValue()) * 10;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.nDelayTime = n2 == 0 ? 100 : Math.max(n2, 30);
        }
    }
}

