/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.AWTPermission;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilePermission;
import java.lang.reflect.Method;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyPermission;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CEvalScript;
import org.monazilla.v2c.V2CExtCommand;
import org.monazilla.v2c.V2CGetDatScript;
import org.monazilla.v2c.V2CImageCacheScript;
import org.monazilla.v2c.V2CJSE6Util;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMenuScript;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPostScript;
import org.monazilla.v2c.V2CProxyScript;
import org.monazilla.v2c.V2CResCheckScript;
import org.monazilla.v2c.V2CRuntimePermission;
import org.monazilla.v2c.V2CScriptApp;
import org.monazilla.v2c.V2CScriptClassLoader;
import org.monazilla.v2c.V2CScriptConsole;
import org.monazilla.v2c.V2CScriptSP;
import org.monazilla.v2c.V2CScriptTLBSContext;
import org.monazilla.v2c.V2CScriptThread;
import org.monazilla.v2c.V2CSubjectScript;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CSystemScript;
import org.monazilla.v2c.V2CThreadUpdateScript;

public class V2CScriptUtil {
    private static final String sJavaScript = "JavaScript";
    private static AccessControlContext vDefaultAccessControlContext;
    private static AccessControlContext vAllAccessControlContext;
    private static boolean bSecurityManagerInstalled;
    private static boolean bSecurityManagerInstallFailed;
    private static boolean bSOMJ;
    private static boolean bSOMJChecked;

    static void printMessage(String string) {
        V2CScriptConsole.appendText(string + '\n');
        V2CMain.setMessage(V2CMiscUtil.replaceChar(string, '\n', ' '));
    }

    private static void checkSOMJ(Permissions permissions) {
        if (!bSOMJChecked) {
            try {
                Class.forName("sun.org.mozilla.javascript.DefiningClassLoader");
                bSOMJ = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            bSOMJChecked = true;
        }
        if (bSOMJ) {
            permissions.add(new RuntimePermission("createClassLoader"));
            permissions.add(new RuntimePermission("accessClassInPackage.sun.org.mozilla.*"));
        }
    }

    private static synchronized boolean checkSecurityManager() {
        if (bSecurityManagerInstallFailed) {
            return false;
        }
        if (bSecurityManagerInstalled) {
            return true;
        }
        boolean bl = false;
        bSecurityManagerInstallFailed = true;
        try {
            Policy.setPolicy(new AllPermissionPolicy());
            Method method = System.class.getMethod("setSecurityManager", SecurityManager.class);
            method.invoke(null, new SecurityManager());
            bl = true;
            bSecurityManagerInstallFailed = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bSecurityManagerInstalled = bl;
        if (!bl) {
            V2CSwingUtil.showErrorMessage("SecurityManager\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u5b9f\u884c\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        return bl;
    }

    private static void addAccessEventQueuePermission(Permissions permissions) {
        if (V2CApp.javaVersionEqualOrGreaterThan(1, 7)) {
            permissions.add(new AWTPermission("accessEventQueue"));
        }
        if (V2CApp.javaVersionEqualOrGreaterThan(1, 8)) {
            permissions.add(new RuntimePermission("accessClassInPackage.jdk.nashorn.internal.objects"));
        }
    }

    private static void addDefaultPropertyPermissions(Permissions permissions) {
        String[] stringArray = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.class.version", "os.name", "os.version", "os.arch", "file.encoding", "file.separator", "path.separator", "line.separator", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name"};
        for (int i = 0; i < stringArray.length; ++i) {
            permissions.add(new PropertyPermission(stringArray[i], "read"));
        }
    }

    private static void addPermission(Permissions permissions, Permission permission, SecurityManager securityManager) {
        if (securityManager != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                return;
            }
        }
        permissions.add(permission);
    }

    static AccessControlContext createAccessControlContext(String string) {
        return V2CScriptUtil.createAccessControlContext(string, null);
    }

    static AccessControlContext createAccessControlContext(String string, SecurityManager securityManager) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            AccessControlContext accessControlContext = vDefaultAccessControlContext;
            if (accessControlContext != null) {
                return accessControlContext;
            }
            Permissions permissions = new Permissions();
            V2CScriptUtil.checkSOMJ(permissions);
            V2CScriptUtil.addAccessEventQueuePermission(permissions);
            V2CScriptUtil.addDefaultPropertyPermissions(permissions);
            vDefaultAccessControlContext = accessControlContext = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
            return accessControlContext;
        }
        if (n == 1 && string.charAt(0) == 'A') {
            AccessControlContext accessControlContext = vAllAccessControlContext;
            if (accessControlContext != null && securityManager == null) {
                return accessControlContext;
            }
            Permissions permissions = new Permissions();
            V2CScriptUtil.checkSOMJ(permissions);
            V2CScriptUtil.addAccessEventQueuePermission(permissions);
            V2CScriptUtil.addPermission(permissions, new PropertyPermission("*", "read"), securityManager);
            V2CScriptUtil.addPermission(permissions, new FilePermission("<<ALL FILES>>", "read,write,execute,delete"), securityManager);
            V2CScriptUtil.addPermission(permissions, new V2CRuntimePermission("changeFavorite"), securityManager);
            V2CScriptUtil.addPermission(permissions, new V2CRuntimePermission("changeProperty"), securityManager);
            V2CScriptUtil.addPermission(permissions, new RuntimePermission("exitVM"), securityManager);
            V2CScriptUtil.addPermission(permissions, new SocketPermission("*", "connect"), securityManager);
            V2CScriptUtil.addPermission(permissions, new AWTPermission("accessClipboard"), securityManager);
            V2CScriptUtil.addPermission(permissions, new AWTPermission("showWindowWithoutWarningBanner"), securityManager);
            V2CScriptUtil.addPermission(permissions, new AWTPermission("setWindowAlwaysOnTop"), securityManager);
            accessControlContext = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
            if (securityManager == null) {
                vAllAccessControlContext = accessControlContext;
            }
            return accessControlContext;
        }
        Permissions permissions = new Permissions();
        V2CScriptUtil.checkSOMJ(permissions);
        V2CScriptUtil.addAccessEventQueuePermission(permissions);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == 'A') {
                return null;
            }
            if (c > 'A' && c <= 'Z') {
                int n2;
                if (c == 'F') {
                    char c2;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (n2 = i + 1; n2 < n && ((c2 = string.charAt(n2)) < 'A' || c2 > 'Z'); ++n2) {
                        if (c2 == 'r') {
                            stringBuffer.append("read,");
                            continue;
                        }
                        if (c2 == 'w') {
                            stringBuffer.append("write,");
                            continue;
                        }
                        if (c2 == 'x') {
                            stringBuffer.append("execute,");
                            continue;
                        }
                        if (c2 == 'd') {
                            stringBuffer.append("delete,");
                            continue;
                        }
                        return null;
                    }
                    i = n2 - 1;
                    n2 = stringBuffer.length();
                    String string2 = n2 > 0 ? stringBuffer.substring(0, n2 - 1) : "read,write,execute,delete";
                    V2CScriptUtil.addPermission(permissions, new FilePermission("<<ALL FILES>>", string2), securityManager);
                    continue;
                }
                if (c == 'P') {
                    V2CScriptUtil.addPermission(permissions, new PropertyPermission("*", "read"), securityManager);
                    bl = true;
                    continue;
                }
                if (c == 'R') {
                    int n3;
                    for (n3 = i + 1; n3 < n && ((n2 = (int)string.charAt(n3)) < 65 || n2 > 90); ++n3) {
                        if (n2 != 120) {
                            return null;
                        }
                        V2CScriptUtil.addPermission(permissions, new RuntimePermission("exitVM"), securityManager);
                    }
                    if (i == n3 - 1) {
                        V2CScriptUtil.addPermission(permissions, new RuntimePermission("exitVM"), securityManager);
                        continue;
                    }
                    i = n3 - 1;
                    continue;
                }
                if (c == 'S') {
                    V2CScriptUtil.addPermission(permissions, new SocketPermission("*", "connect"), securityManager);
                    continue;
                }
                if (c == 'T') {
                    int n4;
                    for (n4 = i + 1; n4 < n && ((n2 = (int)string.charAt(n4)) < 65 || n2 > 90); ++n4) {
                        if (n2 == 99) {
                            V2CScriptUtil.addPermission(permissions, new AWTPermission("accessClipboard"), securityManager);
                            continue;
                        }
                        if (n2 == 116) {
                            V2CScriptUtil.addPermission(permissions, new AWTPermission("setWindowAlwaysOnTop"), securityManager);
                            continue;
                        }
                        if (n2 == 119) {
                            V2CScriptUtil.addPermission(permissions, new AWTPermission("showWindowWithoutWarningBanner"), securityManager);
                            continue;
                        }
                        return null;
                    }
                    if (i == n4 - 1) {
                        V2CScriptUtil.addPermission(permissions, new AWTPermission("accessClipboard"), securityManager);
                        V2CScriptUtil.addPermission(permissions, new AWTPermission("showWindowWithoutWarningBanner"), securityManager);
                        V2CScriptUtil.addPermission(permissions, new AWTPermission("setWindowAlwaysOnTop"), securityManager);
                        continue;
                    }
                    i = n4 - 1;
                    continue;
                }
                if (c == 'V') {
                    int n5;
                    for (n5 = i + 1; n5 < n && ((n2 = (int)string.charAt(n5)) < 65 || n2 > 90); ++n5) {
                        if (n2 == 102) {
                            V2CScriptUtil.addPermission(permissions, new V2CRuntimePermission("changeFavorite"), securityManager);
                            continue;
                        }
                        if (n2 == 112) {
                            V2CScriptUtil.addPermission(permissions, new V2CRuntimePermission("changeProperty"), securityManager);
                            continue;
                        }
                        return null;
                    }
                    if (i == n5 - 1) {
                        V2CScriptUtil.addPermission(permissions, new V2CRuntimePermission("changeFavorite"), securityManager);
                        V2CScriptUtil.addPermission(permissions, new V2CRuntimePermission("changeProperty"), securityManager);
                        continue;
                    }
                    i = n5 - 1;
                    continue;
                }
                return null;
            }
            return null;
        }
        if (!bl) {
            V2CScriptUtil.addDefaultPropertyPermissions(permissions);
        }
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    private static V2CEvalScript createEvalScript(V2CExtCommand v2CExtCommand, String string, ActionEvent actionEvent, boolean bl, boolean bl2, boolean bl3) {
        V2CScriptClassLoader v2CScriptClassLoader;
        String string2;
        File file;
        if (!V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
            V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u5b9f\u884c\u306b\u306fJRE6\u4ee5\u4e0a\u304c\u5fc5\u8981\u3067\u3059\u3002");
            return null;
        }
        if (!V2CScriptUtil.checkSecurityManager()) {
            return null;
        }
        String string3 = v2CExtCommand.getCommand();
        Matcher matcher = Pattern.compile("\\$(?:SCRIPT|\\{SCRIPT(?:\\[([-/\\w]+)\\])?(?::(\\p{Alpha}*))?\\})\\s+").matcher(string3);
        if (!matcher.lookingAt()) {
            V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u6307\u5b9a\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
            return null;
        }
        String string4 = null;
        if (matcher.groupCount() >= 1) {
            string4 = matcher.group(1);
        }
        if (string4 == null) {
            string4 = sJavaScript;
        }
        string3 = string3.substring(matcher.end());
        String string5 = string4;
        Matcher matcher2 = Pattern.compile("(<?[-\\w.\\\\/]+>?)\\s*").matcher(string3);
        if (!matcher2.lookingAt()) {
            V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            return null;
        }
        String string6 = matcher2.group(1);
        int n = string6.length();
        if (n > 2 && string6.charAt(0) == '<' && string6.charAt(n - 1) == '>') {
            file = null;
            string2 = V2CLocalFileHandler.restoreTextResource("org/monazilla/v2c/script/" + string6.substring(1, n - 1));
        } else {
            file = V2CLocalFileHandler.getScriptFile(string6);
            if (file == null) {
                V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                return null;
            }
            if (!file.isFile()) {
                V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                return null;
            }
            string2 = V2CLocalFileHandler.restoreFromFile(file, "UTF-8");
        }
        if (string2 == null || string2.length() <= 1) {
            V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u5185\u5bb9\u304c\u7a7a\u3067\u3059\u3002");
            return null;
        }
        if (string2.charAt(0) == '\ufeff') {
            if (string2.length() == 1) {
                V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u5185\u5bb9\u304c\u7a7a\u3067\u3059\u3002");
                return null;
            }
            string2 = string2.substring(1);
        }
        if (string != null) {
            string2 = string2 + string;
        }
        if ((v2CScriptClassLoader = V2CScriptClassLoader.getInstance()) == null) {
            V2CSwingUtil.showErrorMessage("\u30af\u30e9\u30b9\u30ed\u30fc\u30c0\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            return null;
        }
        AccessControlContext accessControlContext = V2CScriptUtil.createAccessControlContext(matcher.group(2));
        if (accessControlContext == null) {
            V2CSwingUtil.showErrorMessage("\u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u306e\u6307\u5b9a\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002\n\n" + matcher.group(2));
            return null;
        }
        V2CScriptApp v2CScriptApp = new V2CScriptApp(file, string3.substring(matcher2.end()), v2CExtCommand, actionEvent, bl, bl2, bl3);
        return new V2CEvalScript(string5, string2, v2CScriptApp, v2CScriptClassLoader, accessControlContext);
    }

    static void execScript(V2CExtCommand v2CExtCommand, ActionEvent actionEvent, boolean bl, boolean bl2, boolean bl3) {
        V2CEvalScript v2CEvalScript = V2CScriptUtil.createEvalScript(v2CExtCommand, null, actionEvent, bl, bl2, bl3);
        if (v2CEvalScript == null) {
            return;
        }
        Thread thread = new Thread(v2CEvalScript);
        thread.start();
    }

    static Object evalScriptFunction(V2CExtCommand v2CExtCommand, ActionEvent actionEvent, String string, Object[] objectArray) {
        V2CEvalScript v2CEvalScript = V2CScriptUtil.createEvalScript(v2CExtCommand, null, actionEvent, false, false, false);
        if (v2CEvalScript == null) {
            return null;
        }
        v2CEvalScript.setInvokeFunction(string, objectArray);
        v2CEvalScript.run();
        return v2CEvalScript.getResult();
    }

    static void redirectURL(V2CEvalScript v2CEvalScript, URL uRL) {
        v2CEvalScript.redirectURL(uRL);
        Thread thread = new Thread(v2CEvalScript);
        thread.start();
    }

    static void formSubmitted(V2CEvalScript v2CEvalScript, URL uRL, String string, String string2) {
        v2CEvalScript.formSubmitted(uRL, string, string2);
        Thread thread = new Thread(v2CEvalScript);
        thread.start();
    }

    static boolean startResCheckScript() {
        AccessControlContext accessControlContext;
        V2CScriptClassLoader v2CScriptClassLoader;
        String string;
        File file;
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("V2CScriptUtil.startResCheckScript");
        }
        if (!V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
            return false;
        }
        if (!V2CScriptUtil.checkSecurityManager()) {
            return false;
        }
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("SecurityManager OK");
        }
        if (!(file = V2CLocalFileHandler.getSystemScriptFile("rescheck.js")).isFile()) {
            return false;
        }
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("ResCheckScriptFile OK");
        }
        if ((string = V2CLocalFileHandler.restoreFromFile(file, "UTF-8")) == null || string.length() <= 1) {
            return false;
        }
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("Read OK");
        }
        if (string.charAt(0) == '\ufeff') {
            if (string.length() == 1) {
                return false;
            }
            string = string.substring(1);
        }
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("Read2 OK");
        }
        if ((v2CScriptClassLoader = V2CScriptClassLoader.getInstance()) == null) {
            return false;
        }
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("ClassLoader OK");
        }
        if ((accessControlContext = V2CScriptUtil.createAccessControlContext(V2CSystemScript.getPermissionString("rescheck.js"))) == null) {
            return false;
        }
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("AccessControlContext OK");
        }
        return V2CResCheckScript.startScript(string, v2CScriptClassLoader, accessControlContext);
    }

    static V2CSystemScript createSystemScript(String string) {
        V2CScriptClassLoader v2CScriptClassLoader;
        if (!V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
            return null;
        }
        if (!V2CScriptUtil.checkSecurityManager()) {
            return null;
        }
        File file = V2CLocalFileHandler.getSystemScriptFile(string);
        if (!file.isFile()) {
            return null;
        }
        String string2 = V2CLocalFileHandler.restoreFromFile(file, "UTF-8");
        if (string2 == null || string2.length() <= 1) {
            return null;
        }
        if (string2.charAt(0) == '\ufeff') {
            if (string2.length() == 1) {
                return null;
            }
            string2 = string2.substring(1);
        }
        if ((v2CScriptClassLoader = V2CScriptClassLoader.getInstance()) == null) {
            return null;
        }
        AccessControlContext accessControlContext = V2CScriptUtil.createAccessControlContext(V2CSystemScript.getPermissionString(string));
        if (accessControlContext == null) {
            return null;
        }
        if (string.equals("subject.js")) {
            return V2CSubjectScript.createSubjectScript(string2, v2CScriptClassLoader, accessControlContext);
        }
        if (string.equals("imgcache.js")) {
            return V2CImageCacheScript.createImageCacheScript(string2, v2CScriptClassLoader, accessControlContext);
        }
        if (string.equals("menu.js")) {
            return V2CMenuScript.createMenuScript(string2, v2CScriptClassLoader, accessControlContext);
        }
        if (string.equals("getdat.js")) {
            return V2CGetDatScript.createGetDatScript(string2, v2CScriptClassLoader, accessControlContext);
        }
        if (string.equals("threadld.js")) {
            return V2CThreadUpdateScript.createThreadUpdateScript(string2, v2CScriptClassLoader, accessControlContext);
        }
        if (string.equals("post.js")) {
            return V2CPostScript.createPostScript(string2, v2CScriptClassLoader, accessControlContext);
        }
        if (string.equals("proxy.js")) {
            return V2CProxyScript.createProxyScript(string2, v2CScriptClassLoader, accessControlContext);
        }
        return null;
    }

    static V2CScriptSP createScriptSP() {
        return new V2CScriptSP(new String[]{"subject.js", "rescheck.js", "imgcache.js", "menu.js", "getdat.js", "threadld.js", "post.js", "proxy.js"});
    }

    static boolean getThreadsForTLBS(V2CExtCommand v2CExtCommand, ArrayList arrayList, V2CScriptTLBSContext v2CScriptTLBSContext) {
        String string = V2CLocalFileHandler.restoreTextResource("org/monazilla/v2c/script/tlbsft.js");
        if (string == null) {
            return false;
        }
        V2CEvalScript v2CEvalScript = V2CScriptUtil.createEvalScript(v2CExtCommand, string, null, false, false, false);
        if (v2CEvalScript == null) {
            return false;
        }
        v2CEvalScript.run();
        PrivilegedExceptionAction privilegedExceptionAction = v2CEvalScript.vPrivilegedExceptionAction;
        if (privilegedExceptionAction == null) {
            return false;
        }
        V2CJSE6Util.setInvokeFunction(privilegedExceptionAction, "_v2c_getThreads", new Object[]{v2CScriptTLBSContext});
        Object object = V2CScriptUtil.execPEA(privilegedExceptionAction, v2CEvalScript.vScriptApp, v2CEvalScript.vScriptClassLoader, v2CEvalScript.vAccessControlContext);
        if (v2CScriptTLBSContext.getSkip()) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (!(e instanceof V2CScriptThread)) {
                return false;
            }
            arrayList.add(((V2CScriptThread)e).getThreadItem());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object execPEA(PrivilegedExceptionAction privilegedExceptionAction, V2CScriptApp v2CScriptApp, V2CScriptClassLoader v2CScriptClassLoader, AccessControlContext accessControlContext) {
        Object var7_7;
        String string;
        block5: {
            string = null;
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(v2CScriptClassLoader);
            var7_7 = null;
            try {
                try {
                    var7_7 = AccessController.doPrivileged(privilegedExceptionAction, accessControlContext);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    string = "\u30b9\u30af\u30ea\u30d7\u30c8\u5b9f\u884c\u30a8\u30e9\u30fc\uff1a " + privilegedActionException.getException().getMessage();
                    Object var10_9 = null;
                    thread.setContextClassLoader(classLoader);
                    V2CMain.endTempMessage(v2CScriptApp);
                    break block5;
                }
                Object var10_8 = null;
                thread.setContextClassLoader(classLoader);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                thread.setContextClassLoader(classLoader);
                V2CMain.endTempMessage(v2CScriptApp);
                throw throwable;
            }
            V2CMain.endTempMessage(v2CScriptApp);
        }
        if (string != null) {
            V2CScriptUtil.setErrorMessage(string);
        }
        return var7_7;
    }

    static void setErrorMessage(String string) {
        if (string == null) {
            return;
        }
        V2CScriptConsole.appendText(string + '\n');
        V2CMain.setErrorMessage(string);
        System.out.println(string);
    }

    private static class AllPermissionPolicy
    extends Policy {
        final Permissions vPermissions;

        AllPermissionPolicy() {
            Permissions permissions = new Permissions();
            permissions.add(new AllPermission());
            this.vPermissions = permissions;
        }

        public PermissionCollection getPermissions(CodeSource codeSource) {
            return this.vPermissions;
        }

        public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
            return this.vPermissions;
        }

        public void refresh() {
        }
    }
}

