/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CNewThreadItem;
import org.monazilla.v2c.V2CParseLinkResult;
import org.monazilla.v2c.V2CResCheckScript;
import org.monazilla.v2c.V2CResLabel;
import org.monazilla.v2c.V2CRuntimePermission;
import org.monazilla.v2c.V2CScriptApp;
import org.monazilla.v2c.V2CScriptBBS;
import org.monazilla.v2c.V2CScriptBoard;
import org.monazilla.v2c.V2CScriptRes;
import org.monazilla.v2c.V2CScriptResCheckContext;
import org.monazilla.v2c.V2CScriptResLabel;
import org.monazilla.v2c.V2CScriptWritePanel;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadList;
import org.monazilla.v2c.V2CThreadOpenRequest;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CThreadRes;
import org.monazilla.v2c.V2CThreadStyle;
import org.monazilla.v2c.V2CThreadViewPane;

public final class V2CScriptThread {
    private V2CResCheckScript vResCheckScript;
    private final V2CThreadItem vThreadItem;
    private V2CThreadRes vThreadRes;
    private final boolean bNewThread;
    private int nCheckType;
    private V2CScriptResCheckContext vScriptResCheckContext;
    private volatile boolean bSleeping;
    private static final int ACTION_CLOSE = 1;
    private static final int ACTION_LOCK = 2;
    private static final int ACTION_UNLOCK = 3;
    private static final int ACTION_SETNEWMARK = 4;
    private static final int ACTION_RESETNEWMARK = 5;
    private static final int ACTION_SAVEVIEWPOS = 6;
    private static final int ACTION_GETVIEWPOS = 7;
    private static final int ACTION_SETVIEWPOS = 8;
    private static final int ACTION_COLUMNINDEX = 9;
    private static final int ACTION_MOVE = 10;
    private static final int ACTION_GETAUTORESLABEL = 11;
    private static final int ACTION_RESTORELABELS = 12;

    static V2CScriptThread createCheckScriptThread(V2CThreadItem v2CThreadItem, V2CThreadRes v2CThreadRes) {
        V2CResCheckScript v2CResCheckScript = V2CResCheckScript.getInstance();
        if (v2CResCheckScript == null || !v2CResCheckScript.checkFunctionDefined()) {
            return null;
        }
        V2CScriptThread v2CScriptThread = V2CScriptThread.createScriptThread(v2CThreadItem, v2CThreadRes);
        try {
            v2CResCheckScript.beginCheckThread(v2CScriptThread);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        V2CScriptResCheckContext v2CScriptResCheckContext = v2CScriptThread.vScriptResCheckContext;
        if (!v2CScriptResCheckContext.shouldCheckAny()) {
            try {
                v2CResCheckScript.endCheckThread(v2CScriptThread);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return null;
        }
        v2CScriptThread.vResCheckScript = v2CResCheckScript;
        return v2CScriptThread;
    }

    static V2CScriptThread createScriptThread(V2CAbstractThreadPanel v2CAbstractThreadPanel) {
        return v2CAbstractThreadPanel != null ? new V2CScriptThread(v2CAbstractThreadPanel.getThreadItem(), v2CAbstractThreadPanel.getThreadRes()) : null;
    }

    static V2CScriptThread createInstance(V2CThreadItem v2CThreadItem) {
        return v2CThreadItem != null ? new V2CScriptThread(v2CThreadItem, null) : null;
    }

    static V2CScriptThread createScriptThread(V2CThreadItem v2CThreadItem, V2CThreadRes v2CThreadRes) {
        return v2CThreadItem != null && v2CThreadRes != null ? new V2CScriptThread(v2CThreadItem, v2CThreadRes) : null;
    }

    static V2CScriptThread createScriptThread(final String string, final String string2, final int n) {
        return (V2CScriptThread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                V2CThreadPanel v2CThreadPanel;
                V2CThreadItem v2CThreadItem;
                V2CParseLinkResult v2CParseLinkResult = new V2CParseLinkResult(string);
                if (!v2CParseLinkResult.parse(false) || (v2CThreadItem = v2CParseLinkResult.getThreadItem()) == null) {
                    return null;
                }
                if (string2 != null && string2.length() > 0 && v2CThreadItem.getTitle() == null) {
                    v2CThreadItem.setTitle(string2);
                }
                if (n > 0 && n > v2CThreadItem.getNRes()) {
                    v2CThreadItem.setNRes(n);
                }
                V2CThreadRes v2CThreadRes = (v2CThreadPanel = V2CThreadPanel.loadThreadIfNotLoaded(v2CThreadItem)) != null ? v2CThreadPanel.getThreadRes() : null;
                return new V2CScriptThread(v2CThreadItem, v2CThreadRes);
            }
        });
    }

    static V2CScriptThread createScriptThread(final V2CBoardItem v2CBoardItem, final String string, final String string2, final String string3, final int n) {
        if (v2CBoardItem == null || string == null) {
            return null;
        }
        return (V2CScriptThread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                V2CThreadPanel v2CThreadPanel;
                Object object = v2CBoardItem.checkSubjectTxtLoaded();
                V2CThreadItem v2CThreadItem = v2CBoardItem.getThreadItemK(string);
                if (v2CThreadItem == null && string2 != null) {
                    v2CThreadItem = V2CThreadItem.createThreadItemOfName(string, v2CBoardItem, string2);
                }
                v2CBoardItem.releaseSubjectHoldKey(object);
                if (v2CThreadItem == null) {
                    return null;
                }
                if (string3 != null && string3.length() > 0 && v2CThreadItem.getTitle() == null) {
                    v2CThreadItem.setTitle(string3);
                }
                if (n > 0 && n > v2CThreadItem.getNRes()) {
                    v2CThreadItem.setNRes(n);
                }
                V2CThreadRes v2CThreadRes = (v2CThreadPanel = V2CThreadPanel.loadThreadIfNotLoaded(v2CThreadItem)) != null ? v2CThreadPanel.getThreadRes() : null;
                return new V2CScriptThread(v2CThreadItem, v2CThreadRes);
            }
        });
    }

    V2CScriptThread(V2CThreadItem v2CThreadItem, V2CThreadRes v2CThreadRes) {
        this.vThreadItem = v2CThreadItem;
        this.vThreadRes = v2CThreadRes;
        this.bNewThread = v2CThreadItem instanceof V2CNewThreadItem;
    }

    V2CResCheckScript getResCheckScript() {
        return this.vResCheckScript;
    }

    void beginCheck(boolean bl, boolean bl2, boolean bl3) {
        this.nCheckType = 1;
        this.vScriptResCheckContext = new V2CScriptResCheckContext(bl, bl2, bl3);
    }

    void endCheck() {
        this.nCheckType = 6;
    }

    public int _getCheckType() {
        return this.nCheckType;
    }

    public V2CScriptResCheckContext _getResCheckContext() {
        return this.vScriptResCheckContext;
    }

    void releaseRCCAndSS() {
        this.vScriptResCheckContext = null;
        this.vResCheckScript = null;
    }

    boolean isChecking() {
        return this.vResCheckScript != null;
    }

    V2CThreadItem getThreadItem() {
        return this.vThreadItem;
    }

    V2CThreadRes getThreadRes() {
        return this.vThreadRes;
    }

    public V2CScriptBBS getBbs() {
        return new V2CScriptBBS(this.vThreadItem.getBBS());
    }

    boolean isNewThread() {
        return this.bNewThread;
    }

    public boolean isLocal() {
        return this.vThreadItem.isLocalThread();
    }

    public String getTitle() {
        return this.vThreadItem.getTitle();
    }

    private V2CThreadRes getAttachedThreadRes() {
        V2CThreadRes v2CThreadRes = this.vThreadRes;
        if (v2CThreadRes != null) {
            return v2CThreadRes;
        }
        V2CThreadPanel v2CThreadPanel = this.getAttachedPanel();
        return v2CThreadPanel != null ? v2CThreadPanel.getThreadRes() : null;
    }

    private V2CThreadRes loadThreadRes() {
        V2CThreadRes v2CThreadRes = this.vThreadRes;
        if (v2CThreadRes == null && !this.bNewThread) {
            this.vThreadRes = v2CThreadRes = (V2CThreadRes)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    V2CThreadPanel v2CThreadPanel = V2CThreadPanel.loadThreadIfNotLoaded(V2CScriptThread.this.vThreadItem);
                    return v2CThreadPanel != null ? v2CThreadPanel.getThreadRes() : null;
                }
            });
        }
        return v2CThreadRes;
    }

    public V2CScriptRes getRes(int n) {
        V2CThreadRes v2CThreadRes = this.loadThreadRes();
        return v2CThreadRes != null ? V2CScriptRes.createScriptRes(v2CThreadRes.getResItem(n), this) : null;
    }

    public V2CScriptBoard getBoard() {
        return new V2CScriptBoard(this.vThreadItem.getBoardItem());
    }

    public URL getUrl() {
        return this.getURL();
    }

    public URL getURL() {
        try {
            return new URL(this.vThreadItem.getFormalURLString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getKey() {
        return this.bNewThread ? null : this.vThreadItem.getThreadKey();
    }

    public File getLocalFile() {
        return this.bNewThread ? null : this.vThreadItem.getLocalFile();
    }

    public File getStyleDir() {
        return V2CThreadStyle.getStyleFolder(this.vThreadItem);
    }

    public File getStyleFile() {
        return V2CThreadStyle.getStyleFile(this.vThreadItem);
    }

    public int getResCount() {
        return this.bNewThread ? 1 : this.vThreadItem.getNRes();
    }

    public int getLocalResCount() {
        return this.bNewThread ? 0 : this.vThreadItem.getNResGet();
    }

    public int getNewResCount() {
        if (this.bNewThread) {
            return 0;
        }
        V2CThreadRes v2CThreadRes = this.loadThreadRes();
        return v2CThreadRes != null ? v2CThreadRes.getNumNewRes() : 0;
    }

    public int getNewMarkResCount() {
        int n = this.getLocalResCount();
        if (n <= 0) {
            return 0;
        }
        return Math.max(n - this.getNewMarkResIndex(), 0);
    }

    public int getNewMarkResIndex() {
        if (this.bNewThread) {
            return 0;
        }
        V2CThreadRes v2CThreadRes = this.getAttachedThreadRes();
        if (v2CThreadRes != null) {
            return v2CThreadRes.getNewMarkPos();
        }
        int n = this.vThreadItem.getNewThreshold();
        return n >= 0 ? n : this.getLocalResCount();
    }

    public void setNewMarkResIndex(int n) {
        if (this.bNewThread) {
            return;
        }
        if (this.doPanelAction(4, n, 0) == null) {
            V2CThreadItem v2CThreadItem = this.vThreadItem;
            v2CThreadItem.setNewThreshold(n);
            v2CThreadItem.updateLocalThreadStatusLater();
            v2CThreadItem.threadStatusChanged();
        }
    }

    public int getViewResIndex() {
        if (this.bNewThread) {
            return 0;
        }
        this.doPanelAction(6);
        int[] nArray = (int[])AccessController.doPrivileged(new PEDTAction(7, null, 0, 0));
        if (nArray == null) {
            return 0;
        }
        int n = nArray[0];
        if (n > 0 && nArray[1] > 0) {
            --n;
        }
        return n;
    }

    public void setViewResIndex(int n) {
        if (this.bNewThread) {
            return;
        }
        V2CThreadPanel v2CThreadPanel = this.getAttachedPanel();
        if (v2CThreadPanel != null) {
            v2CThreadPanel.goToResNumberLater(n, 0);
        } else {
            AccessController.doPrivileged(new PEDTAction(8, null, n, 0));
        }
    }

    public V2CScriptResLabel getPostResLabel() {
        V2CResLabel v2CResLabel = (V2CResLabel)AccessController.doPrivileged(new PEDTAction(11, null, 0, 0));
        return v2CResLabel != null ? V2CScriptResLabel.get(v2CResLabel) : null;
    }

    public int[] getPostResIndex() {
        int n;
        V2CResLabel[] v2CResLabelArray;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        V2CResLabel v2CResLabel = (V2CResLabel)AccessController.doPrivileged(new PEDTAction(11, null, 0, 0));
        if (v2CResLabel != null && (v2CResLabelArray = (V2CResLabel[])AccessController.doPrivileged(new PEDTAction(12, null, 0, 0))) != null) {
            int n2 = v2CResLabelArray.length;
            for (n = 0; n < n2; ++n) {
                if (v2CResLabelArray[n] != v2CResLabel) continue;
                arrayList.add(new Integer(n));
            }
        }
        int n3 = arrayList.size();
        int[] nArray = new int[n3];
        for (n = n3 - 1; n >= 0; --n) {
            nArray[n] = (Integer)arrayList.get(n);
        }
        return nArray;
    }

    public boolean setPostResIndex(int n) {
        if (this.bNewThread) {
            return false;
        }
        V2CScriptResLabel v2CScriptResLabel = this.getPostResLabel();
        if (v2CScriptResLabel == null) {
            return false;
        }
        V2CThreadRes v2CThreadRes = this.getAttachedThreadRes();
        if (v2CThreadRes != null) {
            V2CScriptRes v2CScriptRes = this.getRes(n);
            if (v2CScriptRes == null) {
                return false;
            }
            v2CScriptRes.setResLabel(v2CScriptResLabel);
        } else {
            V2CResLabel.setResLabel(n, v2CScriptResLabel.getResLabel(), null, this.vThreadItem, true);
        }
        return true;
    }

    public float getSpeed() {
        return this.bNewThread ? 0.0f : this.vThreadItem.getSpeed() * 86400.0f;
    }

    public boolean getLive() {
        return this.bNewThread || this.vThreadItem.isTwitter() ? true : this.vThreadItem.isActiveScr();
    }

    public boolean getUnread() {
        return this.bNewThread ? false : this.vThreadItem.getUnread();
    }

    public void resetUnread() {
        if (this.bNewThread) {
            return;
        }
        this.vThreadItem.resetNewThreshold();
        this.vThreadItem.updateLocalThreadStatusLater();
    }

    public void clearNewMark() {
        if (this.bNewThread) {
            return;
        }
        if (this.doPanelAction(5) == null) {
            this.resetUnread();
        }
    }

    public void open() {
        this.open(true, true, false, null);
    }

    public void open(boolean bl) {
        this.open(bl, true, false, null);
    }

    public void open(boolean bl, boolean bl2) {
        this.open(bl, bl2, false, null);
    }

    public void open(boolean bl, boolean bl2, boolean bl3) {
        this.open(bl, bl2, bl3, null);
    }

    public void open(boolean bl, boolean bl2, boolean bl3, V2CThreadOpenRequest v2CThreadOpenRequest) {
        if (this.bNewThread) {
            return;
        }
        V2CScriptApp.open(this.vThreadItem, bl, bl2, bl3, v2CThreadOpenRequest);
    }

    public boolean update() {
        return this.update(false);
    }

    public boolean updateAndWait() {
        return this.update(true);
    }

    private boolean update(boolean bl) {
        if (this.bNewThread || !V2CThreadList.checkRoundCount()) {
            return false;
        }
        V2CThreadItem v2CThreadItem = this.vThreadItem;
        if (!bl) {
            return V2CScriptApp.open(v2CThreadItem, true, true, false, -1);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return false;
        }
        Long l = V2CScriptApp.getLastThreadUpdateTime(v2CThreadItem);
        V2CThreadOpenRequest v2CThreadOpenRequest = this.doUpdateAndWait();
        if (v2CThreadOpenRequest == null) {
            return false;
        }
        if (v2CThreadOpenRequest.getSetUpdSucc()) {
            return true;
        }
        V2CScriptApp.setLastThreadUpdateTime(v2CThreadItem, l);
        V2CThreadPanel v2CThreadPanel = V2CThreadPanel.getAttachedPanel(this.vThreadItem);
        if (v2CThreadPanel == null) {
            return true;
        }
        Object object = v2CThreadPanel.getUpdLockObj();
        if (v2CThreadOpenRequest.getWasUpdating()) {
            V2CScriptThread.waitUpdateFinish(v2CThreadPanel, object);
            return true;
        }
        for (int i = 0; i < 2; ++i) {
            if (!V2CScriptThread.waitUpdateFinish(v2CThreadPanel, object)) {
                return true;
            }
            l = V2CScriptApp.getLastThreadUpdateTime(v2CThreadItem);
            v2CThreadOpenRequest = this.doUpdateAndWait();
            if (v2CThreadOpenRequest == null) {
                return false;
            }
            if (v2CThreadOpenRequest.getSetUpdSucc()) {
                return true;
            }
            V2CScriptApp.setLastThreadUpdateTime(v2CThreadItem, l);
            if (!v2CThreadOpenRequest.getWasUpdating()) continue;
            V2CScriptThread.waitUpdateFinish(v2CThreadPanel, object);
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitUpdateFinish(V2CThreadPanel v2CThreadPanel, Object object) {
        Object object2 = object;
        synchronized (object2) {
            while (v2CThreadPanel.isUpdating()) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V2CThreadOpenRequest doUpdateAndWait() {
        V2CThreadOpenRequest v2CThreadOpenRequest = new V2CThreadOpenRequest();
        v2CThreadOpenRequest.setWaitObject(v2CThreadOpenRequest);
        v2CThreadOpenRequest.setOpenLater(true);
        V2CThreadOpenRequest v2CThreadOpenRequest2 = v2CThreadOpenRequest;
        synchronized (v2CThreadOpenRequest2) {
            if (!V2CScriptApp.open(this.vThreadItem, true, true, false, v2CThreadOpenRequest)) {
                return null;
            }
            try {
                v2CThreadOpenRequest.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return v2CThreadOpenRequest;
    }

    public V2CScriptWritePanel openWritePanel() {
        V2CThreadRes v2CThreadRes = this.loadThreadRes();
        if (v2CThreadRes == null) {
            return null;
        }
        return V2CScriptWritePanel.createScriptWritePanel(v2CThreadRes.vtpThreadPanel, true);
    }

    public V2CScriptWritePanel mayOpenWritePanel() {
        V2CThreadRes v2CThreadRes = this.loadThreadRes();
        if (v2CThreadRes == null) {
            return null;
        }
        return V2CScriptWritePanel.createScriptWritePanel(v2CThreadRes.vtpThreadPanel, false);
    }

    V2CThreadPanel getOpenPanel() {
        return V2CThreadPanel.getOpenPanel(this.vThreadItem);
    }

    private V2CThreadPanel getAttachedPanel() {
        return V2CThreadPanel.getAttachedPanel(this.vThreadItem);
    }

    private Object doPanelAction(int n) {
        return this.doPanelAction(n, 0, 0);
    }

    private Object doPanelAction(int n, int n2, int n3) {
        V2CThreadPanel v2CThreadPanel = this.getAttachedPanel();
        if (v2CThreadPanel != null) {
            return V2CScriptApp.performPrivilegedEDTAction(new PEDTAction(n, v2CThreadPanel, n2, n3));
        }
        return null;
    }

    public int getColumnIndex() {
        Object object = this.doPanelAction(9);
        return object instanceof Integer ? (Integer)object : -1;
    }

    public void movePanelTo(int n, int n2) {
        this.doPanelAction(10, n, n2);
    }

    public void close() {
        this.doPanelAction(1);
    }

    public boolean getLock() {
        V2CThreadPanel v2CThreadPanel = this.getAttachedPanel();
        return v2CThreadPanel != null ? v2CThreadPanel.isLocked() : false;
    }

    public void setLock(boolean bl) {
        this.doPanelAction(bl ? 2 : 3);
    }

    public boolean importDatFile(String string) {
        return this.importDatFile(string, null, true);
    }

    public boolean importDatFile(String string, String string2) {
        return this.importDatFile(string, string2, true);
    }

    public boolean importDatFile(String string, String string2, boolean bl) {
        if (this.bNewThread) {
            return false;
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("\u30a4\u30f3\u30dd\u30fc\u30c8\u3059\u308bdat\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u7a7a\u3067\u3059\u3002");
        }
        return this.importDat(new File(string), null, string2, bl);
    }

    public boolean importDatBytes(byte[] byArray) {
        return this.importDat(null, byArray, null, true);
    }

    public boolean importDatBytes(byte[] byArray, String string) {
        return this.importDat(null, byArray, string, true);
    }

    public boolean importDatBytes(byte[] byArray, String string, boolean bl) {
        return this.importDat(null, byArray, string, bl);
    }

    private boolean importDat(final File file, final byte[] byArray, final String string, final boolean bl) {
        Object object;
        if (this.bNewThread) {
            return false;
        }
        if (file == null && (byArray == null || byArray.length == 0)) {
            throw new IllegalArgumentException("\u30a4\u30f3\u30dd\u30fc\u30c8\u3059\u308bdat\u304c\u7a7a\u3067\u3059\u3002");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = V2CLocalFileHandler.getV2CDir().getPath();
            securityManager.checkWrite((String)object);
        }
        return (object = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                V2CThreadPanel v2CThreadPanel;
                V2CThreadItem v2CThreadItem;
                block7: {
                    File file2;
                    boolean bl3;
                    boolean bl2 = bl3 = file != null;
                    if (bl3) {
                        file2 = file;
                    } else {
                        file2 = V2CLocalFileHandler.getTempFile();
                        V2CLocalFileHandler.saveToFile(file2, byArray);
                    }
                    v2CThreadItem = V2CScriptThread.this.vThreadItem;
                    try {
                        String string2 = v2CThreadItem.getThreadKey();
                        V2CThreadItem.copyDatFile(v2CThreadItem, file2, string2, string2, string, v2CThreadItem.getBoardItem(), null, bl);
                        v2CThreadPanel = null;
                        if (bl3 || !file2.exists()) break block7;
                        file2.delete();
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (!bl3 && file2.exists()) {
                            file2.delete();
                        }
                        throw throwable;
                    }
                    {
                    }
                }
                boolean bl4 = v2CThreadItem.getNResGet() > 0;
                V2CThreadPanel v2CThreadPanel2 = V2CThreadPanel.getOpenPanel(v2CThreadItem);
                if (v2CThreadPanel2 != null) {
                    v2CThreadPanel2.setTabText();
                }
                if (bl4 && bl && V2CScriptThread.this.vThreadRes == null && (v2CThreadPanel = V2CThreadPanel.loadThreadIfNotLoaded(v2CThreadItem)) != null) {
                    V2CScriptThread.this.vThreadRes = v2CThreadPanel.getThreadRes();
                }
                return bl4;
            }
        })) != null ? (Boolean)object : false;
    }

    public void importPropertyFrom(final V2CScriptThread v2CScriptThread) {
        if (this.isNewThread() || v2CScriptThread == null || v2CScriptThread.isNewThread()) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new V2CRuntimePermission("changeProperty"));
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                V2CScriptThread.this.vThreadItem.importThreadPropertyFrom(v2CScriptThread.vThreadItem);
                return null;
            }
        });
    }

    private class PEDTAction
    implements PrivilegedAction {
        final int iAction;
        final V2CThreadPanel vTargetPanel;
        int iResPaneComumn;
        int iTabIndex;

        PEDTAction(int n, V2CThreadPanel v2CThreadPanel, int n2, int n3) {
            this.iAction = n;
            this.vTargetPanel = v2CThreadPanel;
            this.iResPaneComumn = n2;
            this.iTabIndex = n3;
        }

        public Object run() {
            V2CThreadViewPane v2CThreadViewPane = V2CMain.getDisplayPane();
            switch (this.iAction) {
                case 1: {
                    v2CThreadViewPane.removePanel(this.vTargetPanel);
                    break;
                }
                case 2: {
                    v2CThreadViewPane.setTabLock(this.vTargetPanel, true);
                    break;
                }
                case 3: {
                    v2CThreadViewPane.setTabLock(this.vTargetPanel, false);
                    break;
                }
                case 4: {
                    this.vTargetPanel.setNewThreshold(this.iResPaneComumn);
                    return Boolean.TRUE;
                }
                case 5: {
                    this.vTargetPanel.resetNewThreshold();
                    return Boolean.TRUE;
                }
                case 6: {
                    this.vTargetPanel.saveViewPosition();
                    return Boolean.TRUE;
                }
                case 7: {
                    return V2CScriptThread.this.vThreadItem.getViewPos();
                }
                case 8: {
                    V2CScriptThread.this.vThreadItem.setViewPos(this.iResPaneComumn, this.iTabIndex);
                    break;
                }
                case 9: {
                    return new Integer(V2CMain.getDisplayPane().getColumnIndexOfPanel(this.vTargetPanel));
                }
                case 10: {
                    V2CMain.getDisplayPane().movePanel(this.vTargetPanel, this.iResPaneComumn, this.iTabIndex);
                    break;
                }
                case 11: {
                    return V2CScriptThread.this.vThreadItem.getAutoPostResLabel();
                }
                case 12: {
                    return V2CResLabel.restoreLabels(V2CScriptThread.this.vThreadItem);
                }
            }
            return null;
        }
    }
}

