/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.im.InputContext;
import java.security.PrivilegedAction;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;
import org.monazilla.v2c.V2CScriptApp;

public final class V2CScriptTextComp {
    private static final int ACTION_GETTEXT = 0;
    private static final int ACTION_SETTEXT = 1;
    private static final int ACTION_GETSELTEXT = 2;
    private static final int ACTION_REPLACESELTEXT = 3;
    private static final int ACTION_COPY = 4;
    private static final int ACTION_PASTE = 5;
    private static final int ACTION_CUT = 6;
    private static final int ACTION_GETCARETPOS = 7;
    private static final int ACTION_SETCARETPOS = 8;
    private static final int ACTION_GETSELSTART = 9;
    private static final int ACTION_SETSELSTART = 10;
    private static final int ACTION_GETSELEND = 11;
    private static final int ACTION_SETSELEND = 12;
    private static final int ACTION_SELECT = 13;
    private JTextComponent jTextComponent;
    JComboBox vParentComboBox;

    static V2CScriptTextComp createScriptTextComp(JTextComponent jTextComponent) {
        return jTextComponent != null ? new V2CScriptTextComp(jTextComponent) : null;
    }

    private V2CScriptTextComp(JTextComponent jTextComponent) {
        this.jTextComponent = jTextComponent;
    }

    public String toString() {
        return this.getText();
    }

    public String getText() {
        return (String)this.performPrivilegedEDTAction(0);
    }

    public void setText(String string) {
        this.performPrivilegedEDTAction(1, string, 0, 0);
    }

    public String getSelText() {
        return (String)this.performPrivilegedEDTAction(2);
    }

    public void setSelText(String string) {
        this.performPrivilegedEDTAction(3, string, 0, 0);
    }

    public void copy() {
        this.performPrivilegedEDTAction(4);
    }

    public void paste() {
        this.performPrivilegedEDTAction(5);
    }

    public void cut() {
        this.performPrivilegedEDTAction(6);
    }

    public int getCaretPos() {
        return (Integer)this.performPrivilegedEDTAction(7);
    }

    public void setCaretPos(int n) {
        this.performPrivilegedEDTAction(8, null, n, 0);
    }

    private void endComposition() {
        InputContext inputContext = this.jTextComponent.getInputContext();
        if (inputContext != null) {
            inputContext.endComposition();
        }
    }

    public int getSelStart() {
        return (Integer)this.performPrivilegedEDTAction(9);
    }

    public void setSelStart(int n) {
        this.performPrivilegedEDTAction(10, null, n, 0);
    }

    public int getSelEnd() {
        return (Integer)this.performPrivilegedEDTAction(11);
    }

    public void setSelEnd(int n) {
        this.performPrivilegedEDTAction(12, null, n, 0);
    }

    public void select(int n, int n2) {
        this.performPrivilegedEDTAction(13, null, n, n2);
    }

    private Object performPrivilegedEDTAction(int n) {
        return this.performPrivilegedEDTAction(n, null, 0, 0);
    }

    private Object performPrivilegedEDTAction(int n, String string, int n2, int n3) {
        return V2CScriptApp.performPrivilegedEDTAction(new PrivilegedEDTAction(n, string, n2, n3));
    }

    private class PrivilegedEDTAction
    implements PrivilegedAction {
        final int iAction;
        final String sTextToSet;
        final int iCaretPos;
        final int iCaretPos2;

        PrivilegedEDTAction(int n, String string, int n2, int n3) {
            this.iAction = n;
            this.sTextToSet = string;
            this.iCaretPos = n2;
            this.iCaretPos2 = n3;
        }

        public Object run() {
            JTextComponent jTextComponent = V2CScriptTextComp.this.jTextComponent;
            int n = jTextComponent.getText().length();
            try {
                switch (this.iAction) {
                    case 0: {
                        return jTextComponent.getText();
                    }
                    case 1: {
                        if (V2CScriptTextComp.this.vParentComboBox != null && (!V2CScriptTextComp.this.vParentComboBox.isEnabled() || !V2CScriptTextComp.this.vParentComboBox.isEditable())) break;
                        jTextComponent.setText(this.sTextToSet);
                        break;
                    }
                    case 2: {
                        return jTextComponent.getSelectedText();
                    }
                    case 3: {
                        if (V2CScriptTextComp.this.vParentComboBox != null && (!V2CScriptTextComp.this.vParentComboBox.isEnabled() || !V2CScriptTextComp.this.vParentComboBox.isEditable())) break;
                        jTextComponent.replaceSelection(this.sTextToSet);
                        break;
                    }
                    case 4: {
                        jTextComponent.copy();
                        break;
                    }
                    case 5: {
                        jTextComponent.paste();
                        break;
                    }
                    case 6: {
                        jTextComponent.cut();
                        break;
                    }
                    case 7: {
                        return new Integer(jTextComponent.getCaretPosition());
                    }
                    case 8: {
                        jTextComponent.setCaretPosition(this.restrictRange(this.iCaretPos, n));
                        break;
                    }
                    case 9: {
                        return new Integer(jTextComponent.getSelectionStart());
                    }
                    case 10: {
                        jTextComponent.setSelectionStart(this.restrictRange(this.iCaretPos, n));
                        break;
                    }
                    case 11: {
                        return new Integer(jTextComponent.getSelectionEnd());
                    }
                    case 12: {
                        jTextComponent.setSelectionEnd(this.restrictRange(this.iCaretPos, n));
                        break;
                    }
                    case 13: {
                        jTextComponent.select(this.restrictRange(this.iCaretPos, n), this.restrictRange(this.iCaretPos2, n));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private int restrictRange(int n, int n2) {
            return n >= 0 && n <= n2 ? n : n2;
        }
    }
}

