/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBaseFont;
import org.monazilla.v2c.V2CFont;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSSDistance;
import org.monazilla.v2c.V2CSSFontWeight;
import org.monazilla.v2c.V2CStyleSheet;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CThreadStyle;

public class V2CSSFont
extends V2CFont {
    static final String sDefaultFontSizeKey = "ThreadView.DefaultFontSize";
    static HashMap hmBaseFontMap = new HashMap();
    static HashMap hmSSFontMap = new HashMap();
    static boolean bDefaultFontChecked;
    static V2CSSFont ssDefaultFont;
    static boolean bAltFontChecked;
    static final V2CSSFont[] flAltFont;
    static int nDefaultFontSize;
    Float fWeight;
    boolean bWeightImportant;
    int nULDescent;

    static int getDefaultSize() {
        return nDefaultFontSize;
    }

    static void setDefaultSize(int n) {
        nDefaultFontSize = n;
        V2CApp.getUserProperty().putInt(sDefaultFontSizeKey, n);
    }

    static void defaultFontChanged() {
        ssDefaultFont = null;
        bDefaultFontChecked = false;
        if (!V2CThreadStyle.isAltSizeFixed()) {
            V2CSSFont.altFontChanged();
        }
    }

    static V2CSSFont getDefaultFont() {
        return V2CSSFont.getDefaultFont(null);
    }

    static V2CSSFont getDefaultFont(Graphics2D graphics2D) {
        if (!bDefaultFontChecked) {
            bDefaultFontChecked = true;
            V2CBaseFont v2CBaseFont = V2CBaseFont.getBaseFont("ThreadDefault");
            if (v2CBaseFont == null) {
                v2CBaseFont = V2CBaseFont.getBaseFont("Default");
            }
            V2CSSFont v2CSSFont = V2CSSFont.createSSFont(v2CBaseFont, nDefaultFontSize);
            if (graphics2D != null) {
                v2CSSFont.calcFontMetrics(graphics2D, false);
            }
            ssDefaultFont = v2CSSFont;
        }
        return ssDefaultFont;
    }

    static void altFontChanged() {
        V2CSSFont.flAltFont[0] = null;
        bAltFontChecked = false;
        V2CThreadPanel.altFontChanged();
    }

    static V2CSSFont[] getAltFont(Graphics2D graphics2D) {
        if (!bAltFontChecked) {
            bAltFontChecked = true;
            V2CBaseFont v2CBaseFont = V2CBaseFont.getBaseFont("ThreadAlt");
            if (v2CBaseFont == null) {
                v2CBaseFont = V2CBaseFont.getBaseFont("ThreadDefault");
            }
            if (v2CBaseFont != null) {
                V2CSSFont v2CSSFont;
                int n = V2CThreadStyle.getAltFontSize();
                if (n <= 0) {
                    v2CSSFont = V2CSSFont.getDefaultFont();
                    n = v2CSSFont != null ? (int)v2CSSFont.getSize() : 16;
                }
                v2CSSFont = V2CSSFont.createSSFont(v2CBaseFont, n);
                v2CSSFont.calcFontMetrics(graphics2D, false);
                V2CSSFont.flAltFont[0] = v2CSSFont;
            }
        }
        return flAltFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean calcAllFontMetrics(Graphics2D graphics2D, boolean bl) {
        boolean bl2 = true;
        HashMap hashMap = hmSSFontMap;
        int n = hashMap.size();
        if (n > 0) {
            Object object;
            ArrayList arrayList = new ArrayList();
            HashMap hashMap2 = hashMap;
            synchronized (hashMap2) {
                object = hashMap.keySet().iterator();
                while (object.hasNext()) {
                    arrayList.add(hashMap.get(object.next()));
                }
            }
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                object = (V2CSSFont)arrayList.get(i);
                if (((V2CSSFont)object).calcFontMetrics(graphics2D, bl)) continue;
                bl2 = false;
            }
        }
        return bl2;
    }

    static V2CBaseFont getBaseFontFromFamily(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.equals("sans-serif")) {
            string = "SansSerif";
        } else if (string.equals("serif")) {
            string = "Serif";
        } else if (string.equals("monospace")) {
            string = "Monospaced";
        } else if (string.equals("fantasy") || string.equals("cursive")) {
            return null;
        }
        HashMap hashMap = hmBaseFontMap;
        Object v = hashMap.get(string);
        if (v instanceof V2CBaseFont) {
            return (V2CBaseFont)v;
        }
        if (v instanceof String) {
            if (((String)v).length() == 0) {
                return null;
            }
            if ((v = hashMap.get(v)) instanceof V2CBaseFont) {
                return (V2CBaseFont)v;
            }
        }
        V2CBaseFont v2CBaseFont = new V2CBaseFont(new Font(string, 0, 1));
        String string2 = v2CBaseFont.getFaceName();
        if (!string.equalsIgnoreCase("Dialog") && v2CBaseFont.getFamily().equalsIgnoreCase("Dialog")) {
            hashMap.put(string, "");
            return null;
        }
        if (string2.equals(string)) {
            hashMap.put(string, v2CBaseFont);
        } else {
            hashMap.put(string, string2);
            hashMap.put(string2, v2CBaseFont);
        }
        return v2CBaseFont;
    }

    static V2CSSFont[] createSSFont(String[] stringArray, V2CSSDistance v2CSSDistance, V2CSSFontWeight v2CSSFontWeight, V2CFont v2CFont, V2CFont v2CFont2, V2CStyleSheet v2CStyleSheet) {
        int n;
        float f;
        Object object;
        int n2;
        if (v2CSSDistance != null) {
            if (v2CSSDistance.isFontKeyword()) {
                n2 = v2CSSDistance.getFontSize();
                float f2 = 1.0f;
                switch (n2) {
                    case 0: {
                        f2 = 0.6f;
                        break;
                    }
                    case 1: {
                        f2 = 0.75f;
                        break;
                    }
                    case 2: {
                        f2 = 0.888f;
                        break;
                    }
                    case 3: {
                        f2 = 1.0f;
                        break;
                    }
                    case 4: {
                        f2 = 1.2f;
                        break;
                    }
                    case 5: {
                        f2 = 1.5f;
                        break;
                    }
                    case 6: {
                        f2 = 2.0f;
                        break;
                    }
                    case 7: {
                        f2 = 0.8333333f;
                        break;
                    }
                    case 8: {
                        f2 = 1.2f;
                    }
                }
                object = n2 == 7 || n2 == 8 ? v2CFont : v2CFont2;
                f = f2 * ((V2CFont)object).getSize();
            } else {
                f = v2CSSDistance.isPercent() ? v2CSSDistance.getValue() * v2CFont.getSize() : v2CStyleSheet.getValue(v2CSSDistance, 2);
            }
        } else {
            f = v2CFont.getSize();
        }
        n2 = Math.round(f);
        if (v2CSSFontWeight == null) {
            Float f3 = v2CFont instanceof V2CSSFont ? ((V2CSSFont)v2CFont).fWeight : (v2CFont2 instanceof V2CSSFont ? ((V2CSSFont)v2CFont2).fWeight : TextAttribute.WEIGHT_REGULAR);
            v2CSSFontWeight = new V2CSSFontWeight(f3);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                V2CBaseFont v2CBaseFont = V2CSSFont.getBaseFontFromFamily(stringArray[i]);
                if (v2CBaseFont == null) continue;
                arrayList.add(v2CBaseFont);
            }
        }
        if (arrayList.size() == 0) {
            arrayList.add(v2CFont.getBaseFont());
        }
        object = V2CSSFont.getDefaultFont().getBaseFont();
        boolean bl = false;
        for (n = arrayList.size() - 1; n >= 0; --n) {
            if (arrayList.get(n) != object) continue;
            bl = true;
            break;
        }
        if (!bl) {
            arrayList.add(object);
        }
        n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.set(i, V2CSSFont.createSSFont((V2CBaseFont)arrayList.get(i), n2, v2CSSFontWeight));
        }
        return arrayList.toArray(new V2CSSFont[n]);
    }

    static V2CSSFont createSSFont(V2CBaseFont v2CBaseFont, int n) {
        return V2CSSFont.createSSFont(v2CBaseFont, n, new V2CSSFontWeight(TextAttribute.WEIGHT_REGULAR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static V2CSSFont createSSFont(V2CBaseFont v2CBaseFont, int n, V2CSSFontWeight v2CSSFontWeight) {
        V2CSSFont v2CSSFont;
        HashMap hashMap;
        String string = v2CBaseFont.getFaceName();
        SSFontKey sSFontKey = new SSFontKey(string, n, v2CSSFontWeight);
        HashMap hashMap2 = hashMap = hmSSFontMap;
        synchronized (hashMap2) {
            v2CSSFont = (V2CSSFont)hashMap.get(sSFontKey);
        }
        if (v2CSSFont != null) {
            return v2CSSFont;
        }
        v2CSSFont = new V2CSSFont(v2CBaseFont, n, v2CSSFontWeight);
        hashMap.put(sSFontKey, v2CSSFont);
        return v2CSSFont;
    }

    private V2CSSFont(V2CBaseFont v2CBaseFont, int n) {
        this(v2CBaseFont, n, new V2CSSFontWeight(TextAttribute.WEIGHT_REGULAR));
    }

    private V2CSSFont(V2CBaseFont v2CBaseFont, int n, V2CSSFontWeight v2CSSFontWeight) {
        this.bTemporary = true;
        this.fWeight = v2CSSFontWeight.getWeight();
        this.bWeightImportant = v2CSSFontWeight.isImportant();
        if (this.fWeight == TextAttribute.WEIGHT_BOLD) {
            this.setStyle(1);
        }
        this.setBaseFont(v2CBaseFont);
        this.setSize(n);
        this.createWidthCache();
    }

    boolean isWeightImportant() {
        return this.bWeightImportant;
    }

    int getLeading(int n) {
        if (n > 0) {
            return this.nHeight * n >> 8;
        }
        return n == Integer.MIN_VALUE ? this.nLeading : -n;
    }

    Rectangle2D getNewLineRect(int n, int n2) {
        return new Rectangle2D.Float(n, n2 - this.nAscent, this.nSPWidth, this.nHeight);
    }

    boolean calcFontMetrics(Graphics2D graphics2D, boolean bl) {
        boolean bl2;
        if (!bl && this.nLineHeight > 0) {
            return true;
        }
        graphics2D.setFont(this.getAwtFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.nAscent = fontMetrics.getAscent();
        this.nDescent = fontMetrics.getDescent();
        this.nLeading = fontMetrics.getLeading();
        boolean bl3 = bl2 = this.nAscent > 1;
        if (!bl2) {
            this.nAscent = (int)this.getSize();
            this.nLeading = this.nDescent = (int)((float)this.nAscent / 5.0f);
        }
        if (this.nLeading < 1) {
            this.nLeading = Math.max((int)((float)this.nAscent * 0.14f), 1);
        }
        this.nULDescent = this.nDescent >= 3 ? (this.nDescent + 1) / 2 : this.nDescent;
        this.nHeight = this.nAscent + this.nDescent;
        this.nLineHeight = this.nHeight + this.nLeading;
        this.nSPWidth = this.nHeight / 2;
        return bl2;
    }

    int getAscent() {
        return this.nAscent;
    }

    int getDescent() {
        return this.nDescent;
    }

    int getLineHeight() {
        return this.nLineHeight;
    }

    static {
        flAltFont = new V2CSSFont[1];
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        nDefaultFontSize = v2CProperty.getInt(sDefaultFontSizeKey, 16);
    }

    private static class SSFontKey {
        final String sFamilyName;
        final int nSize;
        final int nWeight;
        final int nHashCode;

        SSFontKey(String string, int n, V2CSSFontWeight v2CSSFontWeight) {
            this.sFamilyName = string;
            this.nSize = n;
            int n2 = (int)(v2CSSFontWeight.getWeight().floatValue() * 100.0f) << 1;
            this.nWeight = v2CSSFontWeight.isImportant() ? n2 + 1 : n2;
            this.nHashCode = string.hashCode() ^ (n << 8 | this.nWeight);
        }

        public int hashCode() {
            return this.nHashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SSFontKey)) {
                return false;
            }
            SSFontKey sSFontKey = (SSFontKey)object;
            return this.sFamilyName.equals(sSFontKey.sFamilyName) && this.nSize == sSFontKey.nSize && this.nWeight == sSFontKey.nWeight;
        }
    }
}

