/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CSSColor;
import org.monazilla.v2c.V2CSSDistance;

public class V2CSSBoxShadow {
    final V2CSSDistance[] ssdlLength;
    final V2CSSColor sscColor;
    BufferedImage[] bilBorder;
    int nInset;
    static final Pattern pLength = Pattern.compile("(-?\\d+[\\w.]+|0)(?:\\s+|$)");
    private static final int NINTP = 20;
    private static final float fDX = 2.0f;
    private static float[] flERF;

    static V2CSSBoxShadow parse(String string) {
        Matcher matcher = pLength.matcher(string);
        V2CSSDistance[] v2CSSDistanceArray = new V2CSSDistance[4];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 4 && matcher.find(n) && matcher.start() == n; ++i) {
            n = matcher.end();
            V2CSSDistance v2CSSDistance = V2CSSDistance.parse(matcher.group(1));
            if (v2CSSDistance == null) {
                return null;
            }
            v2CSSDistanceArray[n2++] = v2CSSDistance;
        }
        if (n2 < 2) {
            return null;
        }
        if (n2 >= 3 && v2CSSDistanceArray[2].isNegative()) {
            return null;
        }
        V2CSSColor v2CSSColor = null;
        if (n < string.length()) {
            v2CSSColor = V2CSSColor.parseColor(string.substring(n));
        }
        return new V2CSSBoxShadow(v2CSSDistanceArray, v2CSSColor);
    }

    private V2CSSBoxShadow(V2CSSDistance[] v2CSSDistanceArray, V2CSSColor v2CSSColor) {
        this.ssdlLength = v2CSSDistanceArray;
        this.sscColor = v2CSSColor != null ? v2CSSColor : new V2CSSColor(Color.BLACK);
        this.nInset = (int)(2.0f * (float)this.getRadius()) / 2;
    }

    static float[] getERF() {
        if (flERF == null) {
            int n;
            double d = 0.10526315867900848;
            d = d * d / 2.0;
            int n2 = 10;
            float[] fArray = new float[21];
            fArray[0] = 0.0f;
            fArray[20] = 0.0f;
            for (int i = 1; i < 20; ++i) {
                fArray[i] = (float)Math.exp((double)(-(i - n2) * (i - n2)) * d);
            }
            float[] fArray2 = new float[21];
            float f = 0.0f;
            for (n = 1; n <= 20; ++n) {
                fArray2[n] = f += (fArray[n - 1] + fArray[n]) / 2.0f;
            }
            f = 1.0f / f;
            for (n = 1; n <= 20; ++n) {
                fArray2[n] = 1.0f - fArray2[n] * f;
            }
            fArray2[0] = 1.0f;
            flERF = fArray2;
        }
        return flERF;
    }

    static float calcFactor(float f, float f2, float[] fArray) {
        if (f <= 0.0f) {
            return 1.0f;
        }
        int n = (int)(f *= f2);
        if (n >= 20) {
            return 0.0f;
        }
        float f3 = fArray[n];
        return f3 + (f - (float)n) * (fArray[n + 1] - f3);
    }

    static int calcAlpha(int n, float f, int n2, float[] fArray) {
        return V2CSSBoxShadow.calcAlpha(n, 1.0f, f, n2, fArray);
    }

    static int calcAlpha(int n, float f, float f2, int n2, float[] fArray) {
        float f3 = V2CSSBoxShadow.calcFactor(n, f2, fArray);
        return Math.round((float)n2 * f3 * f);
    }

    void createBorderImage() {
        int n;
        int n2;
        int n3;
        int n4 = this.getRadius();
        if (n4 <= 0) {
            return;
        }
        float[] fArray = V2CSSBoxShadow.getERF();
        float f = 20.0f / ((float)n4 * 2.0f);
        int n5 = (int)(2.0f * (float)n4);
        int n6 = n5 - 1;
        int[] nArray = new int[Math.max(n5 * n5, 100)];
        Color color = this.sscColor.getColor();
        int n7 = color.getRGB();
        int n8 = n7 & 0xFFFFFF;
        int n9 = n7 >>> 24;
        Color color2 = new Color(0, true);
        BufferedImage[] bufferedImageArray = new BufferedImage[17];
        this.bilBorder = bufferedImageArray;
        GraphicsConfiguration graphicsConfiguration = V2CMain.v2cMain.getGraphicsConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(10, n5, 3);
        int n10 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = V2CSSBoxShadow.calcAlpha(n6 - n3, f, n9, fArray) << 24 | n8;
            for (n = 0; n < 10; ++n) {
                nArray[n10++] = n2;
            }
        }
        bufferedImage.setRGB(0, 0, 10, n5, nArray, 0, 10);
        bufferedImageArray[8] = bufferedImage;
        bufferedImage = graphicsConfiguration.createCompatibleImage(n5, 10, 3);
        n10 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = V2CSSBoxShadow.calcAlpha(n6 - n3, f, n9, fArray) << 24 | n8;
            for (n = 0; n < 10; ++n) {
                nArray[n * n5 + n3] = n2;
            }
        }
        bufferedImage.setRGB(0, 0, n5, 10, nArray, 0, n5);
        bufferedImageArray[10] = bufferedImage;
        bufferedImage = graphicsConfiguration.createCompatibleImage(10, n5, 3);
        n10 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = V2CSSBoxShadow.calcAlpha(n3, f, n9, fArray) << 24 | n8;
            for (n = 0; n < 10; ++n) {
                nArray[n10++] = n2;
            }
        }
        bufferedImage.setRGB(0, 0, 10, n5, nArray, 0, 10);
        bufferedImageArray[12] = bufferedImage;
        bufferedImage = graphicsConfiguration.createCompatibleImage(n5, 10, 3);
        n10 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = V2CSSBoxShadow.calcAlpha(n3, f, n9, fArray) << 24 | n8;
            for (n = 0; n < 10; ++n) {
                nArray[n * n5 + n3] = n2;
            }
        }
        bufferedImage.setRGB(0, 0, n5, 10, nArray, 0, n5);
        bufferedImageArray[14] = bufferedImage;
        bufferedImage = graphicsConfiguration.createCompatibleImage(n5, n5, 3);
        n10 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            float f2 = V2CSSBoxShadow.calcFactor(n6 - n3, f, fArray);
            for (n = 0; n < n5; ++n) {
                nArray[n10++] = V2CSSBoxShadow.calcAlpha(n6 - n, f2, f, n9, fArray) << 24 | n8;
            }
        }
        bufferedImage.setRGB(0, 0, n5, n5, nArray, 0, n5);
        bufferedImageArray[9] = bufferedImage;
        bufferedImage = graphicsConfiguration.createCompatibleImage(n5, n5, 3);
        n10 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            float f3 = V2CSSBoxShadow.calcFactor(n3, f, fArray);
            for (n = 0; n < n5; ++n) {
                nArray[n10++] = V2CSSBoxShadow.calcAlpha(n6 - n, f3, f, n9, fArray) << 24 | n8;
            }
        }
        bufferedImage.setRGB(0, 0, n5, n5, nArray, 0, n5);
        bufferedImageArray[11] = bufferedImage;
        bufferedImage = graphicsConfiguration.createCompatibleImage(n5, n5, 3);
        n10 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            float f4 = V2CSSBoxShadow.calcFactor(n3, f, fArray);
            for (n = 0; n < n5; ++n) {
                nArray[n10++] = V2CSSBoxShadow.calcAlpha(n, f4, f, n9, fArray) << 24 | n8;
            }
        }
        bufferedImage.setRGB(0, 0, n5, n5, nArray, 0, n5);
        bufferedImageArray[13] = bufferedImage;
        bufferedImage = graphicsConfiguration.createCompatibleImage(n5, n5, 3);
        n10 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            float f5 = V2CSSBoxShadow.calcFactor(n6 - n3, f, fArray);
            for (n = 0; n < n5; ++n) {
                nArray[n10++] = V2CSSBoxShadow.calcAlpha(n, f5, f, n9, fArray) << 24 | n8;
            }
        }
        bufferedImage.setRGB(0, 0, n5, n5, nArray, 0, n5);
        bufferedImageArray[15] = bufferedImage;
        bufferedImage = graphicsConfiguration.createCompatibleImage(10, 10, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, 10, 10);
        graphics2D.dispose();
        bufferedImageArray[16] = bufferedImage;
    }

    BufferedImage[] getBorderImage() {
        if (this.bilBorder == null) {
            this.createBorderImage();
        }
        return this.bilBorder;
    }

    int getInset() {
        return this.nInset;
    }

    int getHOffset() {
        return (int)this.ssdlLength[0].getValue();
    }

    int getVOffset() {
        return (int)this.ssdlLength[1].getValue();
    }

    int getRadius() {
        V2CSSDistance v2CSSDistance = this.ssdlLength[2];
        return v2CSSDistance != null ? (int)v2CSSDistance.getValue() : 0;
    }

    int getSpread() {
        V2CSSDistance v2CSSDistance = this.ssdlLength[3];
        return v2CSSDistance != null ? (int)v2CSSDistance.getValue() : 0;
    }
}

