/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CCheckBoxRenderer;
import org.monazilla.v2c.V2CHeaderTextSegment;
import org.monazilla.v2c.V2CImageTextSegment;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CSSBoxShadow;
import org.monazilla.v2c.V2CSSColor;
import org.monazilla.v2c.V2CSSColorGradation;
import org.monazilla.v2c.V2CSSDistance;
import org.monazilla.v2c.V2CSSFont;
import org.monazilla.v2c.V2CSSTextShadow;
import org.monazilla.v2c.V2CStyleSheet;
import org.monazilla.v2c.V2CTextSegment;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadStyle;
import org.monazilla.v2c.V2CVariableImage;

public class V2CResRect {
    static final int SIDE_TOP = 0;
    static final int SIDE_LEFT = 1;
    static final int SIDE_BOTTOM = 2;
    static final int SIDE_RIGHT = 3;
    static final byte DISP_NOTIME = -1;
    static final byte DISP_ANYTIME = 0;
    static final byte DISP_TIME = 1;
    V2CResRect vParentRect;
    boolean bVertical;
    V2CResRect[] vlRects;
    V2CResRect[] vlDrawRects;
    int nRightSpace;
    V2CHeaderTextSegment[] vlResElements;
    boolean bContainsResNum;
    boolean bContainsMessage;
    int iSeqNum;
    V2CSSColor sscBackground;
    Color cBackground;
    V2CSSColorGradation cgBGGradation;
    boolean bMarginLeftAuto;
    boolean bMarginRightAuto;
    int nMarginTop;
    int nMarginLeft;
    int nMarginBottom;
    int nMarginRight;
    int nPadTop;
    int nPadLeft;
    int nPadBottom;
    int nPadRight;
    int nTBMOfst;
    int nBBMOfst;
    int nHMarginPad;
    int nMinFullWidth;
    int nMinWidth0;
    int nMaxWidth;
    int nWidth;
    int nMinHeight;
    boolean bFillHeight;
    float fOpacity = 1.0f;
    V2CSSBoxShadow ssBoxShadow;
    boolean bIgnoreThreadBG;
    V2CVariableImage[] vilBGImage;
    BGPos[] lBGPos;
    int[] ilBGRepeat;
    int[] ilBGAttachment;
    boolean[] blBGOverflow;
    BufferedImage[] bilBDImgSrc;
    int[] nlBDImgSlc;
    boolean bBDImgFill;
    int[] nlBDImgOS;
    int nBDImgRpt;
    BufferedImage[] bilBorderImage;
    boolean[] blBDOverflow;
    int[] nlBorderWidth;
    int[] nlBorderStyle;
    int[] nlBorderRadius;
    V2CSSColor[] ssclBorderColor;
    Color[] clBorderColor;
    int nLineLeadingFactor = -2;
    int nTextAlignment = -1;
    V2CSSTextShadow ssTextShadow;
    boolean bThumbnail;
    boolean bRefCount;
    byte bTime;
    boolean bRTB;

    static int calcMinFullWidth(V2CResRect[] v2CResRectArray, boolean bl) {
        int n = 0;
        for (int i = 0; i < v2CResRectArray.length; ++i) {
            V2CResRect v2CResRect = v2CResRectArray[i];
            if (!bl && v2CResRect.bThumbnail && !V2CAbstractThreadPanel.bGroupThumbnail) continue;
            int n2 = v2CResRect.calcMinFullWidth();
            if (bl) {
                if (n2 <= n) continue;
                n = n2;
                continue;
            }
            n += n2;
        }
        return n;
    }

    public V2CResRect() {
        this.nLineLeadingFactor = -1;
        this.nTextAlignment = 0;
        this.nBBMOfst = Integer.MIN_VALUE;
        this.nTBMOfst = Integer.MIN_VALUE;
    }

    public V2CResRect(V2CResRect[] v2CResRectArray, boolean bl) {
        if (!bl && v2CResRectArray.length < 2) {
            bl = true;
        }
        this.bVertical = bl;
        this.vlRects = v2CResRectArray;
        this.vlDrawRects = v2CResRectArray;
        for (int i = 0; i < v2CResRectArray.length; ++i) {
            v2CResRectArray[i].vParentRect = this;
        }
    }

    public V2CResRect(V2CHeaderTextSegment[] v2CHeaderTextSegmentArray) {
        this.vlResElements = v2CHeaderTextSegmentArray;
        int n = v2CHeaderTextSegmentArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = v2CHeaderTextSegmentArray[i].getType();
            if (n2 == 32) {
                this.bContainsResNum = true;
                continue;
            }
            if (n2 != 0x40000000) continue;
            this.bContainsMessage = true;
        }
    }

    void setThumbnail() {
        this.bThumbnail = true;
    }

    void setRefCount() {
        this.bRefCount = true;
    }

    void setTime(boolean bl) {
        this.bTime = (byte)(bl ? 1 : -1);
    }

    void setRTB() {
        this.bRTB = true;
    }

    void checkVersion(int n) {
        Object[] objectArray;
        int[] nArray;
        Object[] objectArray2;
        Object[] objectArray3;
        if (n <= 0) {
            return;
        }
        V2CVariableImage[] v2CVariableImageArray = this.vilBGImage;
        if (v2CVariableImageArray != null && v2CVariableImageArray.length > 1) {
            objectArray3 = new V2CVariableImage[v2CVariableImageArray.length];
            System.arraycopy(v2CVariableImageArray, 0, objectArray3, 0, v2CVariableImageArray.length);
            this.vilBGImage = objectArray3;
            V2CMiscUtil.revertArray(objectArray3);
        }
        objectArray3 = this.lBGPos;
        if (v2CVariableImageArray != null && v2CVariableImageArray.length > 1) {
            objectArray2 = new BGPos[objectArray3.length];
            System.arraycopy(objectArray3, 0, objectArray2, 0, objectArray3.length);
            this.lBGPos = (BGPos[])objectArray2;
            V2CMiscUtil.revertArray(this.lBGPos);
        }
        if ((objectArray2 = this.ilBGRepeat) != null && objectArray2.length > 1) {
            nArray = new int[objectArray2.length];
            System.arraycopy(objectArray2, 0, nArray, 0, objectArray2.length);
            this.ilBGRepeat = nArray;
            V2CMiscUtil.revertIntArray(nArray);
        }
        if ((nArray = this.ilBGAttachment) != null && nArray.length > 1) {
            objectArray = new int[nArray.length];
            System.arraycopy(nArray, 0, objectArray, 0, nArray.length);
            this.ilBGAttachment = (int[])objectArray;
            V2CMiscUtil.revertIntArray((int[])objectArray);
        }
        if ((objectArray = this.blBGOverflow) != null && objectArray.length > 1) {
            boolean[] blArray = new boolean[objectArray.length];
            System.arraycopy(objectArray, 0, blArray, 0, objectArray.length);
            this.blBGOverflow = blArray;
            V2CMiscUtil.revertBoolArray(blArray);
        }
    }

    void propagateParametes() {
        if (this.nLineLeadingFactor == -2) {
            this.nLineLeadingFactor = this.vParentRect != null ? this.vParentRect.nLineLeadingFactor : -1;
        }
        if (this.nTextAlignment < 0) {
            this.nTextAlignment = this.vParentRect != null ? this.vParentRect.nTextAlignment : 0;
        }
        if (this.ssTextShadow == null && this.vParentRect != null) {
            this.ssTextShadow = this.vParentRect.ssTextShadow;
        }
        boolean bl = this.bThumbnail;
        boolean bl2 = this.bRefCount;
        byte by = this.bTime;
        boolean bl3 = this.bRTB;
        V2CResRect[] v2CResRectArray = this.vlRects;
        if (v2CResRectArray != null) {
            for (int i = 0; i < v2CResRectArray.length; ++i) {
                V2CResRect v2CResRect = v2CResRectArray[i];
                if (bl) {
                    v2CResRect.bThumbnail = true;
                }
                if (bl2) {
                    v2CResRect.bRefCount = true;
                }
                if (by != 0) {
                    v2CResRect.bTime = by;
                }
                if (bl3) {
                    v2CResRect.bRTB = true;
                }
                v2CResRect.propagateParametes();
            }
        }
    }

    boolean checkHBOX() {
        if (this.nWidth > 0) {
            return false;
        }
        V2CResRect[] v2CResRectArray = this.vlRects;
        if (v2CResRectArray != null) {
            int n;
            int n2 = v2CResRectArray.length;
            if (!this.bVertical && n2 > 0) {
                int n3;
                n = -1;
                for (int i = n2 - 1; i >= 0; --i) {
                    n3 = v2CResRectArray[i].nWidth;
                    if (n3 < 0) {
                        return true;
                    }
                    if (n3 != 0) continue;
                    if (n >= 0) {
                        return true;
                    }
                    n = i;
                }
                if (n >= 0 && n < n2 - 1) {
                    V2CResRect[] v2CResRectArray2 = new V2CResRect[n2];
                    n3 = 0;
                    int n4 = 0;
                    for (int i = 0; i < n2; ++i) {
                        V2CResRect v2CResRect = v2CResRectArray[i];
                        if (i != n) {
                            v2CResRectArray2[n4++] = v2CResRect;
                        }
                        if (i <= n) continue;
                        n3 += v2CResRect.nWidth;
                    }
                    V2CResRect v2CResRect = v2CResRectArray[n];
                    v2CResRect.nRightSpace = n3;
                    v2CResRectArray2[n4] = v2CResRect;
                    this.vlRects = v2CResRectArray2;
                }
            }
            for (n = 0; n < n2; ++n) {
                if (!v2CResRectArray[n].checkHBOX()) continue;
                return true;
            }
        }
        return false;
    }

    void checkAutoMargin(boolean bl) {
        this.checkAutoMargin(bl, this.vlRects != null && !this.bVertical);
    }

    void checkAutoMargin(boolean bl, boolean bl2) {
        V2CResRect[] v2CResRectArray;
        if (this.nMarginLeft == -2147483647) {
            this.nMarginLeft = 0;
            if (bl) {
                this.bMarginLeftAuto = true;
            }
        }
        if (this.nMarginRight == -2147483647) {
            this.nMarginRight = 0;
            if (bl) {
                this.bMarginRightAuto = true;
            }
        }
        this.nHMarginPad = this.nMarginLeft + this.nPadLeft + this.nPadRight + this.nMarginRight;
        if (!bl2 && this.nWidth < 0) {
            this.nWidth = 0;
        }
        if ((v2CResRectArray = this.vlRects) != null) {
            int n = v2CResRectArray.length;
            for (int i = 0; i < n; ++i) {
                v2CResRectArray[i].checkAutoMargin(false, !this.bVertical);
            }
        }
    }

    boolean checkThumbnail() {
        block3: {
            block2: {
                V2CResRect[] v2CResRectArray = this.vlRects;
                if (this.vlRects == null) break block2;
                int n = v2CResRectArray.length;
                for (int i = 0; i < n; ++i) {
                    V2CResRect v2CResRect = v2CResRectArray[i];
                    if (!v2CResRect.checkThumbnail()) continue;
                    v2CResRect.bThumbnail = false;
                    v2CResRect.bRefCount = false;
                    v2CResRect.bTime = 0;
                    v2CResRect.bRTB = false;
                    return true;
                }
                break block3;
            }
            V2CHeaderTextSegment[] v2CHeaderTextSegmentArray = this.vlResElements;
            if (this.vlResElements == null) break block3;
            int n = v2CHeaderTextSegmentArray.length;
            for (int i = 0; i < n; ++i) {
                V2CHeaderTextSegment v2CHeaderTextSegment = v2CHeaderTextSegmentArray[i];
                if (v2CHeaderTextSegment.getType() != 0x40000000) continue;
                return true;
            }
        }
        return false;
    }

    boolean checkMinHeightFill() {
        if (this.bFillHeight) {
            return true;
        }
        V2CResRect[] v2CResRectArray = this.vlRects;
        if (this.vlRects != null) {
            int n = v2CResRectArray.length;
            for (int i = 0; i < n; ++i) {
                if (!v2CResRectArray[i].checkMinHeightFill()) continue;
                return true;
            }
        }
        return false;
    }

    boolean checkOverflow() {
        boolean[] blArray;
        boolean[] blArray2 = this.blBGOverflow;
        if (blArray2 != null) {
            for (int i = 0; i < blArray2.length; ++i) {
                if (!blArray2[i]) continue;
                return true;
            }
        }
        if ((blArray = this.blBDOverflow) != null && blArray[0]) {
            return true;
        }
        V2CResRect[] v2CResRectArray = this.vlRects;
        if (this.vlRects != null) {
            int n = v2CResRectArray.length;
            for (int i = 0; i < n; ++i) {
                if (!v2CResRectArray[i].checkOverflow()) continue;
                return true;
            }
        }
        return false;
    }

    void calcMinHeightFill(int[] nArray) {
        V2CResRect[] v2CResRectArray = this.vlRects;
        if (this.vlRects != null) {
            int n;
            int n2 = v2CResRectArray.length;
            int n3 = nArray[this.iSeqNum] - this.nMarginTop - this.nPadTop - this.nMarginBottom - this.nPadBottom;
            if (this.bVertical) {
                int n4;
                n = 0;
                int n5 = 0;
                for (n4 = 0; n4 < n2; ++n4) {
                    V2CResRect v2CResRect = v2CResRectArray[n4];
                    n += nArray[v2CResRect.iSeqNum];
                    if (!v2CResRect.bFillHeight) continue;
                    ++n5;
                }
                if (n5 > 0 && (n4 = n3 - n) > 0) {
                    for (int i = 0; i < n2; ++i) {
                        V2CResRect v2CResRect = v2CResRectArray[i];
                        if (!v2CResRect.bFillHeight) continue;
                        int n6 = n4 / n5;
                        int n7 = v2CResRect.iSeqNum;
                        nArray[n7] = nArray[n7] + n6;
                        n4 -= n6;
                        --n5;
                    }
                }
            } else {
                for (n = 0; n < n2; ++n) {
                    V2CResRect v2CResRect = v2CResRectArray[n];
                    if (!v2CResRect.bFillHeight) continue;
                    nArray[v2CResRectArray[n].iSeqNum] = n3;
                }
            }
            for (n = 0; n < n2; ++n) {
                v2CResRectArray[n].calcMinHeightFill(nArray);
            }
        }
    }

    int setSeqNum(int n) {
        this.iSeqNum = n++;
        V2CResRect[] v2CResRectArray = this.vlRects;
        if (v2CResRectArray != null) {
            for (int i = 0; i < v2CResRectArray.length; ++i) {
                n = v2CResRectArray[i].setSeqNum(n);
            }
        }
        return n;
    }

    final int getSeqNum() {
        return this.iSeqNum;
    }

    final boolean containsResNum() {
        return this.bContainsResNum;
    }

    final boolean containsMessage() {
        return this.bContainsMessage;
    }

    final boolean isRectContainer() {
        return this.vlRects != null;
    }

    final boolean isVertical() {
        return this.bVertical;
    }

    final V2CResRect[] getResRects() {
        return this.vlRects;
    }

    final V2CResRect[] getDrawResRects() {
        return this.vlDrawRects;
    }

    final V2CHeaderTextSegment[] getResElements() {
        return this.vlResElements;
    }

    void removeTextSegments(V2CHeaderTextSegment[] v2CHeaderTextSegmentArray) {
        V2CResRect[] v2CResRectArray = this.vlRects;
        if (this.vlRects != null) {
            int n = v2CResRectArray.length;
            for (int i = 0; i < n; ++i) {
                v2CResRectArray[i].removeTextSegments(v2CHeaderTextSegmentArray);
            }
        } else {
            V2CHeaderTextSegment[] v2CHeaderTextSegmentArray2 = this.vlResElements;
            if (this.vlResElements != null) {
                int n = v2CHeaderTextSegmentArray2.length;
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    V2CHeaderTextSegment v2CHeaderTextSegment = v2CHeaderTextSegmentArray2[i];
                    boolean bl = false;
                    for (int j = 0; j < v2CHeaderTextSegmentArray.length; ++j) {
                        if (v2CHeaderTextSegmentArray[j] != v2CHeaderTextSegment) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    v2CHeaderTextSegmentArray2[n2++] = v2CHeaderTextSegmentArray2[i];
                }
                if (n2 < n) {
                    V2CHeaderTextSegment[] v2CHeaderTextSegmentArray3;
                    if (n2 > 0) {
                        v2CHeaderTextSegmentArray3 = new V2CHeaderTextSegment[n2];
                        System.arraycopy(v2CHeaderTextSegmentArray2, 0, v2CHeaderTextSegmentArray3, 0, n2);
                    } else {
                        v2CHeaderTextSegmentArray3 = null;
                    }
                    this.vlResElements = v2CHeaderTextSegmentArray3;
                }
            }
        }
    }

    void setBackground(V2CSSColor v2CSSColor, V2CSSColorGradation v2CSSColorGradation, V2CVariableImage[] v2CVariableImageArray, V2CSSDistance[][] v2CSSDistanceArray, int[] objectArray, int[] objectArray2, boolean[] objectArray3, boolean bl, V2CStyleSheet v2CStyleSheet) {
        Object[] objectArray4;
        int n;
        boolean bl2;
        this.sscBackground = v2CSSColor;
        this.cBackground = v2CSSColor != null ? v2CSSColor.getColor() : null;
        this.cgBGGradation = v2CSSColorGradation;
        boolean bl3 = bl2 = v2CVariableImageArray != null && v2CVariableImageArray.length > 0;
        if (bl2) {
            this.vilBGImage = v2CVariableImageArray;
        }
        if (bl2 && v2CSSDistanceArray != null && (n = v2CSSDistanceArray.length) < v2CVariableImageArray.length) {
            objectArray4 = new V2CSSDistance[v2CVariableImageArray.length][];
            if (n > 1) {
                System.arraycopy(objectArray4, 0, v2CSSDistanceArray, 0, n);
            } else if (n == 1) {
                Arrays.fill(objectArray4, v2CSSDistanceArray[0]);
            }
            v2CSSDistanceArray = objectArray4;
        }
        if (v2CSSDistanceArray != null) {
            n = v2CSSDistanceArray.length;
            objectArray4 = new BGPos[n];
            for (int i = 0; i < n; ++i) {
                V2CSSDistance v2CSSDistance;
                V2CSSDistance[] v2CSSDistanceArray2 = v2CSSDistanceArray[i];
                if (v2CSSDistanceArray2 == null) continue;
                BGPos bGPos = new BGPos();
                V2CSSDistance v2CSSDistance2 = v2CSSDistanceArray2[0];
                if (v2CSSDistance2 != null) {
                    bGPos.bBGPosXPct = v2CSSDistance2.isPercent();
                    bGPos.fBGPosX = v2CStyleSheet.getValue(v2CSSDistance2);
                }
                if ((v2CSSDistance = v2CSSDistanceArray2[1]) != null) {
                    bGPos.bBGPosYPct = v2CSSDistance.isPercent();
                    bGPos.fBGPosY = v2CStyleSheet.getValue(v2CSSDistance);
                }
                objectArray4[i] = bGPos;
            }
            this.lBGPos = objectArray4;
        }
        if (bl2 && objectArray != null && (n = objectArray.length) < v2CVariableImageArray.length) {
            objectArray4 = new int[v2CVariableImageArray.length];
            if (n > 1) {
                System.arraycopy(objectArray4, 0, objectArray, 0, n);
            } else if (n == 1) {
                Arrays.fill((int[])objectArray4, objectArray[0]);
            }
            objectArray = objectArray4;
        }
        this.ilBGRepeat = objectArray;
        if (bl2 && objectArray2 != null && (n = objectArray2.length) < v2CVariableImageArray.length) {
            objectArray4 = new int[v2CVariableImageArray.length];
            if (n > 1) {
                System.arraycopy(objectArray4, 0, objectArray2, 0, n);
            } else if (n == 1) {
                Arrays.fill((int[])objectArray4, objectArray2[0]);
            }
            objectArray2 = objectArray4;
        }
        this.ilBGAttachment = objectArray2;
        if (bl2 && objectArray3 != null && (n = objectArray3.length) < v2CVariableImageArray.length) {
            objectArray4 = new boolean[v2CVariableImageArray.length];
            if (n > 1) {
                System.arraycopy(objectArray4, 0, objectArray3, 0, n);
            } else if (n == 1 && objectArray3[0]) {
                Arrays.fill((boolean[])objectArray4, true);
            }
            objectArray3 = objectArray4;
        }
        this.blBGOverflow = objectArray3;
        this.bIgnoreThreadBG = bl2 && !bl;
    }

    Color getBGColor() {
        return this.cBackground;
    }

    int getBGPosition(int n, int n2, int n3, boolean bl) {
        BGPos bGPos;
        BGPos[] bGPosArray = this.lBGPos;
        if (this.lBGPos == null || (bGPos = bGPosArray[n]) == null) {
            return 0;
        }
        boolean bl2 = bl ? bGPos.bBGPosYPct : bGPos.bBGPosXPct;
        float f = bl ? bGPos.fBGPosY : bGPos.fBGPosX;
        return (int)(bl2 ? (float)(n3 - n2) * f : f);
    }

    void setBorder(int[] nArray, int[] nArray2, V2CSSColor[] v2CSSColorArray, int[] nArray3, boolean[] blArray) {
        this.nlBorderWidth = nArray;
        this.nlBorderStyle = nArray2;
        this.ssclBorderColor = v2CSSColorArray;
        if (v2CSSColorArray != null) {
            int n = v2CSSColorArray.length;
            Color[] colorArray = new Color[n];
            for (int i = 0; i < n; ++i) {
                colorArray[i] = v2CSSColorArray[i].getColor();
            }
            this.clBorderColor = colorArray;
        } else {
            this.clBorderColor = null;
        }
        this.nlBorderRadius = nArray3;
        this.blBDOverflow = blArray;
    }

    void setTextProperties(Float f, int n, V2CSSTextShadow v2CSSTextShadow) {
        float f2;
        this.nLineLeadingFactor = f != null ? ((f2 = f.floatValue()) >= 1.0f ? (int)((f2 - 1.0f) * 256.0f) : -1) : -2;
        this.nTextAlignment = n;
        this.ssTextShadow = v2CSSTextShadow;
    }

    void setBorderImage(BufferedImage[] bufferedImageArray) {
        this.bilBorderImage = bufferedImageArray;
    }

    BufferedImage[] getBorderImage() {
        return this.bilBorderImage;
    }

    void setBorderImage(BufferedImage bufferedImage, V2CSSDistance[] v2CSSDistanceArray, int[] nArray, int[] nArray2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (v2CSSDistanceArray.length == 5) {
            this.bBDImgFill = true;
        }
        int[] nArray3 = new int[]{n2, n, n2, n};
        for (int i = 0; i < 4; ++i) {
            V2CSSDistance v2CSSDistance = v2CSSDistanceArray[i];
            int n3 = 0;
            if (v2CSSDistance == null) {
                return;
            }
            int n4 = nArray3[i];
            int n5 = v2CSSDistance.getUnit();
            if (n5 == 13) {
                n3 = Math.min((int)v2CSSDistance.getValue(), n4);
            } else if (n5 == 10) {
                n3 = Math.min((int)(v2CSSDistance.getValue() * (float)n4), n4);
            } else {
                return;
            }
            nArray3[i] = n3;
        }
        this.nlBDImgSlc = nArray3;
        BufferedImage[] bufferedImageArray = new BufferedImage[6];
        bufferedImageArray[0] = bufferedImage;
        this.bilBDImgSrc = bufferedImageArray;
        this.nlBDImgOS = nArray;
        if (nArray2 != null) {
            this.nBDImgRpt = nArray2[1] << 8 | nArray2[0];
        }
    }

    void setBox(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, boolean bl, Float f, V2CSSBoxShadow v2CSSBoxShadow) {
        if (nArray != null && nArray.length == 4) {
            this.nMarginTop = Math.max(nArray[0], 0);
            this.nMarginLeft = nArray[1];
            if (this.nMarginLeft < 0 && this.nMarginLeft != -2147483647) {
                this.nMarginLeft = 0;
            }
            this.nMarginBottom = Math.max(nArray[2], 0);
            this.nMarginRight = nArray[3];
            if (this.nMarginRight < 0 && this.nMarginRight != -2147483647) {
                this.nMarginRight = 0;
            }
        }
        if (nArray2 != null && nArray2.length == 4) {
            this.nPadTop = Math.max(nArray2[0], 0);
            this.nPadLeft = Math.max(nArray2[1], 0);
            this.nPadBottom = Math.max(nArray2[2], 0);
            this.nPadRight = Math.max(nArray2[3], 0);
        }
        if (n != 0) {
            this.nWidth = n;
        }
        if (n2 > 0) {
            this.nMinWidth0 = n2;
        }
        if (n3 > 0) {
            this.nMaxWidth = n3;
        }
        if (n4 > 0) {
            this.nMinHeight = n4;
        }
        if (bl) {
            this.bFillHeight = true;
        }
        if (f != null) {
            this.fOpacity = f.floatValue();
        }
        this.ssBoxShadow = v2CSSBoxShadow;
    }

    void setMarginOffsets(int[] nArray) {
        if (nArray != null && nArray.length == 2) {
            this.nTBMOfst = nArray[0];
            this.nBBMOfst = nArray[1];
        }
    }

    V2CResRect getRoot() {
        return this.vParentRect != null ? this.vParentRect.getRoot() : this;
    }

    int getStringLength(V2CResItem v2CResItem, V2CThreadItem v2CThreadItem) {
        return this.getCharIndex(v2CResItem, null, v2CThreadItem);
    }

    void userColorChanged() {
        block6: {
            int n;
            Object[] objectArray;
            block5: {
                V2CSSColor[] v2CSSColorArray;
                if (this.sscBackground != null) {
                    this.cBackground = this.sscBackground.getColor();
                }
                if ((v2CSSColorArray = this.ssclBorderColor) != null) {
                    int n2 = v2CSSColorArray.length;
                    objectArray = new Color[n2];
                    for (n = 0; n < n2; ++n) {
                        objectArray[n] = v2CSSColorArray[n].getColor();
                    }
                    this.clBorderColor = objectArray;
                }
                V2CResRect[] v2CResRectArray = this.vlRects;
                if (this.vlRects == null) break block5;
                n = v2CResRectArray.length;
                for (int i = 0; i < n; ++i) {
                    v2CResRectArray[i].userColorChanged();
                }
                break block6;
            }
            objectArray = this.vlResElements;
            if (this.vlResElements == null) break block6;
            n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                ((V2CHeaderTextSegment)objectArray[i]).userColorChanged();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasNoChar(V2CResItem v2CResItem) {
        if (this.bThumbnail) return true;
        if (this.bRefCount) {
            if (v2CResItem == null) return true;
            if (!V2CThreadStyle.getShowRefCount()) return true;
            if (v2CResItem.getRefCount() <= 0) return true;
        }
        if (this.bTime != 0) {
            if (v2CResItem == null) return true;
            if (this.bTime > 0) {
                if (v2CResItem.getTime() <= 0L) {
                    return true;
                }
            } else if (v2CResItem.getTime() > 0L) return true;
        }
        if (!this.bRTB) return false;
        if (v2CResItem == null) return true;
        if (v2CResItem.getRetweetName() != null) return false;
        return true;
    }

    int getCharIndex(V2CResItem v2CResItem, V2CTextSegment v2CTextSegment, V2CThreadItem v2CThreadItem) {
        int[] nArray = new int[]{0};
        boolean bl = this.getCharIndex(v2CResItem, v2CTextSegment, v2CThreadItem, nArray);
        return bl || v2CTextSegment == null ? nArray[0] : -1;
    }

    boolean getCharIndex(V2CResItem v2CResItem, V2CTextSegment v2CTextSegment, V2CThreadItem v2CThreadItem, int[] nArray) {
        if (this.hasNoChar(v2CResItem)) {
            return false;
        }
        V2CResRect[] v2CResRectArray = this.vlRects;
        if (this.vlRects != null) {
            int n = v2CResRectArray.length;
            for (int i = 0; i < n; ++i) {
                if (!v2CResRectArray[i].getCharIndex(v2CResItem, v2CTextSegment, v2CThreadItem, nArray)) continue;
                return true;
            }
        } else {
            V2CHeaderTextSegment[] v2CHeaderTextSegmentArray = this.vlResElements;
            if (this.vlResElements != null) {
                int n;
                int n2 = v2CHeaderTextSegmentArray.length;
                for (n = 0; n < n2; ++n) {
                    V2CHeaderTextSegment v2CHeaderTextSegment = v2CHeaderTextSegmentArray[n];
                    if (v2CHeaderTextSegment == v2CTextSegment) {
                        return true;
                    }
                    if (v2CHeaderTextSegment.getType() == 0x2000000) {
                        nArray[0] = nArray[0] + 1;
                        continue;
                    }
                    CharSequence charSequence = v2CResItem != null ? v2CHeaderTextSegment.getTextToDraw(v2CResItem, v2CThreadItem) : ((V2CTextSegment)v2CHeaderTextSegment).getString();
                    if (charSequence == null) continue;
                    nArray[0] = nArray[0] + charSequence.length();
                }
                if (n2 > 0) {
                    n = v2CHeaderTextSegmentArray[n2 - 1].getType();
                    boolean bl = true;
                    if (n == 0x4000000) {
                        if (n2 > 1) {
                            n = v2CHeaderTextSegmentArray[n2 - 2].getType();
                        } else {
                            bl = false;
                        }
                    }
                    if (bl) {
                        boolean bl2 = bl = n != 0x40000000 && n != 0x2000000;
                    }
                    if (bl) {
                        nArray[0] = nArray[0] + 1;
                    }
                }
            }
        }
        return false;
    }

    int getMessageCharIndex(V2CResItem v2CResItem, V2CThreadItem v2CThreadItem, boolean bl) {
        int[] nArray = new int[1];
        return this.getMessageCharIndex(v2CResItem, v2CThreadItem, nArray, bl) ? nArray[0] : -1;
    }

    boolean getMessageCharIndex(V2CResItem v2CResItem, V2CThreadItem v2CThreadItem, int[] nArray, boolean bl) {
        if (this.hasNoChar(v2CResItem)) {
            return false;
        }
        V2CResRect[] v2CResRectArray = this.vlRects;
        if (this.vlRects != null) {
            int n = v2CResRectArray.length;
            for (int i = 0; i < n; ++i) {
                if (!v2CResRectArray[i].getMessageCharIndex(v2CResItem, v2CThreadItem, nArray, bl)) continue;
                return true;
            }
        } else {
            V2CHeaderTextSegment[] v2CHeaderTextSegmentArray = this.vlResElements;
            if (this.vlResElements != null) {
                int n;
                int n2 = v2CHeaderTextSegmentArray.length;
                for (n = 0; n < n2; ++n) {
                    V2CHeaderTextSegment v2CHeaderTextSegment = v2CHeaderTextSegmentArray[n];
                    int n3 = v2CHeaderTextSegment.getType();
                    if (n3 == (bl ? 0x40000000 : 256)) {
                        return true;
                    }
                    if (n3 == 0x2000000) {
                        nArray[0] = nArray[0] + 1;
                        continue;
                    }
                    CharSequence charSequence = v2CHeaderTextSegment.getTextToDraw(v2CResItem, v2CThreadItem);
                    if (charSequence == null) continue;
                    nArray[0] = nArray[0] + charSequence.length();
                }
                if (n2 > 0) {
                    n = v2CHeaderTextSegmentArray[n2 - 1].getType();
                    boolean bl2 = true;
                    if (n == 0x4000000) {
                        if (n2 > 1) {
                            n = v2CHeaderTextSegmentArray[n2 - 2].getType();
                        } else {
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        boolean bl3 = bl2 = n != 0x40000000 && n != 0x2000000;
                    }
                    if (bl2) {
                        nArray[0] = nArray[0] + 1;
                    }
                }
            }
        }
        return false;
    }

    String getString(V2CResItem v2CResItem, V2CThreadItem v2CThreadItem) {
        StringBuffer stringBuffer = new StringBuffer();
        this.getString(v2CResItem, v2CThreadItem, stringBuffer);
        return stringBuffer.toString();
    }

    private void getString(V2CResItem v2CResItem, V2CThreadItem v2CThreadItem, StringBuffer stringBuffer) {
        if (this.hasNoChar(v2CResItem)) {
            return;
        }
        V2CResRect[] v2CResRectArray = this.vlRects;
        if (this.vlRects != null) {
            int n = v2CResRectArray.length;
            for (int i = 0; i < n; ++i) {
                v2CResRectArray[i].getString(v2CResItem, v2CThreadItem, stringBuffer);
            }
        } else {
            V2CHeaderTextSegment[] v2CHeaderTextSegmentArray = this.vlResElements;
            if (this.vlResElements != null) {
                int n;
                int n2 = v2CHeaderTextSegmentArray.length;
                for (n = 0; n < n2; ++n) {
                    V2CHeaderTextSegment v2CHeaderTextSegment = v2CHeaderTextSegmentArray[n];
                    if (v2CHeaderTextSegment.getType() == 0x2000000) {
                        stringBuffer.append('\n');
                        continue;
                    }
                    CharSequence charSequence = v2CHeaderTextSegment.getTextToDraw(v2CResItem, v2CThreadItem);
                    if (charSequence == null) continue;
                    if (V2CApp.javaVersionEqualOrGreaterThan(1, 5)) {
                        stringBuffer.append(charSequence);
                        continue;
                    }
                    stringBuffer.append(((Object)charSequence).toString());
                }
                if (n2 > 0) {
                    n = v2CHeaderTextSegmentArray[n2 - 1].getType();
                    boolean bl = true;
                    if (n == 0x4000000) {
                        if (n2 > 1) {
                            n = v2CHeaderTextSegmentArray[n2 - 2].getType();
                        } else {
                            bl = false;
                        }
                    }
                    if (bl) {
                        boolean bl2 = bl = n != 0x40000000 && n != 0x2000000;
                    }
                    if (bl) {
                        stringBuffer.append('\n');
                    }
                }
            }
        }
    }

    void calcAscent(V2CResItem v2CResItem) {
        block10: {
            int n;
            block9: {
                V2CResRect[] v2CResRectArray = this.vlRects;
                if (this.vlRects == null) break block9;
                int n2 = v2CResRectArray.length;
                for (int i = 0; i < n2; ++i) {
                    v2CResRectArray[i].calcAscent(v2CResItem);
                }
                break block10;
            }
            V2CHeaderTextSegment[] v2CHeaderTextSegmentArray = this.vlResElements;
            if (this.vlResElements == null) break block10;
            int n3 = 0;
            int n4 = 0;
            int n5 = v2CHeaderTextSegmentArray.length;
            for (n = 0; n < n5; ++n) {
                V2CSSFont[] v2CSSFontArray;
                int n6;
                V2CHeaderTextSegment v2CHeaderTextSegment = v2CHeaderTextSegmentArray[n];
                int n7 = v2CHeaderTextSegment.getType();
                if (n7 == 131072 && v2CHeaderTextSegment.getSubType() == 2) {
                    int n8 = V2CCheckBoxRenderer.getBoxHeight();
                    if (n8 <= n4) continue;
                    n4 = n8;
                    continue;
                }
                if (n7 == 0x400000) {
                    int n9;
                    if (!((V2CImageTextSegment)v2CHeaderTextSegment).checkID(v2CResItem) || (n9 = ((V2CImageTextSegment)v2CHeaderTextSegment).getHeight()) <= n4) continue;
                    n4 = n9;
                    continue;
                }
                if (n7 == 0x1000000) {
                    int n10 = V2CAbstractThreadPanel.nSNSAvatarSize;
                    if (n10 <= n4) continue;
                    n4 = n10;
                    continue;
                }
                if (n7 == 0x2000000) {
                    V2CSSFont[] v2CSSFontArray2;
                    if (n4 <= 0 && (v2CSSFontArray2 = v2CHeaderTextSegment.getFonts()) != null && (n6 = v2CSSFontArray2[0].nAscent) > n4) {
                        n4 = n6;
                    }
                    for (int i = n3; i <= n; ++i) {
                        v2CHeaderTextSegmentArray[i].setAscent(n4);
                    }
                    n3 = n + 1;
                    n4 = 0;
                    continue;
                }
                if (n7 == 0x40000000 || (v2CSSFontArray = v2CHeaderTextSegment.getFonts()) == null || (n6 = v2CSSFontArray[0].nAscent) <= n4) continue;
                n4 = n6;
            }
            for (n = n3; n < n5; ++n) {
                v2CHeaderTextSegmentArray[n].setAscent(n4);
            }
        }
    }

    boolean isAutoMargin() {
        return this.bMarginLeftAuto || this.bMarginRightAuto;
    }

    boolean isWidthLimited() {
        return this.nWidth != 0 || this.nMaxWidth > 0;
    }

    void calcWidths(int n, int[] nArray) {
        this.calcWidths(n, nArray, true);
    }

    void calcWidths(int n, int[] nArray, boolean bl) {
        int n2;
        int[] nArray2;
        boolean bl2;
        int n3;
        V2CResRect[] v2CResRectArray;
        int n4;
        block42: {
            int n5;
            int n6;
            int n7;
            n4 = this.nHMarginPad;
            if (bl) {
                if (this.nWidth > 0 && this.nWidth + n4 < n) {
                    n = this.nWidth + n4;
                }
                if (this.nMaxWidth > 0 && this.nMaxWidth + n4 < n) {
                    n = this.nMaxWidth + n4;
                }
                if (n < this.nMinFullWidth) {
                    n = this.nMinFullWidth;
                }
            }
            if (!this.isRectContainer()) {
                nArray[this.iSeqNum] = n;
                return;
            }
            int n8 = n - n4;
            v2CResRectArray = this.vlRects;
            n3 = v2CResRectArray.length;
            if (this.bVertical) {
                int n9;
                int n10 = n8;
                for (n9 = 0; n9 < n3; ++n9) {
                    V2CResRect v2CResRect = v2CResRectArray[n9];
                    v2CResRect.calcWidths(n10, nArray, true);
                    if (nArray[v2CResRect.iSeqNum] <= n10) continue;
                    n8 = nArray[v2CResRect.iSeqNum];
                }
                if (n8 > n10) {
                    for (n9 = 0; n9 < n3; ++n9) {
                        v2CResRectArray[n9].calcWidths(n8, nArray, true);
                    }
                }
                nArray[this.iSeqNum] = n8 + n4;
                return;
            }
            bl2 = V2CAbstractThreadPanel.bGroupThumbnail;
            nArray2 = new int[n3];
            int[] nArray3 = new int[n3];
            int n11 = 0;
            int n12 = n8;
            int n13 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                V2CResRect v2CResRect = v2CResRectArray[n2];
                if (!bl2 && v2CResRect.bThumbnail) continue;
                n7 = v2CResRect.nWidth;
                n6 = v2CResRect.nMinFullWidth;
                n5 = v2CResRect.nMaxWidth;
                nArray3[n2] = n6;
                if (n7 > 0) {
                    if (n5 > 0 && n7 > n5) {
                        n7 = n5;
                    }
                    if ((n7 += v2CResRect.nHMarginPad) < n6) {
                        n7 = n6;
                    }
                } else if (n7 < 0) {
                    n13 -= n7;
                    n7 = (int)((float)n * ((float)(-n7) / 10000.0f));
                    if (n5 > 0 && n7 > n5) {
                        n7 = n5;
                    }
                    if ((n7 += v2CResRect.nHMarginPad) < n6) {
                        n7 = n6;
                    }
                } else {
                    if (n5 <= 0 || n5 + v2CResRect.nHMarginPad > n6) {
                        ++n11;
                    }
                    n7 = n6;
                }
                n12 -= n7;
                nArray2[n2] = n7;
            }
            if (n12 > 0) {
                if (n11 > 0) {
                    while (n12 > 0 && n11 > 0) {
                        float f = (float)n12 / (float)n11;
                        int n14 = n11;
                        n11 = 0;
                        for (n7 = 0; n7 < n3; ++n7) {
                            V2CResRect v2CResRect = v2CResRectArray[n7];
                            if (!bl2 && v2CResRect.bThumbnail || v2CResRect.nWidth != 0) continue;
                            n5 = v2CResRect.nMaxWidth;
                            int n15 = v2CResRect.nHMarginPad;
                            int n16 = nArray2[n7];
                            if (n5 > 0 && n16 >= n5 + n15) continue;
                            int n17 = n12 - (int)(f * (float)(--n14));
                            if (n5 > 0 && n16 + n17 > n5 + n15) {
                                n17 = n5 + n15 - n16;
                            } else {
                                ++n11;
                            }
                            nArray2[n7] = n16 + n17;
                            n12 -= n17;
                        }
                    }
                } else if (n13 > 0) {
                    int n18;
                    n2 = 0;
                    for (n18 = n3 - 1; n18 >= 0; --n18) {
                        V2CResRect v2CResRect = v2CResRectArray[n18];
                        if (!bl2 && v2CResRect.bThumbnail || (n6 = v2CResRect.nWidth) == 0) continue;
                        n5 = (v2CResRect.nMarginLeft + v2CResRect.nPadLeft + v2CResRect.nPadRight + v2CResRect.nMarginRight) * 10000;
                        if (n6 > 0) {
                            n2 += n6 * 10000 + n5;
                            continue;
                        }
                        if (n6 >= 0) continue;
                        n2 += -n * n6 + n5;
                    }
                    if (n2 >= n8 * 10000) {
                        for (n18 = n3 - 1; n18 >= 0; --n18) {
                            V2CResRect v2CResRect = v2CResRectArray[n18];
                            if (!bl2 && v2CResRect.bThumbnail || (n6 = v2CResRect.nWidth) >= 0) continue;
                            int n19 = n18;
                            nArray2[n19] = nArray2[n19] + 1;
                            if (--n12 > 0) {
                                continue;
                            }
                            break;
                        }
                    }
                }
            } else if (n12 < 0 && n13 > 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    for (int i = 0; i < n3; ++i) {
                        V2CResRect v2CResRect = v2CResRectArray[i];
                        if (!bl2 && v2CResRect.bThumbnail || (n6 = v2CResRect.nWidth) >= 0) continue;
                        n5 = nArray2[i] - nArray3[i];
                        if (n5 > 0) {
                            if ((n5 = -((int)((float)n5 * (float)n6 / (float)n13))) == 0) {
                                n5 = 1;
                            }
                            if (n12 + n5 > 0) {
                                n5 = -n12;
                            }
                            int n20 = i;
                            nArray2[n20] = nArray2[n20] - n5;
                            if ((n12 += n5) < 0) continue;
                            break;
                        }
                        if ((n13 += n6) > 0) {
                            continue;
                        }
                        break block42;
                    }
                    if (n12 < 0) {
                        continue;
                    }
                    break;
                }
            }
        }
        n2 = 0;
        for (int i = 0; i < n3; ++i) {
            V2CResRect v2CResRect = v2CResRectArray[i];
            if (!bl2 && v2CResRect.bThumbnail) continue;
            v2CResRect.calcWidths(nArray2[i], nArray, false);
            n2 += nArray[v2CResRect.iSeqNum];
        }
        nArray[this.iSeqNum] = n2 + n4;
    }

    int getMinFullWidth() {
        return this.nMinFullWidth;
    }

    int calcMinFullWidth() {
        int n;
        int n2 = this.nHMarginPad;
        int n3 = 0;
        V2CResRect[] v2CResRectArray = this.vlRects;
        if (this.vlRects != null) {
            n3 = V2CResRect.calcMinFullWidth(v2CResRectArray, this.bVertical);
        } else {
            V2CHeaderTextSegment[] v2CHeaderTextSegmentArray = this.vlResElements;
            if (this.vlResElements != null) {
                if (this.nMinWidth0 > 0) {
                    n3 = this.nMinWidth0;
                } else {
                    n = 0;
                    for (int i = 0; i < v2CHeaderTextSegmentArray.length; ++i) {
                        int n4 = v2CHeaderTextSegmentArray[i].getType();
                        if (n4 != 0x40000000) continue;
                        n = 1;
                        break;
                    }
                    int n5 = n3 = n != 0 ? 200 : 30;
                }
            }
        }
        if (n3 < this.nMinWidth0) {
            n3 = this.nMinWidth0;
        }
        if ((n = this.nWidth) > 0) {
            if (this.nMaxWidth > 0 && this.nMaxWidth < n) {
                n = this.nMaxWidth;
            }
            if (n3 < n) {
                n3 = n;
            }
        }
        this.nMinFullWidth = n3 += n2;
        return n3;
    }

    V2CResRect getRectAt(int n, int n2, int[] nArray, int[] nArray2) {
        V2CResRect[] v2CResRectArray = this.vlRects;
        if (this.vlRects != null) {
            int n3 = v2CResRectArray.length;
            if (n3 == 0) {
                return null;
            }
            if (this.bVertical) {
                int n4 = 0;
                int n5 = 0;
                V2CResRect v2CResRect = null;
                for (int i = 0; i < n3; ++i) {
                    v2CResRect = v2CResRectArray[i];
                    n5 = n4;
                    if (n2 <= (n4 += nArray2[v2CResRect.getSeqNum()])) break;
                }
                return v2CResRect.getRectAt(n, n2 - n5, nArray, nArray2);
            }
            int n6 = 0;
            int n7 = 0;
            V2CResRect v2CResRect = null;
            for (int i = 0; i < n3; ++i) {
                v2CResRect = v2CResRectArray[i];
                n7 = n6;
                if (n <= (n6 += nArray[v2CResRect.getSeqNum()])) break;
            }
            return v2CResRect.getRectAt(n - n7, n2, nArray, nArray2);
        }
        V2CHeaderTextSegment[] v2CHeaderTextSegmentArray = this.vlResElements;
        if (this.vlResElements != null) {
            return this;
        }
        return null;
    }

    private static class BGPos {
        boolean bBGPosXPct;
        boolean bBGPosYPct;
        float fBGPosX;
        float fBGPosY;

        private BGPos() {
        }
    }
}

