/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadPanel;

public class V2CRefRankingPanel
implements ActionListener,
ListSelectionListener,
WindowListener {
    private static final String sCondKey = "ThreadView.RefRankCond";
    static String[] slColNames = new String[]{"\u88ab\u53c2\u7167\u6570", "\u30ec\u30b9"};
    V2CThreadPanel vThreadPanel;
    JDialog jDialog;
    JTable jTable;
    RefRankingTableModel tmRefRanking;
    JButton jbClose;
    JButton jbFilter;
    static /* synthetic */ Class class$java$lang$String;

    static V2CRefRankingPanel showPanel(V2CThreadPanel v2CThreadPanel) {
        V2CRefRankingPanel v2CRefRankingPanel = new V2CRefRankingPanel(v2CThreadPanel);
        v2CRefRankingPanel.showDialog();
        return v2CRefRankingPanel;
    }

    static RefEntry[] createRankingArray(V2CThreadPanel v2CThreadPanel) {
        int n;
        int[] nArray = v2CThreadPanel.getThreadRes().createRefCountArray();
        int n2 = nArray.length;
        ArrayList<RefEntry> arrayList = new ArrayList<RefEntry>();
        for (n = 0; n < n2; ++n) {
            if (nArray[n] <= 0) continue;
            arrayList.add(new RefEntry(n, nArray[n]));
        }
        n = arrayList.size();
        if (n == 0) {
            return new RefEntry[0];
        }
        RefEntry[] refEntryArray = arrayList.toArray(new RefEntry[n]);
        Arrays.sort(refEntryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((RefEntry)object2).iRefCount - ((RefEntry)object).iRefCount;
            }
        });
        return refEntryArray;
    }

    public V2CRefRankingPanel(V2CThreadPanel v2CThreadPanel) {
        JButton jButton;
        Serializable serializable;
        JTable jTable;
        JDialog jDialog;
        this.jDialog = jDialog = new JDialog(V2CMain.v2cMain, "\u88ab\u53c2\u7167\u6570\u30e9\u30f3\u30ad\u30f3\u30b0\uff1a " + v2CThreadPanel.getThreadItem().getTitle(), false);
        jDialog.setDefaultCloseOperation(2);
        V2CSwingUtil.registerESCToDialog(jDialog);
        jDialog.addWindowListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jDialog.setContentPane(jPanel);
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.vThreadPanel = v2CThreadPanel;
        this.tmRefRanking = new RefRankingTableModel(V2CRefRankingPanel.createRankingArray(v2CThreadPanel));
        this.jTable = jTable = new JTable(this.tmRefRanking);
        jTable.setSelectionMode(0);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                this.setHorizontalAlignment(n2 == 0 ? 0 : 2);
                return this;
            }
        };
        jTable.getSelectionModel().addListSelectionListener(this);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int[] nArray = new int[]{50, 350};
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            serializable = tableColumnModel.getColumn(i);
            ((TableColumn)serializable).setCellRenderer(defaultTableCellRenderer);
            ((TableColumn)serializable).setPreferredWidth(nArray[i]);
        }
        jTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                V2CRefRankingPanel.this.showResNumber();
            }
        });
        V2CSwingUtil.setTableRowHeight(jTable);
        V2CSwingUtil.ensureTableColumnWidths(jTable);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)new JLabel("\uff08\u9078\u629e\u3055\u308c\u305f\u88ab\u53c2\u7167\u6570\u4ee5\u4e0a\u306e\u30ec\u30b9\u3092\u62bd\u51fa\uff09"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        serializable = new JButton(" \u62bd\u51fa ");
        this.jbFilter = serializable;
        ((Component)serializable).setFocusable(false);
        ((AbstractButton)serializable).addActionListener(this);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)serializable, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jbClose = jButton = new JButton("\u9589\u3058\u308b");
        jButton.setFocusable(false);
        jButton.addActionListener(this);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jButton, gridBagConstraints);
    }

    void showDialog() {
        Point point;
        JDialog jDialog = this.jDialog;
        V2CPackedPropValue v2CPackedPropValue = V2CApp.getUserProperty().getPackedValue(sCondKey);
        Point point2 = point = v2CPackedPropValue != null ? v2CPackedPropValue.getPoint('P') : null;
        if (point != null) {
            V2CSwingUtil.checkWindowPosition(point);
            jDialog.setLocation(point);
        }
        jDialog.pack();
        jDialog.setVisible(true);
    }

    void closeDialog() {
        this.jDialog.dispose();
    }

    void showResNumber() {
        int n = this.jTable.getSelectedRow();
        if (n >= 0) {
            this.vThreadPanel.showResNumber(this.tmRefRanking.getResNumber(n));
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.showResNumber();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbFilter) {
            int n = this.jTable.getSelectedRow();
            if (n >= 0) {
                this.vThreadPanel.filterResOfRefCountGE(this.tmRefRanking.getRefEntry((int)n).iRefCount);
            }
            this.jDialog.dispose();
        } else if (object == this.jbClose) {
            this.jDialog.dispose();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
        v2CPackedPropValue.setPoint('P', this.jDialog.getLocation());
        V2CApp.getUserProperty().putPackedValue(sCondKey, v2CPackedPropValue);
        this.vThreadPanel.refRankingPanelClosed();
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private class RefRankingTableModel
    extends AbstractTableModel {
        RefEntry[] lRefEntry;

        RefRankingTableModel(RefEntry[] refEntryArray) {
            this.lRefEntry = refEntryArray;
        }

        int getResNumber(int n) {
            return this.lRefEntry[n].iRes;
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = V2CRefRankingPanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getRowCount() {
            return this.lRefEntry.length;
        }

        public int getColumnCount() {
            return slColNames.length;
        }

        RefEntry getRefEntry(int n) {
            return this.lRefEntry[n];
        }

        public String getColumnName(int n) {
            return slColNames[n];
        }

        public Object getValueAt(int n, int n2) {
            RefEntry refEntry = this.lRefEntry[n];
            switch (n2) {
                case 0: {
                    return refEntry.getRefCountString();
                }
                case 1: {
                    return refEntry.getMessageHeader(V2CRefRankingPanel.this.vThreadPanel);
                }
            }
            return null;
        }
    }

    private static class RefEntry {
        int iRes;
        int iRefCount;
        String sResNum;
        String sHeader;

        RefEntry(int n, int n2) {
            this.iRes = n;
            this.iRefCount = n2;
        }

        String getRefCountString() {
            if (this.sResNum == null) {
                this.sResNum = String.valueOf(this.iRefCount);
            }
            return this.sResNum;
        }

        String getMessageHeader(V2CThreadPanel v2CThreadPanel) {
            if (this.sHeader == null) {
                this.sHeader = v2CThreadPanel.getMessageHeaderString(this.iRes);
            }
            return this.sHeader;
        }
    }
}

