/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CJ2SE5Util;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CProxyItem;
import org.monazilla.v2c.V2CProxyScript;
import org.monazilla.v2c.V2CProxySettingPanel;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CProxySetting {
    private static final boolean bDebug = false;
    static final String sKeyPrefix = "Proxy.";
    static final String sUseSystemSettingKey = "Proxy.UseSystemSetting";
    static final String sProxySetKey = "proxySet";
    static final String sHttpProxyHostKey = "http.proxyHost";
    static final String sHttpProxyPortKey = "http.proxyPort";
    static final String sHttpsProxyHostKey = "https.proxyHost";
    static final String sHttpsProxyPortKey = "https.proxyPort";
    static final String sProxySet;
    static final String sHttpProxyHost;
    static final String sHttpProxyPort;
    static final String sHttpsProxyHost;
    static final String sHttpsProxyPort;
    static final MyAuthenticator myAuth;
    static final boolean bUseProperty;
    static V2CProxySetting vpsReadProxySetting;
    static V2CProxySetting vpsWriteProxySetting;
    static boolean bUseSystemSetting;
    static boolean bNeedSynch;
    private static Vector vProxyItems;
    private static boolean bProxyItemsRestored;
    final String sUseProxyKey;
    final String sHostKey;
    final String sPortKey;
    final String sIDKey;
    final String sPWKey;
    boolean bProxyUsed;
    String sHost;
    InetAddress iAddress;
    int nPort;
    String sID;
    String sPW;
    volatile int nProcs;

    static PasswordAuthentication getProxyPasswordAuth(InetAddress inetAddress, int n) {
        return V2CProxySetting.getUseProxySetting() ? myAuth.getPasswordAuthentication(inetAddress, n) : null;
    }

    static Vector getProxyItems() {
        Vector<V2CProxyItem> vector;
        if (bUseProperty) {
            return null;
        }
        if (bProxyItemsRestored) {
            return vProxyItems;
        }
        bProxyItemsRestored = true;
        Object var0 = null;
        String string = V2CLocalFileHandler.restoreFromFile(V2CLocalFileHandler.getUserConfigFile("Proxy.txt"));
        if (string != null && string.length() > 0) {
            vector = new Vector<V2CProxyItem>();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            vector.add(new V2CProxyItem());
            try {
                String string2;
                Matcher matcher = Pattern.compile("([\\dA-Za-z.-]+)(?::(\\d+))?(?:\\s|$)").matcher("");
                while ((string2 = bufferedReader.readLine()) != null) {
                    int n;
                    if ((string2 = string2.trim()).equalsIgnoreCase("[Write]")) continue;
                    matcher.reset(string2);
                    if (!matcher.lookingAt() || (n = V2CMiscUtil.parseInt(matcher.group(2))) <= 0 || n > 65535) continue;
                    vector.add(new V2CProxyItem(matcher.group(1), n, string2.substring(matcher.end())));
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (vector.size() <= 1) {
                vector = null;
            }
        } else {
            vector = null;
        }
        vProxyItems = vector;
        return vector;
    }

    static void createSettings() {
        bUseSystemSetting = V2CApp.getUserProperty().getBoolean(sUseSystemSettingKey, V2CApp.isMacintosh());
        vpsReadProxySetting = new V2CProxySetting("Read");
        vpsWriteProxySetting = new V2CProxySetting("Write");
        V2CProxySetting.resetStates();
    }

    static boolean getUseSystemSetting() {
        return bUseSystemSetting;
    }

    static boolean getUseProxySetting() {
        return !bUseSystemSetting && (V2CProxySetting.vpsReadProxySetting.bProxyUsed || V2CProxySetting.vpsWriteProxySetting.bProxyUsed);
    }

    static boolean isO2onUsed() {
        if (!V2CApp.isWinType()) {
            return false;
        }
        V2CProxySetting v2CProxySetting = vpsReadProxySetting;
        if (!v2CProxySetting.bProxyUsed) {
            return false;
        }
        String string = v2CProxySetting.sHost;
        return string != null && (string.equals("127.0.0.1") || string.equals("localhost"));
    }

    static void setUseSystemSetting(boolean bl) {
        if (bUseSystemSetting != bl) {
            bUseSystemSetting = bl;
            V2CMain.getUserProperty().putBoolean(sUseSystemSettingKey, bl);
        }
    }

    static void resetStates() {
        V2CProxySetting.checkNeedSynch();
        myAuth.resetIDPW();
    }

    static void checkNeedSynch() {
        boolean bl;
        V2CProxySetting v2CProxySetting = vpsReadProxySetting;
        V2CProxySetting v2CProxySetting2 = vpsWriteProxySetting;
        boolean bl2 = true;
        if (bUseSystemSetting) {
            bl2 = false;
            bl = false;
        } else {
            if (v2CProxySetting.bProxyUsed && v2CProxySetting2.bProxyUsed && v2CProxySetting.sHost.equals(v2CProxySetting2.sHost) && v2CProxySetting.nPort == v2CProxySetting2.nPort && (!v2CProxySetting.sID.equals(v2CProxySetting2.sID) || !v2CProxySetting.sPW.equals(v2CProxySetting2.sPW))) {
                V2CSwingUtil.showErrorMessage("\u8aad\u307f\u8fbc\u307f\u30fb\u66f8\u304d\u8fbc\u307fProxy\u306e\nID\u307e\u305f\u306f\u30d1\u30b9\u30ef\u30fc\u30c9\u3060\u3051\u3092\n\u9055\u3046\u8a2d\u5b9a\u306b\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                v2CProxySetting2.sID = v2CProxySetting.sID;
                v2CProxySetting2.sPW = v2CProxySetting.sPW;
            }
            if (bUseProperty) {
                bl = true;
                if (v2CProxySetting.bProxyUsed) {
                    if (v2CProxySetting2.bProxyUsed && v2CProxySetting.sHost.equals(v2CProxySetting2.sHost) && v2CProxySetting.nPort == v2CProxySetting2.nPort && v2CProxySetting.sID.equals(v2CProxySetting2.sID) && v2CProxySetting.sPW.equals(v2CProxySetting2.sPW)) {
                        bl2 = false;
                        bl = false;
                        v2CProxySetting.setProperty();
                    }
                } else if (!v2CProxySetting2.bProxyUsed) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        bNeedSynch = bl;
        if (bl2) {
            V2CProxySetting.reset();
        }
    }

    static void showSettingPanel() {
        boolean bl = bUseSystemSetting;
        V2CProxySettingPanel v2CProxySettingPanel = new V2CProxySettingPanel(vpsReadProxySetting, vpsWriteProxySetting);
        if (!v2CProxySettingPanel.showPanel()) {
            return;
        }
        V2CProxySetting.resetStates();
        vpsReadProxySetting.save();
        vpsWriteProxySetting.save();
    }

    static HttpURLConnection openReadConnection(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection;
        if (bUseProperty) {
            if (bNeedSynch) {
                V2CProxySetting.setReadProxy();
            }
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        } else {
            V2CProxySetting v2CProxySetting = vpsReadProxySetting;
            V2CProxyItem v2CProxyItem = null;
            if (!bUseSystemSetting && v2CProxySetting.bProxyUsed) {
                v2CProxyItem = new V2CProxyItem(v2CProxySetting.sHost, v2CProxySetting.nPort);
            }
            if (V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
                v2CProxyItem = V2CProxyScript.checkProxy(uRL, v2CProxyItem);
            }
            httpURLConnection = v2CProxyItem != null ? V2CJ2SE5Util.openConnection(uRL, v2CProxyItem.sHost, v2CProxyItem.nPort) : (HttpURLConnection)uRL.openConnection();
        }
        httpURLConnection.setUseCaches(false);
        return httpURLConnection;
    }

    static HttpURLConnection openWriteConnection(URL uRL) throws IOException {
        return V2CProxySetting.openWriteConnection(uRL, null);
    }

    static HttpURLConnection openWriteConnection(URL uRL, V2CProxyItem v2CProxyItem) throws IOException {
        HttpURLConnection httpURLConnection;
        if (bUseProperty) {
            if (bNeedSynch) {
                V2CProxySetting.setWriteProxy();
            }
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        } else {
            if (v2CProxyItem == null) {
                V2CProxySetting v2CProxySetting = vpsWriteProxySetting;
                if (!bUseSystemSetting && v2CProxySetting.bProxyUsed) {
                    v2CProxyItem = new V2CProxyItem(v2CProxySetting.sHost, v2CProxySetting.nPort);
                }
                if (V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
                    v2CProxyItem = V2CProxyScript.checkProxy(uRL, v2CProxyItem);
                }
            }
            httpURLConnection = v2CProxyItem != null ? V2CJ2SE5Util.openConnection(uRL, v2CProxyItem.sHost, v2CProxyItem.nPort) : (HttpURLConnection)uRL.openConnection();
        }
        httpURLConnection.setUseCaches(false);
        return httpURLConnection;
    }

    private static synchronized void setReadProxy() {
        while (V2CProxySetting.vpsWriteProxySetting.nProcs > 0) {
            try {
                (class$org$monazilla$v2c$V2CProxySetting == null ? V2CProxySetting.class$("org.monazilla.v2c.V2CProxySetting") : class$org$monazilla$v2c$V2CProxySetting).wait();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        vpsReadProxySetting.inc();
    }

    private static synchronized void setWriteProxy() {
        while (V2CProxySetting.vpsReadProxySetting.nProcs > 0) {
            try {
                (class$org$monazilla$v2c$V2CProxySetting == null ? V2CProxySetting.class$("org.monazilla.v2c.V2CProxySetting") : class$org$monazilla$v2c$V2CProxySetting).wait();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        vpsWriteProxySetting.inc();
    }

    static void resetReadProxy() {
        if (bUseProperty && bNeedSynch) {
            vpsReadProxySetting.dec();
        }
    }

    static void resetWriteProxy() {
        if (bUseProperty && bNeedSynch) {
            vpsWriteProxySetting.dec();
        }
    }

    static void reset() {
        System.setProperty(sProxySetKey, "false");
        System.setProperty(sHttpProxyHostKey, "");
        System.setProperty(sHttpsProxyHostKey, "");
        Authenticator.setDefault(null);
    }

    static void restore() {
        System.setProperty(sProxySetKey, sProxySet);
        System.setProperty(sHttpProxyHostKey, sHttpProxyHost);
        System.setProperty(sHttpProxyPortKey, sHttpProxyPort);
        System.setProperty(sHttpsProxyHostKey, sHttpsProxyHost);
        System.setProperty(sHttpsProxyPortKey, sHttpsProxyPort);
        Authenticator.setDefault(null);
    }

    public V2CProxySetting(String string) {
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        this.sUseProxyKey = "Proxy.Use" + string + "Proxy";
        this.sHostKey = sKeyPrefix + string + "Host";
        this.sPortKey = sKeyPrefix + string + "Port";
        this.sIDKey = sKeyPrefix + string + "ID";
        this.sPWKey = sKeyPrefix + string + "PW";
        this.bProxyUsed = v2CProperty.getBoolean(this.sUseProxyKey);
        this.sHost = v2CProperty.get(this.sHostKey, "");
        this.nPort = v2CProperty.getInt(this.sPortKey);
        this.sID = v2CProperty.get(this.sIDKey, "");
        if (this.sID.length() > 0) {
            this.sID = V2CMiscUtil.hexDecode(this.sID);
        }
        this.sPW = v2CProperty.get(this.sPWKey, "");
        if (this.sPW.length() > 0) {
            this.sPW = V2CMiscUtil.hexDecode(this.sPW);
        }
    }

    void setProperty() {
        String string = this.nPort > 0 ? String.valueOf(this.nPort) : "";
        System.setProperty(sProxySetKey, "true");
        System.setProperty(sHttpProxyHostKey, this.sHost);
        System.setProperty(sHttpProxyPortKey, string);
        System.setProperty(sHttpsProxyHostKey, this.sHost);
        System.setProperty(sHttpsProxyPortKey, string);
    }

    void inc() {
        if (!this.bProxyUsed) {
            V2CProxySetting.reset();
            return;
        }
        if (this.nProcs == 0) {
            this.setProperty();
        }
        ++this.nProcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dec() {
        if (!this.bProxyUsed) {
            return;
        }
        Class clazz = V2CProxySetting.class;
        synchronized (clazz) {
            --this.nProcs;
            if (this.nProcs == 0) {
                V2CProxySetting.class.notifyAll();
            }
        }
    }

    void save() {
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        v2CProperty.putBoolean(this.sUseProxyKey, this.bProxyUsed);
        if (this.sHost != null && this.sHost.length() > 0) {
            v2CProperty.put(this.sHostKey, this.sHost);
        } else {
            v2CProperty.remove(this.sHostKey);
        }
        if (this.nPort > 0) {
            v2CProperty.putInt(this.sPortKey, this.nPort);
        } else {
            v2CProperty.remove(this.sPortKey);
        }
        if (this.sID != null && this.sID.length() > 0) {
            v2CProperty.put(this.sIDKey, V2CMiscUtil.hexEncode(this.sID));
        } else {
            v2CProperty.remove(this.sIDKey);
        }
        if (this.sPW != null && this.sPW.length() > 0) {
            v2CProperty.put(this.sPWKey, V2CMiscUtil.hexEncode(this.sPW));
        } else {
            v2CProperty.remove(this.sPWKey);
        }
    }

    boolean proxyUsed() {
        return this.bProxyUsed;
    }

    String getHost() {
        return this.sHost;
    }

    InetAddress getSite() {
        if (this.bProxyUsed && this.iAddress == null && this.sHost.length() > 0) {
            try {
                this.iAddress = InetAddress.getByName(this.sHost);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.iAddress;
    }

    int getPort() {
        return this.nPort;
    }

    String getID() {
        return this.sID;
    }

    String getPW() {
        return this.sPW;
    }

    void setProxyUsed(boolean bl) {
        this.bProxyUsed = bl;
    }

    void setHost(String string) {
        this.sHost = string != null ? string : "";
        this.iAddress = null;
    }

    void setPort(int n) {
        this.nPort = n;
    }

    void setID(String string) {
        this.sID = string;
    }

    void setPW(String string) {
        this.sPW = string;
    }

    static {
        String string = System.getProperty(sProxySetKey);
        sProxySet = string != null ? string : "";
        string = System.getProperty(sHttpProxyHostKey);
        sHttpProxyHost = string != null ? string : "";
        string = System.getProperty(sHttpProxyPortKey);
        sHttpProxyPort = string != null ? string : "";
        string = System.getProperty(sHttpsProxyHostKey);
        sHttpsProxyHost = string != null ? string : "";
        string = System.getProperty(sHttpsProxyPortKey);
        sHttpsProxyPort = string != null ? string : "";
        myAuth = new MyAuthenticator();
        bUseProperty = V2CApp.javaVersionLessThan(1, 5);
    }

    private static class MyAuthenticator {
        PasswordAuthentication paRead;
        PasswordAuthentication paWrite;

        private MyAuthenticator() {
        }

        void resetIDPW() {
            this.paRead = MyAuthenticator.createPasswordAuthentication(vpsReadProxySetting);
            this.paWrite = MyAuthenticator.createPasswordAuthentication(vpsWriteProxySetting);
        }

        private static PasswordAuthentication createPasswordAuthentication(V2CProxySetting v2CProxySetting) {
            String string;
            if (bUseSystemSetting || !v2CProxySetting.bProxyUsed) {
                return null;
            }
            String string2 = v2CProxySetting.sID;
            if (string2 == null) {
                string2 = "";
            }
            char[] cArray = (string = v2CProxySetting.sPW) != null ? string.toCharArray() : new char[]{};
            return new PasswordAuthentication(string2, cArray);
        }

        private static boolean checkHostAndPort(V2CProxySetting v2CProxySetting, InetAddress inetAddress, int n) {
            if (!v2CProxySetting.bProxyUsed) {
                return false;
            }
            InetAddress inetAddress2 = v2CProxySetting.getSite();
            return inetAddress2 != null && inetAddress2.equals(inetAddress) && n == v2CProxySetting.nPort;
        }

        PasswordAuthentication getPasswordAuthentication(InetAddress inetAddress, int n) {
            if (inetAddress == null) {
                return null;
            }
            if (MyAuthenticator.checkHostAndPort(vpsReadProxySetting, inetAddress, n)) {
                return this.paRead;
            }
            if (MyAuthenticator.checkHostAndPort(vpsWriteProxySetting, inetAddress, n)) {
                return this.paWrite;
            }
            return null;
        }
    }
}

