/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CPersistentState;
import org.monazilla.v2c.V2CPropertyOwner;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CProperty
implements V2CPersistentState {
    static Color cDefaultColor = Color.GRAY;
    V2CPropertyOwner vpOwner;
    V2CPropertyOwner vpoParent;
    private final HashMap hmProperties = new HashMap();
    File fFile;
    String sFileName;
    File fParentFolder;
    String sCharset;
    boolean bSystem;
    boolean bReadOnly;
    volatile boolean bChanged;
    long lSaveRequestTime;

    static V2CProperty createSettingTxtProperty(File file, V2CBoardItem v2CBoardItem, String string) {
        return new V2CProperty(file, v2CBoardItem, null, string, v2CBoardItem.getBoardDir());
    }

    public V2CProperty(boolean bl) {
        this.bReadOnly = bl;
    }

    public V2CProperty(String string) {
        if (string != null && string.length() > 0) {
            this.restore(new BufferedReader(new StringReader(string)));
        }
    }

    public V2CProperty(String string, V2CPropertyOwner v2CPropertyOwner) {
        this.vpOwner = v2CPropertyOwner;
        this.sFileName = string;
        this.fParentFolder = V2CLocalFileHandler.getV2CDir();
        this.fFile = V2CLocalFileHandler.getUserConfigFile(string);
        this.sCharset = "UTF-8";
        this.bSystem = true;
        this.restore((String)null);
    }

    public V2CProperty(File file) {
        this(file, null, null, "UTF-8", null);
    }

    public V2CProperty(File file, V2CPropertyOwner v2CPropertyOwner, V2CPropertyOwner v2CPropertyOwner2) {
        this(file, v2CPropertyOwner, v2CPropertyOwner2, "UTF-8", null);
    }

    public V2CProperty(File file, V2CPropertyOwner v2CPropertyOwner, V2CPropertyOwner v2CPropertyOwner2, String string) {
        this(file, v2CPropertyOwner, v2CPropertyOwner2, string, null);
    }

    private V2CProperty(File file, V2CPropertyOwner v2CPropertyOwner, V2CPropertyOwner v2CPropertyOwner2, String string, String string2) {
        this.vpOwner = v2CPropertyOwner;
        this.vpoParent = v2CPropertyOwner2;
        if (file != null) {
            File file2;
            this.fFile = file;
            String string3 = file.getName();
            if (string3 != null && string3.endsWith(".txt") && (file2 = file.getParentFile()) != null) {
                this.sFileName = string3;
                this.fParentFolder = file2;
            }
            this.sCharset = string;
            this.restore(string2);
        }
    }

    HashMap createMap() {
        return new HashMap(this.hmProperties);
    }

    private String getNewFileName(boolean bl) {
        String string = this.sFileName;
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n <= 4) {
            return null;
        }
        return string.substring(0, n - 4) + (bl ? "_new" : "_old") + string.substring(n - 4);
    }

    private void restore(String string) {
        BufferedReader bufferedReader = null;
        String string2 = this.sFileName;
        if (string2 != null) {
            File file;
            String string3;
            File file2;
            if (this.bSystem && (bufferedReader = V2CLocalFileHandler.getConfigReader(string2)) != null) {
                this.restore(bufferedReader);
            }
            if (!(file2 = this.fFile).exists() && (string3 = this.getNewFileName(true)) != null && (file = new File(this.fParentFolder, string3)).exists()) {
                file.renameTo(file2);
            }
            this.restore(V2CLocalFileHandler.getBufferedReader(file2, this.sCharset), string);
        } else if (this.fFile != null) {
            this.restore(V2CLocalFileHandler.getBufferedReader(this.fFile, this.sCharset), string);
        }
    }

    public synchronized void doSaveState() {
        File file;
        String string;
        Object object;
        if (!this.bChanged) {
            return;
        }
        this.bChanged = false;
        File file2 = this.fFile;
        if (file2 != null) {
            boolean bl = false;
            object = this.hmProperties.keySet().iterator();
            while (object.hasNext()) {
                string = object.next();
                if (!(string instanceof String) || !((file = this.hmProperties.get(string)) instanceof String)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                file2.delete();
                return;
            }
        }
        File file3 = null;
        object = null;
        if (this.sFileName != null) {
            string = this.getNewFileName(true);
            if (string != null) {
                file = new File(this.fParentFolder, string);
                if (file.exists()) {
                    file.delete();
                }
                if (!file.exists()) {
                    file3 = file;
                }
            }
            object = V2CLocalFileHandler.getBufferedWriter(file3 != null ? file3 : file2, false, this.sCharset);
        } else if (file2 != null) {
            object = V2CLocalFileHandler.getBufferedWriter(file2, false, this.sCharset);
        }
        if (object != null) {
            this.save((BufferedWriter)object);
        }
        if (file3 != null) {
            string = this.getNewFileName(false);
            file = new File(this.fParentFolder, string);
            if (this.bSystem) {
                if (file.exists()) {
                    file.delete();
                }
                if (file.exists()) {
                    file2.delete();
                } else {
                    file2.renameTo(file);
                }
            } else {
                file2.delete();
            }
            file3.renameTo(file2);
        }
    }

    String get(String string, String string2) {
        String string3 = this.get(string);
        return string3 != null ? string3 : string2;
    }

    synchronized String get(String string) {
        String string2 = (String)this.hmProperties.get(string);
        if (string2 == null && this.vpoParent != null && string.charAt(string.length() - 1) != ':') {
            string2 = this.vpoParent.getProperty().get(string);
        }
        return string2;
    }

    synchronized String getLocal(String string) {
        return (String)this.hmProperties.get(string);
    }

    synchronized void delete() {
        this.bChanged = false;
        this.hmProperties.clear();
        if (this.fFile != null) {
            this.fFile.delete();
        }
    }

    synchronized int size() {
        return this.hmProperties.size();
    }

    synchronized void clear() {
        this.hmProperties.clear();
    }

    int getIntInRangeIfExists(String string, int n, int n2) {
        int n3 = this.getInt(string, 0);
        return n3 != 0 ? V2CMiscUtil.restrictRange(n, n3, n2) : 0;
    }

    int getIntInRangeIfExists(String string, int n, int n2, int n3) {
        int n4 = this.getInt(string, Integer.MIN_VALUE);
        return n4 != Integer.MIN_VALUE ? V2CMiscUtil.restrictRange(n2, n4, n3) : n;
    }

    int getIntInRange(String string, int n, int n2) {
        return V2CMiscUtil.restrictRange(n, this.getInt(string, 0), n2);
    }

    int getInt(String string) {
        return this.getInt(string, 0);
    }

    int getInt(String string, int n) {
        String string2 = this.get(string);
        return string2 != null ? V2CMiscUtil.parseInt(string2, n) : n;
    }

    long getLong(String string) {
        return this.getLong(string, 0L);
    }

    long getLong(String string, long l) {
        String string2 = this.get(string);
        if (string2 != null) {
            return V2CMiscUtil.parseLong(string2, l);
        }
        return l;
    }

    float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    float getFloat(String string, float f) {
        float f2 = f;
        String string2 = this.get(string);
        if (string2 != null) {
            try {
                f2 = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return f2;
    }

    boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    boolean getBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = this.get(string);
        if (string2 != null) {
            bl2 = Boolean.valueOf(string2);
        }
        return bl2;
    }

    V2CPackedPropValue getPackedValue(String string) {
        return this.getPackedValue(string, '\u0000');
    }

    V2CPackedPropValue getPackedValue(String string, char c) {
        String string2 = this.get(string);
        return string2 != null ? new V2CPackedPropValue(string2, c) : null;
    }

    V2CPackedPropValue[] getPackedValueArray(String string) {
        return this.getPackedValueArray(string, '\u0000');
    }

    V2CPackedPropValue[] getPackedValueArray(String string, char c) {
        return V2CPackedPropValue.createPackedValueArray(this.get(string), c);
    }

    Color getColor(String string) {
        return this.getColor(string, cDefaultColor);
    }

    Color getColor(String string, Color color) {
        Color color2 = V2CSwingUtil.parseColorString(this.get(string));
        return color2 != null ? color2 : color;
    }

    Color getColor(String string, int n) {
        Color color = V2CSwingUtil.parseColorString(this.get(string));
        return color != null ? color : new Color(n);
    }

    Point getPoint(String string) {
        String string2 = this.get(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String[] stringArray = V2CMiscUtil.split(string2);
        if (stringArray.length != 2) {
            return null;
        }
        try {
            return new Point(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    Dimension getDimension(String string) {
        String string2 = this.get(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String[] stringArray = V2CMiscUtil.split(string2);
        if (stringArray.length != 2) {
            return null;
        }
        try {
            return new Dimension(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    Rectangle getBounds(String string) {
        String string2 = this.get(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String[] stringArray = V2CMiscUtil.split(string2);
        if (stringArray.length != 4) {
            return null;
        }
        try {
            return new Rectangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    synchronized Object getTransient(Object object) {
        if (object == null || object instanceof String) {
            return null;
        }
        return this.hmProperties.get(object);
    }

    synchronized void putTransient(Object object, Object object2) {
        if (object == null || object instanceof String) {
            return;
        }
        this.hmProperties.put(object, object2);
    }

    synchronized void put(String string, String string2) {
        String string3;
        if (this.bReadOnly) {
            System.out.println("put into readonly property !!");
            return;
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((string3 = (String)this.hmProperties.get(string)) == null || !string3.equals(string2)) {
            this.hmProperties.put(string, string2);
            this.bChanged = true;
            this.lSaveRequestTime = System.currentTimeMillis() + 10000L;
            V2CApp.registerStateSave(this);
        }
    }

    void putInt(String string, int n) {
        this.put(string, String.valueOf(n));
    }

    void putLong(String string, long l) {
        this.put(string, String.valueOf(l));
    }

    void putFloat(String string, float f) {
        this.put(string, String.valueOf(f));
    }

    void putBoolean(String string, boolean bl) {
        this.put(string, String.valueOf(bl));
    }

    void putBooleanOrRemoveIfFalse(String string, boolean bl) {
        if (bl) {
            this.put(string, String.valueOf(true));
        } else {
            this.remove(string);
        }
    }

    void putPackedValue(String string, V2CPackedPropValue v2CPackedPropValue) {
        String string2;
        String string3 = string2 = v2CPackedPropValue != null ? v2CPackedPropValue.getSaveString() : "";
        if (string2.length() > 0) {
            this.put(string, string2);
        } else {
            this.remove(string);
        }
    }

    void putPackedValueArray(String string, V2CPackedPropValue[] v2CPackedPropValueArray) {
        String string2;
        String string3 = string2 = v2CPackedPropValueArray != null ? V2CPackedPropValue.createArraySaveString(v2CPackedPropValueArray) : "";
        if (string2.length() > 0) {
            this.put(string, string2);
        } else {
            this.remove(string);
        }
    }

    boolean putOrRemoveBoolean(String string, boolean bl, boolean bl2) {
        return this.putOrRemoveBoolean(string, this.getBoolean(string, bl2), bl, bl2);
    }

    boolean putOrRemoveBoolean(String string, boolean bl, boolean bl2, boolean bl3) {
        if (bl2 == bl) {
            return false;
        }
        if (bl2 != bl3) {
            this.putBoolean(string, bl2);
        } else {
            this.remove(string);
        }
        return true;
    }

    void putColor(String string, Color color) {
        this.put(string, V2CSwingUtil.colorToString(color));
    }

    void putPoint(String string, Point point) {
        if (point != null) {
            this.put(string, point.x + "," + point.y);
        }
    }

    void putDimension(String string, Dimension dimension) {
        if (dimension != null) {
            this.put(string, dimension.width + "," + dimension.height);
        }
    }

    void putBounds(String string, Rectangle rectangle) {
        if (rectangle != null) {
            this.put(string, rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height);
        }
    }

    synchronized void remove(String string) {
        if (this.hmProperties.containsKey(string)) {
            this.bChanged = true;
            this.hmProperties.remove(string);
            this.lSaveRequestTime = System.currentTimeMillis() + 10000L;
            V2CApp.registerStateSave(this);
        }
    }

    synchronized String[] keys() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.hmProperties.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof String)) continue;
            arrayList.add(k);
        }
        int n = arrayList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    synchronized boolean containsKey(Object object) {
        return this.hmProperties.containsKey(object);
    }

    void setReadOnly(boolean bl) {
        this.bReadOnly = bl;
    }

    String getLevelString() {
        return this.vpOwner.getLevelString(true);
    }

    String[] getLevelArray(boolean bl) {
        return this.getLevelArray(0, bl);
    }

    private String[] getLevelArray(int n, boolean bl) {
        String[] stringArray = null;
        stringArray = this.vpoParent == null ? new String[n + 1] : this.vpoParent.getProperty().getLevelArray(n + 1, bl);
        stringArray[n] = this.vpOwner != null ? this.vpOwner.getLevelString(bl) : null;
        return stringArray;
    }

    V2CProperty[] getProperties() {
        return this.getProperties(0);
    }

    private V2CProperty[] getProperties(int n) {
        V2CProperty[] v2CPropertyArray = this.vpoParent == null ? new V2CProperty[n + 1] : this.vpoParent.getProperty().getProperties(n + 1);
        v2CPropertyArray[n] = this;
        return v2CPropertyArray;
    }

    V2CProperty getAncestor(int n) {
        if (n > 0) {
            return this.vpoParent.getProperty().getAncestor(--n);
        }
        return this;
    }

    V2CProperty getAncestor(String string) {
        if (this.vpOwner.getPropertyClassString().equals(string)) {
            return this;
        }
        if (this.vpoParent != null) {
            return this.vpoParent.getProperty().getAncestor(string);
        }
        return null;
    }

    private synchronized void restore(BufferedReader bufferedReader) {
        this.restore(bufferedReader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void restore(BufferedReader bufferedReader, String string) {
        if (bufferedReader == null) {
            return;
        }
        try {
            String string2;
            boolean bl = true;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                char c;
                int n2 = string2.length();
                if (bl) {
                    bl = false;
                    if (n2 > 0 && string2.charAt(0) == '\ufeff') {
                        if (n2 == 1) continue;
                        string2 = string2.substring(1);
                        --n2;
                    }
                    if (string != null && string2.indexOf(61) < 0 && string2.startsWith(string + '@')) {
                        this.hmProperties.put(null, string2);
                        continue;
                    }
                }
                if (n2 <= 0 || (c = string2.charAt(0)) == '#' || c == '\ufeff' || (n = string2.indexOf(61)) < 0) continue;
                String string3 = n + 1 < n2 ? string2.substring(n + 1) : "";
                this.hmProperties.put(string2.substring(0, n), string3);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            V2CLocalFileHandler.closeReader(bufferedReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void save(BufferedWriter bufferedWriter) {
        Iterator iterator = this.hmProperties.keySet().iterator();
        try {
            while (iterator.hasNext()) {
                String string;
                Object v;
                Object k = iterator.next();
                if (!(k instanceof String) || !((v = this.hmProperties.get(string = (String)k)) instanceof String)) continue;
                bufferedWriter.write(string);
                bufferedWriter.write(61);
                bufferedWriter.write((String)v);
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            V2CLocalFileHandler.closeWriter(bufferedWriter);
        }
    }

    void setFile(File file) {
        this.fFile = file;
    }

    public long getSaveRequestTime() {
        return this.lSaveRequestTime;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.hmProperties.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof String)) continue;
            String string = (String)k;
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(this.hmProperties.get(string));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

