/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CExtServer;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CMovieMenuItem;
import org.monazilla.v2c.V2CMovieUtil;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CWebBrowser;
import org.monazilla.v2c.V2CWebBrowserListener;

public abstract class V2CMoviePanel
extends JPanel
implements ActionListener,
Runnable,
V2CWebBrowserListener {
    private static HashMap hmPanels = new HashMap();
    protected static final boolean bRetainBrowser = V2CApp.isMacintosh() && System.getProperty("java.runtime.version").equals("1.5.0_07-164");
    String sURL;
    String sID;
    String sTitle;
    Point pPopup;
    JFrame jDialog;
    JPanel jPanel;
    V2CWebBrowser vWebBrowser;
    JButton jbFunction;
    Thread thGetKey;
    URL uVideo;
    long lTime;
    V2CMovieMenuItem vMovieMenuItem;
    boolean bClosed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerPanel(String string, String string2, V2CMoviePanel v2CMoviePanel) {
        HashMap hashMap = hmPanels;
        synchronized (hashMap) {
            hmPanels.put(string + string2, v2CMoviePanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterPanel(String string, String string2) {
        HashMap hashMap = hmPanels;
        synchronized (hashMap) {
            hmPanels.remove(string + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static V2CMoviePanel getPanel(String string, String string2) {
        HashMap hashMap = hmPanels;
        synchronized (hashMap) {
            return (V2CMoviePanel)hmPanels.get(string + string2);
        }
    }

    public V2CMoviePanel(String string, String string2, Point point) {
        super(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.sURL = string;
        this.sID = string2;
        this.pPopup = point;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)new JLabel("\u30d3\u30c7\u30aa\u60c5\u5831\u53d6\u5f97\u4e2d\u2026"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)jProgressBar, gridBagConstraints);
    }

    void unregisterPanel() {
        V2CMoviePanel.unregisterPanel(this.getSiteID(), this.sID);
        V2CMain.removeMovieMenuItem(this);
    }

    void registerPanel() {
        V2CMoviePanel.registerPanel(this.getSiteID(), this.sID, this);
        this.vMovieMenuItem = new V2CMovieMenuItem(this, this.sID, this.getSiteID(), this.sTitle);
        V2CMain.addMovieMenuItem(this.vMovieMenuItem);
    }

    String getID() {
        return this.sID;
    }

    abstract String getSiteID();

    abstract Dimension calcBrowserSize();

    abstract String createHTMLContents();

    abstract boolean createHTMLFile(String var1);

    boolean isDialogResizable() {
        return true;
    }

    void setTitle(String string) {
        this.sTitle = string = V2CResItem.replaceEscapes(string);
        V2CMovieUtil.registerTitle(this.getSiteID() + this.sID, string);
    }

    void moveToFront() {
        if (this.jDialog == null) {
            return;
        }
        if (this.bClosed) {
            V2CMain.removeMovieMenuItem(this);
            return;
        }
        V2CSwingUtil.toFront(this.jDialog);
    }

    final void setBrowserSize() {
        this.setBrowserSize(this.calcBrowserSize());
    }

    final void setBrowserSize(Dimension dimension) {
        this.jPanel.setPreferredSize(dimension);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.bClosed) {
            this.disposeLater();
        }
    }

    void disposeLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!V2CMoviePanel.this.bClosed && V2CMoviePanel.this.vWebBrowser != null) {
                    V2CMoviePanel.this.vWebBrowser.stop();
                    Component component = (Component)((Object)V2CMoviePanel.this.vWebBrowser);
                    Container container = component.getParent();
                    if (container != null) {
                        container.remove(component);
                    }
                    if (V2CMoviePanel.this.jPanel != null) {
                        V2CMoviePanel.this.remove(V2CMoviePanel.this.jPanel);
                    }
                }
                V2CMoviePanel.this.jDialog.dispose();
            }
        });
    }

    void adjustDialogPosition(boolean bl) {
        Point point = bl && this.pPopup != null ? this.pPopup : this.jDialog.getLocation();
        int n = point.x;
        int n2 = point.y;
        if (bl) {
            n += 5;
        }
        Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(point);
        int n3 = this.jDialog.getWidth();
        int n4 = this.jDialog.getHeight();
        boolean bl2 = false;
        if (n3 > rectangle.width) {
            bl2 = true;
            n3 = rectangle.width;
        }
        if (n4 > rectangle.height) {
            bl2 = true;
            n4 = rectangle.height;
        }
        if (bl2) {
            this.jDialog.setSize(n3, n4);
        }
        if (n + n3 > rectangle.x + rectangle.width) {
            n = rectangle.x + rectangle.width - n3;
        }
        if (n2 + n4 > rectangle.y + rectangle.height) {
            n2 = rectangle.y + rectangle.height - n4;
        }
        this.jDialog.setLocation(n, n2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbFunction) {
            JPopupMenu jPopupMenu = V2CMain.getPopupMenu(this.getSiteID() + "Function");
            Point point = this.jbFunction.getLocation();
            if (jPopupMenu != null) {
                V2CPopupListener.showPopup(jPopupMenu, null, this, point.x, point.y + this.jbFunction.getHeight());
            }
        }
    }

    void createBPanel() {
        this.jPanel = new BPanel();
        this.setBrowserSize();
        Dimension dimension = this.jPanel.getPreferredSize();
        ((Component)((Object)this.vWebBrowser)).setBounds(0, 0, dimension.width, dimension.height);
        this.addBrowserPanel();
    }

    void addBrowserPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jPanel, gridBagConstraints);
    }

    public void documentCompleted() {
    }

    public void titleChange(String string) {
    }

    public boolean willOpenURL(URL uRL) {
        return true;
    }

    boolean executeCommand(char c) {
        return c == 'G';
    }

    void openLinkOutside() {
        V2CMiscUtil.openLinkOutside(this.sURL);
    }

    void openLinkInside() {
        V2CMiscUtil.openLinkWithWebBrowser(this.sURL, true, true, false, false);
    }

    void setErrorMessage(String string) {
        Toolkit.getDefaultToolkit().beep();
        this.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(40, 40, 20, 20);
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.RED);
        jLabel.setFont(jLabel.getFont().deriveFont(20.0f));
        this.add((Component)jLabel, gridBagConstraints);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                V2CMoviePanel.this.jDialog.dispose();
            }
        });
        this.jDialog.pack();
        this.repaint();
    }

    void createLocalVideoURL() {
        this.lTime = System.currentTimeMillis();
        this.registerPanel();
        if (!V2CExtServer.startServer(false)) {
            V2CSwingUtil.showErrorMessage("ServerSocket\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        try {
            this.uVideo = new URL("http", "127.0.0.1", V2CExtServer.getServerPort(), '/' + this.getSiteID() + '/' + this.sID + "/G");
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        SwingUtilities.invokeLater(this);
    }

    static class TitleLabel
    extends JLabel {
        TitleLabel(String string) {
            super(string);
            this.setHorizontalAlignment(0);
            this.setFont(this.getFont().deriveFont(16.0f));
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(100, dimension.height);
        }
    }

    class BPanel
    extends JPanel
    implements Runnable {
        boolean bAdded;

        BPanel() {
            super(new BorderLayout());
            this.setBackground(Color.WHITE);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (!this.bAdded) {
                this.bAdded = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            this.add((Component)((Object)V2CMoviePanel.this.vWebBrowser), "Center");
            this.revalidate();
            this.repaint();
        }
    }
}

