/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CFont;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CStatusBarComponent;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CMemoryGauge
extends V2CStatusBarComponent {
    static final String sUsedColorKey = "MemoryGauge.UsedColor";
    static final String sFreeColorKey = "MemoryGauge.FreeColor";
    static final DecimalFormat dfMemory = new DecimalFormat("####0.0");
    static final int nWidth = 100;
    static Color cUsedColor;
    static Color cFreeColor;
    static V2CMemoryGauge vMemoryGauge;
    int nLastUsed;
    V2CFont vFont;
    boolean bPointerInside;

    static void updateColors(Color color, Color color2) {
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        boolean bl = false;
        if (!color.equals(cUsedColor)) {
            bl = true;
            cUsedColor = color;
            v2CProperty.putColor(sUsedColorKey, color);
        }
        if (!color2.equals(cFreeColor)) {
            bl = true;
            cFreeColor = color2;
            v2CProperty.putColor(sFreeColorKey, color2);
        }
        if (bl && vMemoryGauge != null) {
            vMemoryGauge.repaint();
        }
    }

    static V2CMemoryGauge getInstance() {
        if (vMemoryGauge == null) {
            vMemoryGauge = new V2CMemoryGauge();
        }
        return vMemoryGauge;
    }

    static void update() {
        if (vMemoryGauge == null) {
            return;
        }
        vMemoryGauge.repaint();
    }

    public V2CMemoryGauge() {
        super(null, null);
        this.addMouseListener(new PopupListener());
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, nHeight);
    }

    public Dimension getMaximumSize() {
        return new Dimension(100, nHeight * 5);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (bMacSpecial && !this.bPointerInside) {
            V2CMemoryGauge.checkFadeFactor(graphics2D);
        }
        V2CSwingUtil.setRenderingHint(graphics2D);
        Insets insets = this.getInsets();
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = this.getWidth() - n3 - insets.right;
        int n6 = this.getHeight() - n4 - insets.bottom;
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        if (V2CApp.isMacintosh() && V2CApp.javaVersionEqualTo(1, 4)) {
            l -= 0x5000000L;
        }
        if ((n2 = (n = (int)((float)n5 * (float)runtime.totalMemory() / (float)l)) - (int)((float)n5 * (float)runtime.freeMemory() / (float)l)) > 0) {
            graphics.setColor(cUsedColor);
            graphics.fillRect(n3, n4, n2, n6);
        }
        if (n > n2) {
            graphics.setColor(cFreeColor);
            graphics.fillRect(n3 + n2, n4, n - n2, n6);
        }
        if (n5 > n) {
            if (bMacSpecial) {
                graphics.setColor(cMacBG);
                graphics.fillRect(n3 + n, n4, n5 - n, n6);
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(n3 + n, n4, n5 - n, n6);
            }
        }
        String string = dfMemory.format((double)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0) + "MB";
        graphics.setFont(this.getFont());
        int n7 = SwingUtilities.computeStringWidth(((Graphics2D)graphics).getFontMetrics(), string);
        V2CMemoryGauge.drawString(graphics, string, n5 - n7);
    }

    static {
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        cUsedColor = v2CProperty.getColor(sUsedColorKey, Color.RED);
        cFreeColor = v2CProperty.getColor(sFreeColorKey, Color.YELLOW);
    }

    private class PopupListener
    extends V2CPopupListener {
        PopupListener() {
            super("MemoryGauge", V2CMemoryGauge.this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (V2CSwingUtil.isSimpleClick(mouseEvent)) {
                V2CApp.doGC();
            } else {
                super.mouseClicked(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (V2CStatusBarComponent.bMacSpecial) {
                V2CMemoryGauge.this.bPointerInside = true;
                V2CMemoryGauge.this.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (V2CStatusBarComponent.bMacSpecial) {
                V2CMemoryGauge.this.bPointerInside = false;
                V2CMemoryGauge.this.repaint();
            }
        }
    }
}

