/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import javax.swing.JTextArea;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CWriteMessagePanel;
import org.monazilla.v2c.V2CWritePanel;

public class V2CMemoItem {
    private static final String sMemoConfKey = "WritePanel.MemoConf";
    private static final int DEFMEMOCOUNT = 6;
    private static final int nMemoCount;
    static V2CMemoItem[] vlMemoItems;
    final int iIndex;
    final String sTitle;
    String sText;
    Document vDocument;
    UndoManager vUndoManager;

    static V2CMemoItem[] restore() {
        V2CMemoItem[] v2CMemoItemArray = vlMemoItems;
        if (v2CMemoItemArray == null) {
            v2CMemoItemArray = new V2CMemoItem[nMemoCount];
            for (int i = 0; i < v2CMemoItemArray.length; ++i) {
                v2CMemoItemArray[i] = new V2CMemoItem(i + 1);
            }
            vlMemoItems = v2CMemoItemArray;
        }
        return v2CMemoItemArray;
    }

    static void save() {
        V2CMemoItem[] v2CMemoItemArray = vlMemoItems;
        if (v2CMemoItemArray != null) {
            for (int i = 0; i < v2CMemoItemArray.length; ++i) {
                v2CMemoItemArray[i].saveText();
            }
        }
    }

    static int getMemoCount() {
        return nMemoCount;
    }

    static void setMemoCount(int n) {
        n = V2CMiscUtil.restrictRange(1, n, 100);
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        if (n != 6) {
            v2CProperty.put(sMemoConfKey, ":N" + n);
        } else {
            v2CProperty.remove(sMemoConfKey);
        }
    }

    static V2CMemoItem getNext(V2CMemoItem v2CMemoItem, boolean bl) {
        if (nMemoCount <= 0) {
            return null;
        }
        int n = nMemoCount + 1;
        int n2 = v2CMemoItem != null ? v2CMemoItem.getIndex() : 0;
        int n3 = (n2 + (bl ? 1 : n - 1)) % n;
        return n3 > 0 ? V2CMemoItem.restore()[n3 - 1] : null;
    }

    private V2CMemoItem(int n) {
        this.iIndex = n;
        this.sTitle = "\u30e1\u30e2 " + n;
    }

    int getIndex() {
        return this.iIndex;
    }

    void setDocument(JTextArea jTextArea) {
        Document document = this.vDocument;
        if (document == null) {
            String string = V2CLocalFileHandler.getMemoText(this.iIndex);
            if (string == null) {
                string = "";
            }
            this.sText = string;
            JTextArea jTextArea2 = new JTextArea(string);
            this.vDocument = document = jTextArea2.getDocument();
            this.vUndoManager = new UndoManager();
            document.addUndoableEditListener(new UndoableEditListener(){

                public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    if (undoableEditEvent.getSource() == V2CMemoItem.this.vDocument) {
                        V2CMemoItem.this.vUndoManager.addEdit(undoableEditEvent.getEdit());
                        V2CWriteMessagePanel.updateUndoRedoState(V2CMemoItem.this.vUndoManager);
                    }
                }
            });
        }
        jTextArea.setDocument(document);
    }

    UndoManager getUndoManager() {
        UndoManager undoManager = this.vUndoManager;
        if (undoManager == null) {
            this.vUndoManager = undoManager = new UndoManager();
        }
        return undoManager;
    }

    void saveText() {
        String string = this.sText;
        Document document = this.vDocument;
        if (string != null && document != null) {
            String string2;
            try {
                string2 = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            if (!string.equals(string2)) {
                this.sText = string2;
                V2CLocalFileHandler.saveMemoText(this.iIndex, string2);
            }
        }
    }

    void removeDocumentListener(V2CWritePanel v2CWritePanel) {
        Document document = this.vDocument;
        if (document != null) {
            document.removeDocumentListener(v2CWritePanel);
        }
    }

    public String toString() {
        return this.sTitle;
    }

    static {
        V2CPackedPropValue v2CPackedPropValue = V2CApp.getUserProperty().getPackedValue(sMemoConfKey);
        int n = 0;
        nMemoCount = v2CPackedPropValue != null ? ((n = v2CPackedPropValue.getInt('N')) <= 0 ? 6 : V2CMiscUtil.restrictRange(1, n, 100)) : 6;
    }
}

