/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CKeywordUtil {
    private static final String[] slNGWeightLabel = new String[]{"9", "8", "7", "6", "5", "4", "3", "2", "1", "0", "-1", "-2", "-3", "-4", "-5", "-6", "-7", "-8", "-9"};
    private static final String[] slWeightLabel = new String[]{"9", "8", "7", "6", "5", "4", "3", "2", "1", "0"};

    static JComboBox createWeightComboBox(boolean bl) {
        return V2CSwingUtil.createComboBox(bl ? slNGWeightLabel : slWeightLabel);
    }

    static DefaultCellEditor createWeightCellEditor(boolean bl) {
        JComboBox jComboBox = V2CKeywordUtil.createWeightComboBox(bl);
        jComboBox.setMaximumRowCount(20);
        return new DefaultCellEditor(jComboBox);
    }

    static String getWeightString(int n) {
        if (n <= 9 && n >= -9) {
            return slNGWeightLabel[9 - n];
        }
        return String.valueOf(n);
    }

    static int toWeight(String string) {
        int n = V2CMiscUtil.parseInt(string);
        return V2CMiscUtil.restrictRange(-9, n, 9);
    }

    static int parseExpiration(String string) {
        if (string.equals("\u30c7\u30d5\u30a9\u30eb\u30c8")) {
            return 0;
        }
        if (string.equals("\u7121\u671f\u9650")) {
            return -1;
        }
        String[] stringArray = new String[4];
        Matcher matcher = Pattern.compile("\\s*(?:([\\d\uff10-\uff19]+)(?:\u30f6?\u6708))?\\s*(?:([\\d\uff10-\uff19]+)\u65e5?)?\\s*").matcher(string);
        if (!matcher.matches()) {
            matcher = Pattern.compile("\\s*(?:([\\d\uff10-\uff19]+)(?:\u30f6?\u6708))?\\s*(?:([\\d\uff10-\uff19]+)\u65e5)?\\s*(?:([\\d\uff10-\uff19]+)\u6642\u9593)?\\s*(?:([\\d\uff10-\uff19]+)\u5206)?\\s*").matcher(string);
            if (!matcher.matches()) {
                return -2;
            }
            stringArray[2] = matcher.group(3);
            stringArray[3] = matcher.group(4);
        }
        stringArray[0] = matcher.group(1);
        stringArray[1] = matcher.group(2);
        int[] nArray = new int[]{43200, 1440, 60, 1};
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            String string2 = V2CMiscUtil.fullWidthNumberToHalfWidth(stringArray[i]);
            if (string2 == null) continue;
            int n2 = V2CMiscUtil.parseInt(string2, -1);
            if (n2 < 0) {
                return -2;
            }
            n += nArray[i] * n2;
        }
        return n > 0 ? n : -2;
    }

    static String formatExpiration(int n) {
        if (n == 0) {
            return "\u30c7\u30d5\u30a9\u30eb\u30c8";
        }
        if (n < 0) {
            return "\u7121\u671f\u9650";
        }
        int n2 = n / 1440;
        String string = n2 > 0 ? n2 + "\u65e5" : "";
        int n3 = n % 1440;
        if (n3 > 0) {
            int n4 = n3 / 60;
            if (n4 > 0) {
                string = string + n4 + "\u6642\u9593";
            }
            if ((n3 %= 60) > 0) {
                string = string + n3 + "\u5206";
            }
        }
        return string;
    }

    static String[] getExpirationSelections() {
        return new String[]{"\u30c7\u30d5\u30a9\u30eb\u30c8", "30\u5206", "1\u6642\u9593", "2\u6642\u9593", "4\u6642\u9593", "8\u6642\u9593", "1\u65e5", "3\u65e5", "10\u65e5", "30\u65e5", "90\u65e5", "\u7121\u671f\u9650"};
    }

    static DefaultCellEditor createExpirationEditor() {
        JComboBox jComboBox = V2CSwingUtil.createComboBox(V2CKeywordUtil.getExpirationSelections());
        jComboBox.setEditable(true);
        jComboBox.setMaximumRowCount(15);
        return new DefaultCellEditor(jComboBox);
    }
}

