/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.monazilla.v2c.V2CJPConverter;
import org.monazilla.v2c.V2CMiscUtil;

public class V2CJSONUtil {
    private static boolean isWS(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    private static void throwException() throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    private static void throwException(String string, int n) throws IllegalArgumentException {
        int n2 = string.length();
        for (int i = n - 1; i < Math.min(n + 2, n2); ++i) {
            System.out.println(i + ": " + Integer.toHexString(string.charAt(i)));
        }
        throw new IllegalArgumentException(n + ": [" + string.substring(n - 1, Math.min(n + 40, n2)) + ']');
    }

    private static int parseArray(String string, int n, Object[] objectArray) throws IllegalArgumentException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = string.length();
        boolean bl = true;
        while (n < n2) {
            char c;
            if (V2CJSONUtil.isWS(c = string.charAt(n++))) continue;
            if (c == ']') {
                objectArray[0] = arrayList;
                return n;
            }
            if (bl) {
                bl = false;
                n = V2CJSONUtil.parseValue(string, n - 1, objectArray);
                arrayList.add(objectArray[0]);
                continue;
            }
            if (c == ',') {
                n = V2CJSONUtil.parseValue(string, n, objectArray);
                arrayList.add(objectArray[0]);
                continue;
            }
            V2CJSONUtil.throwException(string, n);
        }
        V2CJSONUtil.throwException(string, n);
        return -1;
    }

    private static int parseObject(String string, int n, Object[] objectArray) throws IllegalArgumentException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n2 = string.length();
        boolean bl = true;
        String string2 = null;
        while (n < n2) {
            Object object;
            char c;
            if (V2CJSONUtil.isWS(c = string.charAt(n++))) continue;
            if (c == '}') {
                objectArray[0] = hashMap;
                return n;
            }
            if (bl) {
                bl = false;
                n = V2CJSONUtil.parseValue(string, n - 1, objectArray);
                object = objectArray[0];
                if (!(object instanceof String)) {
                    V2CJSONUtil.throwException(string, n);
                }
                string2 = (String)object;
                continue;
            }
            if (c == ',') {
                if (string2 != null) {
                    V2CJSONUtil.throwException(string, n);
                }
                n = V2CJSONUtil.parseValue(string, n, objectArray);
                object = objectArray[0];
                if (!(object instanceof String)) {
                    V2CJSONUtil.throwException(string, n);
                }
                string2 = (String)object;
                continue;
            }
            if (c == ':') {
                if (string2 == null) {
                    V2CJSONUtil.throwException(string, n);
                }
                n = V2CJSONUtil.parseValue(string, n, objectArray);
                hashMap.put(string2, objectArray[0]);
                string2 = null;
                continue;
            }
            V2CJSONUtil.throwException(string, n);
        }
        V2CJSONUtil.throwException(string, n);
        return -1;
    }

    private static int parseString(String string, int n, Object[] objectArray) throws IllegalArgumentException {
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        boolean bl = false;
        Object var7_7 = null;
        while (n < n3) {
            char c = string.charAt(n++);
            if (bl) {
                bl = false;
                if (c == '\"' || c == '\\' || c == '/') {
                    stringBuffer.append(c);
                    continue;
                }
                if (c == 'b') {
                    stringBuffer.append('\b');
                    continue;
                }
                if (c == 'f') {
                    stringBuffer.append('\f');
                    continue;
                }
                if (c == 'n') {
                    stringBuffer.append('\n');
                    continue;
                }
                if (c == 'r') {
                    stringBuffer.append('\r');
                    continue;
                }
                if (c == 't') {
                    stringBuffer.append('\t');
                    continue;
                }
                if (c == 'u') {
                    int n4;
                    if (n3 <= n + 4) {
                        V2CJSONUtil.throwException(string, n);
                    }
                    if ((n4 = V2CMiscUtil.parseHexInt(string, n, n + 4, -1)) < 0) {
                        V2CJSONUtil.throwException(string, n);
                    }
                    n += 4;
                    stringBuffer.append((char)n4);
                    continue;
                }
                V2CJSONUtil.throwException(string, n);
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            if (c == '\"') {
                objectArray[0] = stringBuffer.toString();
                return n;
            }
            stringBuffer.append(c);
        }
        V2CJSONUtil.throwException(string, n);
        return -1;
    }

    private static int parseValue(String string, int n, Object[] objectArray) throws IllegalArgumentException {
        int n2 = string.length();
        while (n < n2) {
            int n3;
            boolean bl;
            char c;
            if (V2CJSONUtil.isWS(c = string.charAt(n++))) continue;
            if (c == '[') {
                return V2CJSONUtil.parseArray(string, n, objectArray);
            }
            if (c == '{') {
                return V2CJSONUtil.parseObject(string, n, objectArray);
            }
            if (c == '\"') {
                return V2CJSONUtil.parseString(string, n, objectArray);
            }
            if (c == 't') {
                if (n2 <= n + 2 || string.charAt(n) != 'r' || string.charAt(n + 1) != 'u' || string.charAt(n + 2) != 'e') {
                    V2CJSONUtil.throwException(string, n);
                }
                objectArray[0] = Boolean.TRUE;
                return n + 3;
            }
            if (c == 'f') {
                if (n2 <= n + 3 || string.charAt(n) != 'a' || string.charAt(n + 1) != 'l' || string.charAt(n + 2) != 's' || string.charAt(n + 3) != 'e') {
                    V2CJSONUtil.throwException(string, n);
                }
                objectArray[0] = Boolean.FALSE;
                return n + 4;
            }
            if (c == 'n') {
                if (n2 <= n + 2 || string.charAt(n) != 'u' || string.charAt(n + 1) != 'l' || string.charAt(n + 2) != 'l') {
                    V2CJSONUtil.throwException(string, n);
                }
                objectArray[0] = null;
                return n + 3;
            }
            int n4 = n - 1;
            boolean bl2 = bl = c == '-';
            if (bl || c == '+') {
                ++n4;
            }
            int n5 = n4;
            long l = 0L;
            boolean bl3 = false;
            char c2 = '\u0000';
            if (bl) {
                while (n4 < n2) {
                    c2 = string.charAt(n4);
                    if (c2 < '0' || c2 > '9') {
                        if (c2 != '.' && c2 != 'e' && c2 != 'E') break;
                        bl3 = true;
                        break;
                    }
                    if (n4 >= n5 + 18 && l <= -922337203685477580L && (l < -922337203685477580L || c2 > '8')) {
                        bl3 = true;
                        break;
                    }
                    l = l * 10L - (long)(c2 - 48);
                    ++n4;
                }
                if (!bl3) {
                    objectArray[0] = l >= Integer.MIN_VALUE ? (Number)new Integer((int)l) : (Number)new Long(l);
                    return n4;
                }
            } else {
                while (n4 < n2) {
                    c2 = string.charAt(n4);
                    if (c2 < '0' || c2 > '9') {
                        if (c2 != '.' && c2 != 'e' && c2 != 'E') break;
                        bl3 = true;
                        break;
                    }
                    if (n4 >= n5 + 18 && l >= 0xCCCCCCCCCCCCCCCL && (l > 0xCCCCCCCCCCCCCCCL || c2 > '7')) {
                        bl3 = true;
                        break;
                    }
                    l = l * 10L + (long)(c2 - 48);
                    ++n4;
                }
                if (!bl3) {
                    objectArray[0] = l <= Integer.MAX_VALUE ? (Number)new Integer((int)l) : (Number)new Long(l);
                    return n4;
                }
            }
            double d = 0.0;
            c2 = '\u0000';
            for (n4 = n5; n4 < n2 && (c2 = string.charAt(n4)) >= '0' && c2 <= '9'; ++n4) {
                d = d * 10.0 + (double)(c2 - 48);
            }
            if (c2 == '.') {
                n3 = ++n4;
                while (n4 < n2 && (c2 = string.charAt(n4)) >= '0' && c2 <= '9') {
                    ++n4;
                }
                if (n4 > n3) {
                    double d2 = 0.0;
                    for (int i = n4 - 1; i >= n3; --i) {
                        d2 = (d2 + (double)(string.charAt(i) - 48)) / 10.0;
                    }
                    d += d2;
                }
            } else if (c2 == '\u0000') {
                V2CJSONUtil.throwException(string, n);
            }
            if (c2 == 'e' || c2 == 'E') {
                if (++n4 >= n2) {
                    V2CJSONUtil.throwException(string, n);
                }
                int n6 = n3 = (c2 = string.charAt(n4)) == '-' ? 1 : 0;
                if (n3 != 0 || c2 == '+') {
                    ++n4;
                }
                int n7 = 0;
                while (n4 < n2 && (c2 = string.charAt(n4)) >= '0' && c2 <= '9') {
                    n7 = n7 * 10 + (c2 - 48);
                    ++n4;
                }
                if (n3 != 0) {
                    for (int i = n7 - 1; i >= 0; --i) {
                        d /= 10.0;
                    }
                } else {
                    for (int i = n7 - 1; i >= 0; --i) {
                        d *= 10.0;
                    }
                }
            }
            if (bl) {
                d *= -1.0;
            }
            objectArray[0] = new Double(d);
            return n4;
        }
        V2CJSONUtil.throwException(string, n);
        return -1;
    }

    static Object parse(byte[] byArray) throws IllegalArgumentException {
        if (byArray == null || byArray.length < 2) {
            return null;
        }
        return V2CJSONUtil.parse(byArray, 0, byArray.length);
    }

    static Object parse(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        if (byArray == null || byArray.length < 2) {
            return null;
        }
        if (byArray[n] == 0 || byArray[n + 1] == 0) {
            return null;
        }
        try {
            return V2CJSONUtil.parse(new String(byArray, n, n2 - n, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    static Object parse(String string) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n < 2) {
            return null;
        }
        Object[] objectArray = new Object[1];
        V2CJSONUtil.parseValue(string, 0, objectArray);
        return objectArray[0];
    }

    private static void append(Object object, StringBuffer stringBuffer) throws IllegalArgumentException {
        if (object == null) {
            stringBuffer.append("null");
        } else if (object instanceof Boolean) {
            stringBuffer.append((Boolean)object != false ? "true" : "false");
        } else if (object instanceof Integer) {
            stringBuffer.append(((Integer)object).longValue());
        } else if (object instanceof Long) {
            stringBuffer.append((Long)object);
        } else if (object instanceof Double) {
            long l;
            double d = (Double)object;
            if (d == (double)(l = (long)d)) {
                stringBuffer.append(l);
            } else {
                stringBuffer.append(d);
            }
        } else if (object instanceof String) {
            String string = (String)object;
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append('\"');
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\"') {
                    stringBuffer2.append("\\\"");
                    continue;
                }
                if (c == '\\') {
                    stringBuffer2.append("\\\\");
                    continue;
                }
                if (c == '\b') {
                    stringBuffer2.append("\\b");
                    continue;
                }
                if (c == '\f') {
                    stringBuffer2.append("\\f");
                    continue;
                }
                if (c == '\n') {
                    stringBuffer2.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    stringBuffer2.append("\\r");
                    continue;
                }
                if (c == '\t') {
                    stringBuffer2.append("\\t");
                    continue;
                }
                if (c >= '\ud8000' && c < '\ue000') {
                    stringBuffer2.append("\\u");
                    String string2 = "0000" + Integer.toHexString(c);
                    stringBuffer2.append(string2.substring(string2.length() - 4));
                    continue;
                }
                stringBuffer2.append(c);
            }
            stringBuffer2.append('\"');
            stringBuffer.append(stringBuffer2.toString());
        } else if (object instanceof List) {
            List list = (List)object;
            stringBuffer.append('[');
            int n = list.size();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    V2CJSONUtil.append(list.get(i), stringBuffer);
                    stringBuffer.append(',');
                }
                stringBuffer.setCharAt(stringBuffer.length() - 1, ']');
            } else {
                stringBuffer.append(']');
            }
        } else if (object instanceof Map) {
            Map map = (Map)object;
            stringBuffer.append('{');
            if (map.size() > 0) {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    if (!(k instanceof String)) {
                        V2CJSONUtil.throwException();
                    }
                    V2CJSONUtil.append(k, stringBuffer);
                    stringBuffer.append(':');
                    V2CJSONUtil.append(map.get(k), stringBuffer);
                    stringBuffer.append(',');
                }
                stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
            } else {
                stringBuffer.append('}');
            }
        } else {
            V2CJSONUtil.throwException();
        }
    }

    static byte[] generate(Object object) throws IllegalArgumentException {
        return V2CJPConverter.getBytes(V2CJSONUtil.generateString(object), "UTF-8");
    }

    static String generateString(Object object) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer();
        V2CJSONUtil.append(object, stringBuffer);
        return stringBuffer.toString();
    }
}

