/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.monazilla.v2c.V2CAbstractAction;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CInputMap;
import org.monazilla.v2c.V2CInputMapConstants;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTextChangeListener;

public class V2CInputMapSP
extends JPanel
implements V2CInputMapConstants,
ActionListener,
ListSelectionListener,
KeyListener,
FocusListener {
    static final String[] slOtherColNames = new String[]{"S", "C", "A", "Key", "Action"};
    static final String[] slMacColNames = new String[]{"S", "O", "C", "Key", "Action"};
    static final String[] slColNames = V2CApp.isMacintosh() ? slMacColNames : slOtherColNames;
    private static int iSelectedTableIndex;
    private static int iSBValue;
    V2CInputMap[] vimlInputMaps;
    V2CInputMap imCurrentInputMap;
    JComboBox jcbComponent;
    JTextField jtfFilter;
    String sLastFilterWords;
    ActionTableModel tmAction;
    JTable jtActions;
    JScrollPane jScrollPane;
    Color cFG;
    JCheckBox jcbShift;
    JCheckBox jcbControl;
    JCheckBox jcbAlt;
    JCheckBox jcbOption;
    JCheckBox jcbCommand;
    JPanel jpKey;
    String sKeyStr;
    int nKeyCode;
    JButton jbSet;
    JButton jbAdd;
    JButton jbClear;
    JLabel jlStatus;
    boolean bChanged;

    public V2CInputMapSP(V2CInputMap[] v2CInputMapArray) {
        super(new GridBagLayout());
        JLabel jLabel;
        JPanel jPanel;
        JScrollPane jScrollPane;
        JTable jTable;
        JTextField jTextField;
        JComboBox jComboBox;
        this.vimlInputMaps = v2CInputMapArray;
        this.sLastFilterWords = "";
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jcbComponent = jComboBox = V2CSwingUtil.createComboBox(this.vimlInputMaps);
        jComboBox.setFocusable(false);
        jComboBox.setMaximumRowCount(this.vimlInputMaps.length);
        jComboBox.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jComboBox, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        this.jtfFilter = jTextField = V2CSwingUtil.createTextField(6);
        new FilterListener();
        this.add((Component)jTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        ++gridBagConstraints.gridy;
        this.tmAction = new ActionTableModel();
        this.jtActions = jTable = new JTable(this.tmAction);
        this.cFG = jTable.getForeground();
        jTable.setSelectionMode(0);
        jTable.setColumnSelectionAllowed(false);
        jTable.getSelectionModel().addListSelectionListener(this);
        Font font = jTable.getFont();
        int n = font.getSize();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = slColNames.length;
        for (int i = 0; i < n2 - 2; ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(n);
        }
        tableColumnModel.getColumn(n2 - 2).setPreferredWidth(5 * n);
        tableColumnModel.getColumn(n2 - 1).setPreferredWidth(20 * n);
        tableColumnModel.getColumn(n2 - 1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setForeground(n < V2CInputMapSP.this.tmAction.nFiltered ? Color.RED : V2CInputMapSP.this.cFG);
                return component;
            }
        });
        this.jScrollPane = jScrollPane = V2CSwingUtil.createScrollPaneForTable(jTable, 200);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        GridBagConstraints gridBagConstraints2 = V2CSwingUtil.createGridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 3, 5, 2);
        this.jcbShift = this.createCheckBox("Shift", jPanel2, gridBagConstraints2);
        if (!V2CApp.isMacintosh()) {
            this.jcbControl = this.createCheckBox("Control", jPanel2, gridBagConstraints2);
            this.jcbAlt = this.createCheckBox("Alt", jPanel2, gridBagConstraints2);
        } else {
            this.jcbOption = this.createCheckBox("Option", jPanel2, gridBagConstraints2);
            this.jcbCommand = this.createCheckBox("Command", jPanel2, gridBagConstraints2);
        }
        this.jpKey = jPanel = new JPanel(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (V2CInputMapSP.this.sKeyStr == null) {
                    return;
                }
                int n = graphics.getFontMetrics().getHeight();
                Insets insets = this.getInsets();
                graphics.drawString(V2CInputMapSP.this.sKeyStr, insets.left + 1, (this.getHeight() + n) / 2 - insets.bottom);
            }
        };
        jPanel.setFocusable(true);
        jPanel.enableInputMethods(false);
        jPanel.addKeyListener(this);
        jPanel.addMouseListener(new MouseClickListener());
        jPanel.addFocusListener(this);
        Dimension dimension = this.jcbShift.getPreferredSize();
        dimension = new Dimension(dimension);
        dimension.width = (int)((float)dimension.width * 1.5f);
        dimension.height = (int)((float)dimension.height * 1.3f);
        jPanel.setPreferredSize(dimension);
        jPanel.setMinimumSize(dimension);
        this.setInactiveColor();
        Border border = UIManager.getBorder("TextField.border");
        if (border == null) {
            border = BorderFactory.createEtchedBorder();
        }
        jPanel.setBorder(border);
        jPanel2.add((Component)jPanel, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        this.jbSet = this.createButton("\u8a2d\u5b9a", jPanel2, gridBagConstraints2);
        this.jbAdd = this.createButton("\u8ffd\u52a0", jPanel2, gridBagConstraints2);
        this.jbClear = this.createButton("\u524a\u9664", jPanel2, gridBagConstraints2);
        this.jlStatus = jLabel = new JLabel("\u8a2d\u5b9a\u7121\u3057");
        this.add((Component)jLabel, gridBagConstraints);
        this.jcbComponent.setSelectedIndex(iSelectedTableIndex);
    }

    private JCheckBox createCheckBox(String string, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setFocusable(false);
        jCheckBox.addActionListener(this);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridx;
        return jCheckBox;
    }

    private JButton createButton(String string, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        JButton jButton = new JButton(string);
        jButton.setFocusable(false);
        jButton.addActionListener(this);
        jPanel.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        return jButton;
    }

    void setInactiveColor() {
        Color color;
        Color color2 = UIManager.getColor("TextField.inactiveForeground");
        if (color2 != null) {
            this.jpKey.setForeground(color2);
        }
        if ((color = UIManager.getColor("TextField.inactiveBackground")) != null) {
            this.jpKey.setBackground(color);
        }
    }

    void setActiveColor() {
        Color color;
        Color color2 = UIManager.getColor("TextField.foreground");
        if (color2 != null) {
            this.jpKey.setForeground(color2);
        }
        if ((color = UIManager.getColor("TextField.background")) != null) {
            this.jpKey.setBackground(color);
        }
    }

    void setKeyStrokeField(KeyStroke keyStroke) {
        if (keyStroke != null) {
            int n = keyStroke.getModifiers();
            this.jcbShift.setSelected((n & 0x40) != 0);
            if (this.jcbControl != null) {
                this.jcbControl.setSelected((n & 0x80) != 0);
            }
            if (this.jcbAlt != null) {
                this.jcbAlt.setSelected((n & 0x200) != 0);
            }
            if (this.jcbOption != null) {
                this.jcbOption.setSelected((n & 0x200) != 0);
            }
            if (this.jcbCommand != null) {
                this.jcbCommand.setSelected((n & 0x100) != 0);
            }
            this.nKeyCode = keyStroke.getKeyCode();
            this.sKeyStr = KeyEvent.getKeyText(this.nKeyCode);
        } else {
            this.jcbShift.setSelected(false);
            if (this.jcbControl != null) {
                this.jcbControl.setSelected(false);
            }
            if (this.jcbAlt != null) {
                this.jcbAlt.setSelected(false);
            }
            if (this.jcbOption != null) {
                this.jcbOption.setSelected(false);
            }
            if (this.jcbCommand != null) {
                this.jcbCommand.setSelected(false);
            }
            this.nKeyCode = -1;
            this.sKeyStr = null;
        }
        this.jpKey.repaint();
        this.updateStatus();
    }

    void inputMapSelectionChanged() {
        int n = this.jcbComponent.getSelectedIndex();
        if (n < 0 || n >= slInputMapName.length) {
            return;
        }
        this.imCurrentInputMap = this.vimlInputMaps[n];
        this.setKeyStrokeField(null);
        this.jbAdd.setEnabled(!this.imCurrentInputMap.isGlobal());
        this.tmAction.setActions(V2CAction.getInputActionsToConfigure(n));
    }

    private KeyStroke getCurrentKeyStroke() {
        if (this.nKeyCode < 0) {
            return null;
        }
        int n = 0;
        if (this.jcbShift.isSelected()) {
            n |= 0x40;
        }
        if (this.jcbControl != null && this.jcbControl.isSelected()) {
            n |= 0x80;
        }
        if (this.jcbAlt != null && this.jcbAlt.isSelected()) {
            n |= 0x200;
        }
        if (this.jcbOption != null && this.jcbOption.isSelected()) {
            n |= 0x200;
        }
        if (this.jcbCommand != null && this.jcbCommand.isSelected()) {
            n |= 0x100;
        }
        return KeyStroke.getKeyStroke(this.nKeyCode, n);
    }

    void updateStatus() {
        KeyStroke[] keyStrokeArray;
        KeyStroke keyStroke = this.getCurrentKeyStroke();
        String string = "\u8a2d\u5b9a\u7121\u3057";
        if (keyStroke != null && (keyStrokeArray = this.imCurrentInputMap.keys()) != null) {
            for (int i = 0; i < keyStrokeArray.length; ++i) {
                V2CAbstractAction v2CAbstractAction;
                if (!keyStroke.equals(keyStrokeArray[i])) continue;
                Object object = this.imCurrentInputMap.get(keyStroke);
                if (!(object instanceof String) || (v2CAbstractAction = V2CAction.getAction((String)object)) == null) break;
                string = v2CAbstractAction.toString();
                if (!this.imCurrentInputMap.getName().equals("Write") || !(v2CAbstractAction instanceof V2CAction.OpenWritePanel)) break;
                string = "\u66f8\u304d\u8fbc\u307f\u6b04\u3092\u9589\u3058\u308b";
                break;
            }
        }
        this.jlStatus.setText(string);
    }

    void setKeyStroke(boolean bl) {
        KeyStroke keyStroke;
        KeyStroke keyStroke2 = this.getCurrentKeyStroke();
        if (keyStroke2 == null) {
            return;
        }
        int n = this.jtActions.getSelectedRow();
        if (n < 0) {
            return;
        }
        V2CAbstractAction v2CAbstractAction = this.tmAction.getAction(n);
        if (v2CAbstractAction == null) {
            return;
        }
        KeyStroke[] keyStrokeArray = this.imCurrentInputMap.keys();
        if (keyStrokeArray != null) {
            for (int i = 0; i < keyStrokeArray.length; ++i) {
                if (!keyStroke2.equals(keyStrokeArray[i])) continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
        if (!bl && (keyStroke = this.tmAction.getKeyStroke(n)) != null) {
            this.imCurrentInputMap.remove(keyStroke);
        }
        if (this.imCurrentInputMap.isGlobal()) {
            v2CAbstractAction.setAcceleratorKeyStroke(keyStroke2);
        }
        this.imCurrentInputMap.put(keyStroke2, v2CAbstractAction.getName());
        this.tmAction.keyStrokeChanged(n, keyStroke2, bl);
        this.bChanged = true;
    }

    void clearKeyStroke() {
        KeyStroke keyStroke;
        int n = this.jtActions.getSelectedRow();
        if (n < 0) {
            return;
        }
        V2CAbstractAction v2CAbstractAction = this.tmAction.getAction(n);
        if (v2CAbstractAction == null) {
            return;
        }
        if (this.imCurrentInputMap.isGlobal()) {
            v2CAbstractAction.setAcceleratorKeyStroke(null);
        }
        if ((keyStroke = this.tmAction.getKeyStroke(n)) != null) {
            this.imCurrentInputMap.remove(keyStroke);
        }
        this.tmAction.clearKeyStroke(n);
        this.bChanged = true;
        this.setKeyStrokeField(null);
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyPressed(KeyEvent keyEvent) {
        keyEvent.consume();
        int n = keyEvent.getKeyCode();
        if (n == 0) {
            return;
        }
        if (n == 18 || n == 65406 || n == 20 || n == 144 || n == 17 || n == 16 || n == 157) {
            return;
        }
        this.nKeyCode = n;
        this.sKeyStr = V2CInputMap.getKeyText(n);
        this.updateStatus();
        this.jpKey.repaint();
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jcbComponent) {
            this.inputMapSelectionChanged();
        } else if (object == this.jbSet) {
            this.setKeyStroke(false);
        } else if (object == this.jbAdd) {
            this.setKeyStroke(true);
        } else if (object == this.jbClear) {
            this.clearKeyStroke();
        } else if (object instanceof JCheckBox) {
            this.updateStatus();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.jtActions.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.setKeyStrokeField(this.tmAction.getKeyStroke(n));
    }

    public void focusGained(FocusEvent focusEvent) {
        this.setActiveColor();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setInactiveColor();
    }

    boolean showDialog() {
        JScrollBar jScrollBar;
        int n = iSBValue;
        if (n > 0) {
            this.scrollLater(n);
        }
        V2CSwingUtil.showDialogWithClose(this, null, "\u30ad\u30fc\u30d0\u30a4\u30f3\u30c9\u306e\u8a2d\u5b9a");
        int n2 = this.jcbComponent.getSelectedIndex();
        if (n2 >= 0 && n2 < slInputMapName.length) {
            iSelectedTableIndex = n2;
        }
        if ((jScrollBar = this.jScrollPane.getVerticalScrollBar()) != null) {
            iSBValue = jScrollBar.getValue();
        }
        return this.bChanged;
    }

    private void scrollLater(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JScrollBar jScrollBar = V2CInputMapSP.this.jScrollPane.getVerticalScrollBar();
                if (jScrollBar != null) {
                    jScrollBar.setValue(n);
                }
            }
        });
    }

    private class MouseClickListener
    extends MouseAdapter {
        private MouseClickListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            V2CInputMapSP.this.jpKey.requestFocusInWindow();
        }
    }

    private class ActionTableModel
    extends AbstractTableModel {
        int nColumns = slColNames.length;
        V2CAbstractAction[] vlAbstractActions;
        ArrayList vActions = new ArrayList();
        boolean bGlobal;
        boolean bWrite;
        int nFiltered;

        private ActionTableModel() {
        }

        void filterActions() {
            this.setActions(this.vlAbstractActions);
            V2CInputMapSP.this.scrollLater(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setActions(V2CAbstractAction[] v2CAbstractActionArray) {
            this.vlAbstractActions = v2CAbstractActionArray;
            try {
                block11: {
                    this.bGlobal = V2CInputMapSP.this.imCurrentInputMap.isGlobal();
                    this.bWrite = V2CInputMapSP.this.imCurrentInputMap.getName().equals("Write");
                    this.vActions.clear();
                    if (v2CAbstractActionArray == null) break block11;
                    if (v2CAbstractActionArray.length != 0) break block12;
                }
                Object var10_2 = null;
            }
            catch (Throwable throwable) {
                Object var10_4 = null;
                this.fireTableDataChanged();
                throw throwable;
            }
            this.fireTableDataChanged();
            {
                Object object;
                Object object2;
                block12: {
                    return;
                }
                String string = V2CMiscUtil.normalizeCase(V2CInputMapSP.this.sLastFilterWords);
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                for (int i = 0; i < v2CAbstractActionArray.length; ++i) {
                    V2CAbstractAction v2CAbstractAction = v2CAbstractActionArray[i];
                    object2 = new Object[this.nColumns + 1];
                    object2[this.nColumns - 1] = v2CAbstractAction;
                    object = V2CMiscUtil.normalizeCase(v2CAbstractAction.toString());
                    if (string.length() > 0 && ((String)object).indexOf(string) >= 0) {
                        arrayList.add((Object[])object2);
                        continue;
                    }
                    this.vActions.add(object2);
                }
                this.nFiltered = arrayList.size();
                this.vActions.addAll(0, arrayList);
                KeyStroke[] keyStrokeArray = V2CInputMapSP.this.imCurrentInputMap.keys();
                if (keyStrokeArray != null) {
                    block3: for (int i = 0; i < keyStrokeArray.length; ++i) {
                        object2 = (String)V2CInputMapSP.this.imCurrentInputMap.get(keyStrokeArray[i]);
                        if (object2 == null || (object = V2CAction.getAction((String)object2)) == null) continue;
                        for (int j = this.vActions.size() - 1; j >= 0; --j) {
                            if (((Object[])this.vActions.get(j))[this.nColumns - 1] != object) continue;
                            this.setKeyStroke(j, keyStrokeArray[i], true);
                            continue block3;
                        }
                    }
                }
            }
            Object var10_3 = null;
            this.fireTableDataChanged();
        }

        private void setKeyStroke(int n, KeyStroke keyStroke, boolean bl) {
            if (keyStroke == null) {
                return;
            }
            Object[] objectArray = (Object[])this.vActions.get(n);
            if (bl && objectArray[this.nColumns] != null) {
                Object object = objectArray[this.nColumns - 1];
                objectArray = new Object[this.nColumns + 1];
                this.vActions.add(n + 1, objectArray);
                objectArray[this.nColumns - 1] = object;
                if (n < this.nFiltered) {
                    ++this.nFiltered;
                }
            } else {
                for (int i = 0; i < this.nColumns - 1; ++i) {
                    objectArray[i] = null;
                }
            }
            objectArray[this.nColumns] = keyStroke;
            int n2 = keyStroke.getModifiers();
            if ((n2 & 0x40) != 0) {
                objectArray[0] = "S";
            }
            if (!V2CApp.isMacintosh()) {
                if ((n2 & 0x80) != 0) {
                    objectArray[1] = "C";
                }
                if ((n2 & 0x200) != 0) {
                    objectArray[2] = "A";
                }
            } else {
                if ((n2 & 0x200) != 0) {
                    objectArray[1] = "O";
                }
                if ((n2 & 0x100) != 0) {
                    objectArray[2] = "C";
                }
            }
            objectArray[this.nColumns - 2] = KeyEvent.getKeyText(keyStroke.getKeyCode());
        }

        void keyStrokeChanged(int n, KeyStroke keyStroke, boolean bl) {
            int n2 = this.vActions.size();
            this.setKeyStroke(n, keyStroke, bl);
            if (this.vActions.size() == n2) {
                this.fireTableRowsUpdated(n, n);
            } else if (this.vActions.size() == n2 + 1) {
                this.fireTableRowsInserted(n + 1, n + 1);
            }
        }

        void clearKeyStroke(int n) {
            Object[] objectArray;
            Object[] objectArray2 = (Object[])this.vActions.get(n);
            objectArray2[this.nColumns] = null;
            for (int i = 0; i < this.nColumns - 1; ++i) {
                objectArray2[i] = null;
            }
            V2CAbstractAction v2CAbstractAction = (V2CAbstractAction)objectArray2[this.nColumns - 1];
            boolean bl = false;
            if (n > 0) {
                objectArray = (Object[])this.vActions.get(n - 1);
                boolean bl2 = bl = v2CAbstractAction == objectArray[this.nColumns - 1];
            }
            if (!bl && n < this.vActions.size() - 1) {
                objectArray = (Object[])this.vActions.get(n + 1);
                boolean bl3 = bl = v2CAbstractAction == objectArray[this.nColumns - 1];
            }
            if (bl) {
                this.vActions.remove(n);
                if (n < this.nFiltered) {
                    --this.nFiltered;
                }
                this.fireTableRowsDeleted(n, n);
            } else {
                this.fireTableRowsUpdated(n, n);
            }
        }

        V2CAbstractAction getAction(int n) {
            if (n < 0 || n >= this.vActions.size()) {
                return null;
            }
            return (V2CAbstractAction)((Object[])this.vActions.get(n))[this.nColumns - 1];
        }

        KeyStroke getKeyStroke(int n) {
            if (n < 0 || n >= this.vActions.size()) {
                return null;
            }
            return (KeyStroke)((Object[])this.vActions.get(n))[this.nColumns];
        }

        public int getRowCount() {
            return this.vActions.size();
        }

        public int getColumnCount() {
            return this.nColumns;
        }

        public String getColumnName(int n) {
            return slColNames[n];
        }

        public Object getValueAt(int n, int n2) {
            Object object = ((Object[])this.vActions.get(n))[n2];
            if (!this.bWrite && !this.bGlobal || n2 < this.nColumns - 1) {
                return object;
            }
            if (this.bGlobal) {
                String string;
                if (object instanceof V2CAbstractAction && (string = ((V2CAbstractAction)object).getName()) != null && string.startsWith("ThreadPanel")) {
                    return object.toString() + " [\u30ec\u30b9\u8868\u793a\u6b04]";
                }
            } else if (this.bWrite && object instanceof V2CAction.OpenWritePanel) {
                return "\u66f8\u304d\u8fbc\u307f\u6b04\u3092\u9589\u3058\u308b";
            }
            return object;
        }
    }

    private class FilterListener
    extends V2CTextChangeListener {
        FilterListener() {
            super(V2CInputMapSP.this.jtfFilter);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.isComposing()) {
                return;
            }
            V2CInputMapSP.this.sLastFilterWords = V2CInputMapSP.this.jtfFilter.getText();
            V2CInputMapSP.this.tmAction.filterActions();
        }
    }
}

