/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CCheckBoxRenderer;
import org.monazilla.v2c.V2CImageIcon;
import org.monazilla.v2c.V2CImageSet;
import org.monazilla.v2c.V2CImageViewerPanel;
import org.monazilla.v2c.V2CInputMap;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CNGFileItem;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadAndRes;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadPanel;

public class V2CImageViewer
extends JTabbedPane
implements ActionListener,
MouseWheelListener,
WindowListener,
ChangeListener {
    static final int CLOSE_OTHER = 0;
    static final int CLOSE_LEFT = -1;
    static final int CLOSE_RIGHT = 1;
    static V2CImageViewer vImageViewer;
    static final HashMap hmLinks;
    static boolean bShrinkable;
    static boolean bGrabImageMemory;
    static int iSerialNumber;
    JDialog jDialog;
    Insets insDialog;
    boolean bDialogShown;
    boolean bDialogRestored;
    Timer tRepaintTimer;
    volatile boolean bRepaintTimerRunning;
    volatile long ltLastRepaint;
    Rectangle2D rTabBounds;
    Timer tResizeTimer;
    int nResizeCount;
    Dimension dShrinked;
    Rectangle rDialogBounds;
    Dimension dFullSize;
    Dimension dRestoredSize;
    Rectangle rNormalBounds;
    boolean bDialogMaximized;
    V2CImageViewerPanel vCurrentPanel;
    V2CCheckBoxRenderer vCheckBoxRenderer;
    boolean bDrawCheckBox;
    private static final Insets insZero;

    static V2CImageViewer getInstance() {
        return vImageViewer;
    }

    static synchronized int getSerialNumber() {
        return ++iSerialNumber;
    }

    static void clearRefs() {
        V2CImageViewer v2CImageViewer = vImageViewer;
        if (v2CImageViewer != null) {
            v2CImageViewer.clearRefs(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean contains(V2CLink v2CLink) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap = hmLinks;
        synchronized (hashMap2) {
            return hashMap.containsKey(v2CLink);
        }
    }

    static void notifyLinkStateChange(V2CLink v2CLink) {
        V2CImageViewer v2CImageViewer = vImageViewer;
        if (v2CImageViewer != null) {
            v2CImageViewer.linkStateChanged(v2CLink);
        }
    }

    static void showWindow() {
        V2CImageViewer v2CImageViewer = vImageViewer;
        if (v2CImageViewer == null) {
            V2CSwingUtil.showErrorMessage("\u753b\u50cf\u30d3\u30e5\u30fc\u30a2\u3067\u958b\u304b\u308c\u3066\u3044\u308b\u753b\u50cf\u304c\u3042\u308a\u307e\u305b\u3093\u3002", "\u753b\u50cf\u30d3\u30e5\u30fc\u30a2");
            return;
        }
        v2CImageViewer.activateWindow();
    }

    static void addImage(V2CLink v2CLink, V2CThreadAndRes v2CThreadAndRes, int n) {
        V2CImageViewer.addImage(v2CLink, V2CLink.nViewerImageSize, v2CThreadAndRes, false, n);
    }

    static void addImage(V2CLink v2CLink, int n, V2CThreadAndRes v2CThreadAndRes, boolean bl) {
        V2CImageViewer.addImage(v2CLink, n, v2CThreadAndRes, bl, -1);
    }

    private static void addImage(final V2CLink v2CLink, final int n, final V2CThreadAndRes v2CThreadAndRes, final boolean bl, int n2) {
        int n3;
        if (v2CLink == null || !v2CLink.isEnabled() || v2CLink.isNGFile() || !v2CLink.isChecking() && !v2CLink.hasImageCache()) {
            return;
        }
        int n4 = n3 = n2 >= 0 ? n2 : V2CImageViewer.getSerialNumber();
        if (SwingUtilities.isEventDispatchThread()) {
            V2CImageViewer.addImage0(v2CLink, n, v2CThreadAndRes, bl, n3);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        V2CImageViewer.addImage0(v2CLink, n, v2CThreadAndRes, bl, n3);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void addImage0(V2CLink v2CLink, int n, V2CThreadAndRes v2CThreadAndRes, boolean bl, int n2) {
        V2CImageViewer v2CImageViewer = vImageViewer;
        if (v2CImageViewer == null) {
            vImageViewer = v2CImageViewer = new V2CImageViewer();
        }
        v2CImageViewer.add(v2CLink, n, v2CThreadAndRes, bl, n2);
    }

    private V2CImageViewer() {
        bGrabImageMemory = V2CLink.bGrabViewerImageMemory;
        this.setTabLayoutPolicy(1);
        this.setFocusable(false);
        this.addMouseListener(new PopupListener());
        this.addMouseWheelListener(this);
        this.addChangeListener(this);
        if (V2CApp.isWinType()) {
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    Dimension dimension = V2CImageViewer.this.dRestoredSize;
                    JDialog jDialog = V2CImageViewer.this.jDialog;
                    if (dimension != null && jDialog != null) {
                        Dimension dimension2 = jDialog.getSize();
                        if (dimension2.equals(V2CImageViewer.this.dShrinked)) {
                            jDialog.pack();
                        }
                        V2CImageViewer.this.dRestoredSize = null;
                    }
                }
            });
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n;
        Component component = this.getSelectedComponent();
        if (component != null) {
            Rectangle rectangle = component.getBounds();
            if (mouseWheelEvent.getY() >= rectangle.y) {
                return;
            }
        }
        switch (mouseWheelEvent.getScrollType()) {
            case 0: {
                n = mouseWheelEvent.getUnitsToScroll();
                break;
            }
            case 1: {
                n = mouseWheelEvent.getWheelRotation();
                break;
            }
            default: {
                return;
            }
        }
        if (n != 0) {
            this.selectTab(false, n > 0, mouseWheelEvent);
        }
    }

    private boolean isInCheckBox(MouseEvent mouseEvent) {
        int n;
        if (!this.bDrawCheckBox) {
            return false;
        }
        int n2 = mouseEvent.getX();
        int n3 = this.indexAtLocation(n2, n = mouseEvent.getY());
        if (n3 < 0) {
            return false;
        }
        int n4 = 4 * V2CCheckBoxRenderer.getBoxWidth() / 5;
        int n5 = 4 * V2CCheckBoxRenderer.getBoxHeight() / 5;
        Rectangle rectangle = this.getBoundsAt(n3);
        return rectangle != null && n2 >= rectangle.x && n2 <= rectangle.x + n4 && n >= rectangle.y + rectangle.height - n5 && n <= rectangle.y + rectangle.height;
    }

    public void updateUI() {
        this.setUI(new ViewerUI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(V2CLink v2CLink, int n, V2CThreadAndRes v2CThreadAndRes, boolean bl, int n2) {
        JDialog jDialog = this.jDialog;
        boolean bl2 = jDialog == null;
        boolean bl3 = V2CMain.isIconified();
        HashMap hashMap = hmLinks;
        Object object = hashMap;
        synchronized (object) {
            if (hashMap.containsKey(v2CLink)) {
                int n3;
                if (!bl2 && !jDialog.isVisible()) {
                    if (!bl || V2CLink.bStartViewerShrinked) {
                        this.bDialogRestored = true;
                    }
                    if (!bl3) {
                        jDialog.setVisible(true);
                    }
                }
                if (bl && (n3 = this.getIndexOfLink(v2CLink)) >= 0) {
                    this.setSelectedIndex(n3);
                    if (!bl3 && !V2CLink.bStartViewerShrinked && V2CMain.hasFocusInApplication()) {
                        this.getPanelAt(n3).requestFocus();
                    }
                }
                return;
            }
        }
        if (bl2) {
            V2CImageIcon.updateIconSizes();
        }
        object = V2CImageIcon.createIcon(v2CLink, n2);
        V2CImageViewerPanel v2CImageViewerPanel = new V2CImageViewerPanel(v2CLink, n, v2CThreadAndRes, this);
        Serializable serializable = hashMap;
        synchronized (serializable) {
            hashMap.put(v2CLink, v2CImageViewerPanel);
        }
        serializable = new JScrollPane(v2CImageViewerPanel);
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            V2CImageIcon v2CImageIcon = (V2CImageIcon)this.getIconAt(i);
            if (n2 <= v2CImageIcon.getSerialNumber()) continue;
            this.insertTab(null, (Icon)object, (Component)serializable, null, i + 1);
            object = null;
            break;
        }
        if (object != null) {
            this.insertTab(null, (Icon)object, (Component)serializable, null, 0);
        }
        if (bl2) {
            this.vCurrentPanel = v2CImageViewerPanel;
            this.showFrame(bl);
        } else {
            if (!jDialog.isVisible()) {
                if (!bl || V2CLink.bStartViewerShrinked) {
                    this.bDialogRestored = true;
                }
                if (!bl3) {
                    jDialog.setVisible(true);
                }
            }
            if (bl) {
                this.setSelectedIndex(this.getTabCount() - 1);
                if (!bl3 && !V2CLink.bStartViewerShrinked && V2CMain.hasFocusInApplication()) {
                    v2CImageViewerPanel.requestFocus();
                }
            }
        }
        this.setDialogTitle();
    }

    V2CImageViewerPanel getSelectedPanel() {
        return this.getPanelAt(this.getSelectedIndex());
    }

    V2CImageViewerPanel getPanelAt(int n) {
        return n >= 0 && n < this.getTabCount() ? (V2CImageViewerPanel)((JScrollPane)this.getComponentAt(n)).getViewport().getView() : null;
    }

    int getIndexOfLink(V2CLink v2CLink) {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            if (((V2CImageIcon)this.getIconAt(i)).getLink() != v2CLink) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadStateChanged(V2CLink v2CLink) {
        V2CImageViewerPanel v2CImageViewerPanel;
        HashMap hashMap;
        HashMap hashMap2 = hashMap = hmLinks;
        synchronized (hashMap2) {
            v2CImageViewerPanel = (V2CImageViewerPanel)hashMap.get(v2CLink);
        }
        if (v2CImageViewerPanel == null) {
            return;
        }
        try {
            Rectangle rectangle;
            int n = this.getIndexOfLink(v2CLink);
            if (n >= 0 && ((V2CImageIcon)this.getIconAt(n)).downloadStateChanged(v2CLink) && (rectangle = this.getBoundsAt(n)) != null) {
                this.requestRepaintTab(rectangle);
            }
            if (n == this.getSelectedIndex()) {
                this.setDialogTitle();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void requestRepaintTab(Rectangle rectangle) {
        if (this.bRepaintTimerRunning) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l > this.ltLastRepaint + 200L) {
            this.ltLastRepaint = l;
            this.repaint(rectangle);
            return;
        }
        this.bRepaintTimerRunning = true;
        Rectangle2D rectangle2D = this.rTabBounds;
        this.rTabBounds = rectangle2D != null ? rectangle2D.createUnion(rectangle) : rectangle;
        Timer timer = this.tRepaintTimer;
        if (timer == null) {
            timer = new Timer(200, this);
            timer.setRepeats(false);
            this.tRepaintTimer = timer;
        }
        if (!timer.isRunning()) {
            timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void linkStateChanged(V2CLink v2CLink) {
        V2CImageViewerPanel v2CImageViewerPanel;
        HashMap hashMap;
        HashMap hashMap2 = hashMap = hmLinks;
        synchronized (hashMap2) {
            v2CImageViewerPanel = (V2CImageViewerPanel)hashMap.get(v2CLink);
        }
        if (v2CImageViewerPanel == null) {
            return;
        }
        try {
            if (!v2CLink.isEnabled() || v2CLink.isNGFile() || !v2CLink.containedInHistory()) {
                int n = this.getIndexOfLink(v2CLink);
                if (n >= 0) {
                    this.closeTab(n);
                }
                return;
            }
            boolean bl = v2CImageViewerPanel == this.getSelectedPanel();
            v2CImageViewerPanel.linkStateChanged(bl);
            if (bl) {
                this.setDialogTitle();
            }
            for (int i = this.getTabCount() - 1; i >= 0; --i) {
                if (!((V2CImageIcon)this.getIconAt(i)).thumbnailImageUpdated(v2CLink)) continue;
                this.repaint(this.getBoundsAt(i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void imageUpdated(V2CImageSet v2CImageSet) {
        V2CImageViewerPanel v2CImageViewerPanel = this.getSelectedPanel();
        if (v2CImageViewerPanel != null && v2CImageSet == v2CImageViewerPanel.getImageSet(true)) {
            v2CImageViewerPanel.repaint();
        }
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            Icon icon = this.getIconAt(i);
            if (v2CImageSet != ((V2CImageIcon)icon).getImageSet()) continue;
            this.repaint(this.getBoundsAt(i));
        }
    }

    void performAction(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("CloseOldTab")) {
            this.closeOldTabs();
        } else if (string.equals("RemoveAllLinkHistory")) {
            this.removeAllLinkHistory();
        } else if (string.equals("CheckToHere")) {
            int n = this.getSelectedIndex();
            if (n < 0) {
                return;
            }
            for (int i = n; i >= 0; --i) {
                ((V2CImageIcon)this.getIconAt(i)).setChecked(true);
            }
            this.bDrawCheckBox = true;
            this.repaint();
        } else if (string.equals("CheckFromHere")) {
            int n = this.getSelectedIndex();
            if (n < 0) {
                return;
            }
            for (int i = this.getTabCount() - 1; i >= n; --i) {
                ((V2CImageIcon)this.getIconAt(i)).setChecked(true);
            }
            this.bDrawCheckBox = true;
            this.repaint();
        } else if (string.equals("ClearCheckFromHere")) {
            int n;
            int n2 = this.getSelectedIndex();
            if (n2 < 0) {
                return;
            }
            for (n = this.getTabCount() - 1; n >= n2; --n) {
                ((V2CImageIcon)this.getIconAt(n)).setChecked(false);
            }
            n = 0;
            for (int i = n2 - 1; i >= 0; --i) {
                if (!((V2CImageIcon)this.getIconAt(i)).isChecked()) continue;
                n = 1;
                break;
            }
            this.bDrawCheckBox = n;
            this.repaint();
        } else if (string.equals("InvertAllCheck")) {
            boolean bl = false;
            for (int i = this.getTabCount() - 1; i >= 0; --i) {
                boolean bl2;
                V2CImageIcon v2CImageIcon = (V2CImageIcon)this.getIconAt(i);
                boolean bl3 = bl2 = !v2CImageIcon.isChecked();
                if (bl2) {
                    bl = true;
                }
                v2CImageIcon.setChecked(bl2);
            }
            this.bDrawCheckBox = bl;
            this.repaint();
        } else if (string.equals("ClearAllCheck")) {
            this.bDrawCheckBox = false;
            for (int i = this.getTabCount() - 1; i >= 0; --i) {
                ((V2CImageIcon)this.getIconAt(i)).setChecked(false);
            }
            this.repaint();
        } else if (string.equals("CloseTabWithoutCheck")) {
            for (int i = this.getTabCount() - 1; i >= 0; --i) {
                if (((V2CImageIcon)this.getIconAt(i)).isChecked()) continue;
                this.closeTab(i);
            }
        }
    }

    void toggleCheckSelectedTab() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return;
        }
        V2CImageIcon v2CImageIcon = (V2CImageIcon)this.getIconAt(n);
        boolean bl = !v2CImageIcon.isChecked();
        v2CImageIcon.setChecked(bl);
        this.checkDrawCheckBox();
        this.repaint();
    }

    void checkDrawCheckBox() {
        boolean bl = false;
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            if (!((V2CImageIcon)this.getIconAt(i)).isChecked()) continue;
            bl = true;
            break;
        }
        this.bDrawCheckBox = bl;
    }

    boolean getDrawCheckBox() {
        return this.bDrawCheckBox;
    }

    void closeWindow() {
        if (V2CLink.bCloseWindowHoldingTab) {
            JDialog jDialog = this.jDialog;
            if (jDialog != null) {
                jDialog.setVisible(false);
            }
        } else {
            this.closeAllTabs();
        }
    }

    void closeErrorTabs() {
        boolean bl = V2CLink.bNETimeOut;
        boolean bl2 = V2CLink.bNE503;
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            V2CLink v2CLink = ((V2CImageIcon)this.getIconAt(i)).getLink();
            if (v2CLink.isChecking() || v2CLink.hasImageCache()) continue;
            if (bl || bl2) {
                int n = v2CLink.getResponseCode();
                if (bl && n == 3 || bl2 && n == 503) continue;
            }
            this.closeTab(i);
        }
    }

    void closeOldTabs() {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            V2CLink v2CLink = ((V2CImageIcon)this.getIconAt(i)).getLink();
            if (v2CLink.isChecking() || !v2CLink.hasImageCache() || v2CLink.isNewImage()) continue;
            this.closeTab(i);
        }
    }

    void removeAllLinkHistory() {
        int n;
        ArrayList<V2CLink> arrayList = new ArrayList<V2CLink>();
        for (n = this.getTabCount() - 1; n >= 0; --n) {
            arrayList.add(((V2CImageIcon)this.getIconAt(n)).getLink());
        }
        V2CLink.setImageViewerShown(false);
        this.closeAllTabs();
        for (n = arrayList.size() - 1; n >= 0; --n) {
            ((V2CLink)arrayList.get(n)).deleteHistory();
        }
    }

    void clearRefs(boolean bl) {
        if (!bl && bGrabImageMemory) {
            return;
        }
        int n = bl ? -1 : this.getSelectedIndex();
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            if (i == n) continue;
            V2CImageViewerPanel v2CImageViewerPanel = this.getPanelAt(i);
            v2CImageViewerPanel.resetImage(false);
        }
    }

    void closeAllTabs() {
        this.disposeWindow();
    }

    void closeSelectedTab() {
        int n = this.getSelectedIndex();
        if (n >= 0) {
            this.closeTab(n);
        }
    }

    void closeUnselectedTabs(int n) {
        int n2 = this.getSelectedIndex();
        if (n2 < 0) {
            return;
        }
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            if (i == n2 || (i - n2) * n < 0) continue;
            this.closeTab(i);
        }
    }

    void closeTab(V2CLink v2CLink) {
        int n = this.getIndexOfLink(v2CLink);
        if (n >= 0) {
            this.closeTab(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeTab(int n) {
        if (this.getTabCount() <= 1) {
            this.closeAllTabs();
            return;
        }
        V2CImageViewerPanel v2CImageViewerPanel = this.getPanelAt(n);
        V2CImageIcon v2CImageIcon = (V2CImageIcon)this.getIconAt(n);
        this.remove(n);
        if (v2CImageViewerPanel != null) {
            HashMap hashMap;
            HashMap hashMap2 = hashMap = hmLinks;
            synchronized (hashMap2) {
                hashMap.remove(v2CImageViewerPanel.getLink());
            }
        }
        if (this.bDrawCheckBox && v2CImageIcon != null && v2CImageIcon.isChecked()) {
            this.checkDrawCheckBox();
        }
        this.setDialogTitle();
    }

    void selectTab(boolean bl, boolean bl2, MouseWheelEvent mouseWheelEvent) {
        boolean bl3;
        int n = this.getTabCount();
        if (n < 2) {
            return;
        }
        if (bl) {
            this.setSelectedIndex(bl2 ? n - 1 : 0);
            return;
        }
        int n2 = this.getSelectedIndex();
        if (n2 < 0) {
            return;
        }
        n2 = bl2 ? ++n2 : --n2;
        int n3 = (n2 + n) % n;
        boolean bl4 = bl2 ? n3 == 0 : (bl3 = n2 < 0);
        if (!bl3 || !V2CLink.bDontWrapTabSelection || mouseWheelEvent == null || mouseWheelEvent.isShiftDown()) {
            this.setSelectedIndex(n3);
        }
        if (V2CLink.bWarnWrapTabSelection && bl3 && (!V2CLink.bDontWrapTabSelection || mouseWheelEvent == null)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    V2CCheckBoxRenderer getCheckBoxRenderer() {
        V2CCheckBoxRenderer v2CCheckBoxRenderer = this.vCheckBoxRenderer;
        if (v2CCheckBoxRenderer == null) {
            this.vCheckBoxRenderer = v2CCheckBoxRenderer = new V2CCheckBoxRenderer();
        }
        return v2CCheckBoxRenderer;
    }

    private V2CLink[] getCheckedLinks() {
        ArrayList<V2CLink> arrayList = new ArrayList<V2CLink>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            V2CLink v2CLink;
            V2CImageIcon v2CImageIcon = (V2CImageIcon)this.getIconAt(i);
            if (!v2CImageIcon.isChecked() || (v2CLink = v2CImageIcon.getLink()) == null) continue;
            arrayList.add(v2CLink);
        }
        return arrayList.size() > 0 ? arrayList.toArray(new V2CLink[arrayList.size()]) : null;
    }

    void copyLinkLocation(String string) {
        if (string != null && string.equals("VC")) {
            V2CLink[] v2CLinkArray = this.getCheckedLinks();
            if (v2CLinkArray == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < v2CLinkArray.length; ++i) {
                stringBuffer.append(v2CLinkArray[i].getURLString());
                stringBuffer.append('\n');
            }
            if (stringBuffer.length() > 0) {
                V2CMain.copyString(stringBuffer.substring(0, stringBuffer.length() - 1));
            }
        }
    }

    void disableLink(String string) {
        if (string != null && string.equals("VC")) {
            V2CLink[] v2CLinkArray = this.getCheckedLinks();
            if (v2CLinkArray == null) {
                return;
            }
            for (int i = v2CLinkArray.length - 1; i >= 0; --i) {
                v2CLinkArray[i].disable();
            }
        }
    }

    void addToNGFile(String string, boolean bl) {
        if (string != null && string.equals("VC")) {
            String string2;
            V2CLink[] v2CLinkArray = this.getCheckedLinks();
            if (v2CLinkArray == null) {
                return;
            }
            if (bl) {
                string2 = "";
            } else {
                string2 = V2CNGFileItem.getInputComment();
                if (string2 == null) {
                    return;
                }
            }
            for (int i = v2CLinkArray.length - 1; i >= 0; --i) {
                v2CLinkArray[i].addToNGFile(string2);
            }
        }
    }

    void deleteLinkCache(String string) {
        if (string != null && string.equals("VC")) {
            V2CLink[] v2CLinkArray = this.getCheckedLinks();
            if (v2CLinkArray == null) {
                return;
            }
            for (int i = v2CLinkArray.length - 1; i >= 0; --i) {
                v2CLinkArray[i].deleteHistory();
            }
        }
    }

    void setProtectCache(boolean bl) {
        V2CLink[] v2CLinkArray = this.getCheckedLinks();
        if (v2CLinkArray == null) {
            return;
        }
        for (int i = v2CLinkArray.length - 1; i >= 0; --i) {
            v2CLinkArray[i].setProtectCache(bl);
        }
        this.repaint();
        V2CThreadPanel.repaintActivePanel(true);
    }

    void saveImage(String string, File file, boolean bl) {
        int n;
        V2CThreadItem[] v2CThreadItemArray;
        V2CLink[] v2CLinkArray;
        boolean bl2;
        if (string == null) {
            return;
        }
        if (string.equals("VC")) {
            bl2 = true;
        } else if (string.equals("VA")) {
            bl2 = false;
        } else {
            return;
        }
        ArrayList<V2CLink[]> arrayList = new ArrayList<V2CLink[]>();
        ArrayList<V2CThreadItem[]> arrayList2 = new ArrayList<V2CThreadItem[]>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            V2CImageIcon v2CImageIcon = (V2CImageIcon)this.getIconAt(i);
            if (bl2 && !v2CImageIcon.isChecked()) continue;
            v2CLinkArray = v2CImageIcon.getLink();
            v2CThreadItemArray = this.getPanelAt(i).getThreadItem();
            if (v2CLinkArray == null || v2CThreadItemArray == null) continue;
            arrayList.add(v2CLinkArray);
            arrayList2.add(v2CThreadItemArray);
        }
        Window window = this.jDialog;
        if (window == null) {
            window = V2CMain.v2cMain;
        }
        if ((n = arrayList.size()) == 0) {
            return;
        }
        v2CLinkArray = arrayList.toArray(new V2CLink[n]);
        v2CThreadItemArray = arrayList2.toArray(new V2CThreadItem[n]);
        V2CLink.saveImages(v2CLinkArray, (Component)window, file, v2CThreadItemArray, bl);
    }

    void showFrame(boolean bl) {
        int n;
        V2CPackedPropValue v2CPackedPropValue = V2CApp.getUserProperty().getPackedValue("ImageViewer.Conf");
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        if (v2CPackedPropValue != null) {
            rectangle = v2CPackedPropValue.getRectangle('B');
            rectangle2 = v2CPackedPropValue.getRectangle('N');
        }
        bShrinkable = !V2CLink.bNotShrinkViewer;
        JDialog jDialog = this.jDialog;
        if (jDialog != null) {
            jDialog.dispose();
        }
        this.jDialog = jDialog = new JDialog((Frame)V2CMain.v2cMain, false);
        jDialog.getRootPane().enableInputMethods(false);
        jDialog.setDefaultCloseOperation(1);
        Container container = jDialog.getContentPane();
        container.add((Component)this, "Center");
        Rectangle rectangle3 = V2CMain.v2cMain.getBounds();
        Rectangle rectangle4 = rectangle != null ? rectangle : rectangle3;
        Rectangle rectangle5 = V2CSwingUtil.getScreenBoundsAt(rectangle4.x + rectangle4.width / 2, rectangle4.y + rectangle4.height / 2);
        if (rectangle != null) {
            this.checkDialogBounds(rectangle, rectangle5);
        } else {
            n = rectangle5.width;
            int n2 = rectangle5.height;
            rectangle = new Rectangle((int)((double)n * 0.1), (int)((double)n2 * 0.1), (int)((double)n * 0.8), (int)((double)n2 * 0.8));
        }
        if (rectangle2 != null) {
            this.checkDialogBounds(rectangle2, rectangle5);
        } else {
            rectangle2 = rectangle;
        }
        if (container instanceof JComponent) {
            V2CInputMap.setKeyBind((JComponent)container, 1, "Global");
        }
        this.rDialogBounds = rectangle;
        this.rNormalBounds = rectangle2;
        jDialog.addWindowListener(this);
        V2CMain.v2cMain.addWindowListener(this);
        this.setDialogTitle();
        if (bShrinkable && (!bl || V2CLink.bStartViewerShrinked)) {
            jDialog.setLocation(rectangle.x, rectangle.y);
            n = rectangle.width;
            this.setPreferredSize(new Dimension(n, V2CImageIcon.getTabHeight()));
            jDialog.pack();
            Insets insets = jDialog.getInsets();
            this.dFullSize = new Dimension(n -= insets.left + insets.right, rectangle.height - insets.top - insets.bottom);
            this.setPreferredSize(new Dimension(n, V2CImageIcon.getTabHeight()));
            jDialog.pack();
        } else {
            this.bDialogShown = !V2CLink.bStartViewerShrinked;
            jDialog.setBounds(rectangle);
        }
        if (!V2CMain.isIconified()) {
            jDialog.setVisible(true);
        }
        this.insDialog = jDialog.getInsets();
        V2CLink.setImageViewerShown(true);
    }

    void checkDialogBounds(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            return;
        }
        int n = rectangle2.width;
        int n2 = rectangle2.height;
        if (rectangle.width > n) {
            rectangle.width = n;
        }
        if (rectangle.height > n2) {
            rectangle.height = n2;
        }
        if (rectangle.x < rectangle2.x) {
            rectangle.x = rectangle2.x;
        } else if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
            rectangle.x = rectangle2.x + rectangle2.width - rectangle.width;
        }
        if (rectangle.y < rectangle2.y) {
            rectangle.y = rectangle2.y;
        } else if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
            rectangle.y = rectangle2.y + rectangle2.height - rectangle.height;
        }
    }

    void activateWindow() {
        if (V2CMain.isIconified()) {
            return;
        }
        JDialog jDialog = this.jDialog;
        if (jDialog != null) {
            if (jDialog.isVisible()) {
                Component component = jDialog.getMostRecentFocusOwner();
                if (component != null) {
                    component.requestFocus();
                }
            } else {
                jDialog.setVisible(true);
            }
        }
    }

    void setDialogTitle() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return;
        }
        V2CImageIcon v2CImageIcon = (V2CImageIcon)this.getIconAt(n);
        if (v2CImageIcon == null) {
            return;
        }
        V2CImageViewerPanel v2CImageViewerPanel = this.getPanelAt(n);
        if (v2CImageViewerPanel == null) {
            return;
        }
        JDialog jDialog = this.jDialog;
        if (jDialog == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(n + 1);
        stringBuffer.append("/");
        stringBuffer.append(this.getTabCount());
        stringBuffer.append(") ");
        stringBuffer.append(v2CImageIcon.getStateString());
        stringBuffer.append(": ");
        v2CImageViewerPanel.appendStatusString(stringBuffer);
        jDialog.setTitle(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.tResizeTimer) {
            if (this.dFullSize != null) {
                return;
            }
            JDialog jDialog = this.jDialog;
            Dimension dimension = this.dShrinked;
            if (jDialog == null || this.nResizeCount <= 0 || dimension == null) {
                return;
            }
            Dimension dimension2 = jDialog.getSize();
            if (!dimension2.equals(dimension)) {
                this.dRestoredSize = dimension2;
                return;
            }
            --this.nResizeCount;
            jDialog.pack();
            this.tResizeTimer.start();
        } else if (object == this.tRepaintTimer) {
            V2CImageViewer v2CImageViewer = this;
            synchronized (v2CImageViewer) {
                this.bRepaintTimerRunning = false;
                this.ltLastRepaint = System.currentTimeMillis();
                Rectangle2D rectangle2D = this.rTabBounds;
                if (rectangle2D != null) {
                    this.rTabBounds = null;
                    this.repaint(rectangle2D.getBounds());
                }
            }
        }
    }

    void maximizeWindow() {
        JDialog jDialog = this.jDialog;
        if (jDialog == null) {
            return;
        }
        Rectangle rectangle = jDialog.getBounds();
        Rectangle rectangle2 = V2CSwingUtil.getScreenBoundsAt(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        if (rectangle2 == null) {
            return;
        }
        Dimension dimension = this.dFullSize;
        if (dimension != null) {
            rectangle.setSize(dimension);
        }
        if (rectangle.width < rectangle2.width - 2 || rectangle.height < rectangle2.height - 2) {
            this.rNormalBounds = rectangle;
            this.bDialogMaximized = true;
            jDialog.setBounds(rectangle2);
        } else if (this.rNormalBounds != null) {
            jDialog.setBounds(this.rNormalBounds);
        } else if (dimension != null) {
            jDialog.setSize(dimension);
        }
    }

    boolean isShrinked() {
        return this.dFullSize != null;
    }

    void setShrink(final boolean bl) {
        boolean bl2;
        if (bl && !bShrinkable) {
            return;
        }
        boolean bl3 = bl2 = this.bDialogShown && !this.bDialogRestored;
        if (!bl2) {
            this.bDialogShown = true;
            this.bDialogRestored = false;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (bl2) {
                    V2CImageViewer.this.setShrink0(bl);
                } else {
                    V2CMain.v2cMain.activateWindow();
                }
            }
        });
    }

    private void setShrink0(boolean bl) {
        boolean bl2;
        Dimension dimension = this.dFullSize;
        boolean bl3 = bl2 = dimension != null;
        if (bShrinkable ? bl == bl2 : bl || !bl2) {
            return;
        }
        JDialog jDialog = this.jDialog;
        if (jDialog == null) {
            return;
        }
        boolean bl4 = !bl;
        Container container = jDialog.getContentPane();
        if (bl4) {
            this.dShrinked = jDialog.getSize();
            int n = this.getHeight();
            if (dimension.height < n + 50) {
                dimension.height = n + 50;
            }
            this.setPreferredSize(dimension);
            this.invalidate();
            jDialog.pack();
            this.dFullSize = null;
            this.nResizeCount = 30;
            Timer timer = this.tResizeTimer;
            if (timer == null) {
                timer = new Timer(100, this);
                timer.setRepeats(false);
                this.tResizeTimer = timer;
            }
            timer.start();
        } else {
            this.dShrinked = null;
            this.rDialogBounds = jDialog.getBounds();
            Rectangle rectangle = this.getBounds();
            this.dFullSize = new Dimension(rectangle.width, rectangle.height);
            this.setPreferredSize(new Dimension(rectangle.width, V2CImageIcon.getTabHeight()));
            this.invalidate();
            jDialog.pack();
        }
    }

    private void saveWindowGeometry(JDialog jDialog) {
        Rectangle rectangle;
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        V2CPackedPropValue v2CPackedPropValue = v2CProperty.getPackedValue("ImageViewer.Conf");
        if (v2CPackedPropValue == null) {
            v2CPackedPropValue = new V2CPackedPropValue();
        }
        if ((rectangle = this.rDialogBounds) == null) {
            rectangle = jDialog.getBounds();
            if (this.dFullSize != null && this.insDialog != null) {
                rectangle.height = this.dFullSize.height + this.insDialog.top + this.insDialog.bottom;
            }
        }
        v2CPackedPropValue.setRectangle('B', rectangle);
        Rectangle rectangle2 = this.rNormalBounds;
        if (rectangle2 != null) {
            v2CPackedPropValue.setRectangle('N', rectangle2);
        }
        v2CProperty.putPackedValue("ImageViewer.Conf", v2CPackedPropValue);
    }

    void disposeWindow() {
        JDialog jDialog = this.jDialog;
        if (jDialog == null) {
            return;
        }
        if (this.dFullSize == null) {
            this.rDialogBounds = jDialog.getBounds();
        }
        jDialog.dispose();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        JDialog jDialog = this.jDialog;
        if (jDialog == null) {
            return;
        }
        if (this.dFullSize == null) {
            this.rDialogBounds = jDialog.getBounds();
        }
        if (V2CLink.bCloseWindowHoldingTab) {
            this.saveWindowGeometry(jDialog);
        } else {
            jDialog.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowClosed(WindowEvent windowEvent) {
        vImageViewer = null;
        V2CLink.setImageViewerShown(false);
        V2CMain.v2cMain.removeWindowListener(this);
        Serializable serializable = hmLinks;
        synchronized (serializable) {
            hmLinks.clear();
        }
        serializable = this.jDialog;
        if (serializable == null) {
            return;
        }
        ((Window)serializable).removeWindowListener(this);
        ((JDialog)serializable).getContentPane().remove(this);
        this.saveWindowGeometry((JDialog)serializable);
        this.clearRefs(true);
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        boolean bl;
        boolean bl2;
        Component component = windowEvent.getComponent();
        if (component == this.jDialog) {
            bl2 = false;
        } else if (component == V2CMain.v2cMain) {
            bl2 = true;
        } else {
            return;
        }
        if (V2CApp.isWinType() && !V2CApp.getUseJavaLAF()) {
            UIManager.put("PopupMenu.consumeEventOnClose", bl2);
        }
        if (!bShrinkable && !this.bDialogShown && this.dFullSize == null) {
            this.bDialogShown = true;
            V2CMain.v2cMain.activateWindow();
            return;
        }
        this.dRestoredSize = null;
        boolean bl3 = bl = this.dFullSize != null;
        if (bShrinkable ? bl != bl2 : bl && !bl2) {
            this.setShrink(bl2);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        V2CImageViewerPanel v2CImageViewerPanel = this.vCurrentPanel;
        V2CImageViewerPanel v2CImageViewerPanel2 = this.getSelectedPanel();
        if (v2CImageViewerPanel2 != null && v2CImageViewerPanel != null && v2CImageViewerPanel2 != v2CImageViewerPanel) {
            v2CImageViewerPanel.releaseImageReference();
            this.vCurrentPanel = v2CImageViewerPanel2;
        }
        this.setDialogTitle();
    }

    static {
        hmLinks = new HashMap();
        insZero = new Insets(0, 0, 0, 0);
    }

    private static class ViewerUI
    extends BasicTabbedPaneUI {
        private ViewerUI() {
        }

        protected Insets getTabInsets(int n, int n2) {
            return insZero;
        }

        protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
            if (icon instanceof V2CImageIcon) {
                ((V2CImageIcon)icon).setSelected(bl);
            }
            super.paintIcon(graphics, n, n2, icon, rectangle, bl);
        }
    }

    private class PopupListener
    extends V2CPopupListener {
        private PopupListener() {
        }

        JPopupMenu getPopupMenu(MouseEvent mouseEvent) {
            String string;
            int n = V2CImageViewer.this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0) {
                V2CAction.setSelected("ToggleCheckViewerTab", ((V2CImageIcon)V2CImageViewer.this.getIconAt(n)).isChecked());
            }
            if (n >= 0) {
                if (V2CImageViewer.this.isInCheckBox(mouseEvent)) {
                    string = "ImageTabCheck";
                    V2CAction.setEnabled("DisableLinkM", true);
                    V2CAction.setEnabled("AddToNGFile", true);
                } else {
                    string = "ImageViewerTab";
                }
            } else {
                string = "ImageViewerNoTab";
            }
            return V2CMain.getPopupMenu(string);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (PopupListener.isDefined(mouseEvent)) {
                if (V2CSwingUtil.isSimpleClick(mouseEvent)) {
                    if (V2CImageViewer.this.isInCheckBox(mouseEvent)) {
                        V2CImageViewer.this.toggleCheckSelectedTab();
                    }
                } else if (V2CSwingUtil.isSimpleClick(mouseEvent, 2)) {
                    int n = V2CImageViewer.this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n >= 0) {
                        V2CImageViewer.this.closeTab(n);
                    }
                } else if (mouseEvent.getButton() == 1 && mouseEvent.isShiftDown()) {
                    int n = V2CImageViewer.this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
                    V2CImageViewer.this.getPanelAt(n).setMosaic(true);
                }
            }
            super.mousePressed(mouseEvent);
        }
    }
}

