/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.CMMException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.monazilla.v2c.V2CAbstractImagePanel;
import org.monazilla.v2c.V2CAnimationController;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CImageInfo;
import org.monazilla.v2c.V2CImagePanel;
import org.monazilla.v2c.V2CImagePopup;
import org.monazilla.v2c.V2CImageViewer;
import org.monazilla.v2c.V2CJFIFInputStream;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMemoryGauge;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSingleImage;
import org.monazilla.v2c.V2CSlideShowPanel;
import org.monazilla.v2c.V2CSwingUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class V2CImageSet
implements ActionListener,
Cloneable {
    private static final int FORMAT_UNKNOWN = 0;
    private static final int FORMAT_JPEG = 1;
    private static final int FORMAT_PNG = 2;
    private static final int FORMAT_GIF = 3;
    private static final boolean bPrintNodeInfo = false;
    private static final boolean bPrintDebugInfo = false;
    static final Color cDefaultBackground = new Color(204, 204, 204);
    V2CSingleImage[] silImages;
    String sFormatName;
    int nFormat;
    int nFileSize;
    Image iBuffer;
    ImageReader vJFIFImageReader;
    boolean bNeedsBuffer;
    private boolean bBufferChecked;
    boolean bAlwaysClear;
    int nWidth;
    int nHeight;
    int nRotation;
    boolean bMirror;
    int nBlockSize;
    int nOriginalWidth;
    int nOriginalHeight;
    Color cBackground = cDefaultBackground;
    boolean bDrawBG;
    int nDrawIndex;
    int nLastDrawIndex = -1;
    int iClearIndex = -1;
    Timer tTimer;
    boolean bAnimate;
    int iRateIndex;
    volatile boolean bThumbnailCreating;
    String sCaptionEx;
    String sCaption;
    boolean bSizeLimitExceeded;
    boolean bOK;
    String sErrorMessage;
    File fOriginalFile;
    static final int MIN_BLOCKSIZE = 4;
    static final int DEF_BLOCKSIZE = 16;

    boolean needPaintBG() {
        return this.bDrawBG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkGamma(File file) {
        int n;
        Object object;
        int n2;
        if (this.nFormat != 2) {
            return;
        }
        int n3 = (int)file.length();
        FilterInputStream filterInputStream = null;
        int n4 = 0;
        boolean bl = false;
        try {
            int n5;
            filterInputStream = new DataInputStream(new FileInputStream(file));
            if (((DataInputStream)filterInputStream).skipBytes(8) != 8) {
                return;
            }
            int n6 = 8;
            block16: while ((n5 = ((DataInputStream)filterInputStream).readInt()) > 0) {
                int n7 = ((DataInputStream)filterInputStream).readInt();
                n2 = n5 + 4;
                if ((n6 += n2 + 8) + 4 > n3) {
                    break;
                }
                if (n7 == 1732332865) {
                    n4 = ((DataInputStream)filterInputStream).readInt();
                    n2 -= 4;
                }
                if (n7 == 1347179589) {
                    bl = true;
                    break;
                }
                if (n7 == 1229209940) {
                    break;
                }
                while (true) {
                    if (n2 <= 0) continue block16;
                    n2 -= ((DataInputStream)filterInputStream).skipBytes(n2);
                }
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (n4 == 0 || n4 >= 45453 && n4 <= 45456) {
            return;
        }
        double d = 100000.0 / (double)n4;
        BufferedImage bufferedImage = null;
        n2 = 0;
        if (this.silImages != null) {
            object = this.silImages[0].getImage();
            int n8 = n2 = !(object instanceof BufferedImage) ? 1 : 0;
            if (n2 != 0) {
                final BufferedImage bufferedImage2 = new BufferedImage(this.nWidth, this.nHeight, 2);
                if (EventQueue.isDispatchThread()) {
                    Graphics2D graphics2D = bufferedImage2.createGraphics();
                    graphics2D.drawImage((Image)object, 0, 0, null);
                    graphics2D.dispose();
                } else {
                    try {
                        EventQueue.invokeAndWait(new Runnable((Image)object){
                            private final /* synthetic */ Image val$img;
                            {
                                this.val$img = image;
                            }

                            public void run() {
                                Graphics2D graphics2D = bufferedImage2.createGraphics();
                                graphics2D.drawImage(this.val$img, 0, 0, null);
                                graphics2D.dispose();
                            }
                        });
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
                bufferedImage = bufferedImage2;
            } else {
                bufferedImage = (BufferedImage)object;
            }
        }
        if (bufferedImage == null) {
            return;
        }
        object = new int[256];
        for (n = 0; n < 256; ++n) {
            object[n] = (int)(256.0 * Math.pow((double)n / 256.0, d / 2.2));
        }
        n = this.nWidth;
        int n9 = this.nHeight;
        for (int i = 0; i < n9; ++i) {
            for (int j = 0; j < n; ++j) {
                int n10 = bufferedImage.getRGB(j, i);
                bufferedImage.setRGB(j, i, n10 & 0xFF000000 | object[n10 >>> 16 & 0xFF] << 16 | object[n10 >>> 8 & 0xFF] << 8 | object[n10 & 0xFF]);
            }
        }
        if (n2 != 0) {
            this.silImages[0].setImage(bufferedImage);
        }
    }

    static V2CImageSet createImageSet(Object object, boolean bl) {
        return V2CImageSet.createImageSet0(object, 0, 0, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static V2CImageSet createImageSet0(Object object, int n, int n2, boolean bl) {
        String string = null;
        boolean bl2 = false;
        ImageInputStream imageInputStream = null;
        ImageReader imageReader = null;
        V2CImageSet v2CImageSet = null;
        int n3 = 0;
        int n4 = 0;
        try {
            imageInputStream = ImageIO.createImageInputStream(object);
            if (imageInputStream != null) {
                Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                if (iterator.hasNext()) {
                    imageReader = iterator.next();
                    imageReader.setInput(imageInputStream);
                    v2CImageSet = new V2CImageSet(imageReader, object, bl);
                    if (object instanceof File) {
                        v2CImageSet.nFileSize = (int)((File)object).length();
                    }
                } else {
                    string = "No ImageReader Found.";
                }
            } else {
                string = "error in ImageIO.createImageInputStream()";
            }
        }
        catch (ImageSizeException imageSizeException) {
            bl2 = true;
            n3 = imageSizeException.nWidth;
            n4 = imageSizeException.nHeight;
            string = imageSizeException.getMessage();
            V2CMain.setMessage(string);
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            V2CMain.setMessage(string);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            string = "OutOfMemoryError: " + outOfMemoryError.getMessage();
            V2CMain.setMessage(string);
        }
        catch (Exception exception) {
            string = exception.getMessage();
            V2CMain.setMessage(string);
        }
        finally {
            ImageReader imageReader2;
            if (imageReader != null) {
                imageReader.dispose();
            }
            if (imageInputStream != null) {
                try {
                    imageInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (v2CImageSet != null && (imageReader2 = v2CImageSet.vJFIFImageReader) != null) {
                v2CImageSet.vJFIFImageReader = null;
                imageReader2.dispose();
                Object object2 = imageReader2.getInput();
                if (object2 instanceof ImageInputStream) {
                    try {
                        ((ImageInputStream)object2).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (v2CImageSet != null && object instanceof File) {
            v2CImageSet.checkGamma((File)object);
        }
        V2CMemoryGauge.update();
        return v2CImageSet != null ? v2CImageSet : new V2CImageSet(string, bl2, n3, n4);
    }

    static V2CImageSet createImageSet(BufferedImage bufferedImage) {
        String string = null;
        V2CImageSet v2CImageSet = null;
        try {
            v2CImageSet = new V2CImageSet(bufferedImage);
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            V2CMain.setMessage(string);
        }
        return v2CImageSet != null ? v2CImageSet : new V2CImageSet(string, false, 0, 0);
    }

    static V2CImageSet createImageSet(V2CImageSet v2CImageSet, double d, File file) {
        V2CImageSet v2CImageSet2 = null;
        if (d >= 1.0) {
            try {
                v2CImageSet2 = (V2CImageSet)v2CImageSet.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        } else {
            v2CImageSet2 = new V2CImageSet(v2CImageSet, d, file);
        }
        return v2CImageSet2;
    }

    private V2CImageSet(String string, boolean bl, int n, int n2) {
        this.sErrorMessage = string != null ? string : "unknown error";
        this.bSizeLimitExceeded = bl;
        this.nWidth = n;
        this.nHeight = n2;
    }

    private V2CImageSet(BufferedImage bufferedImage) throws IOException {
        if (bufferedImage == null) {
            throw new IOException("bi==null");
        }
        V2CSingleImage v2CSingleImage = new V2CSingleImage(bufferedImage, 0);
        this.silImages = new V2CSingleImage[1];
        this.silImages[0] = v2CSingleImage;
        this.nWidth = v2CSingleImage.getWidth();
        this.nHeight = v2CSingleImage.getHeight();
        this.bOK = true;
    }

    private V2CImageSet(ImageReader imageReader, Object object, boolean bl) throws IOException {
        Object object2;
        Object object3;
        int n;
        int n2;
        int n3;
        V2CImageInfo v2CImageInfo = object instanceof File ? V2CImageInfo.getImageInfo((File)object, false, true) : null;
        String string = imageReader.getFormatName();
        if (string == null) {
            string = "";
        }
        this.sFormatName = string;
        int n4 = string.equalsIgnoreCase("JPEG") ? 1 : (string.equalsIgnoreCase("PNG") ? 2 : (string.equalsIgnoreCase("gif") ? 3 : 0));
        this.nFormat = n4;
        boolean bl2 = n4 == 1;
        boolean bl3 = n4 == 3;
        int n5 = bl2 ? 1 : imageReader.getNumImages(true);
        if (n5 <= 0) {
            throw new IOException("No. of Image <= 0.");
        }
        int n6 = V2CLink.nMaxLoadImageSize;
        if (n6 <= 0) {
            n6 = 32768;
        }
        int n7 = V2CLink.nMaxLoadImageArea;
        int n8 = 0;
        int n9 = 0;
        if (v2CImageInfo != null) {
            n3 = v2CImageInfo.nWidth;
            n2 = v2CImageInfo.nHeight;
            if (n3 > 0 && n2 > 0) {
                n8 = n3;
                n9 = n2;
            }
        }
        if (n8 <= 0 || n9 <= 0) {
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = imageReader.getWidth(n3);
                n = imageReader.getHeight(n3);
                if (n2 > n8) {
                    n8 = n2;
                }
                if (n <= n9) continue;
                n9 = n;
            }
        }
        if (n8 > n6) {
            throw new ImageSizeException("\u5e45\u304c\u4e0a\u9650\u3092\u8d8a\u3048\u3066\u3044\u307e\u3059\uff08" + n8 + "\uff1e" + n6 + "\uff09", n8, n9);
        }
        if (n9 > n6) {
            throw new ImageSizeException("\u9ad8\u3055\u304c\u4e0a\u9650\u3092\u8d8a\u3048\u3066\u3044\u307e\u3059\uff08" + n9 + "\uff1e" + n6 + "\uff09", n8, n9);
        }
        if (n7 > 0 && n8 * n9 > n7) {
            throw new ImageSizeException("\u5e45\u00d7\u9ad8\u3055\u304c\u4e0a\u9650\u3092\u8d8a\u3048\u3066\u3044\u307e\u3059\uff08" + n8 * n9 + "\uff1e" + n7 + "\uff09", n8, n9);
        }
        this.nBlockSize = n3 = bl ? V2CImageSet.calcMaxBlockSize(n8, n9) : 0;
        n2 = n5 == 1 && bl3 ? 1 : 0;
        this.bAlwaysClear = n2;
        int n10 = n = n2 != 0 || bl2 ? 1 : 0;
        if (n != 0) {
            Exception exception;
            boolean bl4;
            block44: {
                ImageReader imageReader2;
                if (bl2 && v2CImageInfo != null && v2CImageInfo.bICC && !v2CImageInfo.bJFIFBeforeICC && !v2CImageInfo.bJFIF && object instanceof File && (imageReader2 = V2CJFIFInputStream.createImageReader((File)object)) != null) {
                    imageReader = imageReader2;
                    this.vJFIFImageReader = imageReader2;
                    v2CImageInfo.bJFIFBeforeICC = true;
                }
                bl4 = object instanceof File && (bl3 || bl2 && v2CImageInfo != null && v2CImageInfo.bICC && v2CImageInfo.bJFIFBeforeICC);
                exception = null;
                object3 = null;
                try {
                    object3 = new V2CSingleImage(imageReader, object, n3, bl4, bl2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    exception = illegalArgumentException;
                }
                catch (IIOException iIOException) {
                    exception = iIOException;
                }
                catch (CMMException cMMException) {
                    exception = cMMException;
                }
                catch (IOException iOException) {
                    if (bl4 || !V2CMiscUtil.isEqual(iOException.getMessage(), "image loading error !")) break block44;
                    try {
                        object3 = new V2CSingleImage(imageReader, object, n3, true, bl2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IllegalArgumentException(illegalArgumentException.getMessage());
                    }
                }
            }
            if (exception != null && bl4) {
                try {
                    object3 = new V2CSingleImage(null, object, n3, false, bl2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException(exception.getMessage());
                }
            }
            if (object3 != null) {
                this.silImages = new V2CSingleImage[1];
                this.silImages[0] = object3;
            } else {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("Interrupted during sleep");
                }
            }
        }
        if (n == 0 || this.silImages == null) {
            ArrayList<V2CSingleImage> arrayList = new ArrayList<V2CSingleImage>();
            for (int i = 0; i < n5; ++i) {
                object3 = null;
                try {
                    object3 = new V2CSingleImage(imageReader, i, n3);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    if (n4 == 2 && object instanceof File) {
                        object3 = new V2CSingleImage(null, object, n3, false, false);
                    }
                    throw outOfMemoryError;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
                arrayList.add((V2CSingleImage)object3);
            }
            if ((n5 = arrayList.size()) <= 0) {
                throw new IOException("No. of Image <= 0.");
            }
            this.silImages = new V2CSingleImage[n5];
            this.silImages = arrayList.toArray(this.silImages);
        }
        V2CSingleImage[] v2CSingleImageArray = this.silImages;
        if (n5 > 1) {
            this.bAnimate = true;
            this.extractStreamInfo(imageReader);
            Rectangle rectangle = new Rectangle();
            for (int i = 0; i < n5; ++i) {
                object2 = v2CSingleImageArray[i];
                ((V2CSingleImage)object2).extractInfo(imageReader, i);
                ((V2CSingleImage)object2).computeUnion(rectangle);
            }
            if (this.nWidth <= 0 || this.nHeight <= 0) {
                this.nWidth = rectangle.width;
                this.nHeight = rectangle.height;
            }
            if (rectangle.x != 0 || rectangle.y != 0 || rectangle.width != this.nWidth || rectangle.height != this.nHeight) {
                this.bNeedsBuffer = true;
            }
        } else {
            V2CSingleImage v2CSingleImage = this.silImages[0];
            if (this.nWidth <= 0 || this.nHeight <= 0) {
                this.nWidth = v2CSingleImage.getWidth();
                this.nHeight = v2CSingleImage.getHeight();
            }
            if (this.nFormat == 2 && (object3 = v2CSingleImage.getImage()) instanceof BufferedImage) {
                boolean bl5;
                object2 = (BufferedImage)object3;
                ColorModel colorModel = ((BufferedImage)object2).getColorModel();
                this.bDrawBG = bl5 = colorModel.getTransparency() != 1;
                if (!bl5 && V2CApp.isWinType()) {
                    String string2 = System.getProperty("sun.java2d.noddraw");
                    String string3 = System.getProperty("sun.java2d.d3d");
                    if (string2 != null && string2.equals("true") || string3 != null && string3.equals("true")) {
                        bl5 = true;
                    }
                }
                if (bl5) {
                    EventQueue.invokeLater(new Runnable((BufferedImage)object2, v2CSingleImage){
                        private final /* synthetic */ BufferedImage val$bi;
                        private final /* synthetic */ V2CSingleImage val$vsi0;
                        {
                            this.val$bi = bufferedImage;
                            this.val$vsi0 = v2CSingleImage;
                        }

                        public void run() {
                            BufferedImage bufferedImage = V2CSwingUtil.convertToCompatibeImage(this.val$bi);
                            if (bufferedImage != null) {
                                this.val$vsi0.setImage(bufferedImage);
                            }
                        }
                    });
                }
            }
        }
        this.bOK = true;
    }

    public V2CImageSet(V2CImageSet v2CImageSet, final double d, File file) {
        AffineTransformOp affineTransformOp;
        if (!v2CImageSet.bOK) {
            return;
        }
        this.fOriginalFile = file;
        this.bThumbnailCreating = true;
        this.nWidth = (int)Math.round(d * (double)v2CImageSet.nWidth);
        this.nHeight = (int)Math.round(d * (double)v2CImageSet.nHeight);
        this.cBackground = v2CImageSet.cBackground;
        this.bNeedsBuffer = v2CImageSet.bNeedsBuffer;
        this.bAlwaysClear = v2CImageSet.bAlwaysClear;
        this.sFormatName = v2CImageSet.sFormatName;
        this.nFormat = v2CImageSet.nFormat;
        final V2CSingleImage[] v2CSingleImageArray = v2CImageSet.silImages;
        final V2CSingleImage[] v2CSingleImageArray2 = new V2CSingleImage[v2CSingleImageArray.length];
        this.silImages = v2CSingleImageArray2;
        final boolean bl = V2CAbstractImagePanel.bHRQTh;
        AffineTransformOp affineTransformOp2 = affineTransformOp = bl && this.nFormat != 3 ? null : new AffineTransformOp(new AffineTransform(d, 0.0, 0.0, d, 0.0, 0.0), 1);
        if (bl || EventQueue.isDispatchThread()) {
            for (int i = 0; i < v2CSingleImageArray2.length; ++i) {
                v2CSingleImageArray2[i] = new V2CSingleImage(v2CSingleImageArray[i], d, affineTransformOp, bl, this.sFormatName);
            }
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        for (int i = 0; i < v2CSingleImageArray2.length; ++i) {
                            v2CSingleImageArray2[i] = new V2CSingleImage(v2CSingleImageArray[i], d, affineTransformOp, bl, V2CImageSet.this.sFormatName);
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.nOriginalWidth = v2CImageSet.nWidth;
        this.nOriginalHeight = v2CImageSet.nHeight;
        this.bAnimate = v2CSingleImageArray2.length > 1;
        this.bThumbnailCreating = false;
        this.bOK = true;
    }

    private void createBuffer() {
        this.bBufferChecked = true;
        if (this.silImages.length == 1) {
            return;
        }
        if (!this.bNeedsBuffer) {
            boolean bl = false;
            for (int i = 0; i < this.silImages.length; ++i) {
                V2CSingleImage v2CSingleImage = this.silImages[i];
                if (v2CSingleImage == null) {
                    this.bBufferChecked = false;
                    return;
                }
                if (!v2CSingleImage.needsBuffer(this.nWidth, this.nHeight)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        this.iBuffer = V2CMain.v2cMain.createImage(this.nWidth, this.nHeight);
        Graphics graphics = this.iBuffer.getGraphics();
        this.clearRect(graphics, 0, 0, 0.0);
        graphics.dispose();
    }

    void extractStreamInfo(ImageReader imageReader) {
        IIOMetadata iIOMetadata = null;
        try {
            iIOMetadata = imageReader.getStreamMetadata();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        if (iIOMetadata == null) {
            return;
        }
        String string = iIOMetadata.getNativeMetadataFormatName();
        if (string == null || string.length() == 0) {
            return;
        }
        Node node = iIOMetadata.getAsTree(string);
        if (string.indexOf("_gif_") > 0) {
            this.extractGIFInfo(node);
        }
    }

    int getWidth() {
        return this.nWidth;
    }

    int getHeight() {
        return this.nHeight;
    }

    int getOriginalWidth() {
        return this.nOriginalWidth;
    }

    int getOriginalHeight() {
        return this.nOriginalHeight;
    }

    boolean isOK() {
        return this.bOK;
    }

    boolean isSizeLimitExceeded() {
        return this.bSizeLimitExceeded;
    }

    String getErrorMessage() {
        return this.sErrorMessage;
    }

    int getImageCount() {
        return this.silImages != null ? this.silImages.length : 0;
    }

    Icon createIcon() {
        Image image;
        V2CSingleImage v2CSingleImage;
        if (this.silImages != null && (v2CSingleImage = this.silImages[0]) != null && (image = v2CSingleImage.getImage()) != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    int getDisplayIndex() {
        return this.nDrawIndex;
    }

    void setOriginalFile(File file) {
        this.fOriginalFile = file;
    }

    void setImageProperty(V2CProperty v2CProperty) {
        if (v2CProperty == null || v2CProperty.getInt("Height") > 0) {
            return;
        }
        try {
            v2CProperty.putInt("Width", this.nWidth);
            v2CProperty.putInt("Height", this.nHeight);
            int n = this.getImageCount();
            if (n > 0) {
                v2CProperty.putInt("NumImages", n);
                if (n > 1) {
                    int n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        n2 += this.silImages[i].getDelayTime();
                    }
                    v2CProperty.putInt("TotalTime", n2);
                }
            }
            v2CProperty.doSaveState();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String getCaption(boolean bl) {
        if (this.sCaption == null) {
            int n;
            File file = this.fOriginalFile;
            V2CImageInfo v2CImageInfo = V2CImageInfo.getImageInfo(file, true, true);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.getImageCount();
            boolean bl2 = n2 > 1;
            int n3 = v2CImageInfo.nWidth > 0 ? v2CImageInfo.nWidth : this.nWidth;
            int n4 = v2CImageInfo.nHeight > 0 ? v2CImageInfo.nHeight : this.nHeight;
            String string = v2CImageInfo.sFormatName;
            if (string == null) {
                string = this.sFormatName;
            }
            stringBuffer.append(string != null ? string : "unknown");
            stringBuffer.append(" (");
            stringBuffer.append(n3);
            stringBuffer.append('\u00d7');
            stringBuffer.append(n4);
            stringBuffer.append(')');
            if (bl2) {
                stringBuffer.append(' ');
                stringBuffer.append(n2);
                stringBuffer.append("\u679a \u5408\u8a08 ");
                n = 0;
                for (int i = 0; i < n2; ++i) {
                    n += this.silImages[i].getDelayTime();
                }
                stringBuffer.append((double)n / 1000.0);
                stringBuffer.append("\u79d2");
            }
            int n5 = n = file != null ? (int)file.length() : this.nFileSize;
            if (n > 0) {
                boolean bl3;
                stringBuffer.append(' ');
                DecimalFormat decimalFormat = new DecimalFormat(",##0");
                boolean bl4 = bl3 = n >= 65536;
                if (bl3) {
                    n >>= 10;
                }
                stringBuffer.append(decimalFormat.format(n));
                stringBuffer.append(bl3 ? "kB" : "bytes");
            }
            this.sCaption = stringBuffer.toString();
            this.sCaptionEx = v2CImageInfo.bExif && v2CImageInfo.sInfoString != null ? '\n' + v2CImageInfo.sInfoString : this.sCaption;
        }
        return bl ? this.sCaptionEx : this.sCaption;
    }

    void setNullCaption() {
        this.sCaption = "";
    }

    boolean needsUpdate() {
        return this.silImages.length > 1;
    }

    void clear() {
        if (!this.bOK || this.bThumbnailCreating) {
            return;
        }
        for (int i = 0; i < this.silImages.length; ++i) {
            V2CSingleImage v2CSingleImage = this.silImages[i];
            if (v2CSingleImage == null) continue;
            v2CSingleImage.clear();
            this.silImages[i] = null;
        }
        this.silImages = null;
        if (this.iBuffer != null) {
            this.iBuffer.flush();
            this.iBuffer = null;
        }
        if (this.tTimer != null) {
            this.tTimer.stop();
            this.tTimer = null;
        }
    }

    private void setBlockSize(int n) {
        if (n != this.nBlockSize) {
            this.nBlockSize = n;
            for (int i = 0; i < this.silImages.length; ++i) {
                V2CSingleImage v2CSingleImage = this.silImages[i];
                if (v2CSingleImage == null) continue;
                v2CSingleImage.setBlockSize(n);
            }
        }
    }

    private int calcMaxBlockSize() {
        return V2CImageSet.calcMaxBlockSize(this.nWidth, this.nHeight);
    }

    private static int calcMaxBlockSize(int n, int n2) {
        return Math.max(Math.max(n, n2) / 50, 16);
    }

    boolean isMosaic() {
        return this.nBlockSize > 0;
    }

    void setMosaic(boolean bl) {
        this.setBlockSize(bl ? this.calcMaxBlockSize() : 0);
    }

    boolean changeBlockSize(boolean bl) {
        int n;
        int n2 = n = this.nBlockSize;
        if (bl) {
            if (n2 == 0) {
                n2 = this.calcMaxBlockSize();
            } else if ((n2 = Math.min(n2 * 2, this.calcMaxBlockSize())) < 4) {
                n2 = 4;
            }
        } else if ((n2 /= 2) < 4) {
            n2 = 0;
        }
        this.setBlockSize(n2);
        return n > 0 ^ n2 > 0;
    }

    void startAnimation() {
        if (this.silImages.length <= 1) {
            return;
        }
        this.bAnimate = true;
        this.rescheduleAnimation(false);
    }

    void stopAnimation() {
        if (!this.bAnimate || this.silImages.length <= 1) {
            return;
        }
        this.bAnimate = false;
        if (this.tTimer != null && this.tTimer.isRunning()) {
            this.tTimer.stop();
        }
    }

    void showAnimeController(JComponent jComponent, Point point) {
        V2CAnimationController.showController(this, jComponent, point);
    }

    void controlGIFAnimation(String string) {
        if (string == null || this.silImages.length <= 1) {
            return;
        }
        if (string.equals("NormalPlay")) {
            this.iRateIndex = 0;
            this.startAnimation();
        } else if (string.equals("NextFrame")) {
            this.stopAnimation();
            this.paintNextFrame();
        } else if (string.equals("Stop")) {
            this.stopAnimation();
        } else if (string.equals("FastPlay")) {
            this.stopAnimation();
            ++this.iRateIndex;
            this.startAnimation();
        }
    }

    void drawScaledAndCentered(Graphics2D graphics2D, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5 = this.nWidth;
        int n6 = this.nHeight;
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        double d = Math.min((double)n / (double)n5, (double)n2 / (double)n6);
        if (!bl && d > 1.0) {
            d = 0.0;
        }
        if (bl || d > 0.0) {
            n4 = (int)(d * (double)n5);
            n3 = (int)(d * (double)n6);
        } else {
            n4 = n5;
            n3 = n6;
        }
        int n7 = (n - n4) / 2;
        int n8 = (n2 - n3) / 2;
        this.draw(graphics2D, n7, n8, d);
    }

    void draw(Graphics2D graphics2D) {
        this.draw(graphics2D, 0, 0, 0.0);
    }

    void draw(Graphics2D graphics2D, int n, int n2) {
        this.draw(graphics2D, n, n2, 0.0);
    }

    void draw(Graphics2D graphics2D, int n, int n2, double d) {
        V2CSingleImage[] v2CSingleImageArray = this.silImages;
        if (v2CSingleImageArray == null) {
            return;
        }
        if (!this.bBufferChecked) {
            this.createBuffer();
        }
        this.rescheduleAnimation(this.nDrawIndex == v2CSingleImageArray.length - 1);
        int n3 = this.nDrawIndex;
        V2CSingleImage v2CSingleImage = v2CSingleImageArray[n3];
        if (v2CSingleImage == null) {
            return;
        }
        if (this.iBuffer != null) {
            boolean bl;
            boolean bl2 = bl = n3 != this.nLastDrawIndex;
            if (v2CSingleImage.restoreToPrev()) {
                if (d > 0.0 && d != 1.0) {
                    graphics2D.drawImage(this.iBuffer, n, n2, (int)(d * (double)this.nWidth), (int)(d * (double)this.nHeight), null);
                } else {
                    graphics2D.drawImage(this.iBuffer, n, n2, null);
                }
                v2CSingleImage.draw(graphics2D, n, n2, d);
            } else {
                if (bl) {
                    Graphics2D graphics2D2 = (Graphics2D)this.iBuffer.getGraphics();
                    if (this.iClearIndex >= 0) {
                        this.silImages[this.iClearIndex].clearRect(graphics2D2, 0, 0, 0.0, this.cBackground);
                    } else if (this.nDrawIndex == 0 && v2CSingleImage.isBGVisible(this.nWidth, this.nHeight)) {
                        this.clearRect(graphics2D2, 0, 0, 0.0);
                    }
                    v2CSingleImage.draw(graphics2D2, 0, 0, 0.0);
                    graphics2D2.dispose();
                }
                if (d > 0.0 && d != 1.0) {
                    graphics2D.drawImage(this.iBuffer, n, n2, (int)(d * (double)this.nWidth), (int)(d * (double)this.nHeight), null);
                } else {
                    graphics2D.drawImage(this.iBuffer, n, n2, null);
                }
            }
            this.nLastDrawIndex = n3;
        } else {
            if (this.iClearIndex >= 0) {
                this.silImages[this.iClearIndex].clearRect(graphics2D, n, n2, d, this.cBackground);
            } else if (this.bAlwaysClear) {
                this.clearRect(graphics2D, n, n2, d);
            }
            v2CSingleImage.draw(graphics2D, n, n2, d);
        }
    }

    void nextFrame() {
        if (this.silImages.length > 1) {
            int n = this.nDrawIndex;
            V2CSingleImage v2CSingleImage = this.silImages[n];
            this.iClearIndex = v2CSingleImage != null && v2CSingleImage.shouldClear() ? n : -1;
            this.nDrawIndex = (n + 1) % this.silImages.length;
            V2CAnimationController.displayIndexChanged(this, this.nDrawIndex);
        }
    }

    void rescheduleAnimation(boolean bl) {
        V2CSingleImage v2CSingleImage;
        if (!this.bAnimate || this.silImages.length <= 1) {
            return;
        }
        if (this.tTimer == null) {
            this.tTimer = new Timer(0, this);
            this.tTimer.setRepeats(false);
        }
        if (this.tTimer.isRunning()) {
            return;
        }
        int n = this.iRateIndex;
        final int n2 = n <= 0 ? ((v2CSingleImage = this.silImages[this.nDrawIndex]) != null ? v2CSingleImage.getDelayTime() : 250) : (n == 1 ? 250 : (n == 2 ? 125 : (n == 3 ? 60 : 30)));
        if (bl && V2CApp.isUNIX()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Toolkit.getDefaultToolkit().sync();
                    V2CImageSet.this.tTimer.setInitialDelay(n2);
                    V2CImageSet.this.tTimer.start();
                }
            });
        } else {
            this.tTimer.setInitialDelay(n2);
            this.tTimer.start();
        }
    }

    void clearRect(Graphics graphics, int n, int n2, double d) {
        graphics.setColor(this.cBackground);
        if (d > 0.0 && d != 1.0) {
            graphics.fillRect(n, n2, (int)(d * (double)this.nWidth), (int)(d * (double)this.nHeight));
        } else {
            graphics.fillRect(n, n2, this.nWidth, this.nHeight);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.paintNextFrame();
    }

    void paintNextFrame() {
        JComponent jComponent;
        this.nextFrame();
        if (V2CLink.bStopRedrawThumbnail) {
            return;
        }
        V2CImagePopup.imageUpdated(this);
        V2CImagePanel.imageUpdated(this);
        V2CMain.vtpDisplayPane.imageThumbnailUpdated(this);
        V2CMain.vtpTablePane.imageThumbnailUpdated(this);
        V2CLink.ThumbnailPanel thumbnailPanel = V2CLink.jcThumbnailPanel;
        if (thumbnailPanel != null) {
            thumbnailPanel.imageThumbnailUpdated(this);
        }
        if (V2CLink.bSlideShowPanelShown && (jComponent = V2CSlideShowPanel.getInstance()) != null) {
            ((V2CSlideShowPanel)jComponent).imageThumbnailUpdated(this);
        }
        if (V2CLink.bImageViewerShown && (jComponent = V2CImageViewer.getInstance()) != null) {
            ((V2CImageViewer)jComponent).imageUpdated(this);
        }
    }

    void extractGIFInfo(Node node) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return;
        }
        int n = -1;
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node2;
            Node node3 = nodeList.item(i);
            String string = node3.getNodeName();
            if (string == null) continue;
            NamedNodeMap namedNodeMap = node3.getAttributes();
            if (string.equals("LogicalScreenDescriptor")) {
                node2 = namedNodeMap.getNamedItem("logicalScreenWidth");
                if (node2 != null) {
                    try {
                        this.nWidth = Integer.parseInt(node2.getNodeValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((node2 = namedNodeMap.getNamedItem("logicalScreenHeight")) == null) continue;
                try {
                    this.nHeight = Integer.parseInt(node2.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!string.equals("GlobalColorTable") || (node2 = namedNodeMap.getNamedItem("backgroundColorIndex")) == null) continue;
            try {
                n = Integer.parseInt(node2.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            this.extractGIFBGColorInfo(node3, n);
        }
    }

    void extractGIFBGColorInfo(Node node, int n) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return;
        }
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node2 = nodeList.item(i);
            NamedNodeMap namedNodeMap = node2.getAttributes();
            int n3 = -1;
            Node node3 = namedNodeMap.getNamedItem("index");
            if (node3 != null) {
                try {
                    n3 = Integer.parseInt(node3.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n3 != n) continue;
            int n4 = 204;
            int n5 = 204;
            int n6 = 204;
            node3 = namedNodeMap.getNamedItem("red");
            if (node3 != null) {
                try {
                    n4 = Integer.parseInt(node3.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((node3 = namedNodeMap.getNamedItem("green")) != null) {
                try {
                    n5 = Integer.parseInt(node3.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((node3 = namedNodeMap.getNamedItem("blue")) != null) {
                try {
                    n6 = Integer.parseInt(node3.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.cBackground = new Color(n4, n5, n6);
        }
    }

    void cacheThumbnailImage(File file, int n, int n2) {
        Object object;
        if (file == null || this.getImageCount() != 1 || this.sFormatName == null) {
            return;
        }
        boolean bl = n == this.nWidth && n2 == this.nHeight;
        Image image = this.silImages[0].getImage();
        if (!bl && !(image instanceof BufferedImage)) {
            return;
        }
        if (file.exists()) {
            file.delete();
        } else {
            object = file.getParentFile();
            if (object != null && !((File)object).isDirectory()) {
                ((File)object).mkdirs();
            }
        }
        if (bl) {
            object = new byte[4];
            if (n > 65535) {
                n = 65535;
            }
            if (n2 > 65535) {
                n2 = 65535;
            }
            object[0] = (byte)(n >>> 8);
            object[1] = (byte)n;
            object[2] = (byte)(n2 >>> 8);
            object[3] = (byte)n2;
            if (!V2CLocalFileHandler.saveToFile(file, (byte[])object) && file.exists()) {
                file.delete();
            }
        } else {
            V2CLocalFileHandler.saveThumbnail(file, (BufferedImage)image);
        }
    }

    private static class ImageSizeException
    extends IOException {
        final int nWidth;
        final int nHeight;

        ImageSizeException(String string, int n, int n2) {
            super(string);
            this.nWidth = n;
            this.nHeight = n2;
        }
    }
}

