/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSSFont;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CImageInfo {
    private static final String sTagNameFile = "exif.txt";
    private static final String[] slFormatNames = new String[]{"UNKNOWN", "BYTE", "ASCII", "SHORT", "LONG", "RATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "FLOAT", "DOUBLE"};
    private static final String sFormatError = "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc";
    private static final HashMap hmTagNames = new HashMap();
    private static final HashMap hmFormats = new HashMap();
    private static final HashMap hmParameters = new HashMap();
    private static final HashMap hmUnits = new HashMap();
    static final int FORMAT_JPEG = 1;
    static final int FORMAT_PNG = 2;
    static final int FORMAT_GIF = 3;
    static final int FORMAT_BMP = 4;
    static final int FORMAT_WEBP = 5;
    final File fImageFile;
    int nFormat;
    String sFormatName;
    int nWidth;
    int nHeight;
    boolean bExif;
    int nOrientation;
    boolean bJFIF;
    boolean bICC;
    boolean bJFIFBeforeICC;
    String sInfoString;
    private static final char[] clFilterColor;

    private static int readInt(BufferedInputStream bufferedInputStream) throws IOException {
        int n = bufferedInputStream.read();
        int n2 = bufferedInputStream.read();
        int n3 = bufferedInputStream.read();
        int n4 = bufferedInputStream.read();
        return n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0 ? n << 24 | n2 << 16 | n3 << 8 | n4 : -1;
    }

    private static int readIntR(BufferedInputStream bufferedInputStream) throws IOException {
        int n = bufferedInputStream.read();
        int n2 = bufferedInputStream.read();
        int n3 = bufferedInputStream.read();
        int n4 = bufferedInputStream.read();
        return n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0 ? n4 << 24 | n3 << 16 | n2 << 8 | n : -1;
    }

    private static int readShort(BufferedInputStream bufferedInputStream) throws IOException {
        int n = bufferedInputStream.read();
        int n2 = bufferedInputStream.read();
        return n >= 0 && n2 >= 0 ? n << 8 | n2 : -1;
    }

    private static int readShortR(BufferedInputStream bufferedInputStream) throws IOException {
        int n = bufferedInputStream.read();
        int n2 = bufferedInputStream.read();
        return n >= 0 && n2 >= 0 ? n2 << 8 | n : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void restoreTagName() {
        block16: {
            String string;
            BufferedReader bufferedReader = V2CLocalFileHandler.getConfigReader(sTagNameFile);
            if (bufferedReader == null) {
                System.out.println("cannot read exif.txt !");
                return;
            }
            Integer n = null;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string.length() == 0 || string.charAt(0) == '#') continue;
                char c = string.charAt(0);
                if (c == 'F') {
                    if (n == null) continue;
                    hmFormats.put(n, new DecimalFormat(string.substring(1)));
                    continue;
                }
                if (c == 'P') {
                    if (n == null) continue;
                    stringArray = V2CMiscUtil.split(string.substring(1));
                    hmParameters.put(n, stringArray);
                    continue;
                }
                if (c == 'U') {
                    if (n == null || (stringArray = V2CMiscUtil.split(string.substring(1))).length != 2) continue;
                    hmUnits.put(n, stringArray);
                    continue;
                }
                if (c == 'T') {
                    stringArray = V2CMiscUtil.split(string.substring(1));
                    int n2 = stringArray.length;
                    if (n2 != 3) continue;
                    int n3 = 0;
                    try {
                        n3 = V2CMiscUtil.parseHexString(stringArray[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    n = new Integer(n3);
                    hmTagNames.put(n, stringArray[2]);
                    continue;
                }
                System.out.println("unknown type: " + string);
            }
            Object var9_9 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            break block16;
            {
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    Object var9_10 = null;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static void appendToSB(String string, StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            stringBuffer.append(string);
        }
    }

    private boolean appendIFDInfo(ByteArrayWithPointer byteArrayWithPointer, StringBuffer stringBuffer, int[] nArray, String string) {
        int n = byteArrayWithPointer.getTIFFShort(-1);
        if (n == -1) {
            return false;
        }
        if (!byteArrayWithPointer.checkLength(2 + n * 12 + 4)) {
            stringBuffer.append(" [Error: too many directory entries]");
            return false;
        }
        block0: for (int i = 0; i < n; ++i) {
            String string2;
            byte by;
            String string3;
            int n2;
            String[] stringArray;
            int n3 = byteArrayWithPointer.getTIFFShort(0);
            if (n3 == 0) {
                return false;
            }
            int n4 = byteArrayWithPointer.getTIFFShort(0);
            if (n4 == 0) {
                return false;
            }
            int n5 = (int)byteArrayWithPointer.getTIFFLong(0L);
            if (n5 == 0) {
                return false;
            }
            if (n3 == 59932 && n4 == 7) {
                byteArrayWithPointer.getTIFFEntryUndefined(n5);
                continue;
            }
            stringBuffer.append('\n');
            stringBuffer.append(string);
            Integer n6 = new Integer(n3);
            String string4 = (String)hmTagNames.get(n6);
            if (string4 != null) {
                stringBuffer.append(string4);
            } else {
                stringBuffer.append("0x");
                stringBuffer.append(Integer.toHexString(n3));
            }
            stringBuffer.append("\uff1a ");
            if (n3 == 34665 || n3 == 40965) {
                int n7;
                stringArray = new ByteArrayWithPointer(byteArrayWithPointer);
                int n8 = (int)byteArrayWithPointer.getTIFFLong(0L);
                if (n8 == 0) {
                    return false;
                }
                if (nArray[0] >= nArray.length - 1) {
                    stringBuffer.append(" [Error: stack overflow]");
                    continue;
                }
                n2 = nArray[0] + 1;
                for (n7 = 1; n7 < n2; ++n7) {
                    if (nArray[n7] != n8) continue;
                    stringBuffer.append(" [Error: directory loop]");
                    continue block0;
                }
                nArray[n2] = n8;
                nArray[0] = n2;
                stringArray.setPointer(n8);
                n7 = this.appendIFDInfo((ByteArrayWithPointer)stringArray, stringBuffer, nArray, string + "  ") ? 1 : 0;
                nArray[0] = nArray[0] - 1;
                if (n7 != 0) continue;
                return false;
            }
            stringArray = (String[])hmUnits.get(n6);
            if (stringArray != null && (string3 = stringArray[0]) != null && string3.length() > 0) {
                stringBuffer.append(string3);
            }
            DecimalFormat decimalFormat = (DecimalFormat)hmFormats.get(n6);
            if (n4 == 2) {
                String string5 = byteArrayWithPointer.getTIFFEntryString(n5);
                if (string5 != null) {
                    stringBuffer.append(string5);
                }
            } else if (n4 == 3) {
                if (n5 == 1) {
                    String[] stringArray2;
                    n2 = byteArrayWithPointer.getTIFFEntryShort();
                    if (n3 == 274) {
                        this.nOrientation = n2;
                    }
                    if ((stringArray2 = (String[])hmParameters.get(n6)) != null) {
                        String string6 = null;
                        if (n2 >= 0 && n2 < stringArray2.length) {
                            string6 = stringArray2[n2];
                        }
                        if (string6 != null && string6.length() > 0) {
                            stringBuffer.append(string6);
                        } else {
                            stringBuffer.append(n2);
                        }
                    } else if (n3 == 40961) {
                        if (n2 == 1) {
                            stringBuffer.append("sRGB");
                        } else if (n2 == 2) {
                            stringBuffer.append("Adobe RGB");
                        } else if (n2 == 65533) {
                            stringBuffer.append("Wide Gamut RGB");
                        } else if (n2 == 65534) {
                            stringBuffer.append("ICC Profile");
                        } else if (n2 == 65535) {
                            stringBuffer.append("Uncalibrated");
                        } else {
                            stringBuffer.append(n2);
                        }
                    } else if (n3 == 37385) {
                        stringBuffer.append("\u767a\u5149");
                        if ((n2 & 1) == 0) {
                            stringBuffer.append("\u305b\u305a");
                        }
                        stringBuffer.append("\u3001\u30ea\u30bf\u30fc\u30f3\u691c\u51fa");
                        byte by2 = (byte)(n2 & 6);
                        if (by2 == 0) {
                            stringBuffer.append("\u6a5f\u80fd\u306a\u3057");
                        } else if (by2 == 2) {
                            stringBuffer.append("\u3055\u308c\u305a");
                        }
                        by = (byte)(n2 >> 3 & 3);
                        stringBuffer.append("\u3001\u30e2\u30fc\u30c9\uff1a");
                        if (by == 0) {
                            stringBuffer.append("\u4e0d\u660e");
                        } else if (by == 1) {
                            stringBuffer.append("\u5f37\u5236\u767a\u5149");
                        } else if (by == 2) {
                            stringBuffer.append("\u767a\u5149\u7981\u6b62");
                        } else if (by == 3) {
                            stringBuffer.append("\u30aa\u30fc\u30c8");
                        }
                        if ((n2 & 0x20) != 0) {
                            stringBuffer.append("\u3001\u8d64\u76ee\u8efd\u6e1b\u30e2\u30fc\u30c9");
                        }
                    } else if (n3 == 41989) {
                        if (n2 == 0) {
                            stringBuffer.append("\u4e0d\u660e");
                        } else {
                            stringBuffer.append(n2);
                        }
                    } else {
                        stringBuffer.append(n2);
                    }
                } else {
                    byteArrayWithPointer.skip(4);
                    V2CImageInfo.appendMultiParameterMessage(n4, n5, stringBuffer);
                }
            } else if (n4 == 4) {
                if (n5 == 1) {
                    long l = byteArrayWithPointer.getTIFFEntryLong();
                    if (n3 == 256) {
                        if (this.nWidth <= 0) {
                            this.nWidth = (int)l;
                        }
                    } else if (n3 == 257 && this.nHeight <= 0) {
                        this.nHeight = (int)l;
                    }
                    stringBuffer.append(l);
                } else {
                    byteArrayWithPointer.skip(4);
                    V2CImageInfo.appendMultiParameterMessage(n4, n5, stringBuffer);
                }
            } else if (n4 == 5) {
                if (n5 == 1) {
                    String string7 = byteArrayWithPointer.getTIFFEntryRational();
                    if (string7 != null) {
                        if (n3 == 33437 || n3 == 37381) {
                            if (byteArrayWithPointer.getTIFFEntryRationalDenominator() != 0L) {
                                V2CImageInfo.appendRationalValue(byteArrayWithPointer, decimalFormat, string7, stringBuffer);
                            } else {
                                stringBuffer.append("\u4e0d\u660e");
                            }
                        } else if (n3 == 37382) {
                            long l = byteArrayWithPointer.getTIFFEntryRationalNumerator();
                            if (l == 0xFFFFFFFFL) {
                                stringBuffer.append("\u221e");
                            } else if (l == 0L) {
                                stringBuffer.append("\u4e0d\u660e");
                            } else {
                                V2CImageInfo.appendRationalValue(byteArrayWithPointer, decimalFormat, string7, stringBuffer);
                            }
                        } else if (n3 == 41988) {
                            if (string7.startsWith("0/")) {
                                stringBuffer.append("not used");
                            } else {
                                V2CImageInfo.appendRationalValue(byteArrayWithPointer, decimalFormat, string7, stringBuffer);
                            }
                        } else {
                            V2CImageInfo.appendRationalValue(byteArrayWithPointer, decimalFormat, string7, stringBuffer);
                        }
                    }
                } else {
                    byteArrayWithPointer.skip(4);
                    V2CImageInfo.appendMultiParameterMessage(n4, n5, stringBuffer);
                }
            } else if (n4 == 7) {
                byte[] byArray = byteArrayWithPointer.getTIFFEntryUndefined(n5);
                if (byArray != null && n3 != 37500 && n3 != 50341) {
                    if (n3 == 37121 && n5 == 4) {
                        String[] stringArray3 = new String[]{"\u7121\u3057", "Y", "Cb", "Cr", "R", "G", "B"};
                        for (int j = 0; j < 4; ++j) {
                            by = byArray[j];
                            if (by >= 0 && by <= 6) {
                                stringBuffer.append(stringArray3[by]);
                            } else {
                                stringBuffer.append(by);
                            }
                            stringBuffer.append(',');
                        }
                        stringBuffer.setLength(stringBuffer.length() - 1);
                    } else if (n3 == 41730 && n5 == 8) {
                        boolean bl = true;
                        for (int j = 0; j < 4; ++j) {
                            if (byArray[j] == 0 || byArray[j] == 2) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            stringBuffer.append("[[");
                            stringBuffer.append(V2CImageInfo.getFilterColor(byArray[4]));
                            stringBuffer.append(',');
                            stringBuffer.append(V2CImageInfo.getFilterColor(byArray[5]));
                            stringBuffer.append("],[");
                            stringBuffer.append(V2CImageInfo.getFilterColor(byArray[6]));
                            stringBuffer.append(',');
                            stringBuffer.append(V2CImageInfo.getFilterColor(byArray[7]));
                            stringBuffer.append("]]");
                        } else {
                            V2CImageInfo.appendMultiParameterMessage(n4, n5, stringBuffer);
                        }
                    } else if (n3 == 41728) {
                        if (byArray.length == 1 && byArray[0] == 3) {
                            stringBuffer.append("DSC");
                        } else {
                            V2CImageInfo.appendUndefinedByteArray(byArray, stringBuffer);
                        }
                    } else if (n3 == 41729) {
                        if (byArray.length == 1 && byArray[0] == 1) {
                            stringBuffer.append("\u76f4\u63a5\u64ae\u5f71\u3055\u308c\u305f\u753b\u50cf");
                        } else {
                            V2CImageInfo.appendUndefinedByteArray(byArray, stringBuffer);
                        }
                    } else if (n3 == 37510) {
                        V2CImageInfo.appendUserComment(byArray, stringBuffer);
                    } else {
                        V2CImageInfo.appendUndefinedByteArray(byArray, stringBuffer);
                    }
                } else {
                    V2CImageInfo.appendMultiParameterMessage(n4, n5, stringBuffer);
                }
            } else if (n4 == 10) {
                if (n5 == 1) {
                    String string8 = byteArrayWithPointer.getTIFFEntrySRational();
                    if (string8 != null) {
                        if (n3 == 37379) {
                            if (byteArrayWithPointer.getTIFFEntrySRationalNumerator() == -1) {
                                stringBuffer.append("\u4e0d\u660e");
                            } else {
                                V2CImageInfo.appendSRationalValue(byteArrayWithPointer, decimalFormat, string8, stringBuffer);
                            }
                        } else {
                            V2CImageInfo.appendSRationalValue(byteArrayWithPointer, decimalFormat, string8, stringBuffer);
                        }
                    }
                } else {
                    byteArrayWithPointer.skip(4);
                    V2CImageInfo.appendMultiParameterMessage(n4, n5, stringBuffer);
                }
            } else {
                byteArrayWithPointer.skip(4);
                V2CImageInfo.appendMultiParameterMessage(n4, n5, stringBuffer);
            }
            if (stringArray == null || (string2 = stringArray[1]) == null || string2.length() <= 0) continue;
            stringBuffer.append(string2);
        }
        return true;
    }

    private static void appendRationalValue(ByteArrayWithPointer byteArrayWithPointer, DecimalFormat decimalFormat, String string, StringBuffer stringBuffer) {
        if (byteArrayWithPointer.getTIFFEntryRationalDenominator() != 0L) {
            if (decimalFormat != null) {
                stringBuffer.append(decimalFormat.format(byteArrayWithPointer.getTIFFEntryRationalValue()));
            } else {
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(string);
        }
    }

    private static char getFilterColor(byte by) {
        if (by < 0 || by > 6) {
            return '?';
        }
        return clFilterColor[by];
    }

    private static void appendSRationalValue(ByteArrayWithPointer byteArrayWithPointer, DecimalFormat decimalFormat, String string, StringBuffer stringBuffer) {
        if (byteArrayWithPointer.getTIFFEntrySRationalDenominator() != 0) {
            if (decimalFormat != null) {
                stringBuffer.append(decimalFormat.format(byteArrayWithPointer.getTIFFEntrySRationalValue()));
            } else {
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(string);
        }
    }

    private static void appendUndefinedByteArray(byte[] byArray, StringBuffer stringBuffer) {
        int n;
        int n2;
        if (byArray == null || byArray.length == 0) {
            return;
        }
        boolean bl = true;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            if (byArray[n2] == 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            stringBuffer.append(byArray.length);
            stringBuffer.append("bytes of 0's [TYPE:UNDEFINED]");
            return;
        }
        n2 = 1;
        for (n = 0; n < byArray.length; ++n) {
            byte by = byArray[n];
            if (by >= 32 && by <= 126) continue;
            n2 = 0;
            break;
        }
        if (n2 != 0) {
            stringBuffer.append(new String(byArray, 0, byArray.length));
        } else {
            for (n = 0; n < byArray.length; ++n) {
                stringBuffer.append("0x");
                stringBuffer.append(Integer.toHexString(byArray[n] & 0xFF));
                stringBuffer.append(',');
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append(" [TYPE:UNDEFINED]");
        }
    }

    private static void appendUserComment(byte[] byArray, StringBuffer stringBuffer) {
        int n;
        if (byArray.length < 8) {
            V2CImageInfo.appendUndefinedByteArray(byArray, stringBuffer);
            return;
        }
        int n2 = 8;
        String string = null;
        for (n = 1; n < 8; ++n) {
            if (byArray[n] != 0) continue;
            n2 = n;
            break;
        }
        if (n2 > 0) {
            string = new String(byArray, 0, n2);
        }
        if (string != null) {
            string = string.equalsIgnoreCase("ASCII") ? "ASCII" : (string.equalsIgnoreCase("JIS") ? "ISO2022JP" : (string.equalsIgnoreCase("UNICODE") ? "UTF-8" : null));
        }
        n = 0;
        for (int i = 8; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            n = i - 8;
            break;
        }
        if (n <= 0) {
            return;
        }
        System.arraycopy(byArray, 8, byArray, 0, n);
        String string2 = null;
        if (string != null) {
            try {
                string2 = new String(byArray, 0, n, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            string2 = V2CMiscUtil.jisAutoDetect(byArray, n);
        }
        if (string2 == null) {
            return;
        }
        int n3 = -1;
        for (int i = string2.length() - 1; i >= 0; --i) {
            if (string2.charAt(i) == ' ') continue;
            n3 = i;
            break;
        }
        if (n3 < 0) {
            return;
        }
        if (++n3 < string2.length()) {
            string2 = string2.substring(0, n3);
        }
        stringBuffer.append(string2);
    }

    private static void appendMultiParameterMessage(int n, int n2, StringBuffer stringBuffer) {
        String string = n > 0 && n < slFormatNames.length ? slFormatNames[n] : slFormatNames[0];
        stringBuffer.append(n2);
        stringBuffer.append("*[");
        stringBuffer.append(string);
        stringBuffer.append(']');
    }

    private void appendExifInfo(byte[] byArray, int n, StringBuffer stringBuffer) {
        boolean bl;
        if (n < 10) {
            return;
        }
        if (byArray[0] != 69 || byArray[1] != 120 || byArray[2] != 105 || byArray[3] != 102 || byArray[4] != 0) {
            return;
        }
        System.arraycopy(byArray, 6, byArray, 0, n - 6);
        if (byArray[0] == 77 && byArray[1] == 77) {
            bl = true;
        } else if (byArray[0] == 73 && byArray[1] == 73) {
            bl = false;
        } else {
            return;
        }
        ByteArrayWithPointer byteArrayWithPointer = new ByteArrayWithPointer(byArray, 2, bl);
        int n2 = byteArrayWithPointer.getTIFFShort(0);
        if (n2 != 42 && n2 != 10752) {
            return;
        }
        this.bExif = true;
        stringBuffer.append("Exif\uff1a");
        int[] nArray = new int[5];
        int n3 = (int)byteArrayWithPointer.getTIFFLong(0L);
        if (n3 <= 0) {
            if (n3 < 0) {
                stringBuffer.append("\nIFD\u30aa\u30d5\u30bb\u30c3\u30c8\u30a8\u30e9\u30fc\uff1a ");
                stringBuffer.append(n3);
                stringBuffer.append("\n\n");
            }
            return;
        }
        byteArrayWithPointer.setPointer(n3);
        nArray[0] = 1;
        nArray[1] = n3;
        this.appendIFDInfo(byteArrayWithPointer, stringBuffer, nArray, "  ");
    }

    private static boolean appendJFIFInfo(byte[] byArray, int n, StringBuffer stringBuffer) {
        if (n < 14) {
            stringBuffer.append(sFormatError);
            stringBuffer.append("\n\n");
            return false;
        }
        if (byArray[0] != 74 || byArray[1] != 70 || byArray[2] != 73 || byArray[3] != 70 || byArray[4] != 0) {
            for (int i = 0; i < 5 && byArray[i] != 0; ++i) {
                stringBuffer.append((char)byArray[i]);
            }
            stringBuffer.append("\n\n");
            return false;
        }
        String string = byArray[7] == 1 ? "/inch" : (byArray[7] == 2 ? "/cm" : null);
        stringBuffer.append("JFIF Ver.");
        stringBuffer.append(byArray[5]);
        stringBuffer.append('.');
        stringBuffer.append(byArray[6]);
        stringBuffer.append("\n  \u6c34\u5e73\u30d4\u30af\u30bb\u30eb\u5bc6\u5ea6\uff1a ");
        stringBuffer.append(((byArray[8] & 0xFF) << 8) + (byArray[9] & 0xFF));
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append("\n  \u5782\u76f4\u30d4\u30af\u30bb\u30eb\u5bc6\u5ea6\uff1a ");
        stringBuffer.append(((byArray[10] & 0xFF) << 8) + (byArray[11] & 0xFF));
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append("\n  \u30b5\u30e0\u30cd\u30a4\u30eb\uff1a ");
        byte by = byArray[12];
        byte by2 = byArray[13];
        if (by == 0 || by2 == 0) {
            stringBuffer.append("\u306a\u3057");
        } else {
            stringBuffer.append(by);
            stringBuffer.append('\u00d7');
            stringBuffer.append(by2);
        }
        stringBuffer.append("\n\n");
        return true;
    }

    private byte[] checkBLSize(byte[] byArray, int n) {
        return byArray.length >= n ? byArray : new byte[n];
    }

    private boolean appendJPEGInfo(BufferedInputStream bufferedInputStream, StringBuffer stringBuffer) throws IOException {
        int n;
        byte[] byArray = new byte[64];
        while (bufferedInputStream.read() == 255 && (n = bufferedInputStream.read()) != 0 && n != 255 && n != 217 && n != 218) {
            int n2 = V2CImageInfo.readShort(bufferedInputStream) - 2;
            if (n2 < 0) {
                return false;
            }
            if (n == 192) {
                bufferedInputStream.read();
                this.nHeight = V2CImageInfo.readShort(bufferedInputStream);
                this.nWidth = V2CImageInfo.readShort(bufferedInputStream);
                if (!V2CLocalFileHandler.skipInputStream(bufferedInputStream, n2 - 5)) {
                    return false;
                }
            } else if ((n & 0xF0) == 224) {
                int n3 = n & 0xF;
                if (n3 == 0) {
                    if (bufferedInputStream.read(byArray = this.checkBLSize(byArray, n2), 0, n2) != n2) {
                        return false;
                    }
                    this.bJFIF = V2CImageInfo.appendJFIFInfo(byArray, n2, stringBuffer);
                    n2 = 0;
                } else if (n3 == 1) {
                    if (bufferedInputStream.read(byArray = this.checkBLSize(byArray, n2), 0, n2) != n2) {
                        return false;
                    }
                    this.appendExifInfo(byArray, n2, stringBuffer);
                    n2 = 0;
                } else if (n3 == 2 && n2 > 12) {
                    if (bufferedInputStream.read(byArray, 0, 12) != 12) {
                        return false;
                    }
                    if (byArray[11] == 0 && new String(byArray, 0, 11).equals("ICC_PROFILE")) {
                        this.bICC = true;
                        this.bJFIFBeforeICC = this.bJFIF;
                    }
                    n2 -= 12;
                }
            }
            if (n2 <= 0 || V2CLocalFileHandler.skipInputStream(bufferedInputStream, n2)) continue;
            return false;
        }
        return true;
    }

    private boolean appendGIFInfo(BufferedInputStream bufferedInputStream, StringBuffer stringBuffer) throws IOException {
        if (bufferedInputStream.read() != 70) {
            return false;
        }
        if (!V2CLocalFileHandler.skipInputStream(bufferedInputStream, 3)) {
            return false;
        }
        int n = V2CImageInfo.readShortR(bufferedInputStream);
        int n2 = V2CImageInfo.readShortR(bufferedInputStream);
        if (n <= 0 || n2 <= 0) {
            return false;
        }
        this.nWidth = n;
        this.nHeight = n2;
        return true;
    }

    private boolean appendPNGInfo(BufferedInputStream bufferedInputStream, StringBuffer stringBuffer) throws IOException {
        int n;
        String string = "NG\r\n\u001a\n";
        for (n = 0; n < string.length(); ++n) {
            if (bufferedInputStream.read() == string.charAt(n)) continue;
            return false;
        }
        while ((n = V2CImageInfo.readInt(bufferedInputStream)) >= 0) {
            int n2 = V2CImageInfo.readInt(bufferedInputStream);
            if (n2 < 0) {
                return false;
            }
            if (n2 == 1229472850) {
                int n3 = V2CImageInfo.readInt(bufferedInputStream);
                int n4 = V2CImageInfo.readInt(bufferedInputStream);
                if (n3 <= 0 || n4 <= 0) {
                    return false;
                }
                this.nWidth = n3;
                this.nHeight = n4;
                return true;
            }
            if (V2CLocalFileHandler.skipInputStream(bufferedInputStream, n2 + 4)) continue;
            return false;
        }
        return false;
    }

    private boolean appendBMPInfo(BufferedInputStream bufferedInputStream, StringBuffer stringBuffer) throws IOException {
        if (!V2CLocalFileHandler.skipInputStream(bufferedInputStream, 16)) {
            return false;
        }
        int n = V2CImageInfo.readIntR(bufferedInputStream);
        int n2 = V2CImageInfo.readIntR(bufferedInputStream);
        if (n <= 0 || n2 <= 0) {
            return false;
        }
        this.nWidth = n;
        this.nHeight = n2;
        return true;
    }

    void parse(boolean bl, boolean bl2) {
        this.parse(bl, bl2, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parse(boolean bl, boolean bl2, int n, int n2) {
        Serializable serializable;
        block23: {
            BufferedInputStream bufferedInputStream;
            block22: {
                block21: {
                    this.nWidth = n;
                    this.nHeight = n2;
                    if (this.fImageFile == null) {
                        return;
                    }
                    int n3 = (int)this.fImageFile.length();
                    if (n3 == 0) {
                        return;
                    }
                    bufferedInputStream = null;
                    serializable = bl2 ? new StringBuffer() : null;
                    try {
                        try {
                            Serializable serializable2;
                            bufferedInputStream = new BufferedInputStream(new FileInputStream(this.fImageFile));
                            byte[] byArray = new byte[2];
                            if (bufferedInputStream.read(byArray) != 2) {
                                this.sInfoString = sFormatError;
                                Object var13_10 = null;
                                break block21;
                            }
                            String string = null;
                            boolean bl3 = false;
                            if (byArray[0] == -1 && byArray[1] == -40) {
                                this.nFormat = 1;
                                string = "JPEG";
                                bl3 = this.appendJPEGInfo(bufferedInputStream, (StringBuffer)serializable);
                            } else if (byArray[0] == -119 && byArray[1] == 80) {
                                this.nFormat = 2;
                                string = "PNG";
                                bl3 = this.appendPNGInfo(bufferedInputStream, (StringBuffer)serializable);
                            } else if (byArray[0] == 71 && byArray[1] == 73) {
                                this.nFormat = 3;
                                string = "GIF";
                                bl3 = this.appendGIFInfo(bufferedInputStream, (StringBuffer)serializable);
                            } else if (byArray[0] == 66 && byArray[1] == 77) {
                                this.nFormat = 4;
                                string = "BMP";
                                bl3 = this.appendBMPInfo(bufferedInputStream, (StringBuffer)serializable);
                            } else if (byArray[0] == 82 && byArray[1] == 73) {
                                this.nFormat = 5;
                                string = "WEBP";
                                bl3 = true;
                            }
                            this.sFormatName = string;
                            if (bl && (this.nWidth <= 0 || this.nHeight <= 0) && (serializable2 = V2CImageInfo.getImageSize(this.fImageFile)) != null) {
                                this.nWidth = ((Dimension)serializable2).width;
                                this.nHeight = ((Dimension)serializable2).height;
                            }
                            if (serializable == null) break block22;
                            if (!bl3) {
                                serializable.append(sFormatError);
                            }
                            if (string != null) {
                                serializable2 = new StringBuffer();
                                ((StringBuffer)serializable2).append(string);
                                if (this.nWidth > 0 && this.nHeight > 0) {
                                    V2CImageInfo.appendGeneralInfo((StringBuffer)serializable2, n3, this.nWidth, this.nHeight);
                                }
                                ((StringBuffer)serializable2).append("\n\n");
                                ((StringBuffer)serializable2).append(serializable.toString());
                                serializable = serializable2;
                            }
                            break block22;
                        }
                        catch (IOException iOException) {
                            Object var13_12 = null;
                            V2CLocalFileHandler.closeInputStream(bufferedInputStream);
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_13 = null;
                        V2CLocalFileHandler.closeInputStream(bufferedInputStream);
                        throw throwable;
                    }
                }
                V2CLocalFileHandler.closeInputStream(bufferedInputStream);
                return;
            }
            Object var13_11 = null;
            V2CLocalFileHandler.closeInputStream(bufferedInputStream);
        }
        if (bl2) {
            this.sInfoString = serializable.toString();
        }
    }

    private static void appendGeneralInfo(StringBuffer stringBuffer, int n, int n2, int n3) {
        DecimalFormat decimalFormat = new DecimalFormat(",##0");
        stringBuffer.append("\n  \u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\uff1a ");
        stringBuffer.append(decimalFormat.format(n));
        stringBuffer.append("\n  \u5e45\u00d7\u9ad8\u3055\uff1a ");
        stringBuffer.append(decimalFormat.format(n2));
        stringBuffer.append("\u00d7");
        stringBuffer.append(decimalFormat.format(n3));
    }

    boolean isJPEG() {
        return this.nFormat == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Dimension getImageSize(File file) {
        int n;
        int n2;
        ImageInputStream imageInputStream;
        ImageReader imageReader;
        block11: {
            Iterator<ImageReader> iterator;
            imageReader = null;
            imageInputStream = null;
            n2 = 0;
            n = 0;
            imageInputStream = ImageIO.createImageInputStream(file);
            if (imageInputStream == null || !(iterator = ImageIO.getImageReaders(imageInputStream)).hasNext()) break block11;
            imageReader = iterator.next();
            imageReader.setInput(imageInputStream);
            n2 = imageReader.getWidth(0);
            n = imageReader.getHeight(0);
        }
        Object var7_7 = null;
        if (imageReader != null) {
            imageReader.dispose();
        }
        if (imageInputStream == null) return new Dimension(n2, n);
        try {
            imageInputStream.close();
            return new Dimension(n2, n);
        }
        catch (IOException iOException) {}
        return new Dimension(n2, n);
        {
            catch (IOException iOException) {
                Object var7_8 = null;
                if (imageReader != null) {
                    imageReader.dispose();
                }
                if (imageInputStream == null) return new Dimension(n2, n);
                try {
                    imageInputStream.close();
                    return new Dimension(n2, n);
                }
                catch (IOException iOException2) {}
                return new Dimension(n2, n);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (imageReader != null) {
                imageReader.dispose();
            }
            if (imageInputStream == null) throw throwable;
            try {
                imageInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static V2CImageInfo getImageInfo(File file, boolean bl, boolean bl2) {
        V2CImageInfo v2CImageInfo = new V2CImageInfo(file);
        v2CImageInfo.parse(bl, bl2);
        return v2CImageInfo;
    }

    static void showPanel(File file, int n, int n2) {
        V2CImageInfo.showPanel(null, file, n, n2);
    }

    static void showPanel(Component component, File file, int n, int n2) {
        V2CImageInfo v2CImageInfo = new V2CImageInfo(file);
        v2CImageInfo.parse(true, true, n, n2);
        String string = v2CImageInfo.sInfoString;
        if (string == null || string.length() == 0) {
            string = "\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093";
        }
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setMargin(new Insets(5, 5, 5, 10));
        jTextArea.setEditable(false);
        jTextArea.setFont(V2CSSFont.getDefaultFont().getAwtFont());
        Dimension dimension = jTextArea.getPreferredSize();
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        Insets insets = jScrollPane.getInsets();
        Rectangle rectangle = V2CMain.v2cMain.getBounds();
        Rectangle rectangle2 = V2CSwingUtil.getScreenBoundsAt(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        int n3 = dimension.width + insets.left + insets.right;
        int n4 = 2 * rectangle2.width / 3;
        int n5 = dimension.height + insets.top + insets.bottom;
        int n6 = 2 * rectangle2.height / 3;
        int n7 = UIManager.getInt("ScrollBar.width");
        if (V2CApp.isMacintosh()) {
            n3 += n7;
            n5 += n7;
        }
        if (n3 > n4) {
            n5 += n7;
        }
        if (n5 > n6) {
            n3 += n7;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        if (n5 > n6) {
            n5 = n6;
        }
        Dimension dimension2 = new Dimension(n3, n5);
        jScrollPane.setPreferredSize(dimension2);
        jScrollPane.setMaximumSize(dimension2);
        jTextArea.setLineWrap(true);
        JOptionPane.showMessageDialog(component != null ? component : V2CMain.v2cMain, jScrollPane, "Image Info", -1);
    }

    private V2CImageInfo(File file) {
        this.fImageFile = file;
    }

    static {
        V2CImageInfo.restoreTagName();
        clFilterColor = new char[]{'R', 'G', 'B', 'C', 'M', 'Y', 'W'};
    }

    private static class ByteArrayWithPointer {
        byte[] blBytes;
        int iPointer;
        boolean bBigEndian;
        int iRational0;
        int iRational1;
        long lRational0;
        long lRational1;

        ByteArrayWithPointer(ByteArrayWithPointer byteArrayWithPointer) {
            this.blBytes = byteArrayWithPointer.blBytes;
            this.iPointer = byteArrayWithPointer.iPointer;
            this.bBigEndian = byteArrayWithPointer.bBigEndian;
        }

        ByteArrayWithPointer(byte[] byArray, int n, boolean bl) {
            this.blBytes = byArray;
            this.iPointer = n;
            this.bBigEndian = bl;
        }

        boolean checkLength(int n) {
            return this.blBytes.length >= this.iPointer + n;
        }

        void setPointer(int n) {
            this.iPointer = n;
        }

        void skip(int n) {
            this.iPointer += n;
        }

        int getTIFFSLong() {
            int n = 0;
            if (this.bBigEndian) {
                for (int i = 0; i < 4; ++i) {
                    n = (n << 8) + (this.blBytes[this.iPointer + i] & 0xFF);
                }
            } else {
                for (int i = 3; i >= 0; --i) {
                    n = (n << 8) + (this.blBytes[this.iPointer + i] & 0xFF);
                }
            }
            return n;
        }

        long getTIFFLong() {
            long l = 0L;
            if (this.bBigEndian) {
                for (int i = 0; i < 4; ++i) {
                    l = (l << 8) + (long)(this.blBytes[this.iPointer + i] & 0xFF);
                }
            } else {
                for (int i = 3; i >= 0; --i) {
                    l = (l << 8) + (long)(this.blBytes[this.iPointer + i] & 0xFF);
                }
            }
            return l;
        }

        long getTIFFLong(long l) {
            if (this.blBytes.length < this.iPointer + 4) {
                return l;
            }
            long l2 = this.getTIFFLong();
            this.iPointer += 4;
            return l2;
        }

        int getTIFFShort() {
            if (this.bBigEndian) {
                return ((this.blBytes[this.iPointer] & 0xFF) << 8) + (this.blBytes[this.iPointer + 1] & 0xFF);
            }
            return ((this.blBytes[this.iPointer + 1] & 0xFF) << 8) + (this.blBytes[this.iPointer] & 0xFF);
        }

        int getTIFFShort(int n) {
            if (this.blBytes.length < this.iPointer + 2) {
                return n;
            }
            int n2 = this.getTIFFShort();
            this.iPointer += 2;
            return n2;
        }

        String getTIFFEntryString(int n) {
            int n2 = n <= 4 ? this.iPointer : (int)this.getTIFFLong();
            this.iPointer += 4;
            if (n2 <= 0 || this.blBytes.length < n2 + n) {
                return null;
            }
            if (this.blBytes[n2 + n - 1] != 0) {
                if (this.blBytes.length < n2 + ++n) {
                    return null;
                }
            } else {
                for (int i = n2 + n - 2; i >= n2 && this.blBytes[i] == 0; --i) {
                    --n;
                }
            }
            return n > 1 && this.blBytes[n2 + n - 1] == 0 ? new String(this.blBytes, n2, n - 1) : null;
        }

        int getTIFFEntryShort() {
            int n = this.getTIFFShort();
            this.iPointer += 4;
            return n;
        }

        long getTIFFEntryLong() {
            long l = this.getTIFFLong();
            this.iPointer += 4;
            return l;
        }

        String getTIFFEntryRational() {
            if (!this.setTIFFEntryRationalNumbers()) {
                return null;
            }
            this.reduceRational();
            return String.valueOf(this.lRational0) + "/" + String.valueOf(this.lRational1);
        }

        long getTIFFEntryRationalNumerator() {
            return this.lRational0;
        }

        long getTIFFEntryRationalDenominator() {
            return this.lRational1;
        }

        double getTIFFEntryRationalValue() {
            return (double)this.lRational0 / (double)this.lRational1;
        }

        boolean setTIFFEntryRationalNumbers() {
            int n = (int)this.getTIFFLong();
            this.iPointer += 4;
            if (n <= 0 || this.blBytes.length < n + 8) {
                return false;
            }
            int n2 = this.iPointer;
            this.iPointer = n;
            this.lRational0 = this.getTIFFLong();
            this.iPointer += 4;
            this.lRational1 = this.getTIFFLong();
            this.iPointer = n2;
            return true;
        }

        void reduceRational() {
            boolean bl;
            long l;
            long l2;
            boolean bl2;
            if (this.lRational0 == 0L || this.lRational1 == 0L) {
                return;
            }
            if (this.lRational0 == this.lRational1) {
                this.lRational0 = 1L;
                this.lRational1 = 1L;
            } else if (this.lRational0 < this.lRational1) {
                if (this.lRational1 % this.lRational0 == 0L) {
                    this.lRational1 /= this.lRational0;
                    this.lRational0 = 1L;
                }
            } else if (this.lRational0 % this.lRational1 == 0L) {
                this.lRational0 /= this.lRational1;
                this.lRational1 = 1L;
            }
            if (this.lRational0 == 1L || this.lRational1 == 1L) {
                return;
            }
            boolean bl3 = bl2 = this.lRational0 < this.lRational1;
            if (bl2) {
                l2 = this.lRational0;
                l = this.lRational1;
            } else {
                l2 = this.lRational1;
                l = this.lRational0;
            }
            if (l2 > 0xFFFFFFL) {
                return;
            }
            block0: do {
                bl = false;
                long l3 = l2 / 2L;
                for (long i = 2L; i < l3; ++i) {
                    if (l2 % i != 0L || l % i != 0L) continue;
                    l2 /= i;
                    l /= i;
                    bl = true;
                    continue block0;
                }
            } while (bl);
            if (bl2) {
                this.lRational0 = l2;
                this.lRational1 = l;
            } else {
                this.lRational0 = l;
                this.lRational1 = l2;
            }
        }

        byte[] getTIFFEntryUndefined(int n) {
            if (n <= 0) {
                this.iPointer += 4;
                return null;
            }
            int n2 = n <= 4 ? this.iPointer : (int)this.getTIFFLong();
            this.iPointer += 4;
            if (n2 <= 0 || n2 + n > this.blBytes.length) {
                return null;
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.blBytes, n2, byArray, 0, n);
            return byArray;
        }

        String getTIFFEntrySRational() {
            if (!this.setTIFFEntrySRationalNumbers()) {
                return null;
            }
            this.reduceSRational();
            return String.valueOf(this.iRational0) + "/" + String.valueOf(this.iRational1);
        }

        int getTIFFEntrySRationalNumerator() {
            return this.iRational0;
        }

        int getTIFFEntrySRationalDenominator() {
            return this.iRational1;
        }

        double getTIFFEntrySRationalValue() {
            return (double)this.iRational0 / (double)this.iRational1;
        }

        boolean setTIFFEntrySRationalNumbers() {
            int n = (int)this.getTIFFLong();
            this.iPointer += 4;
            if (n <= 0 || this.blBytes.length < n + 8) {
                return false;
            }
            int n2 = this.iPointer;
            this.iPointer = n;
            this.iRational0 = this.getTIFFSLong();
            this.iPointer += 4;
            this.iRational1 = this.getTIFFSLong();
            this.iPointer = n2;
            return true;
        }

        void reduceSRational() {
            boolean bl;
            int n;
            int n2;
            boolean bl2;
            if (this.iRational0 <= 0 || this.iRational1 <= 0) {
                return;
            }
            if (this.iRational0 == this.iRational1) {
                this.iRational0 = 1;
                this.iRational1 = 1;
            } else if (this.iRational0 < this.iRational1) {
                if (this.iRational1 % this.iRational0 == 0) {
                    this.iRational1 /= this.iRational0;
                    this.iRational0 = 1;
                }
            } else if (this.iRational0 % this.iRational1 == 0) {
                this.iRational0 /= this.iRational1;
                this.iRational1 = 1;
            }
            if (this.iRational0 == 1 || this.iRational1 == 1) {
                return;
            }
            boolean bl3 = bl2 = this.iRational0 < this.iRational1;
            if (bl2) {
                n2 = this.iRational0;
                n = this.iRational1;
            } else {
                n2 = this.iRational1;
                n = this.iRational0;
            }
            block0: do {
                bl = false;
                int n3 = n2 / 2;
                for (int i = 2; i < n3; ++i) {
                    if (n2 % i != 0 || n % i != 0) continue;
                    n2 /= i;
                    n /= i;
                    bl = true;
                    continue block0;
                }
            } while (bl);
            if (bl2) {
                this.iRational0 = n2;
                this.iRational1 = n;
            } else {
                this.iRational0 = n;
                this.iRational1 = n2;
            }
        }
    }
}

