/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.monazilla.v2c.V2CAbstractAction;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CGestureMap;
import org.monazilla.v2c.V2CGestureMapConstants;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTextChangeListener;

public class V2CGestureMapSP
extends JPanel
implements V2CGestureMapConstants,
ActionListener {
    private static int iSelectedTableIndex;
    private static int iSBValue;
    static final String[] slColNames;
    final boolean bUseGesture;
    final boolean bUseLeftButton;
    boolean bUseGesture0;
    boolean bTmpUseLeftButton;
    V2CGestureMap[] vgmlGestureMaps;
    V2CGestureMap gmCurrentGestureMap;
    JCheckBox jcbUseGesture;
    JCheckBox jcbUseRightButton;
    JComboBox jcbComponent;
    JTextField jtfFilter;
    String sLastFilterWords;
    ActionTableModel tmAction;
    JTable jtActions;
    JScrollPane jScrollPane;
    Color cFG;
    JComboBox jcbThreshold;
    JPanel jpStart;
    JTextField jtfGestureString;
    JButton jbSet;
    JButton jbAdd;
    JButton jbClear;
    JLabel jlStatus;
    boolean bChanged;

    public V2CGestureMapSP(V2CGestureMap[] v2CGestureMapArray, int n) {
        super(new GridBagLayout());
        JLabel jLabel;
        Insets insets;
        JScrollPane jScrollPane;
        JTable jTable;
        JTextField jTextField;
        JComboBox jComboBox;
        this.vgmlGestureMaps = v2CGestureMapArray;
        this.sLastFilterWords = "";
        this.bUseGesture = this.bUseGesture0 = V2CGestureMap.getUseGesture();
        this.bUseLeftButton = V2CGestureMap.getUseLeftButton();
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jcbUseGesture = V2CSwingUtil.addCheckBox("\u30de\u30a6\u30b9\u30b8\u30a7\u30b9\u30c1\u30e3\u3092\u4f7f\u7528\u3059\u308b", this.bUseGesture, this, gridBagConstraints, true);
        this.jcbUseGesture.addActionListener(this);
        if (V2CApp.isMacintosh()) {
            this.jcbUseRightButton = new JCheckBox("\u30de\u30a6\u30b9\u306e\u53f3\u30dc\u30bf\u30f3\u3092\u4f7f\u7528\u3059\u308b", !this.bUseLeftButton);
            this.jcbUseRightButton.setFocusable(false);
            this.add((Component)this.jcbUseRightButton, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.jcbComponent = jComboBox = V2CSwingUtil.createComboBox(v2CGestureMapArray);
        jComboBox.setFocusable(false);
        jComboBox.setMaximumRowCount(20);
        jComboBox.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jComboBox, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        this.jtfFilter = jTextField = V2CSwingUtil.createTextField(6);
        new FilterListener();
        this.add((Component)jTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        ++gridBagConstraints.gridy;
        this.tmAction = new ActionTableModel();
        this.jtActions = jTable = new JTable(this.tmAction);
        jTable.setSelectionMode(0);
        jTable.setColumnSelectionAllowed(false);
        jTable.getColumnModel().getColumn(slColNames.length - 1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setForeground(n < V2CGestureMapSP.this.tmAction.nFiltered ? Color.RED : V2CGestureMapSP.this.cFG);
                return component;
            }
        });
        this.jScrollPane = jScrollPane = V2CSwingUtil.createScrollPaneForTable(jTable, 200);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = insets = new Insets(4, 2, 4, 2);
        jPanel.add((Component)new JLabel("\u95be\u8ddd\u96e2\uff1a"), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        Object[] objectArray = new String[19];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = String.valueOf(i * 5 + 10);
        }
        this.jcbThreshold = V2CSwingUtil.createComboBox(objectArray);
        this.jcbThreshold.setSelectedIndex(V2CMiscUtil.restrictRange(0, (V2CGestureMap.nThreshold - 10) / 5, objectArray.length - 1));
        this.jcbThreshold.addActionListener(this);
        this.jcbThreshold.setFocusable(false);
        gridBagConstraints2.insets = new Insets(4, 2, 4, 20);
        jPanel.add((Component)this.jcbThreshold, gridBagConstraints2);
        gridBagConstraints2.insets = insets;
        ++gridBagConstraints2.gridx;
        this.jpStart = new JPanel();
        this.jpStart.setBackground(Color.WHITE);
        Dimension dimension = new Dimension(n, n);
        this.jpStart.setPreferredSize(dimension);
        this.jpStart.setMinimumSize(dimension);
        this.jpStart.setBorder(new EtchedBorder(1));
        GestureListener gestureListener = new GestureListener();
        this.jpStart.addMouseListener(gestureListener);
        this.jpStart.addMouseMotionListener(gestureListener);
        this.jpStart.addMouseWheelListener(gestureListener);
        jPanel.add((Component)this.jpStart, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        this.jtfGestureString = new JTextField(15);
        this.jtfGestureString.setFocusable(false);
        this.jtfGestureString.setEditable(false);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        jPanel.add((Component)this.jtfGestureString, gridBagConstraints2);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        ++gridBagConstraints2.gridx;
        this.jbSet = this.createButton("\u8a2d\u5b9a", jPanel, gridBagConstraints2);
        this.jbAdd = this.createButton("\u8ffd\u52a0", jPanel, gridBagConstraints2);
        this.jbClear = this.createButton("\u524a\u9664", jPanel, gridBagConstraints2);
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.jlStatus = jLabel = new JLabel("\u8a2d\u5b9a\u7121\u3057");
        gridBagConstraints.fill = 0;
        this.add((Component)jLabel, gridBagConstraints);
        this.jcbComponent.setSelectedIndex(iSelectedTableIndex);
    }

    private JButton createButton(String string, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        JButton jButton = new JButton(string);
        jButton.setFocusable(false);
        jButton.addActionListener(this);
        jPanel.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        return jButton;
    }

    void gestureMapSelectionChanged() {
        int n = this.jcbComponent.getSelectedIndex();
        if (n < 0 || n >= slGestureMapName.length) {
            return;
        }
        this.gmCurrentGestureMap = this.vgmlGestureMaps[n];
        this.tmAction.setActions(V2CAction.getGestureActionsToConfigure(n));
        this.updateStatus();
    }

    private void updateStatus() {
        String string = "\u8a2d\u5b9a\u7121\u3057";
        String string2 = this.jtfGestureString.getText();
        if (string2.length() > 0) {
            Iterator iterator = this.gmCurrentGestureMap.getKeyIterator();
            while (iterator.hasNext()) {
                V2CAbstractAction v2CAbstractAction;
                if (!string2.equals(iterator.next())) continue;
                Object object = this.gmCurrentGestureMap.get(string2);
                if (!(object instanceof String) || (v2CAbstractAction = V2CAction.getAction((String)object)) == null) break;
                string = v2CAbstractAction.toString();
                break;
            }
        }
        this.jlStatus.setText(string);
    }

    void setGesture(boolean bl) {
        String string;
        String string2 = this.jtfGestureString.getText();
        if (string2 == null || string2.length() == 0) {
            return;
        }
        int n = this.jtActions.getSelectedRow();
        if (n < 0) {
            return;
        }
        V2CAbstractAction v2CAbstractAction = this.tmAction.getAction(n);
        if (v2CAbstractAction == null) {
            return;
        }
        Iterator iterator = this.gmCurrentGestureMap.getKeyIterator();
        while (iterator.hasNext()) {
            if (!string2.equals(iterator.next())) continue;
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (!bl && (string = this.tmAction.getGesture(n)) != null) {
            this.gmCurrentGestureMap.remove(string);
        }
        this.gmCurrentGestureMap.put(string2, v2CAbstractAction.getName());
        this.tmAction.gestureChanged(n, string2, bl);
        this.bChanged = true;
        if (!this.bUseGesture0 && !this.jcbUseGesture.isSelected()) {
            this.bUseGesture0 = true;
            this.jcbUseGesture.setSelected(true);
        }
    }

    void clearGesture() {
        int n = this.jtActions.getSelectedRow();
        if (n < 0) {
            return;
        }
        V2CAbstractAction v2CAbstractAction = this.tmAction.getAction(n);
        if (v2CAbstractAction == null) {
            return;
        }
        String string = this.tmAction.getGesture(n);
        if (string != null) {
            this.gmCurrentGestureMap.remove(string);
        }
        this.tmAction.clearGesture(n);
        this.bChanged = true;
    }

    int getThreshold() {
        return this.jcbThreshold.getSelectedIndex() * 5 + 10;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jcbUseGesture) {
            this.bUseGesture0 = true;
        } else if (object == this.jcbComponent) {
            this.gestureMapSelectionChanged();
        } else if (object == this.jbSet) {
            this.setGesture(false);
        } else if (object == this.jbAdd) {
            this.setGesture(true);
        } else if (object == this.jbClear) {
            this.clearGesture();
        } else if (object == this.jcbThreshold) {
            int n = this.getThreshold();
            Dimension dimension = new Dimension(n, n);
            this.jpStart.setPreferredSize(dimension);
            this.jpStart.setMinimumSize(dimension);
            this.revalidate();
        }
    }

    void preShowDialog() {
        int n = iSBValue;
        if (n > 0) {
            this.scrollLater(n);
        }
    }

    private void scrollLater(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JScrollBar jScrollBar = V2CGestureMapSP.this.jScrollPane.getVerticalScrollBar();
                if (jScrollBar != null) {
                    jScrollBar.setValue(n);
                }
            }
        });
    }

    void postShowDialog() {
        JScrollBar jScrollBar;
        int n = this.jcbComponent.getSelectedIndex();
        if (n >= 0 && n < slGestureMapName.length) {
            iSelectedTableIndex = n;
        }
        if ((jScrollBar = this.jScrollPane.getVerticalScrollBar()) != null) {
            iSBValue = jScrollBar.getValue();
        }
    }

    boolean isChanged() {
        return this.bChanged;
    }

    boolean getUseGesture() {
        return this.jcbUseGesture.isSelected();
    }

    boolean getUseLeftButton() {
        if (this.jcbUseRightButton != null) {
            return !this.jcbUseRightButton.isSelected();
        }
        return false;
    }

    static {
        slColNames = new String[]{"\u30b8\u30a7\u30b9\u30c1\u30e3", "\u30a2\u30af\u30b7\u30e7\u30f3"};
    }

    private class GestureListener
    extends MouseInputAdapter
    implements MouseWheelListener {
        int nGestureCount;
        boolean bInGesture;

        private GestureListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.bInGesture) {
                return;
            }
            if (!V2CGestureMapSP.this.gmCurrentGestureMap.mouseDragged(mouseEvent)) {
                this.bInGesture = false;
                V2CGestureMapSP.this.jtfGestureString.setText("");
                return;
            }
            if (V2CGestureMap.getCurrentStrokeCount() <= this.nGestureCount) {
                return;
            }
            V2CGestureMapSP.this.jtfGestureString.setText(V2CGestureMap.getCurrentGestureString(false) + " <");
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getButton();
            if (this.bInGesture) {
                this.bInGesture = false;
                String string = V2CGestureMap.getCurrentGestureString(true);
                if (!V2CGestureMapSP.this.bTmpUseLeftButton && (n == 1 || n == 2 || n >= 4 && n <= 7)) {
                    String string2;
                    switch (n) {
                        case 1: {
                            string2 = "L";
                            break;
                        }
                        case 2: {
                            string2 = "M";
                            break;
                        }
                        case 4: {
                            string2 = "W\u2190";
                            break;
                        }
                        case 5: {
                            string2 = "W\u2192";
                            break;
                        }
                        case 6: {
                            string2 = "X1";
                            break;
                        }
                        case 7: {
                            string2 = "X2";
                            break;
                        }
                        default: {
                            string2 = "";
                        }
                    }
                    string = string + string2;
                }
                V2CGestureMapSP.this.jtfGestureString.setText(string);
                this.endGesture();
            } else if (n == 6 || n == 7) {
                String string;
                String string3 = string = n == 6 ? "x1" : "x2";
                if ((mouseEvent.getModifiersEx() & 0x40) != 0) {
                    string = 'S' + string;
                }
                V2CGestureMapSP.this.jtfGestureString.setText(string);
                this.endGesture();
            } else {
                if (!V2CGestureMapSP.this.bUseGesture) {
                    V2CGestureMap.setUseGesture(true);
                }
                if (V2CGestureMapSP.this.jcbUseRightButton != null) {
                    boolean bl = V2CGestureMapSP.this.bTmpUseLeftButton = !V2CGestureMapSP.this.jcbUseRightButton.isSelected();
                    if (V2CGestureMapSP.this.bTmpUseLeftButton != V2CGestureMapSP.this.bUseLeftButton) {
                        V2CGestureMap.setUseLeftButton(V2CGestureMapSP.this.bTmpUseLeftButton);
                    }
                }
                V2CGestureMapSP.this.gmCurrentGestureMap.mousePressed(mouseEvent, true);
                if (!V2CGestureMap.isInGesture()) {
                    return;
                }
                V2CGestureMapSP.this.jtfGestureString.setText(" <");
                this.bInGesture = true;
                this.nGestureCount = 0;
                V2CGestureMap.setFromSettingPanel(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.bInGesture) {
                return;
            }
            this.bInGesture = false;
            V2CGestureMapSP.this.jtfGestureString.setText(V2CGestureMap.getCurrentGestureString(false));
            this.endGesture();
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!this.bInGesture) {
                return;
            }
            this.bInGesture = false;
            StringBuffer stringBuffer = new StringBuffer();
            if (V2CGestureMap.bShiftDown) {
                stringBuffer.append('S');
            }
            if (V2CGestureMapSP.this.gmCurrentGestureMap.mouseWheelMoved(mouseWheelEvent)) {
                stringBuffer.append('W');
                stringBuffer.append(mouseWheelEvent.getUnitsToScroll() >= 0 ? (char)'\u2193' : '\u2191');
            }
            V2CGestureMapSP.this.jtfGestureString.setText(stringBuffer.toString());
            this.endGesture();
        }

        private void endGesture() {
            if (V2CGestureMap.isInGesture()) {
                V2CGestureMap.endGesture();
            }
            if (!V2CGestureMapSP.this.bUseGesture) {
                V2CGestureMap.setUseGesture(false);
            }
            if (V2CGestureMapSP.this.jcbUseRightButton != null && V2CGestureMapSP.this.bTmpUseLeftButton != V2CGestureMapSP.this.bUseLeftButton) {
                V2CGestureMap.setUseLeftButton(V2CGestureMapSP.this.bUseLeftButton);
            }
            V2CGestureMap.setFromSettingPanel(false);
            V2CGestureMapSP.this.updateStatus();
        }
    }

    private class ActionTableModel
    extends AbstractTableModel {
        int nColumns = slColNames.length;
        V2CAbstractAction[] vlAbstractActions;
        ArrayList vActions = new ArrayList();
        boolean bImagePopup;
        int nFiltered;

        private ActionTableModel() {
        }

        void filterActions() {
            this.setActions(this.vlAbstractActions);
            V2CGestureMapSP.this.scrollLater(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setActions(V2CAbstractAction[] v2CAbstractActionArray) {
            this.vlAbstractActions = v2CAbstractActionArray;
            try {
                block9: {
                    this.bImagePopup = V2CGestureMapSP.this.gmCurrentGestureMap.getName().equals("ImagePopup");
                    this.vActions.clear();
                    if (v2CAbstractActionArray == null) break block9;
                    if (v2CAbstractActionArray.length != 0) break block10;
                }
                Object var10_2 = null;
            }
            catch (Throwable throwable) {
                Object var10_4 = null;
                this.fireTableDataChanged();
                throw throwable;
            }
            this.fireTableDataChanged();
            {
                Object object;
                Object object2;
                Object object3;
                block10: {
                    return;
                }
                String string = V2CMiscUtil.normalizeCase(V2CGestureMapSP.this.sLastFilterWords);
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                for (int i = 0; i < v2CAbstractActionArray.length; ++i) {
                    object3 = v2CAbstractActionArray[i];
                    object2 = new Object[this.nColumns + 1];
                    object2[this.nColumns - 1] = object3;
                    object = V2CMiscUtil.normalizeCase(((V2CAbstractAction)object3).toString());
                    if (string.length() > 0 && ((String)object).indexOf(string) >= 0) {
                        arrayList.add((Object[])object2);
                        continue;
                    }
                    this.vActions.add(object2);
                }
                this.nFiltered = arrayList.size();
                this.vActions.addAll(0, arrayList);
                Iterator iterator = V2CGestureMapSP.this.gmCurrentGestureMap.getKeyIterator();
                block3: while (iterator.hasNext()) {
                    object3 = (String)iterator.next();
                    object2 = (String)V2CGestureMapSP.this.gmCurrentGestureMap.get(object3);
                    if (object2 == null || (object = V2CAction.getAction((String)object2)) == null) continue;
                    for (int i = this.vActions.size() - 1; i >= 0; --i) {
                        if (((Object[])this.vActions.get(i))[this.nColumns - 1] != object) continue;
                        this.setGesture(i, (String)object3, true);
                        continue block3;
                    }
                }
            }
            Object var10_3 = null;
            this.fireTableDataChanged();
        }

        private void setGesture(int n, String string, boolean bl) {
            if (string == null) {
                return;
            }
            Object[] objectArray = (Object[])this.vActions.get(n);
            if (bl && objectArray[this.nColumns] != null) {
                Object object = objectArray[this.nColumns - 1];
                objectArray = new Object[this.nColumns + 1];
                this.vActions.add(n + 1, objectArray);
                objectArray[this.nColumns - 1] = object;
                if (n < this.nFiltered) {
                    ++this.nFiltered;
                }
            } else {
                for (int i = 0; i < this.nColumns - 1; ++i) {
                    objectArray[i] = null;
                }
            }
            objectArray[this.nColumns] = string;
            objectArray[0] = string;
        }

        void gestureChanged(int n, String string, boolean bl) {
            int n2 = this.vActions.size();
            this.setGesture(n, string, bl);
            if (this.vActions.size() == n2) {
                this.fireTableRowsUpdated(n, n);
            } else if (this.vActions.size() == n2 + 1) {
                this.fireTableRowsInserted(n + 1, n + 1);
            }
        }

        void clearGesture(int n) {
            Object[] objectArray;
            Object[] objectArray2 = (Object[])this.vActions.get(n);
            objectArray2[this.nColumns] = null;
            for (int i = 0; i < this.nColumns - 1; ++i) {
                objectArray2[i] = null;
            }
            V2CAbstractAction v2CAbstractAction = (V2CAbstractAction)objectArray2[this.nColumns - 1];
            boolean bl = false;
            if (n > 0) {
                objectArray = (Object[])this.vActions.get(n - 1);
                boolean bl2 = bl = v2CAbstractAction == objectArray[this.nColumns - 1];
            }
            if (!bl && n < this.vActions.size() - 1) {
                objectArray = (Object[])this.vActions.get(n + 1);
                boolean bl3 = bl = v2CAbstractAction == objectArray[this.nColumns - 1];
            }
            if (bl) {
                this.vActions.remove(n);
                if (n < this.nFiltered) {
                    --this.nFiltered;
                }
                this.fireTableRowsDeleted(n, n);
            } else {
                this.fireTableRowsUpdated(n, n);
            }
        }

        V2CAbstractAction getAction(int n) {
            if (n < 0 || n >= this.vActions.size()) {
                return null;
            }
            return (V2CAbstractAction)((Object[])this.vActions.get(n))[this.nColumns - 1];
        }

        String getGesture(int n) {
            if (n < 0 || n >= this.vActions.size()) {
                return null;
            }
            return (String)((Object[])this.vActions.get(n))[this.nColumns];
        }

        public int getRowCount() {
            return this.vActions.size();
        }

        public int getColumnCount() {
            return this.nColumns;
        }

        public String getColumnName(int n) {
            return slColNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return ((Object[])this.vActions.get(n))[n2];
        }
    }

    private class FilterListener
    extends V2CTextChangeListener {
        FilterListener() {
            super(V2CGestureMapSP.this.jtfFilter);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.isComposing()) {
                return;
            }
            V2CGestureMapSP.this.sLastFilterWords = V2CGestureMapSP.this.jtfFilter.getText();
            V2CGestureMapSP.this.tmAction.filterActions();
        }
    }
}

