/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.monazilla.v2c.V2CAbstractAction;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CActionMap;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CClassStateSaver;
import org.monazilla.v2c.V2CGestureActionEvent;
import org.monazilla.v2c.V2CGestureMapConstants;
import org.monazilla.v2c.V2CGestureMapSP;
import org.monazilla.v2c.V2CImagePopup;
import org.monazilla.v2c.V2CJStr;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CMouseSP;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSaveFile;

public class V2CGestureMap
extends HashMap
implements V2CGestureMapConstants {
    private static final String sSaveFile = "gesture.txt";
    static final String sKeyPrefix = "Gesture.";
    static final String sUseGestureKey = "Gesture.Enabled";
    static final String sUseLeftButtonKey = "Gesture.UseLeftButton";
    static final String sThresholdKey = "Gesture.Threshold";
    static final String GLOBAL = slGestureMapName[0];
    static final String THREADVIEW = "ThreadView";
    static final String IMAGEPOPUP = "ImagePopup";
    static final String TABBEDPANE = "TabbedPane";
    static final String WRITE = "Write";
    static final String OTHER = "Other";
    static final char MOVE_UP = '\u2191';
    static final char MOVE_LEFT = '\u2190';
    static final char MOVE_DOWN = '\u2193';
    static final char MOVE_RIGHT = '\u2192';
    static final HashMap hmGestureMaps = new HashMap();
    static V2CGestureMap[] vgmlGestureMaps;
    static V2CGestureMap gmGlobal;
    static boolean bUseGesture;
    static boolean bUseLeftButton;
    private static final int nDefThreshold = 30;
    static int nThreshold;
    static final ClassStateSaver classStateSaver;
    static boolean bInGesture;
    static boolean bNoGesture;
    static boolean bPointerMoved;
    static boolean bShiftDown;
    static boolean bWheelRotating;
    static boolean bLeftClicking;
    static boolean bFromSettingPanel;
    static int iX;
    static int iY;
    static int iX0;
    static int iY0;
    static int nLastStroke;
    static Point pStart;
    static char cLastDir;
    static Component cmpGesture;
    static final StringBuffer sbGestureBuffer;
    static final Timer tmCancelTimer;
    String sName;
    String sLabel;
    int iIndex;
    private boolean bGlobal;
    private final int STROKE_FACTOR = 30;

    private static String decodeStroke(String string) {
        CharSequence charSequence;
        char c;
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 1 || n == 2 && string.charAt(0) == 'S') {
            c = string.charAt(n - 1);
            CharSequence charSequence2 = charSequence = n == 1 ? "W" : "SW";
            if (c == 'u') {
                return (String)charSequence + '\u2191';
            }
            if (c == 'd') {
                return (String)charSequence + '\u2193';
            }
            if (c == 'l') {
                return (String)charSequence + '\u2190';
            }
            if (c == 'r') {
                return (String)charSequence + '\u2192';
            }
        }
        c = '\u0000';
        charSequence = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == 'U') {
                ((StringBuffer)charSequence).append('\u2191');
                continue;
            }
            if (c2 == 'L') {
                ((StringBuffer)charSequence).append('\u2190');
                continue;
            }
            if (c2 == 'D') {
                ((StringBuffer)charSequence).append('\u2193');
                continue;
            }
            if (c2 == 'R') {
                ((StringBuffer)charSequence).append('\u2192');
                continue;
            }
            if (c2 == 'S') {
                if (i > 0 || n <= 1) {
                    return null;
                }
                ((StringBuffer)charSequence).append('S');
                continue;
            }
            if (c2 == '1') {
                ((StringBuffer)charSequence).append('L');
                break;
            }
            if (c2 == '2') {
                ((StringBuffer)charSequence).append('M');
                break;
            }
            if (c2 == '6') {
                ((StringBuffer)charSequence).append(c != '\u0000' ? "x1" : "X1");
                break;
            }
            if (c2 == '7') {
                ((StringBuffer)charSequence).append(c != '\u0000' ? "x2" : "X2");
                break;
            }
            if (c2 == '-') {
                c = '\u0001';
                continue;
            }
            return null;
        }
        return ((StringBuffer)charSequence).toString();
    }

    private static String encodeStroke(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 2 && string.charAt(0) == 'W' || n == 3 && string.charAt(0) == 'S' && string.charAt(1) == 'W') {
            char c = string.charAt(n - 1);
            if (c == '\u2191') {
                return n == 2 ? "u" : "Su";
            }
            if (c == '\u2193') {
                return n == 2 ? "d" : "Sd";
            }
            if (c == '\u2190') {
                return n == 2 ? "l" : "Sl";
            }
            if (c == '\u2192') {
                return n == 2 ? "r" : "Sr";
            }
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\u2191') {
                stringBuffer.append('U');
                continue;
            }
            if (c == '\u2190') {
                stringBuffer.append('L');
                continue;
            }
            if (c == '\u2193') {
                stringBuffer.append('D');
                continue;
            }
            if (c == '\u2192') {
                stringBuffer.append('R');
                continue;
            }
            if (c == 'S') {
                if (i > 0 || n <= 1) {
                    return null;
                }
                stringBuffer.append('S');
                continue;
            }
            if (c == 'L') {
                if (i < n - 1) {
                    return null;
                }
                stringBuffer.append('1');
                continue;
            }
            if (c == 'M') {
                if (i < n - 1) {
                    return null;
                }
                stringBuffer.append('2');
                continue;
            }
            if (c == 'X' || c == 'x') {
                char c2;
                if (i != n - 2) {
                    return null;
                }
                if (c == 'x') {
                    stringBuffer.append('-');
                }
                if ((c2 = string.charAt(++i)) == '1') {
                    stringBuffer.append('6');
                    continue;
                }
                if (c2 == '2') {
                    stringBuffer.append('7');
                    continue;
                }
                return null;
            }
            return null;
        }
        return stringBuffer.toString();
    }

    static void checkThumbnailGesture() {
        V2CGestureMap v2CGestureMap = vgmlGestureMaps[9];
        V2CGestureMap v2CGestureMap2 = vgmlGestureMaps[6];
        if (v2CGestureMap == null || v2CGestureMap2 == null) {
            return;
        }
        boolean bl = false;
        String[] stringArray = new String[]{"DisableLink", "DeleteLinkCache", "SaveImageSilent", "ShowQuickImageSaveMenu", "ShowImageProperty"};
        Iterator iterator = v2CGestureMap.keySet().iterator();
        block0: while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)v2CGestureMap.get(string);
            if (string2 == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                v2CGestureMap2.put(string, string2);
                bl = true;
                continue block0;
            }
        }
        if (bl) {
            classStateSaver.requestSave();
        }
    }

    static void endGesture() {
        bInGesture = false;
        V2CGestureMap.restoreCursor();
        V2CMain.endTempMessage(V2CGestureMap.class);
    }

    private static void restoreCursor() {
        if (cmpGesture != null) {
            cmpGesture.setCursor(Cursor.getDefaultCursor());
        }
    }

    static V2CGestureMap getGestureMap(int n) {
        V2CGestureMap[] v2CGestureMapArray = vgmlGestureMaps;
        return n >= 0 && n < v2CGestureMapArray.length ? v2CGestureMapArray[n] : null;
    }

    static V2CGestureMap getGestureMap(String string) {
        V2CGestureMap v2CGestureMap = (V2CGestureMap)hmGestureMaps.get(string);
        if (v2CGestureMap == null) {
            v2CGestureMap = new V2CGestureMap(string);
            hmGestureMaps.put(string, v2CGestureMap);
        }
        return v2CGestureMap;
    }

    static boolean getUseGesture() {
        return bUseGesture;
    }

    static void setUseGesture(boolean bl) {
        bUseGesture = bl;
    }

    static void setFromSettingPanel(boolean bl) {
        bFromSettingPanel = bl;
    }

    static boolean hasPointerMoved() {
        return bPointerMoved;
    }

    static boolean getUseLeftButton() {
        return bUseLeftButton;
    }

    static void setUseLeftButton(boolean bl) {
        bUseLeftButton = bl;
    }

    static boolean isInGesture() {
        return bInGesture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void restoreGestureMap() {
        Object object;
        block11: {
            BufferedReader bufferedReader = V2CLocalFileHandler.getUserSaveFileReader(sSaveFile);
            if (bufferedReader == null) {
                System.out.println("cannot read gesture.txt !");
                return;
            }
            try {
                Object var6_7;
                try {
                    V2CGestureMap v2CGestureMap = null;
                    while ((object = bufferedReader.readLine()) != null) {
                        String[] stringArray;
                        int n;
                        if (((String)object).length() == 0 || ((String)object).charAt(0) == '#' || (n = (stringArray = V2CMiscUtil.split((String)object)).length) != 2) continue;
                        if (stringArray[0].equals("Map")) {
                            v2CGestureMap = new V2CGestureMap(stringArray[1]);
                            hmGestureMaps.put(stringArray[1], v2CGestureMap);
                            continue;
                        }
                        if (v2CGestureMap == null) continue;
                        v2CGestureMap.put(V2CGestureMap.decodeStroke(stringArray[0]), stringArray[1]);
                    }
                    var6_7 = null;
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    var6_7 = null;
                    V2CLocalFileHandler.closeReader(bufferedReader);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                V2CLocalFileHandler.closeReader(bufferedReader);
                throw throwable;
            }
            V2CLocalFileHandler.closeReader(bufferedReader);
        }
        int n = 0;
        while (true) {
            if (n >= vgmlGestureMaps.length) {
                gmGlobal = V2CGestureMap.getGestureMap(GLOBAL);
                V2CGestureMap.gmGlobal.bGlobal = true;
                return;
            }
            object = V2CGestureMap.getGestureMap(slGestureMapName[n]);
            if (object == null) {
                object = new V2CGestureMap(slGestureMapName[n]);
            }
            V2CGestureMap.vgmlGestureMaps[n] = object;
            ((V2CGestureMap)object).sLabel = V2CJStr.slGestureMapLabels[n];
            ((V2CGestureMap)object).iIndex = n++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void saveGestureMap() {
        V2CSaveFile v2CSaveFile;
        block7: {
            v2CSaveFile = new V2CSaveFile(sSaveFile);
            BufferedWriter bufferedWriter = v2CSaveFile.getWriter();
            if (bufferedWriter == null) {
                return;
            }
            try {
                try {
                    for (int i = 0; i < slGestureMapName.length; ++i) {
                        V2CGestureMap v2CGestureMap = vgmlGestureMaps[i];
                        if (v2CGestureMap == null || v2CGestureMap.size() == 0) continue;
                        bufferedWriter.write("Map,");
                        bufferedWriter.write(slGestureMapName[i]);
                        bufferedWriter.newLine();
                        Set set = v2CGestureMap.keySet();
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            String string;
                            String string2;
                            String string3 = (String)iterator.next();
                            if (string3 == null || string3.length() == 0 || (string2 = (String)v2CGestureMap.get(string3)) == null || string2.length() == 0 || (string = V2CGestureMap.encodeStroke(string3)) == null) continue;
                            bufferedWriter.write(string);
                            bufferedWriter.write(44);
                            bufferedWriter.write(string2);
                            bufferedWriter.newLine();
                        }
                        bufferedWriter.newLine();
                    }
                    v2CSaveFile.setOK();
                }
                catch (IOException iOException) {
                    Object var10_11 = null;
                    V2CLocalFileHandler.closeWriter(bufferedWriter);
                    break block7;
                }
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                V2CLocalFileHandler.closeWriter(bufferedWriter);
                throw throwable;
            }
            V2CLocalFileHandler.closeWriter(bufferedWriter);
        }
        v2CSaveFile.replaceTmpFile();
    }

    static void showSettingPanel() {
        int n;
        boolean bl = bUseGesture;
        boolean bl2 = bUseLeftButton;
        int n2 = nThreshold;
        V2CMouseSP v2CMouseSP = new V2CMouseSP(vgmlGestureMaps, n2);
        v2CMouseSP.showDialog();
        V2CGestureMapSP v2CGestureMapSP = v2CMouseSP.getGestureMapSP();
        if (v2CGestureMapSP.isChanged()) {
            classStateSaver.requestSave();
        }
        bUseGesture = bl;
        bUseLeftButton = bl2;
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        boolean bl3 = v2CGestureMapSP.getUseGesture();
        if (bl3 != bUseGesture) {
            bUseGesture = bl3;
            if (bl3) {
                v2CProperty.putBoolean(sUseGestureKey, true);
            } else {
                v2CProperty.remove(sUseGestureKey);
            }
        }
        if (V2CApp.isMacintosh() && (bl3 = v2CGestureMapSP.getUseLeftButton()) != bUseLeftButton) {
            bUseLeftButton = bl3;
            if (bl3) {
                v2CProperty.remove(sUseLeftButtonKey);
            } else {
                v2CProperty.putBoolean(sUseLeftButtonKey, false);
            }
        }
        if ((n = v2CGestureMapSP.getThreshold()) != n2) {
            nThreshold = n;
            if (n != 30) {
                v2CProperty.putInt(sThresholdKey, n);
            } else {
                v2CProperty.remove(sThresholdKey);
            }
        }
    }

    static void checkActions() {
        boolean bl = false;
        V2CGestureMap[] v2CGestureMapArray = vgmlGestureMaps;
        for (int i = 0; i < v2CGestureMapArray.length; ++i) {
            V2CGestureMap v2CGestureMap = v2CGestureMapArray[i];
            Iterator iterator = v2CGestureMap.getKeyIterator();
            while (iterator.hasNext()) {
                if (V2CActionMap.getAction(v2CGestureMap.get(iterator.next())) != null) continue;
                iterator.remove();
                bl = true;
            }
        }
        if (bl) {
            classStateSaver.requestSave();
        }
    }

    private static boolean isNormalPopupButton(MouseEvent mouseEvent) {
        int n = mouseEvent.getButton();
        if (V2CApp.isMacintosh()) {
            return n == 1 && mouseEvent.isControlDown() || n == 3;
        }
        return n == 3;
    }

    public V2CGestureMap(String string) {
        this.sName = string;
    }

    Iterator getKeyIterator() {
        return this.keySet().iterator();
    }

    boolean isPopupTrigger(MouseEvent mouseEvent, boolean bl) {
        if (!bUseGesture || this.leftButtonBeingUsed()) {
            return mouseEvent.isPopupTrigger();
        }
        if (bl) {
            return false;
        }
        return V2CGestureMap.isNormalPopupButton(mouseEvent);
    }

    boolean isGestureTrigger(MouseEvent mouseEvent, boolean bl) {
        if (!bUseGesture) {
            return false;
        }
        if (this.leftButtonBeingUsed()) {
            return bl && mouseEvent.getButton() == 1 && !mouseEvent.isControlDown();
        }
        return mouseEvent.getButton() == 3;
    }

    boolean shouldPassToGlobal() {
        return !this.bGlobal && !(cmpGesture instanceof V2CImagePopup);
    }

    boolean shouldPassToThreadView() {
        int n = this.iIndex;
        return n == 5 || n == 6 || n == 7;
    }

    public Object get(Object object) {
        Object v = super.get(object);
        if (v != null) {
            return v;
        }
        if (this.shouldPassToThreadView()) {
            return vgmlGestureMaps[4].get(object);
        }
        return this.shouldPassToGlobal() ? gmGlobal.get(object) : null;
    }

    boolean checkStroke(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        Set set = this.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 == null || string2.length() == 0 || !string2.startsWith(string)) continue;
            return true;
        }
        if (this.shouldPassToThreadView()) {
            return vgmlGestureMaps[4].checkStroke(string);
        }
        return this.shouldPassToGlobal() ? gmGlobal.checkStroke(string) : false;
    }

    boolean leftButtonBeingUsed() {
        return bUseLeftButton;
    }

    boolean mousePressed(MouseEvent mouseEvent, boolean bl) {
        int n = mouseEvent.getButton();
        if (bInGesture && (n == 3 || (mouseEvent.getModifiersEx() & 0x1000) == 0)) {
            V2CGestureMap.endGesture();
        }
        if (bInGesture) {
            if (this.leftButtonBeingUsed() || (mouseEvent.getModifiersEx() & 0x1000) == 0) {
                V2CGestureMap.endGesture();
                cmpGesture = null;
                return false;
            }
            if (n == 1 || n == 2 || n >= 4 && n <= 7) {
                StringBuffer stringBuffer = sbGestureBuffer;
                if (stringBuffer.length() > 0) {
                    V2CGestureMap.endGesture();
                }
                if (bWheelRotating) {
                    cmpGesture = null;
                    return false;
                }
                if (!bLeftClicking) {
                    bLeftClicking = true;
                    V2CGestureMap.restoreCursor();
                }
                if (cmpGesture != null) {
                    V2CAbstractAction v2CAbstractAction;
                    String string;
                    String string2;
                    switch (n) {
                        case 1: {
                            string2 = "L";
                            break;
                        }
                        case 2: {
                            string2 = "M";
                            break;
                        }
                        case 4: {
                            string2 = "W\u2190";
                            break;
                        }
                        case 5: {
                            string2 = "W\u2192";
                            break;
                        }
                        case 6: {
                            string2 = "X1";
                            break;
                        }
                        case 7: {
                            string2 = "X2";
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    int n2 = string2.length();
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(string2);
                        string2 = stringBuffer.toString();
                    }
                    if (bShiftDown && string2.length() == n2) {
                        string2 = "S" + string2;
                    }
                    if ((string = (String)this.get(string2)) != null && (v2CAbstractAction = V2CAction.getAction(string)) != null) {
                        SwingUtilities.invokeLater(new V2CGestureActionEvent(v2CAbstractAction, cmpGesture, pStart));
                    }
                }
            }
            return false;
        }
        if (n == 6 || n == 7) {
            StringBuffer stringBuffer = sbGestureBuffer;
            if (stringBuffer.length() > 0) {
                V2CGestureMap.endGesture();
                return false;
            }
            bShiftDown = (mouseEvent.getModifiersEx() & 0x40) != 0;
            pStart = mouseEvent.getPoint();
            cmpGesture = mouseEvent.getComponent();
            if (cmpGesture != null) {
                V2CAbstractAction v2CAbstractAction;
                String string;
                String string3;
                String string4 = string3 = n == 6 ? "x1" : "x2";
                if (bShiftDown) {
                    string3 = "S" + string3;
                }
                if ((string = (String)this.get(string3)) != null && (v2CAbstractAction = V2CAction.getAction(string)) != null) {
                    SwingUtilities.invokeLater(new V2CGestureActionEvent(v2CAbstractAction, cmpGesture, pStart));
                }
            }
            return false;
        }
        if (this.isGestureTrigger(mouseEvent, bl)) {
            sbGestureBuffer.setLength(0);
            bInGesture = true;
            bNoGesture = false;
            bPointerMoved = false;
            bWheelRotating = false;
            bLeftClicking = false;
            bShiftDown = mouseEvent.isShiftDown();
            iX = mouseEvent.getX();
            iY = mouseEvent.getY();
            pStart = mouseEvent.getPoint();
            cLastDir = '\u0000';
            cmpGesture = mouseEvent.getComponent();
            if (cmpGesture != null) {
                cmpGesture.setCursor(Cursor.getPredefinedCursor(13));
            }
            if (this.leftButtonBeingUsed()) {
                tmCancelTimer.start();
            }
            return false;
        }
        return this.isPopupTrigger(mouseEvent, true);
    }

    boolean mouseReleased(MouseEvent mouseEvent) {
        boolean bl = false;
        if (bInGesture) {
            if (mouseEvent.getButton() != (this.leftButtonBeingUsed() ? 1 : 3)) {
                return false;
            }
            V2CGestureMap.endGesture();
            if (bLeftClicking || bWheelRotating) {
                cmpGesture = null;
                return false;
            }
            if (cmpGesture != null && sbGestureBuffer.length() > 0) {
                V2CAbstractAction v2CAbstractAction;
                bl = true;
                String string = (String)this.get(sbGestureBuffer.toString());
                if (string != null && (v2CAbstractAction = V2CAction.getAction(string)) != null) {
                    SwingUtilities.invokeLater(new V2CGestureActionEvent(v2CAbstractAction, cmpGesture, pStart));
                }
            }
        }
        cmpGesture = null;
        if (bl || bLeftClicking || bWheelRotating) {
            return false;
        }
        return this.isPopupTrigger(mouseEvent, false);
    }

    boolean mouseDragged(MouseEvent mouseEvent) {
        int n;
        if (!bInGesture) {
            return false;
        }
        if (bLeftClicking || bWheelRotating) {
            return true;
        }
        boolean bl = false;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        int n4 = n2 - iX;
        int n5 = n3 - iY;
        int n6 = 0;
        if (cLastDir == '\u0000') {
            if (Math.abs(n4) > Math.abs(n5)) {
                if (n4 < -nThreshold) {
                    n6 = 8592;
                    nLastStroke = -n4;
                } else if (n4 > nThreshold) {
                    n6 = 8594;
                    nLastStroke = n4;
                }
            } else if (n5 < -nThreshold) {
                n6 = 8593;
                nLastStroke = -n5;
            } else if (n5 > nThreshold) {
                n6 = 8595;
                nLastStroke = n5;
            }
            if (n6 != 0 && this.leftButtonBeingUsed() && tmCancelTimer.isRunning()) {
                tmCancelTimer.stop();
            }
        } else if (cLastDir == '\u2191') {
            if (n5 < 0) {
                n5 = 0;
                iY = n3;
                nLastStroke = iY0 - n3;
            }
            if (n4 < -(n = Math.max(30 * nLastStroke / 100, nThreshold))) {
                n6 = 8592;
            } else if (n4 > n) {
                n6 = 8594;
            } else if (n5 > n) {
                n6 = 8595;
            }
        } else if (cLastDir == '\u2193') {
            if (n5 > 0) {
                n5 = 0;
                iY = n3;
                nLastStroke = n3 - iY0;
            }
            if (n4 < -(n = Math.max(30 * nLastStroke / 100, nThreshold))) {
                n6 = 8592;
            } else if (n4 > n) {
                n6 = 8594;
            } else if (n5 < -n) {
                n6 = 8593;
            }
        } else if (cLastDir == '\u2190') {
            if (n4 < 0) {
                n4 = 0;
                iX = n2;
                nLastStroke = iX0 - n2;
            }
            if (n5 < -(n = Math.max(30 * nLastStroke / 100, nThreshold))) {
                n6 = 8593;
            } else if (n5 > n) {
                n6 = 8595;
            } else if (n4 > n) {
                n6 = 8594;
            }
        } else if (cLastDir == '\u2192') {
            if (n4 > 0) {
                n4 = 0;
                iX = n2;
                nLastStroke = n2 - iX0;
            }
            if (n5 < -(n = Math.max(30 * nLastStroke / 100, nThreshold))) {
                n6 = 8593;
            } else if (n5 > n) {
                n6 = 8595;
            } else if (n4 < -n) {
                n6 = 8592;
            }
        }
        if (n6 != 0) {
            cLastDir = (char)n6;
            bPointerMoved = true;
            StringBuffer stringBuffer = sbGestureBuffer;
            if (bShiftDown && stringBuffer.length() == 0) {
                stringBuffer.append('S');
            }
            stringBuffer.append((char)n6);
            iX0 = iX;
            iY0 = iY;
            iX = n2;
            iY = n3;
            if (!bNoGesture) {
                String string = stringBuffer.toString();
                if (!this.checkStroke(string)) {
                    bNoGesture = true;
                    if (cmpGesture != null) {
                        cmpGesture.setCursor(Cursor.getPredefinedCursor(1));
                        if (!bFromSettingPanel) {
                            V2CMain.endTempMessage(V2CGestureMap.class);
                        }
                    }
                } else if (!bFromSettingPanel) {
                    String string2 = (String)this.get(string);
                    V2CAbstractAction v2CAbstractAction = string2 != null ? V2CAction.getAction(string2) : null;
                    V2CMain.setTempMessage(v2CAbstractAction != null ? string + ' ' + v2CAbstractAction : string, V2CGestureMap.class);
                }
            }
        }
        return true;
    }

    boolean mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        String string;
        V2CAbstractAction v2CAbstractAction;
        if (bInGesture && !V2CApp.javaVersionEqualTo(1, 7) && !V2CApp.isMacintosh() && (mouseWheelEvent.getModifiersEx() & 0x1000) == 0) {
            V2CGestureMap.endGesture();
        }
        if (!bInGesture || bLeftClicking || sbGestureBuffer.length() > 0) {
            return false;
        }
        Component component = mouseWheelEvent.getComponent();
        if (component == null) {
            return false;
        }
        int n = mouseWheelEvent.getWheelRotation();
        if (n == 0) {
            return true;
        }
        if (!bWheelRotating) {
            bWheelRotating = true;
            V2CGestureMap.restoreCursor();
        }
        if (cmpGesture != null && (v2CAbstractAction = V2CAction.getAction(string = (String)this.get((bShiftDown ? "SW" : "W") + (n > 0 ? (char)'\u2193' : '\u2191')))) != null) {
            SwingUtilities.invokeLater(new V2CGestureActionEvent(v2CAbstractAction, cmpGesture, pStart));
        }
        return true;
    }

    static int getCurrentStrokeCount() {
        return sbGestureBuffer.length();
    }

    static String getCurrentGestureString(boolean bl) {
        StringBuffer stringBuffer = sbGestureBuffer;
        if (bl && bShiftDown && stringBuffer.length() == 0) {
            stringBuffer.append('S');
        }
        return stringBuffer.toString();
    }

    String getName() {
        return this.sName;
    }

    boolean isGlobal() {
        return this.bGlobal;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.sLabel.hashCode();
    }

    public String toString() {
        return this.sLabel;
    }

    static {
        classStateSaver = new ClassStateSaver(60);
        sbGestureBuffer = new StringBuffer();
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        bUseGesture = v2CProperty.getBoolean(sUseGestureKey, false);
        if (V2CApp.isMacintosh()) {
            bUseLeftButton = v2CProperty.getBoolean(sUseLeftButtonKey, true);
        }
        nThreshold = V2CMiscUtil.restrictRange(10, v2CProperty.getInt(sThresholdKey, 30), 100);
        vgmlGestureMaps = new V2CGestureMap[slGestureMapName.length];
        tmCancelTimer = new Timer(1000, new GestureCancelAction());
        tmCancelTimer.setRepeats(false);
    }

    private static class GestureCancelAction
    implements ActionListener {
        private GestureCancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            V2CGestureMap.endGesture();
        }
    }

    private static class ClassStateSaver
    extends V2CClassStateSaver {
        ClassStateSaver(int n) {
            super(n);
        }

        public void doSaveState() {
            V2CGestureMap.saveGestureMap();
        }
    }
}

