/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CDnDUtil;
import org.monazilla.v2c.V2CJ2SE5Util;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPopupLabel;
import org.monazilla.v2c.V2CTreeNodeTransferable;

public abstract class V2CDnDTree
extends JTree
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
Autoscroll {
    final int MARKER_NONE = 0;
    final int MARKER_ABOVE = 1;
    final int MARKER_IN = 2;
    final int MARKER_BELOW = 3;
    private final int nMarkerWidth = 3;
    private final int nMarkerLength = 20;
    final boolean bAllowDrop;
    final boolean bAllowSelfCopy;
    boolean bAllowBGDrop;
    DefaultMutableTreeNode mtnDraggedNode;
    DefaultMutableTreeNode mtnTargetNode;
    V2CPopupLabel vDragSourceLabel;
    TreePath tpTargetPath;
    int nMarkerState;
    Rectangle rLastMarker;
    boolean bChanged;
    boolean bDragging;
    private static final int nASInset = 14;
    Point pLastASPoint;
    Insets vASInsets;
    boolean bAutoScrollCalled;
    int nScDx;
    int nScDy;

    public V2CDnDTree(TreeModel treeModel, boolean bl, boolean bl2) {
        super(treeModel);
        this.bAllowDrop = bl;
        this.bAllowSelfCopy = bl2;
        this.setTransferHandler(null);
        DragGestureRecognizer dragGestureRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, bl ? 3 : 1, this);
        if (bl) {
            DropTarget dropTarget = new DropTarget(this, this);
        }
        this.setRowHeight(0);
    }

    boolean isDropAllowed() {
        return this.bAllowDrop;
    }

    boolean isChanged() {
        return this.bChanged;
    }

    boolean isDragging() {
        return this.bDragging;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.rLastMarker = null;
        int n = this.nMarkerState;
        if (this.tpTargetPath == null || n == 0) {
            return;
        }
        Rectangle rectangle = this.getPathBounds(this.tpTargetPath);
        if (rectangle == null) {
            return;
        }
        graphics.setColor(n == 2 ? Color.RED : Color.BLACK);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, 20, 3);
        if (n == 2) {
            rectangle2.y += (rectangle.height - 3) / 2;
        } else if (n == 3) {
            rectangle2.y += rectangle.height - 3;
        }
        this.rLastMarker = rectangle2;
        graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public final Insets getAutoscrollInsets() {
        Insets insets = this.vASInsets;
        if (!this.bAutoScrollCalled || insets == null) {
            JViewport jViewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this);
            insets = new Insets(14, 14, 14, 14);
            if (jViewport == null) {
                return insets;
            }
            Rectangle rectangle = jViewport.getViewRect();
            insets.top += rectangle.y;
            insets.left += rectangle.x;
            insets.bottom += this.getHeight() - (rectangle.y + rectangle.height);
            insets.right += this.getWidth() - (rectangle.x + rectangle.width);
            this.vASInsets = insets;
        }
        this.bAutoScrollCalled = false;
        return new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public final void autoscroll(Point point) {
        int n;
        int n2;
        int n3;
        int n4;
        this.bAutoScrollCalled = true;
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        int n9 = this.getWidth() - n7;
        int n10 = this.getHeight() - n8;
        if (point.equals(this.pLastASPoint)) {
            n4 = this.nScDx;
            n3 = this.nScDy;
        } else {
            n3 = 0;
            n4 = 0;
            n2 = point.x;
            n = point.y;
            if (n5 > 0 && n2 <= n5 + 14) {
                n4 = -this.getScrollableUnitIncrement(rectangle, 0, -1);
            } else if (n5 < n9 && n2 >= n5 + n7 - 14) {
                n4 = this.getScrollableUnitIncrement(rectangle, 0, 1);
            }
            if (n6 > 0 && n <= n6 + 14) {
                n3 = -this.getScrollableUnitIncrement(rectangle, 1, -1);
            } else if (n6 < n10 && n >= n6 + n8 - 14) {
                n3 = this.getScrollableUnitIncrement(rectangle, 1, 1);
            }
            this.pLastASPoint = point;
        }
        n2 = n5 + n4;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > n9) {
            n2 = n9;
        }
        this.nScDx = n2 - n5;
        n = n6 + n3;
        if (n < 0) {
            n = 0;
        }
        if (n > n10) {
            n = n10;
        }
        this.nScDy = n - n6;
        if (n2 != n5 || n != n6) {
            rectangle.x = n2;
            rectangle.y = n;
            this.scrollRectToVisible(rectangle);
        }
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Rectangle rectangle;
        Point point = dragGestureEvent.getDragOrigin();
        Component component = dragGestureEvent.getComponent();
        if (this.bDragging) {
            if (component instanceof V2CPopupLabel) {
                ((V2CPopupLabel)component).dragDropEnd();
            }
            return;
        }
        if (component != this) {
            point = SwingUtilities.convertPoint(component, point, this);
            this.vDragSourceLabel = component instanceof V2CPopupLabel ? (V2CPopupLabel)component : null;
        } else {
            this.vDragSourceLabel = null;
        }
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode == this.getModel().getRoot()) {
            return;
        }
        this.mtnDraggedNode = defaultMutableTreeNode;
        Transferable transferable = this.createTransferable(defaultMutableTreeNode);
        if (transferable == null) {
            return;
        }
        this.bDragging = true;
        Cursor cursor = null;
        switch (dragGestureEvent.getDragAction()) {
            case 1: {
                cursor = DragSource.DefaultCopyNoDrop;
                break;
            }
            case 2: {
                cursor = DragSource.DefaultMoveNoDrop;
                break;
            }
            default: {
                return;
            }
        }
        Point point2 = null;
        BufferedImage bufferedImage = null;
        if (DragSource.isDragImageSupported() && (rectangle = this.getPathBounds(treePath)) != null && rectangle.width > 0 && rectangle.height > 0) {
            point2 = new Point(rectangle.x - point.x, rectangle.y - point.y);
            rectangle.y = 0;
            rectangle.x = 0;
            GraphicsConfiguration graphicsConfiguration = V2CMain.v2cMain.getGraphicsConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(rectangle.width, rectangle.height, 3);
            Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
            CellRendererPane cellRendererPane = new CellRendererPane();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            JComponent jComponent = (JComponent)treeCellRenderer.getTreeCellRendererComponent(this, defaultMutableTreeNode, false, false, !defaultMutableTreeNode.getAllowsChildren(), this.getRowForPath(treePath), false);
            boolean bl = jComponent.isOpaque();
            if (bl) {
                jComponent.setOpaque(false);
            }
            graphics2D.setComposite(AlphaComposite.getInstance(2, 0.7f));
            cellRendererPane.paintComponent(graphics2D, jComponent, null, rectangle);
            if (bl) {
                jComponent.setOpaque(true);
            }
            graphics2D.dispose();
        }
        dragGestureEvent.getDragSource().startDrag(dragGestureEvent, cursor, bufferedImage, point2, transferable, this);
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        V2CDnDUtil.checkSourceDrag(dragSourceDragEvent);
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        V2CDnDUtil.checkSourceDrag(dragSourceDragEvent);
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        V2CDnDUtil.checkSourceDrag(dragSourceDragEvent);
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        DragSourceContext dragSourceContext = dragSourceEvent.getDragSourceContext();
        dragSourceContext.setCursor(DragSource.DefaultMoveNoDrop);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.mtnDraggedNode = null;
        this.bDragging = false;
        V2CPopupLabel v2CPopupLabel = this.vDragSourceLabel;
        if (v2CPopupLabel != null) {
            this.vDragSourceLabel = null;
            v2CPopupLabel.dragDropEnd();
        }
    }

    DataFlavor checkTreeNodeFlavor(DropTargetEvent dropTargetEvent) {
        DataFlavor dataFlavor = V2CTreeNodeTransferable.dfTreeNodeFlavor;
        return V2CDnDUtil.isDataFlavorSupported(dropTargetEvent, dataFlavor) ? dataFlavor : null;
    }

    DataFlavor checkDataFlavor(DropTargetEvent dropTargetEvent) {
        return this.checkTreeNodeFlavor(dropTargetEvent);
    }

    boolean checkTreeNodeData(Object object, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        if (!(object instanceof DefaultMutableTreeNode)) {
            return false;
        }
        if (object != this.mtnDraggedNode) {
            return false;
        }
        return this.checkMoveDestination(this.mtnDraggedNode, defaultMutableTreeNode, n);
    }

    boolean checkTransferData(Object object, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        return this.checkTreeNodeData(object, defaultMutableTreeNode, n);
    }

    boolean checkMoveDestination(TreeNode treeNode, TreeNode treeNode2, int n) {
        if (n == 0 || treeNode == treeNode2) {
            return false;
        }
        TreeNode treeNode3 = (TreeNode)this.getModel().getRoot();
        if (treeNode2 == treeNode3 && n != 2) {
            return false;
        }
        boolean bl = ((DefaultMutableTreeNode)treeNode2).getAllowsChildren();
        if (!bl && n == 2) {
            return false;
        }
        TreeNode treeNode4 = treeNode.getParent();
        if (treeNode4 == null) {
            return false;
        }
        if (n == 2 && treeNode4 == treeNode2) {
            return false;
        }
        if (treeNode4 == treeNode2.getParent()) {
            int n2 = treeNode4.getIndex(treeNode2);
            if (n == 1) {
                --n2;
            } else if (n == 3) {
                ++n2;
            }
            if (n2 == treeNode4.getIndex(treeNode)) {
                return false;
            }
        }
        if (treeNode2 == treeNode3) {
            return true;
        }
        TreeNode treeNode5 = treeNode2;
        boolean bl2 = false;
        for (int i = 0; i < 100; ++i) {
            if ((treeNode5 = treeNode5.getParent()) == null || treeNode5 == treeNode) {
                return false;
            }
            if (treeNode5 != treeNode3) continue;
            return true;
        }
        return false;
    }

    void checkDrag(DropTargetDragEvent dropTargetDragEvent) {
        int n;
        if (!this.bAllowDrop) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        this.nMarkerState = 0;
        this.tpTargetPath = null;
        if (this.rLastMarker != null) {
            this.repaint(this.rLastMarker);
        }
        if ((dropTargetDragEvent.getSourceActions() & 3) == 0) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        DataFlavor dataFlavor = this.checkDataFlavor(dropTargetDragEvent);
        if (dataFlavor == null) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        Point point = dropTargetDragEvent.getLocation();
        int n2 = point.y;
        TreePath treePath = this.getPathForLocation(point.x, n2);
        boolean bl = false;
        if (treePath == null) {
            if (this.bAllowBGDrop && (treePath = this.getSelectionPath()) == null) {
                treePath = this.getPathForRow(0);
            }
            if (treePath == null) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            bl = true;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        this.tpTargetPath = treePath;
        int n3 = 0;
        Rectangle rectangle = this.getPathBounds(treePath);
        if (defaultMutableTreeNode == this.getModel().getRoot()) {
            n3 = 2;
        } else if (bl) {
            n3 = 1;
        } else if (rectangle != null) {
            n = rectangle.y;
            int n4 = rectangle.height;
            n3 = defaultMutableTreeNode.getAllowsChildren() ? (n2 <= n + n4 / 3 ? 1 : (n2 <= n + 2 * n4 / 3 ? 2 : 3)) : (n2 <= n + n4 / 2 ? 1 : 3);
        }
        if (n3 == 0) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        if (V2CApp.javaVersionEqualOrGreaterThan(1, 5)) {
            Object object;
            try {
                object = V2CJ2SE5Util.getTransferable(dropTargetDragEvent).getTransferData(dataFlavor);
            }
            catch (Exception exception) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            if (!this.checkTransferData(object, defaultMutableTreeNode, n3)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
        }
        n = dropTargetDragEvent.getDropAction();
        if (!this.bAllowSelfCopy && n == 1 && this.mtnDraggedNode != null) {
            n = 2;
        }
        dropTargetDragEvent.acceptDrag(n);
        this.nMarkerState = n3;
        this.repaint(rectangle);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.bAllowBGDrop) {
            this.tpTargetPath = null;
            this.nMarkerState = 0;
            this.repaint();
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object object;
        int n;
        if (!this.bAllowDrop) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        this.tpTargetPath = null;
        if (this.rLastMarker != null) {
            this.repaint(this.rLastMarker);
        }
        if (!dropTargetDropEvent.isLocalTransfer()) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        DataFlavor dataFlavor = this.checkDataFlavor(dropTargetDropEvent);
        if (dataFlavor == null) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        Point point = dropTargetDropEvent.getLocation();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null && this.bAllowBGDrop && (treePath = this.getSelectionPath()) == null) {
            treePath = this.getPathForRow(0);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = treePath != null ? (DefaultMutableTreeNode)treePath.getLastPathComponent() : null;
        int n2 = dropTargetDropEvent.getSourceActions();
        int n3 = n2 & (n = dropTargetDropEvent.getDropAction());
        if ((n3 & 3) == 0) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        try {
            object = dropTargetDropEvent.getTransferable().getTransferData(dataFlavor);
        }
        catch (Exception exception) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        int n4 = this.doDropAction(object, defaultMutableTreeNode, n3);
        if (n4 != 0) {
            dropTargetDropEvent.acceptDrop(n4);
            dropTargetDropEvent.dropComplete(true);
            this.requestSaveAfterDnD();
        } else {
            dropTargetDropEvent.dropComplete(false);
        }
    }

    int doDropAction(Object object, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        if (!(object instanceof DefaultMutableTreeNode)) {
            return 0;
        }
        if (defaultMutableTreeNode == null) {
            return 0;
        }
        boolean bl = n == 1;
        int n2 = this.nMarkerState;
        if (!this.checkTransferData(object, defaultMutableTreeNode, n2)) {
            return 0;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.mtnDraggedNode;
        if (bl) {
            defaultMutableTreeNode2 = this.copyNode(defaultMutableTreeNode2);
        } else {
            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
        }
        if (n2 == 2 && defaultMutableTreeNode.getAllowsChildren()) {
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            int n3 = defaultMutableTreeNode3.getIndex(defaultMutableTreeNode);
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode3, n2 == 1 ? n3 : n3 + 1);
        }
        this.bChanged = true;
        return n;
    }

    void requestSaveAfterDnD() {
    }

    DefaultMutableTreeNode copyNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        return null;
    }

    Transferable createTransferable(DefaultMutableTreeNode defaultMutableTreeNode) {
        return new V2CTreeNodeTransferable(defaultMutableTreeNode);
    }
}

